

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MCC_GetServiceCommcellWebServerInfo.sp] ---------- 

--  +==========================================================================================
--  | Stored Procedure: Gets service commcell webserver info and notifies master commcell
--  +==========================================================================================
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MCC_GetServiceCommcellWebServerInfo')
BEGIN
	print '>>> Drop Stored Procedure: MCC_GetServiceCommcellWebServerInfo <<<'
	drop procedure MCC_GetServiceCommcellWebServerInfo
END
IF EXISTS (select * from GxQscripts where name='MCC_GetServiceCommcellWebServerInfo')
	delete from GxQscripts where name = 'MCC_GetServiceCommcellWebServerInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MCC_GetServiceCommcellWebServerInfo')
	delete from GXDBVersions where aliasname = 'MCC_GetServiceCommcellWebServerInfo'
GO
print '... Creating Procedure: MCC_GetServiceCommcellWebServerInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MCC_GetServiceCommcellWebServerInfo
  @inputXml XML ='',
  @o_xml XML = NULL OUTPUT,
  @doSelect INT = 1,
  @notifyMasterCommcell INT = 0
AS
    SET NOCOUNT ON
	DECLARE @error XML
	DECLARE @errorCode int = 0
	DECLARE @errorMsg NVARCHAR(510)
	DECLARE @serviceCommcellWebServerInfo XML
BEGIN TRY
		IF OBJECT_ID('tempdb.dbo.#CommcellTypeForMultiCommcell') IS NOT NULL
		DROP TABLE #CommcellTypeForMultiCommcell
		CREATE TABLE #CommcellTypeForMultiCommcell (commcellType nvarchar(255),globalCommcellName nvarchar(255),globalCommcellRedirectUrl nvarchar(255),errorCode INT, errorMessage nvarchar(max))
		INSERT INTO #CommcellTypeForMultiCommcell
		EXEC MCC_GetCommcellTypeForMultiCommcell
		SELECT	@errorCode = errorCode,
				@errorMsg = errorMessage
				FROM #CommcellTypeForMultiCommcell
		IF(@errorCode <> 0)
			THROW @errorCode, @errorMsg, 1
		IF EXISTS (SELECT 1 FROM #CommcellTypeForMultiCommcell WHERE commcellType='SERVICECOMMCELL')
		BEGIN
		   DECLARE @webServerIdRequestedFrom INT
		    SELECT @webServerIdRequestedFrom = ISNULL(ref.value('(webserverEntity/@clientId)[1]', 'INT'),0),
					@notifyMasterCommcell = ISNULL(ref.value('@notifyMasterCommcell', 'INT'),0)
			FROM @inputXml.nodes('App_PullSCCWebPackageReq') R ( ref )
			DECLARE @configWebserverUrlParam NVARCHAR(30) = N'MCCWebserverUrl'
			DECLARE @globalCommcellClientId INT =  (SELECT ID FROM App_Client(nolock) WHERE name in (SELECT globalCommcellName from #CommcellTypeForMultiCommcell))
			-- check if there is globalparam to choose which webserver to use    --http:--redbull.testlab.commvault.com:81/SearchSvc/
			DECLARE @configWebserverUrl nvarchar(2048) = (SELECT Top 1 value from GXGlobalParam(nolock) WHERE name = @configWebserverUrlParam)
			DECLARE @configPortNumber INT =0
			DECLARE @webserverHostname nvarchar(510)
			DECLARE @webserverName nvarchar(510)
			DECLARE @webserverClientId INT =0
			DECLARE @webserverAlias nvarchar(2048)
			DECLARE @webserverPort nvarchar(12)
			DECLARE @creHostname nvarchar(510)
			DECLARE @creName nvarchar(510)
			DECLARE @creClientId INT =0
			DECLARE @crePort nvarchar(12)
			DECLARE @webConsoleId INT =0
			DECLARE @csGuid nvarchar(100)
			IF(@configWebserverUrl IS NOT NULL OR @configWebserverUrl<>'')
			BEGIN
				SET @webserverHostname  = DBO.GetHostnameFromUrl(@configWebserverUrl)
				SET @webserverClientId = (SELECT TOP 1 id FROM APP_Client WHERE net_hostname = @webserverHostname)
				IF(@webserverClientId IS NULL OR @webserverClientId=0)
					THROW  50001,'Invalid Webserver entry in Global param',1
				SET @configPortNumber = (SELECT SUBSTRING(@configWebserverUrl,CHARINDEX(@webserverHostname, @configWebserverUrl) + LEN(@webserverHostname)+1,
													CHARINDEX('/', @configWebserverUrl,
													CHARINDEX(@webserverHostname, @configWebserverUrl) + LEN(@webserverHostname)+1) - (CHARINDEX(@webserverHostname, @configWebserverUrl) + LEN(@webserverHostname)+1)))
			END
				-- if webserver url was not specified in global param, pick recent online webserver
				SELECT
					TOP 1 @webserverClientId = CL.Id, @webserverHostname = 	CL.net_hostname, @webserverName=CL.name
				FROM APP_Client AS CL WITH(NOLOCK)
					INNER JOIN SimInstalledpackages SIM WITH(NOLOCK) ON SIM.ClientId = CL.id
					INNER JOIN CCRClientToClient CCR (nolock) ON CCR.FromClientId = 2 AND CCR.ToClientId = CL.id
				WHERE SIM.simPackageID = 252 AND (@webserverClientId =0 OR CL.id = @webserverClientId)
				ORDER BY CCR.lastOnlineTime desc
				SELECT
						@webserverAlias = ISNULL(MAX(CASE WHEN attrName='DM2WebService Search Web Alias' THEN attrVal END),0 ),
						@webserverPort= ISNULL(MAX(CASE WHEN attrName='DM2WebService Web Site Port' THEN attrVal END),0),
						@crePort = ISNULL(MAX(CASE WHEN attrName='DM2WebService Apache Port' THEN attrVal END),0)
				FROM APP_ClientProp AS appClientProp WITH(NOLOCK)
				WHERE appClientProp.componentNameId = @webserverClientId
				GROUP BY componentNameId
				IF OBJECT_ID('tempdb.dbo.#AssociatedWebconsoles') IS NOT NULL 	DROP TABLE #AssociatedWebconsoles
				CREATE TABLE #AssociatedWebconsoles (id int )
				-- Get associated webconsoles to webserver
				INSERT INTO #AssociatedWebconsoles
				EXEC simGetAssociatedWebConsoles @webserverClientId
				-- Pick the most recent online one as the webconsole
				SET @webConsoleId = (	SELECT TOP 1 AWC.ID
										FROM #AssociatedWebconsoles AWC
										INNER JOIN CCRClientToClient CCR (nolock) ON CCR.FromClientId = 2 AND CCR.ToClientId = AWC.id
										ORDER BY CCR.lastOnlineTime desc
									)
				--check if there is any additional setting on webconsole for creurl
				DECLARE @configCREUrl nvarchar(2048) = (SELECT Top 1 value from APP_AdvanceSettings WHERE relativePath ='WebConsole' and keyName='customreportengineurl'
														and enabled =1 and deleted = 0 and entityType = 3 and entityid = @webConsoleId)
				DECLARE @configCREPortNumber INT =0
				IF(@configCREUrl IS NOT NULL OR @configCREUrl<>'')
				BEGIN
					SET @creHostname  = DBO.GetHostnameFromUrl(@configWebserverUrl)
					SET @creClientId = (SELECT TOP 1 id FROM APP_Client WHERE net_hostname = @creHostname)
					IF(@creClientId IS NULL OR @creClientId=0)
						THROW  50002,'Invalid customreportengineurl Additional setting on Webconsole' ,1
					SET @configCREPortNumber = (SELECT SUBSTRING(@configCREUrl,CHARINDEX(@creHostname, @configCREUrl) + LEN(@creHostname)+1,
														CHARINDEX('/', @configCREUrl,
														CHARINDEX(@creHostname, @configCREUrl) + LEN(@creHostname)+1) - (CHARINDEX(@creHostname, @configCREUrl) + LEN(@creHostname)+1)))
				END
				ELSE
				BEGIN
						-- if customreportengineurl additional setting is not found use the webserver as cre
						SELECT @creHostname = @webserverHostname,
							   @creClientId = @webserverClientId,
							   @creName		= @webserverName
				END
				SET @csGUID = (SELECT csGUID FROM APP_CommCell(nolock) WHERE clientid = 2)
				SET @serviceCommcellWebServerInfo = (
														SELECT
															IIF(@configPortNumber >0 ,@configWebserverUrl, 'http://' + @webserverHostname + ':' + @webserverPort + '/' + @webserverAlias+ '/')  '@webServiceUrl',
															IIF(@configPortNumber >0 ,@configPortNumber, @webserverPort)  '@webServerport',
															@csGUID as '@csGUID',
															(SELECT @webserverClientId '@clientId', @webserverName '@webServerName', @webserverHostname '@webServerHostName'  FOR XML PATH('webServerEntity'), TYPE),
															(SELECT TOP 1
																	v.Release as '@release',
																	v.spmajor as '@SP',
																	s.upnumber as '@hotfix',
																	v.transactionid as '@transactionID',
																	'Release'+CAST(v.Release AS NVARCHAR(12))+'_SP'+CAST(v.spmajor AS NVARCHAR(12))+ IIF((ISNULL(s.upnumber,0))=0,'','_HPK'+ CAST(s.upnumber AS NVARCHAR(12)))+'_'+
																	CAST(v.transactionid AS NVARCHAR(12)) AS '@SPVersionInfoText'
															FROM simInstalledPackages s(nolock) INNER JOIN  PatchSPVersion v(nolock) ON s.spversionid=v.id
															WHERE clientid=@webserverClientId ORDER BY transactionid DESC, upnumber DESC
															FOR XML PATH('spVersion'), TYPE),
															(SELECT
																IIF(@configCREPortNumber >0 ,@configCREUrl, 'http://' + @creHostname + ':' +@crePort+'/CustomReportsEngine/rest/')  '@creUrl',
																IIF(@configCREPortNumber >0 ,@configCREPortNumber, @crePort)  '@crePort',
															(SELECT @creClientId '@clientId', @creName '@clientName', @creHostname '@hostName'  FOR XML PATH('client'), TYPE)
															FOR XML PATH('cre'), TYPE)
														FOR XML PATH('webserverInfo'),TYPE
													)
			--if there is no GlobalParam entry found, make the current url as ServiceCommcell Primary Url
			--handle race conditions if there are simultaneuous webserver install on service commcell
			IF NOT EXISTS(SELECT 1 from GXGlobalParam(nolock) WHERE name = @configWebserverUrlParam)
			BEGIN
				INSERT INTO GxGlobalParam VALUES (	@configWebserverUrlParam,
													(SELECT ref.value('@webServiceUrl', 'NVARCHAR(MAX)') FROM @serviceCommcellWebServerInfo.nodes('webserverInfo') R(ref)),
													dbo.GetUnixTime(GETDATE()),
													0)
			END
			IF( @webServerIdRequestedFrom > 0 AND @webServerIdRequestedFrom <> @webserverClientId )
			BEGIN
					SET @notifyMasterCommcell = 0; -- we are not change webserver info that is already registered on Master and this may require TPPM and other configuartions.
			END
			IF(@notifyMasterCommcell = 1)
			BEGIN
				DECLARE @workQueueXML XML =	(SELECT
												1 '@serverType', -- AppMsg::WQProcessServerType commserver
												(SELECT
													(SELECT @serviceCommcellWebServerInfo
													FOR XML PATH('serviceCommcells'), TYPE)
												FOR XML PATH('serviceCommcellListProperties'), TYPE)
											FOR XML PATH('App_PullSCCWebPackageWorkQueueReq'), TYPE)
				DECLARE @workQueueXMLText NVARCHAR(MAX) = (SELECT CAST(@workQueueXML AS NVARCHAR(MAX)))
				DECLARE @workQOutPutTbl table (errCode INT,errString nvarchar(max))
				INSERT INTO @workQOutPutTbl
				EXEC AppWorkQueueSubmitRequest 59/*WORK_TOKEN_PULL_SERVICECOMMCELL_WEB_PACKAGE,*/, 0, 0, @globalCommcellClientId, 0, @workQueueXMLText
				SELECT @errorCode = errCode, @errorMsg = errString from @workQOutPutTbl
			END
		END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
        SET @errorCode = ERROR_NUMBER()
        SET @errorMsg ='Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
END  CATCH
 SET @o_xml	= (SELECT
					@serviceCommcellWebServerInfo,
					(SELECT @errorCode as '@errorCode', @errorMsg as '@errorMessage' FOR XML PATH('error'), TYPE)
				FOR  XML PATH('App_ServiceCommcellWebServerInfoResponse'),TYPE)
  IF @doSelect=1
    BEGIN
        SELECT @o_xml
    END
    SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'MCC_GetServiceCommcellWebServerInfo')
	delete from GxQscripts where name = 'MCC_GetServiceCommcellWebServerInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MCC_GetServiceCommcellWebServerInfo')
	delete from GXDBVersions where aliasname = 'MCC_GetServiceCommcellWebServerInfo'
GO

insert into GXDBVersions values(2, 'MCC_GetServiceCommcellWebServerInfo',  '00000000000000000000', 'MCC_GetServiceCommcellWebServerInfo', '00000000000000000000')
GO

