

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MCC_GetServiceCommcellPropertiesList.sp] ---------- 

--  +==========================================================================================
--  | Stored Procedure: Gets service commcell properties for all service commcells
--  +==========================================================================================
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MCC_GetServiceCommcellPropertiesList')
BEGIN
	print '>>> Drop Stored Procedure: MCC_GetServiceCommcellPropertiesList <<<'
	drop procedure MCC_GetServiceCommcellPropertiesList
END
IF EXISTS (select * from GxQscripts where name='MCC_GetServiceCommcellPropertiesList')
	delete from GxQscripts where name = 'MCC_GetServiceCommcellPropertiesList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MCC_GetServiceCommcellPropertiesList')
	delete from GXDBVersions where aliasname = 'MCC_GetServiceCommcellPropertiesList'
GO
print '... Creating Procedure: MCC_GetServiceCommcellPropertiesList'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MCC_GetServiceCommcellPropertiesList
  @inputXml XML
AS
    SET NOCOUNT ON
	DECLARE @error XML
	DECLARE @errorCode int = 0
	DECLARE @errorMsg NVARCHAR(510)
	DECLARE @serviceCommcells XML
BEGIN TRY
	DECLARE @webconsoleId INT = 0
	DECLARE @webconsoleHostName NVARCHAR(512) = N''
	DECLARE @commcellId INT = 0
	DECLARE @userId INT
	DECLARE @serviceCommcellClientId INT = 0
	DECLARE @serviceCommcellClientName NVARCHAR(512) = N''
	DECLARE @webconsolePackageWindows varchar(50)
	DECLARE @webconsolePackageUnix varchar(50)
        DECLARE @webserverClientIdParam varchar(50)
	SELECT
		@webconsoleId			= ISNULL(ref.value('(webconsoleClient/@clientId)[1]', 'INT'),0),
		@webconsoleHostName		= ISNULL(ref.value('(webconsoleClient/@hostName)[1]', 'NVARCHAR(512)'),''),
		@serviceCommcellClientId = ISNULL(ref.value('(serviceCommcellClient/@clientId)[1]', 'INT'),0),
		@serviceCommcellClientName	= ISNULL(ref.value('(serviceCommcellClient/@clientName)[1]', 'NVARCHAR(512)'),''),
		@commcellId				= ISNULL(ref.value('@commcellId', 'INT'),0),
		@userId					= ISNULL(ref.value('(userEntity/@userId)[1]', 'INT'),0)
	FROM @inputXml.nodes('App_GetServiceCommcellPropertiesListRequest') R ( ref )
	-- webconsoles
	IF OBJECT_ID('tempdb.dbo.#webConsoleTbl') is not null
		DROP TABLE #webConsoleTbl
	CREATE TABLE #webConsoleTbl (clientId int, webPackageClientInfo XML DEFAULT(NULL))
	-- webconsole package and webserverclientId attribute
    	IF OBJECT_ID('tempdb.dbo.#clientPropTbl') is not null
     	   DROP TABLE #clientPropTbl
    	CREATE TABLE #clientPropTbl (id int,componentNameId int, attrName nvarchar(2048), attrVal nvarchar(2048))
	    -- available webservers
    	IF OBJECT_ID('tempdb.dbo.#webserverTbl') is not null
    	    DROP TABLE #webserverTbl
   	 CREATE TABLE #webserverTbl (clientId int PRIMARY KEY)
	-- service commcell properties
	IF OBJECT_ID('tempdb.dbo.#serviceCommcellPropertiesTbl') is not null
		DROP TABLE #serviceCommcellPropertiesTbl
	CREATE TABLE #serviceCommcellPropertiesTbl (commcellId int, webPackageClientInfo XML DEFAULT(NULL))
	-- webPackageClientInfo cross applied result
	IF OBJECT_ID('tempdb.dbo.#webPackageClientInfo') is not null
		DROP TABLE #webPackageClientInfo
	CREATE TABLE #webPackageClientInfo (webconsoleId INT,serviceCommcellClientId INT,adminConsolePackagePath nvarchar(255), webconsolePackagePath nvarchar(510), packageStatus int, fwStatus int, pInfo int, status INT)
	-- availableServiceCommcells
	IF OBJECT_ID('tempdb.dbo.#availableServiceCommcells') is not null
		DROP TABLE #availableServiceCommcells
	CREATE TABLE #availableServiceCommcells (commcellId int,redirectURL NVARCHAR(255), commcellRole INT, UNIQUE CLUSTERED(commcellID))
	-- servicecommcell Properties
	IF OBJECT_ID('tempdb.dbo.#serviceCommcellProperties') is not null
		DROP TABLE #serviceCommcellProperties
	CREATE TABLE #serviceCommcellProperties (	commcellId int,
												WebServiceUrl NVARCHAR(2048),
												WebServerport INT,
												TppmWebServerport INT,
												WebServerClientId INT,
												WebServerName NVARCHAR(510),
												WebServerHostName NVARCHAR(510),
												Release INT,
												SP INT,
												Hotfix INT,
												TransactionID INT ,
												SPVersionInfoText NVARCHAR(510),
												CreUrl NVARCHAR(2048),
												CrePort INT,
												TppmCrePort INT,
												CreClientId INT,
												CreClientName NVARCHAR(510),
												CreHostName NVARCHAR(510),
												IsGlobalWebConsoleConfigured INT
									)
DECLARE @adminUser INT = (SELECT TOP 1 id FROM UMUsers WITH(NOLOCK) WHERE flags & 0x040 <> 0) --USERS_ADMIN
	-- Get all servicecommcells
	EXEC MCC_IDP_GetServiceCommcellListForUser @adminUser,1
	--Filter out commcells if provided in the request
	DELETE #availableServiceCommcells WHERE @commcellId >0 AND commcellId <> @commcellId
	IF @serviceCommcellClientId <> 0 OR @serviceCommcellClientName<>''
	BEGIN
		DECLARE @serviceCommcellId INT = ISNULL((SELECT TOP 1 CC.ID
												FROM App_Client CL(NOLOCK)
												INNER JOIN APP_CommCell CC ON CL.ID = CC.ClientId
												WHERE	CL.id =@serviceCommcellClientId OR CL.name = @serviceCommcellClientName)
												,0)
		DELETE #availableServiceCommcells WHERE commcellId <> @serviceCommcellId
	END
	-- get client if hostname is only provided
	IF(@webconsoleId=0 AND @webconsoleHostName<>'')
		SET @webconsoleId = (SELECT TOP 1 id FROM APP_Client (NOLOCK) WHERE net_hostname = @webconsoleHostName)
	INSERT INTO #serviceCommcellProperties
	SELECT
		MAX(CC.ID),
		CAST(MAX(CASE WHEN attrName='ServiceCommcell WebServiceUrl' THEN attrVal END) AS NVARCHAR(2048)),
		CAST(MAX(CASE WHEN attrName='ServiceCommcell WebServerport' THEN attrVal END) AS INT),
		CAST(MAX(CASE WHEN attrName='ServiceCommcell TppmWebServerport' THEN attrVal END) AS INT),
		CAST(MAX(CASE WHEN attrName='ServiceCommcell WebServerClientId' THEN attrVal END) AS INT),
		CAST(MAX(CASE WHEN attrName='ServiceCommcell WebServerName' THEN attrVal END) AS NVARCHAR(510)),
		CAST(MAX(CASE WHEN attrName='ServiceCommcell WebServerHostName' THEN attrVal END) AS NVARCHAR(510)),
		CAST(MAX(CASE WHEN attrName='ServiceCommcell Release' THEN attrVal END) AS INT),
		CAST(MAX(CASE WHEN attrName='ServiceCommcell SP' THEN attrVal END) AS INT),
		CAST(MAX(CASE WHEN attrName='ServiceCommcell Hotfix' THEN attrVal END) AS INT),
		CAST(MAX(CASE WHEN attrName='ServiceCommcell TransactionID' THEN attrVal END) AS INT),
		CAST(MAX(CASE WHEN attrName='ServiceCommcell SPVersionInfoText' THEN attrVal END) AS NVARCHAR(510)),
		CAST(MAX(CASE WHEN attrName='ServiceCommcell CreUrl' THEN attrVal END) AS NVARCHAR(2048)),
		CAST(MAX(CASE WHEN attrName='ServiceCommcell CrePort' THEN attrVal END) AS INT),
		CAST(MAX(CASE WHEN attrName='ServiceCommcell TppmCrePort' THEN attrVal END) AS INT),
		CAST(MAX(CASE WHEN attrName='ServiceCommcell CreClientId' THEN attrVal END) AS INT),
		CAST(MAX(CASE WHEN attrName='ServiceCommcell CreClientName' THEN attrVal END) AS NVARCHAR(510)),
		CAST(MAX(CASE WHEN attrName='ServiceCommcell CreHostName' THEN attrVal END) AS NVARCHAR(510)),
		ISNULL(CAST(MAX(CASE WHEN attrName='IsGlobalWebConsoleConfigured' THEN attrVal END) AS INT),0)
	FROM #availableServiceCommcells SCC
		INNER JOIN APP_CommCell CC(nolock) ON SCC.commcellId = CC.ID
		INNER JOIN App_ClientProp CP(nolock) ON CC.clientId = CP.componentnameId
	GROUP BY CP.componentnameId
	DELETE SCC
	FROM #availableServiceCommcells SCC
	LEFT OUTER JOIN #serviceCommcellProperties SCCP ON SCC.commcellId = SCCP.commcellId AND SCCP.IsGlobalWebConsoleConfigured = 1
	WHERE SCCP.commcellId IS NULL
	SET @webconsolePackageWindows = 'PackageStateForId 726'
	SET @webconsolePackageUnix = 'PackageStateForId 1135'
    SET @webserverClientIdParam = 'WebServerClientId'
	-- Get webservers
    INSERT INTO #webserverTbl(clientId)
    SELECT cl.id
    FROM APP_Client AS CL WITH(NOLOCK)
        INNER JOIN SimInstalledpackages SIM WITH(NOLOCK) ON SIM.ClientId = CL.id AND sim.simPackageID IN (252,1174)
    --Get client props
    INSERT INTO #clientPropTbl(id ,componentNameId , attrName , attrVal )
    SELECT
    (CASE
        WHEN attrName=@webserverClientIdParam THEN 1
        WHEN attrName=@webconsolePackageWindows OR attrName=@webconsolePackageUnix THEN 2
    END) as id,
    componentNameId, attrName, attrval
    FROM APP_ClientProp WITH(NOLOCK) WHERE attrName in (@webserverClientIdParam, @webconsolePackageWindows,@webconsolePackageUnix)
	-- #1 webconsole should have attrName 'WebServerClientId' with attrVal as WebserverID
    -- #2 webconsole should have attrName 'PackageStateForId 726' with attrVal=1
    INSERT INTO #webConsoleTbl(clientId)
    SELECT distinct cpTbl2.componentNameId
        FROM #clientPropTbl cpTbl1
        INNER JOIN #webserverTbl wsTbl ON cpTbl1.attrVal = CAST(wsTbl.clientId AS NVARCHAR(12))
        INNER JOIN #clientPropTbl cpTbl2 ON cpTbl2.componentNameId = cpTbl1.componentNameId
        WHERE cpTbl1.id = 1 --@webserverClientId
        AND cpTbl2.id = 2 /**@webServerAttribute**/ AND cpTbl2.attrVal = N'1'
		AND (@webconsoleId=0 OR cpTbl2.componentNameId = @webconsoleId)
	--remove webconsoles that do not participate in dynamic load
	DELETE WC
	FROM #webConsoleTbl WC
	LEFT OUTER JOIN APP_ClientProp CP WITH(NOLOCK) ON WC.clientId = CP.componentNameId
	AND attrName ='Side by Side Loading of Multiple SP Instance Enabled' and attrVal=N'1' and modified =0
	WHERE CP.componentNameId IS NULL
	--update if the property exists
	UPDATE WCT SET webPackageClientInfo = CAST(ECP.attrVal AS XML)
	FROM #webConsoleTbl WCT
	INNER JOIN APP_ExtendedProperties ECP  WITH(NOLOCK) ON WCT.clientId = ECP.clientId
	WHERE ECP.attrName = N'WebPackageClientInfo' AND ECP.modified = 0
	INSERT INTO #webPackageClientInfo(webconsoleId ,serviceCommcellClientId )
	select wc.clientId,DF.serviceCommcellClientId from #webConsoleTbl WC,
	(SELECT clientId as 'serviceCommcellClientId'
									FROM #availableServiceCommcells SCC
									INNER JOIN APP_CommCell CC(nolock) ON SCC.commcellId = CC.ID) AS DF
	UPDATE WC SET adminConsolePackagePath = tmp.adminconsolePackagePath , webconsolePackagePath = tmp.webconsolePackagePath,
	status = tmp.status, pInfo = tmp.pInfo, packageStatus = tmp.packageStatus, fwStatus = tmp.fwStatus
	FROM #webPackageClientInfo WC
	INNER JOIN
	(
		SELECT
			clientId,
			t.ref.query('.').value('(webPackageAvailableClients/serviceCommcellClient/@clientId)[1]','INT') AS 'serviceCommcellClientId',
			t.ref.query('.').value('(webPackageAvailableClients/@adminconsolePackagePath)[1]','nvarchar(255)') AS 'adminconsolePackagePath',
			t.ref.query('.').value('(webPackageAvailableClients/@webconsolePackagePath)[1]','nvarchar(510)') AS 'webconsolePackagePath',
			t.ref.query('.').value('(webPackageAvailableClients/@packageStatus)[1]','INT') AS 'packageStatus',
			t.ref.query('.').value('(webPackageAvailableClients/@fwStatus)[1]','INT') AS 'fwStatus',
			t.ref.query('.').value('(webPackageAvailableClients/@pInfo)[1]','INT') AS 'pInfo',
			t.ref.query('.').value('(webPackageAvailableClients/@status)[1]','INT') AS 'status'
		FROM #webConsoleTbl
			OUTER APPLY webPackageClientInfo.nodes('/App_WebPackageAvailableClientInfoList/webPackageAvailableClients') as t(ref)
	)tmp
	ON WC.webconsoleId = tmp.clientId and Wc.serviceCommcellClientId = tmp.serviceCommcellClientId
  SET @serviceCommcells =
						  (SELECT
								CC.aliasName as '@commcellName',cc.clientId '@clientId',
								CC.csGUID as '@csGUID',
								(
									SELECT
										IIF(tppmWebServerport>0 , REPLACE(REPLACE(webServiceUrl,':'+CAST(webServerport AS NVARCHAR(12)),':'+CAST(tppmWebServerport AS NVARCHAR(12))),WebServerHostName ,'localhost') , webServiceUrl)+ 'cvwebservice.svc/' as '@webServiceUrl',
										webServerport as '@webServerport',
										tppmWebServerport as '@tppmWebServerport',
										(SELECT WebServerClientId as '@clientId',  WebServerName as '@webServerName', WebServerHostName as '@webServerHostName'  FOR XML PATH('webServerEntity'), TYPE),
										(SELECT
												Release as '@release',
												SP as '@SP',
												Hotfix as '@hotfix',
												TransactionID as '@transactionID',
												SPVersionInfoText AS '@SPVersionInfoText'
										FOR XML PATH('spVersion'), TYPE),
										(SELECT
											  CreUrl as '@creUrl',
											  CrePort as '@crePort',
												TppmCrePort as '@tppmCrePort',
										(SELECT CreClientId as '@clientId', CreClientName as  '@clientName', CreHostName as '@hostName'  FOR XML PATH('client'), TYPE)
										FOR XML PATH('cre'), TYPE)
										FROM #serviceCommcellProperties SCCP WHERE SCCP.commcellId = CC.Id
									FOR XML PATH('webserverInfo'),TYPE
								),
								( -- gets webconsole status for servicecommcells
									SELECT
										(SELECT
											WP.adminConsolePackagePath '@adminconsolePackagePath',
											WP.webconsolePackagePath '@webconsolePackagePath',
											WP.packageStatus '@packageStatus',
											WP.fwStatus '@fwStatus',
											WP.pInfo '@pInfo',
											WP.status '@status',
											(SELECT WP.serviceCommcellClientId '@clientId', CL.GUID '@clientGUID'
												FROM APP_CLIENT(NOLOCK) CL WHERE ID = WP.serviceCommcellClientId
											FOR XML PATH('serviceCommcellClient'),TYPE),
											(SELECT WC.id '@clientId' ,
													WC.name '@clientName',
													WC.net_hostname '@hostName'
													FROM App_Client(nolock) WC
													WHERE WC.ID =  WP.webconsoleId
											FOR XML PATH('webconsoleClient'),TYPE)
										FROM #webPackageClientInfo WP WHERE WP.serviceCommcellClientId = cc.ClientId
										FOR XML PATH('webPackageAvailableClient'),TYPE)
									FOR XML PATH('webPackageAvailableClients'),TYPE
								)
							FROM #availableServiceCommcells SCC
							INNER JOIN APP_CommCell CC(nolock) ON SCC.commcellId = CC.Id
							FOR XML PATH('serviceCommcells'),TYPE)
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @error = ( SELECT
						ERROR_NUMBER() '@errorCode',
						'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE() '@errorMessage'
						FOR XML PATH('error'), TYPE
						)
END  CATCH
	SELECT
		@error,
		@serviceCommcells
	FOR  XML PATH('App_GetServiceCommcellPropertiesListResponse'),TYPE
    SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'MCC_GetServiceCommcellPropertiesList')
	delete from GxQscripts where name = 'MCC_GetServiceCommcellPropertiesList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MCC_GetServiceCommcellPropertiesList')
	delete from GXDBVersions where aliasname = 'MCC_GetServiceCommcellPropertiesList'
GO

insert into GXDBVersions values(2, 'MCC_GetServiceCommcellPropertiesList',  '00000000000000000000', 'MCC_GetServiceCommcellPropertiesList', '00000000000000000000')
GO

