

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MCC_GetServiceCommcellProperties.sp] ---------- 

SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='MCC_GetServiceCommcellProperties')
BEGIN
	print '>>> Drop Stored Procedure: MCC_GetServiceCommcellProperties <<<'
	drop procedure MCC_GetServiceCommcellProperties
END
IF EXISTS (select * from GxQscripts where name='MCC_GetServiceCommcellProperties')
	delete from GxQscripts where name = 'MCC_GetServiceCommcellProperties'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MCC_GetServiceCommcellProperties')
	delete from GXDBVersions where aliasname = 'MCC_GetServiceCommcellProperties'
GO
print '... Creating Procedure: MCC_GetServiceCommcellProperties'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure MCC_GetServiceCommcellProperties
  @icommcellId INT = 0,
  @icommcellClientId INT = 0,
  @icommcellGuid nvarchar(40) = '',
  @ilocaleId INT = 0
AS
BEGIN TRY
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @errorStr nvarchar(max)=''
DECLARE @errorCode INT = 0
DECLARE @respXml XML
DECLARE @webserviceURL nvarchar(max)=''
DECLARE @commcellType INT = 0  -- Router, IDP, Service Commcell, Cloud (5:CV_MULTICOMMCELL_TYPE_CLOUDSERVICE)
DECLARE @isGlobalWebConsoleConfigured INT = 0
DECLARE @globalWebconsoleStatusMessage NVARCHAR(MAX) =N''
DECLARE @servicePackLevel INT = 0
DECLARE @webPackageAvailableClients XML
IF(@icommcellClientId <> 0)
BEGIN
	SELECT @icommcellId = id From APP_CommCell where clientId=@icommcellClientId
END
ELSE IF(@icommcellGuid <> '')
BEGIN
	SELECT @icommcellId = id From APP_CommCell where csGUID=@icommcellGuid
END
DECLARE @lastSyncTimeWitIDP INT= ISNULL((Select top 1 created from APP_ComponentProp where componentId = @icommcellId and componentType=1049 and propertyTypeId =1 order by created desc ),0)
IF(@icommcellClientId = 0)
BEGIN
	SELECT @icommcellClientId = clientId From APP_CommCell where id=@icommcellId
END
IF OBJECT_ID('tempdb.dbo.#serviceCommcellProps') IS NOT NULL
    DROP TABLE #serviceCommcellProps
CREATE TABLE #serviceCommcellProps
(
    aliasName NVARCHAR(512),
	lastSyncWithIDP INT,
    webconsoleUrl NVARCHAR(MAX),
    commcellType INT,
	csGUID NVARCHAR(80),
	webServiceUrl NVARCHAR(MAX),
	isGlobalWebConsoleConfigured INT,
	globalWebconsoleStatusMessage NVARCHAR(MAX),
	webPackageAvailableClients XML
)
-- check if @commcellType is cloud service commcell
SELECT @commcellType = ACP.attrVal FROM APP_ClientProp ACP
INNER JOIN App_Commcell AC ON ACP.componentNameId = AC.clientId AND AC.id = @icommcellId AND ACP.attrName = 'Commcell role'
select @webserviceURL='http://' + attrVal from APP_ClientProp where componentNameId = @icommcellClientId and attrName = 'ServiceCommcell WebServerHostName'
IF EXISTS (SELECT 1 from APP_ClientProp where componentNameId = @icommcellClientId and attrName = 'ServiceCommcell TppmWebServerport')
	SELECT @webserviceURL=@webserviceURL+ ':'+ attrVal from APP_ClientProp where componentNameId = @icommcellClientId and attrName = 'ServiceCommcell TppmWebServerport'
ELSE
	SELECT @webserviceURL=@webserviceURL+ ':'+ attrVal from APP_ClientProp where componentNameId = @icommcellClientId and attrName = 'ServiceCommcell WebServerport'
select @webserviceURL = @webserviceURL + '/SearchSvc/CVWebService.svc'
select @webserviceURL='http://' + attrVal from APP_ClientProp where componentNameId = @icommcellClientId and attrName = 'ServiceCommcell WebServerHostName'
SET @isGlobalWebConsoleConfigured = (SELECT TOP 1 1 FROM APP_ClientProp(NOLOCK) WHERE componentNameId = @icommcellClientId AND attrName=N'IsGlobalWebConsoleConfigured' AND attrVal=N'1' AND modified = 0)
SET @servicePackLevel =  (SELECT TOP 1 CAST(attrVal AS INT) FROM APP_ClientProp(NOLOCK) WHERE componentNameId = @icommcellClientId AND attrName=N'ServiceCommcell SP' AND modified = 0)
IF @isGlobalWebConsoleConfigured = 1 AND @servicePackLevel < 22
BEGIN
SET @globalWebconsoleStatusMessage = (SELECT message FROM EvLocaleMsgs(NOLOCK) WHERE messageId=(4656 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND [localeId] = @ilocaleId)
	IF @globalWebconsoleStatusMessage='' --fallback
	BEGIN
		SET @globalWebconsoleStatusMessage = N'This service CommCell needs to be upgraded for app to be created on universal Command Center.'
	END
END
IF OBJECT_ID('tempdb.dbo.#serviceCommcellListTbl') is not null
        DROP TABLE #serviceCommcellListTbl
    CREATE TABLE #serviceCommcellListTbl (data XML)
DECLARE @serviceCommcellListInputXML NVARCHAR(MAX) = '<App_GetServiceCommcellPropertiesListRequest commcellId="'+ CAST(@icommcellId AS NVARCHAR(10))+'" />'
INSERT INTO #serviceCommcellListTbl
EXEC MCC_GetServiceCommcellPropertiesList @serviceCommcellListInputXML
SET @webPackageAvailableClients =(SELECT TOP 1 data.query('/App_GetServiceCommcellPropertiesListResponse/serviceCommcells/webPackageAvailableClients')  FROM #serviceCommcellListTbl)
If(@commcellType = 5)
BEGIN
	INSERT INTO #serviceCommcellProps (aliasName, lastSyncWithIDP, webconsoleUrl, commcellType, csGUID, webServiceUrl,isGlobalWebConsoleConfigured,globalWebconsoleStatusMessage,webPackageAvailableClients)
		SELECT AC.aliasName AS 'aliasName',
		0 AS lastSyncWithIDP,
		ACP.attrVal AS 'webconsoleUrl,',
		@commcellType AS 'commcellType',
		AC.csGUID AS 'csGUID',
		@webserviceURL AS 'webServiceUrl',
		@isGlobalWebConsoleConfigured,
		@globalWebconsoleStatusMessage,
		@webPackageAvailableClients
		FROM app_commcell  AC
		INNER JOIN APP_ClientProp ACP
ON ACP.componentNameId = AC.clientId AND ACP.attrName = 'Service commcell end point'
		WHERE AC.id = @icommcellId AND @icommcellId <> 2
IF EXISTS (Select Top 1 id from APP_ClientProp where attrName='Cloud Service For MSP' and attrVal = 1)
	BEGIN
		--For Neo commcells , we should pick up the top 1 redirect url from app_companyprop for now.
		INSERT INTO #serviceCommcellProps (aliasName, lastSyncWithIDP, webconsoleUrl, commcellType, csGUID, webServiceUrl,isGlobalWebConsoleConfigured,globalWebconsoleStatusMessage,webPackageAvailableClients)
			SELECT top 1 AC.aliasName AS 'aliasName',
			0 AS lastSyncWithIDP,
			ACP.attrVal AS 'webconsoleUrl,',
			@commcellType AS 'commcellType',
			AC.csGUID AS 'csGUID',
			@webserviceURL AS 'webServiceUrl',
			@isGlobalWebConsoleConfigured,
			@globalWebconsoleStatusMessage,
			@webPackageAvailableClients
			FROM app_commcell  AC
			INNER JOIN APP_Companyprop ACP
ON ACP.attrValInt = AC.clientId AND ACP.attrName = 'Service commcell end point'
			WHERE AC.id = @icommcellId AND @icommcellId <> 2
	END
END
ELSE
BEGIN
INSERT INTO #serviceCommcellProps (aliasName, lastSyncWithIDP, webconsoleUrl, commcellType, csGUID, webServiceUrl,isGlobalWebConsoleConfigured,globalWebconsoleStatusMessage,webPackageAvailableClients)
	SELECT aliasName as 'aliasName', @lastSyncTimeWitIDP as 'lastSyncWithIDP', ATPA.props.value('(/props/nameValues[@name="RedirectUrl"]/@value)[1]','nvarchar(max)') as 'webconsoleUrl',
	case
when longlongVal = 0 then (select 4)
when longlongVal = 1 then (select 2)
	 end as 'commcellType',
	 AC.csGUID as 'csGUID',
	 @webserviceURL as 'webServiceUrl',
	 @isGlobalWebConsoleConfigured,
	 @globalWebconsoleStatusMessage,
	 @webPackageAvailableClients
	from APP_CommCell AC
	inner join App_thirdpartyApp ATPA
	on ATPA.appName = AC.csguid
	inner join APP_ComponentProp ACP
	on ACP.componentId = AC.id
where AC.id = @icommcellId and componentType = 1048 and longVal = 1 and @icommcellId <> 2
END
SET @respXml =ISNULL((SELECT aliasName as '@commcellName',
	 lastSyncWithIDP as '@lastSyncWithIDP',
	 webconsoleUrl as '@webconsoleUrl',
	 commcellType AS '@commcellType',
	 csGUID AS '@csGUID',
	 webserviceURL AS '@webServiceUrl',
	 isGlobalWebConsoleConfigured AS '@isGlobalWebConsoleConfigured',
	 globalWebconsoleStatusMessage AS '@globalWebconsoleStatusMessage',
	 @webPackageAvailableClients
	 FROM #serviceCommcellProps
	FOR XML PATH ('App_ServiceCommcellProperties')),'<App_ServiceCommcellProperties/>')
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorStr  = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
	SET @errorCode =  ERROR_NUMBER()
END CATCH
PROC_EXIT:
IF @errorCode <> 0
Select @errorCode as '@errorCode',@errorStr as '@errorMessage' for xml path('App_GenericResp')
ELSE
Select @respXml
GO

IF EXISTS (select * from GxQscripts where name = 'MCC_GetServiceCommcellProperties')
	delete from GxQscripts where name = 'MCC_GetServiceCommcellProperties'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MCC_GetServiceCommcellProperties')
	delete from GXDBVersions where aliasname = 'MCC_GetServiceCommcellProperties'
GO

insert into GXDBVersions values(2, 'MCC_GetServiceCommcellProperties',  '00000000000000000000', 'MCC_GetServiceCommcellProperties', '00000000000000000000')
GO

