

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MCC_GetServiceCommcellListForUserXML.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- 	+-----------------------------------------------------------------------+
--	| 			Procedure : "MCC_GetServiceCommcellListForUserXML"
--	|	This Procedure is used to check if a user can login
--	|	This SP to be called from Evmgrs login and web console login too.
-- 	+-----------------------------------------------------------------------+
SET ANSI_NULLS ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='MCC_GetServiceCommcellListForUserXML')
BEGIN
	print '>>> Drop Stored Procedure: MCC_GetServiceCommcellListForUserXML <<<'
	drop procedure MCC_GetServiceCommcellListForUserXML
END
IF EXISTS (select * from GxQscripts where name='MCC_GetServiceCommcellListForUserXML')
	delete from GxQscripts where name = 'MCC_GetServiceCommcellListForUserXML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MCC_GetServiceCommcellListForUserXML')
	delete from GXDBVersions where aliasname = 'MCC_GetServiceCommcellListForUserXML'
GO
print '... Creating Procedure: MCC_GetServiceCommcellListForUserXML'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure MCC_GetServiceCommcellListForUserXML
  @userId INT
AS
IF OBJECT_ID('tempdb.dbo.#availableServiceCommcells') IS NOT NULL
				DROP TABLE #availableServiceCommcells
CREATE TABLE #availableServiceCommcells
			(
				commcellID INT,
				redirectURL NVARCHAR(255),
				commcellRole INT,
				UNIQUE CLUSTERED(commcellID)
)
DECLARE @serviceCommcells XML
DECLARE @IDPCommcell XML
DECLARE @resp XML
EXEC MCC_IDP_GetServiceCommcellListForUser @userId,1
DECLARE @localRedirectUrl nvarchar(255) = (Select PROPS.value('(/props/nameValues[@name="RedirectUrl"]/@value)[1]','nvarchar(max)')  from App_ThirdPartyApp where appType = 4)
SET @serviceCommcells = (
		SELECT
				redirectURL as '@webUrl',
				ACP.attrVal as '@servicePackInfo',
				SC.commcellRole as '@commcellRole',
				C.net_hostname as '@commcellHostname',
				AC.id as 'commcell/@commCellId',
				AC.aliasName 'commcell/@commCellName',
				AC.csGUID as 'commcell/@csGUID'
		FROM
			APP_CommCell AC INNER JOIN 	#availableServiceCommcells SC
			on AC.id = SC.commcellID
			INNER JOIN APP_Client C
			on C.id = AC.clientId
			LEFT JOIN APP_ClientProp ACP on ACP.componentNameId = C.id AND ACP.attrName = 'ServiceCommcell SPVersionInfoText'
		FOR XML PATH('serviceCommcell'))
 SET @IDPCommcell = (
		SELECT
				@localRedirectUrl as '@webUrl',
				ACP.CommcellType as '@commcellRole',
				C.net_hostname as '@commcellHostname',
				AC.id as 'commcell/@commCellId',
				AC.aliasName 'commcell/@commCellName',
				AC.csGUID as 'commcell/@csGUID'
		FROM
			APP_CommCell AC
			INNER JOIN APP_Client C on C.id = AC.clientId
			INNER JOIN APP_CommCellProp ACP on ACP.CommCellId = AC.id
		WHERE AC.id = 2
		FOR XML PATH('IDPCommcell'))
SET @resp= ( Select @serviceCommcells,@IDPCommcell FOR XML PATH(''), ROOT ('CometIDPCommcellInfo') )
SELECT @resp as 'RespXml'
GO

IF EXISTS (select * from GxQscripts where name = 'MCC_GetServiceCommcellListForUserXML')
	delete from GxQscripts where name = 'MCC_GetServiceCommcellListForUserXML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MCC_GetServiceCommcellListForUserXML')
	delete from GXDBVersions where aliasname = 'MCC_GetServiceCommcellListForUserXML'
GO

insert into GXDBVersions values(2, 'MCC_GetServiceCommcellListForUserXML',  '00000000000000000000', 'MCC_GetServiceCommcellListForUserXML', '00000000000000000000')
GO

