

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MCC_GetRegisteredCloudServiceCommcells.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--  +-----------------------------------------------------------------------+
--  |           Procedure : "MCC_GetRegisteredCloudServiceCommcells"
--  |   This Procedure is used to get regigstred cloud service commcell details
--  |   , commcell client details for service commcells page on local CS.
--  |
--  +-----------------------------------------------------------------------+
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='MCC_GetRegisteredCloudServiceCommcells')
BEGIN
	print '>>> Drop Stored Procedure: MCC_GetRegisteredCloudServiceCommcells <<<'
	drop procedure MCC_GetRegisteredCloudServiceCommcells
END
IF EXISTS (select * from GxQscripts where name='MCC_GetRegisteredCloudServiceCommcells')
	delete from GxQscripts where name = 'MCC_GetRegisteredCloudServiceCommcells'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MCC_GetRegisteredCloudServiceCommcells')
	delete from GXDBVersions where aliasname = 'MCC_GetRegisteredCloudServiceCommcells'
GO
print '... Creating Procedure: MCC_GetRegisteredCloudServiceCommcells'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure MCC_GetRegisteredCloudServiceCommcells
  @userId INT, 
  @xmlText XML OUTPUT
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @errorCode INT = 0
DECLARE @errorString nvarchar(MAX) = ''
DECLARE @nowTime INT = 0
SET @nowTime = dbo.GetUnixTime(GETUTCDATE())
-- cloud service - service commcells will be visible only to admins
-- Security Check --
DECLARE @isCommCellAdmin INT = 0
DECLARE @isTenantAdmin INT = 0
DECLARE @ownerCompany INT = 0
exec Sec_checkPermissionOnEntity @userId, 1, @isCommCellAdmin OUTPUT, 1, 2
IF(@isCommcellAdmin = 0)
BEGIN
IF EXISTS(SELECT 1 FROM UMUserGroup UU INNER JOIN UMGroups UG ON UU.groupId=UG.id where ((UG.groupFlags & 0x10000 <> 0) or (UG.groupFlags & 0x40000 <> 0)) and UU.userId=@userId
				UNION
SELECT 1 FROM UMUserGroup UU INNER JOIN UMDSGroupMaps UMDS ON UMDS.umDSgroupId = UU.groupId INNER JOIN UMGroups UG ON UMDS.umgroupId=UG.id where ((UG.groupFlags & 0x10000 <> 0) or (UG.groupFlags & 0x40000 <> 0)) and UU.userId=@userId)
	BEGIN
		SET @isTenantAdmin = 1
		SET @ownerCompany = dbo.AppGetOrganizationForUser(@userId)
	END
END
IF(@isCommcellAdmin = 0 AND @isTenantAdmin = 0)
BEGIN
	SET @errorCode = 1
	SET @errorString = 'User does not have permission'
	GOTO SEND_RESP
END
IF OBJECT_ID('tempdb.dbo.#getMemberUserGroupsHelperOutputTbl') IS NOT NULL
    DROP TABLE #getMemberUserGroupsHelperOutputTbl
CREATE TABLE #getMemberUserGroupsHelperOutputTbl
(
    isUser INT,
    userOrgroupId INT,
    UNIQUE CLUSTERED(isUser, userOrGroupId)
)
-- Get Commcell Information (i.e. cloud Service)
IF object_id('tempdb.dbo.#CommcellInfo') IS NOT Null DROP TABLE #CommcellInfo
CREATE TABLE #CommcellInfo
(
    csGuid nvarchar(80),
	commcellName nvarchar(512),
	commcellId INT,
	ccClientId INT,
	csHostName nvarchar(510),
	ccClientName nvarchar(510)
)
IF(@isCommCellAdmin = 1)
BEGIN
	INSERT INTO #commcellInfo (csGuid, commcellName, commcellId, ccClientId, csHostName, ccClientName)
	SELECT AC.csGUID, AC.aliasName, AC.id, AC.clientId, C.net_hostname, C.name
	FROM App_Commcell AC
	INNER JOIN App_ClientProp ACP
ON ACP.componentNameId = AC.clientId AND ACP.attrName = 'Commcell role' AND ACP.attrVal = 5
	INNER JOIN App_Client C
		ON C.id = AC.clientId
END
ELSE IF(@isTenantAdmin = 1)
BEGIN
	INSERT INTO #commcellInfo (csGuid, commcellName, commcellId, ccClientId, csHostName, ccClientName)
	SELECT AC.csGUID, AC.aliasName, AC.id, AC.clientId, C.net_hostname, C.name
	FROM App_Commcell AC
	INNER JOIN App_Client C
		ON C.id =  AC.clientId
	INNER JOIN App_CompanyProp CP
		on CP.attrValInt = C.id
WHERE CP.componentNameId = @ownerCompany and CP.attrName = 'Cloud Service ClientId'
END
SEND_RESP:
IF(@errorCode = 0)
BEGIN
SET @xmlText = (SELECT
				(SELECT
					ccClientid as '@ccClientId',
					csHostName as '@interfaceName',
					ccClientName as '@ccClientName',
					0 as '@isGlobalIDPCommcell',
5 as '@multiCommcellType', -- for cloud service
16 as '@commcellRoleInt',
'CLOUD SERVICE' as '@commcellRoleString',
					(SELECT
						commcellName as '@commCellName',
						commcellId as '@commCellId',
						csGuid as '@csGUID'
					FOR XML PATH('commCell'), TYPE)
			FROM #commcellInfo
			FOR XML PATH ('commcellsList'), TYPE)
			FOR XML PATH ('EVGui_CN2GetRegCommcellsResp'), TYPE)
END
ELSE
BEGIN
	SET @xmlText = '<EVGui_CN2GetRegCommcellsResp/>'
END

IF EXISTS (select * from GxQscripts where name = 'MCC_GetRegisteredCloudServiceCommcells')
	delete from GxQscripts where name = 'MCC_GetRegisteredCloudServiceCommcells'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MCC_GetRegisteredCloudServiceCommcells')
	delete from GXDBVersions where aliasname = 'MCC_GetRegisteredCloudServiceCommcells'
GO

insert into GXDBVersions values(2, 'MCC_GetRegisteredCloudServiceCommcells',  '00000000000000000000', 'MCC_GetRegisteredCloudServiceCommcells', '00000000000000000000')
GO

