

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MCC_GetMultiCommcellsForUser.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--  +-----------------------------------------------------------------------+
--  |           Procedure : "MCC_GetMultiCommcellsForUser"
--  |   This Procedure is used to get associated multi commcells and
--  |   subscribed cloud services for given user.
--  +-----------------------------------------------------------------------+
SET ANSI_NULLS ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='MCC_GetMultiCommcellsForUser')
BEGIN
	print '>>> Drop Stored Procedure: MCC_GetMultiCommcellsForUser <<<'
	drop procedure MCC_GetMultiCommcellsForUser
END
IF EXISTS (select * from GxQscripts where name='MCC_GetMultiCommcellsForUser')
	delete from GxQscripts where name = 'MCC_GetMultiCommcellsForUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MCC_GetMultiCommcellsForUser')
	delete from GXDBVersions where aliasname = 'MCC_GetMultiCommcellsForUser'
GO
print '... Creating Procedure: MCC_GetMultiCommcellsForUser'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure MCC_GetMultiCommcellsForUser
  @userId INT 
AS
DECLARE @xmlText XML
DECLARE @errorCode INT = 0
DECLARE @errorString nvarchar(MAX) = ''
DECLARE @nowTime INT = 0
DECLARE @isTenantOperator INT = 0
DECLARE @ownerCompanyId INT = 0
SET @nowTime = dbo.GetUnixTime(GETUTCDATE())
IF object_id('tempdb.dbo.#CloudServiceDetails') IS NOT Null DROP TABLE #CloudServiceDetails
CREATE TABLE #CloudServiceDetails
(
	csClientId int,
    redirectUrl nvarchar(MAX),
    commcellName nvarchar(MAX),
	companyGuid nvarchar(MAX)
)
IF object_id('tempdb.dbo.#AvailableMultiCommcells') IS NOT Null DROP TABLE #AvailableMultiCommcells
CREATE TABLE #AvailableMultiCommcells
(
	multicommcellType int,
	thirdPartyAppId	int,
    redirectUrl nvarchar(MAX),
    commcellName nvarchar(MAX),
)
IF @userId = 0
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Invalid User'
	GOTO PROC_EXIT
END
IF OBJECT_ID('tempdb.dbo.#getMemberUserGroupsHelperOutputTbl') IS NOT NULL
    DROP TABLE #getMemberUserGroupsHelperOutputTbl
CREATE TABLE #getMemberUserGroupsHelperOutputTbl
(
    isUser INT,
    userOrgroupId INT,
    UNIQUE CLUSTERED(isUser, userOrGroupId)
)
IF EXISTS (SELECT TOP 1 id from Umusers where id = @userId and flags & 0x8000 = 0x8000)
BEGIN
	SET @isTenantOperator = 1
END
-- Security Check for cloud Service --
-- If user  is associated with cloud service then allow.
SET @ownerCompanyId = dbo.AppGetOrganizationForUser(@userId)
IF(@isTenantOperator = 0)
BEGIN
	-- Insert user groups
	EXEC sec_getMemberUserGroupsHelper @userId
	--Insert domain and company also.
	DECLARE @companyId INT =0
	DECLARE @umdsproviderId INT = (SELECT umdsproviderId from UMUsers where id=@userId)
	DECLARE @userName nvarchar(255) = (select login from UMUsers where id=@userId)
	if(@umdsproviderId<>0)
		BEGIN
SET @companyId = ISNULL((SELECT ownerCompany from UMDSProviders where id=@umdsproviderId and serviceType <> 5),0)
			INSERT INTO #getMemberUserGroupsHelperOutputTbl
			SELECT 2,@umdsproviderID
		END
	IF( @companyId<>0)
	BEGIN
		INSERT INTO #getMemberUserGroupsHelperOutputTbl
			SELECT 2,@companyId
	END
	INSERT INTO #CloudServiceDetails (csClientId)
	SELECT DISTINCT ACP.componentNameId FROM APP_ClientProp ACP
		INNER JOIN App_Commcell AC
ON AC.clientId = ACP.componentNameId AND  ACP.attrName = 'Commcell role' AND ACP.attrVal = 5
		INNER JOIN UMSecurityAssociations UMA
ON UMA.entityType1 = 194 AND UMA.entityId1 = AC.id
		INNER JOIN #getMemberUserGroupsHelperOutputTbl member
			ON UMA.isUSer = member.isUSer and UMA.userORGroupId = member.userORGroupId
END
Update CD SET redirectUrl = attrVal FROM #CloudServiceDetails CD
INNER JOIN App_ClientProp ACP ON ACP.componentNameId = CD.csClientId AND ACP.attrName = 'Service commcell end point'
Update CD SET commcellName = aliasName FROM #CloudServiceDetails CD
INNER JOIN App_Commcell CC ON CC.clientId = CD.csClientId
Update CD SET companyGuid = ACP.attrVal FROM #CloudServiceDetails CD
INNER JOIN APP_ClientProp ACP ON ACP.componentNameId = CD.csClientId AND ACP.attrName = 'Cloud Service Company Guid'
IF(@ownerCompanyId > 0)
BEGIN
Update #CloudServiceDetails SET redirectUrl = (Select attrVal FROM App_CompanyProp ACP Where componentNameId=@ownerCompanyId AND ACP.attrName = 'Service commcell end point')
END
--- Cloud Service End ---
DECLARE @isCommcellConfigureAsGlobalIDP INT = ISNULL((SELECT top 1 longlongVal from APP_ComponentProp where componentType = 1048 and propertyTypeId = 2 and longVal = 1 and longlongVal = 1),0)
IF @isCommcellConfigureAsGlobalIDP = 1
BEGIN
	DECLARE @CCIDS TABLE (ccId int)
	-- find direct associations to commcell first.
	IF OBJECT_ID('tempdb.dbo.#availableServiceCommcells') IS NOT NULL
                DROP TABLE #availableServiceCommcells
            CREATE TABLE #availableServiceCommcells
            (
                commcellID INT,
                redirectURL NVARCHAR(255),
				commcellRole INT,
                UNIQUE CLUSTERED(commcellID)
            )
            EXEC MCC_IDP_GetServiceCommcellListForUser @userId,1
            INSERT INTO @CCIDS (ccId) SELECT commcellID FROM #availableServiceCommcells
END
IF EXISTS( SELECT top 1 commcellName from #CloudServiceDetails ) OR EXISTS (SELECT top 1 ccId from @CCIDS)
BEGIN
		--inserting local commcell
		INSERT INTO @CCIDS values(2)	--DEFAULT_COMMCELL_ID
END
	INSERT INTO #AvailableMultiCommcells SELECT DISTINCT 0,ATP.id,ATP.props.value('(/props/nameValues[@name="RedirectUrl"]/@value)[1]','nvarchar(512)'),ACC.aliasName FROM App_ThirdPartyApp ATP with (NOLOCK)
                            INNER JOIN APP_CommCell ACC ON ATP.appName = ACC.csGUID
                            INNER JOIN @CCIDS C ON C.ccId = ACC.id
							INNER JOIN APP_ComponentProp ACP on ACP.componentId = ACC.id
							INNER JOIN App_CommcellProp ACProp ON ACProp.commcellId = ACC.id
                            WHERE ATP.isEnabled  = 1 AND
(ATP.props.value('(/props/nameValues[@name="Enable Sso Redirect"]/@value)[1]','int') = 1 or ATP.appType = 4)  and ((ACP.componentType = 1048 and ACP.longVal = 1 and (ACP.longlongVal = 1 or ATP.appType = 4)) OR (ACProp.commcellType & 32= 32))
	-- check if user is from on-prim subscribers in the cloud service setup
	-- check if user belongs to a company
	-- case 1:commcell user redirected from on-prim, case2:AD user redirected from on-prim
IF @isTenantOperator = 0 AND EXISTS(SELECT TOP(1) 1 FROM UMUsersProp WHERE componentNameId = @userId AND attrName = 'Redirected Cloud service user' AND attrVal IN (1,2))
	BEGIN
		INSERT INTO #AvailableMultiCommcells
SELECT DISTINCT 6, ATP.id, ATP.props.value('(/props/nameValues[@name="RedirectUrl"]/@value)[1]','nvarchar(512)'), ATP.props.value('(/props/nameValues[@name="App Display Name"]/@value)[1]','nvarchar(512)') FROM App_ThirdPartyApp ATP with (NOLOCK)
				INNER JOIN App_ComponentProp ACP
ON ACP.componentType = 1034
AND ACP.componentId = ATP.id AND ACP.propertyTypeId = 61
						AND ACP.longlongVal = @ownerCompanyId AND ACP.dataType = 1 AND ACP.longVal = 0
	END
	DECLARE @multicommcellList xml =
			(SELECT
				(SELECT commcellName AS '@commcellName',
				multicommcellType AS '@commCellType',
				redirectUrl AS '@redirectUrl'
			FROM #AvailableMultiCommcells
			FOR XML PATH('AvailableRedirects'), TYPE))
PROC_EXIT:
	SET @xmlText =
			(SELECT
				(SELECT commcellName AS '@commcellName',
				redirectUrl AS '@redirectUrl'
			FROM #CloudServiceDetails
			FOR XML PATH('cloudServices'), TYPE),
			@multicommcellList,
			(SELECT @errorCode AS '@errorCode', @errorString AS '@errorString' FOR XML PATH('error'), TYPE)
			FOR XML PATH ('RedirectsForUser'), TYPE)
SELECT @xmlText
GO

IF EXISTS (select * from GxQscripts where name = 'MCC_GetMultiCommcellsForUser')
	delete from GxQscripts where name = 'MCC_GetMultiCommcellsForUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MCC_GetMultiCommcellsForUser')
	delete from GXDBVersions where aliasname = 'MCC_GetMultiCommcellsForUser'
GO

insert into GXDBVersions values(2, 'MCC_GetMultiCommcellsForUser',  '00000000000000000000', 'MCC_GetMultiCommcellsForUser', '00000000000000000000')
GO

