

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MCC_GetLandingPageForUser.sp] ---------- 

SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MCC_GetLandingPageForUser')
BEGIN
	print '>>> Drop Stored Procedure: MCC_GetLandingPageForUser <<<'
	drop procedure MCC_GetLandingPageForUser
END
IF EXISTS (select * from GxQscripts where name='MCC_GetLandingPageForUser')
	delete from GxQscripts where name = 'MCC_GetLandingPageForUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MCC_GetLandingPageForUser')
	delete from GXDBVersions where aliasname = 'MCC_GetLandingPageForUser'
GO
print '... Creating Procedure: MCC_GetLandingPageForUser'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MCC_GetLandingPageForUser
  @iUserId INT
AS
BEGIN TRY
DECLARE @redirectUrl nvarchar(max) = ''
DECLARE @shouldRedirect int = 0
DECLARE @errorMessage nvarchar(max) = ''
DECLARE @errorCode int = 0
DECLARE @canUserLogin int = 0
exec sec_canLoginMasterCommcell @iUserId,@canUserLogin OUTPUT
-- find direct associations to commcell first.
IF OBJECT_ID('tempdb.dbo.#availableServiceCommcells') IS NOT NULL
	DROP TABLE #availableServiceCommcells
CREATE TABLE #availableServiceCommcells(commcellID INT,
										redirectURL NVARCHAR(255),
										commcellRole INT,
										UNIQUE CLUSTERED(commcellID))
EXEC MCC_IDP_GetServiceCommcellListForUser @iUserId,1
IF (SELECT COUNT(1) From #availableServiceCommcells Where (commcellRole & 8 = 8)) = 1 AND @canUserLogin = 0
	BEGIN
		SET @shouldRedirect = 1
SET @redirectUrl = (select top 1 redirectURL  from #availableServiceCommcells where (commcellRole & 8 = 8))
	END
Select @shouldRedirect as '@shouldRedirect',@redirectUrl as '@redirectUrl' for xml path ('GetLandingPageResponse'),type
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorMessage  = ERROR_MESSAGE()
	SET @errorCode =  ERROR_NUMBER()
	SELECT @errorCode AS '@errorCode', @errorMessage AS '@errorMessage' for xml path ('GetLandingPageResponse'),type
END CATCH
GO

IF EXISTS (select * from GxQscripts where name = 'MCC_GetLandingPageForUser')
	delete from GxQscripts where name = 'MCC_GetLandingPageForUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MCC_GetLandingPageForUser')
	delete from GXDBVersions where aliasname = 'MCC_GetLandingPageForUser'
GO

insert into GXDBVersions values(2, 'MCC_GetLandingPageForUser',  '00000000000000000000', 'MCC_GetLandingPageForUser', '00000000000000000000')
GO

