

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MCC_GetDefaultCommcellConfiguration.sp] ---------- 

SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MCC_GetDefaultCommcellConfiguration')
BEGIN
	print '>>> Drop Stored Procedure: MCC_GetDefaultCommcellConfiguration <<<'
	drop procedure MCC_GetDefaultCommcellConfiguration
END
IF EXISTS (select * from GxQscripts where name='MCC_GetDefaultCommcellConfiguration')
	delete from GxQscripts where name = 'MCC_GetDefaultCommcellConfiguration'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MCC_GetDefaultCommcellConfiguration')
	delete from GXDBVersions where aliasname = 'MCC_GetDefaultCommcellConfiguration'
GO
print '... Creating Procedure: MCC_GetDefaultCommcellConfiguration'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MCC_GetDefaultCommcellConfiguration
AS
BEGIN TRY
  DECLARE @errorCode INT = 0
  DECLARE @errorMessage NVARCHAR(MAX)=''
  DECLARE @respXml XML
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
		DECLARE @webConsoleURL NVARCHAR(2083) = ''
		DECLARE @defaultWebconsoleClientId INT
		DECLARE @availableWebConsoleClientId INT
		DECLARE @defaultWebServerClientId INT
		DECLARE @defaultMQClientId INT
		DECLARE @mqConfigInfo NVARCHAR(1024)
		DECLARE @MQInfo TABLE(errorCode INT, errorMessage NVARCHAR(MAX), connectString NVARCHAR(MAX), mqClientId INT)
		DECLARE @webServerUrls nvarchar(max) = ''
		SELECT @webServerUrls = @webServerUrls + ',' +'http://'+c.net_hostname+':'+p.attrVal  From APP_Client c
					inner join APP_ClientProp p on c.id = p.componentNameId
					inner join simInstalledPackages s on s.ClientId = c.id
where attrname = 'DM2WebService Web Site Port' AND simPackageID = 252
		IF(len(@webServerUrls) > 0)
		SET @webServerUrls = right(@webServerUrls,len(@webServerUrls)-1)
		SELECT @webConsoleURL = value FROM GXGlobalParam WHERE name = N'WebConsoleURL'
		IF @webConsoleURL IS NOT NULL AND LTRIM(RTRIM(@webConsoleURL)) <> ''
		BEGIN
			SELECT @defaultWebconsoleClientId = id FROM APP_Client WHERE net_hostname = DBO.GetHostnameFromUrl(@webConsoleURL)
			SET @webConsoleURL = LTRIM(RTRIM(REPLACE(@webConsoleURL,'/clientDetails/fsDetails.do?clientName=CLIENTNAME','')))
		END
		-- Check if client is configured and has webconsole package installed.
		IF NOT EXISTS (SELECT 1 FROM App_client CL
			INNER JOIN simInstalledPackages IP
			ON CL.id = IP.ClientId
				AND CL.status & 2 = 0 -- Should be configured
				AND IP.simPackageID = 726 -- AdminConsole package id
				AND Cl.id = @defaultWebconsoleClientId)
			SET @defaultWebconsoleClientId = NULL
		IF @defaultWebconsoleClientId IS NOT NULL
			GOTO GET_DEFAULT_WEBSERVER_CLIENT
		-- IF no default webconsole set, then choose the first available one
		-- TODO add a better logic here to obtain default configuration
		GET_NEXT_WEBCONSOLE_CLIENT:
		SELECT TOP 1 @availableWebConsoleClientId = Cl.id FROM App_client CL
			INNER JOIN simInstalledPackages IP
			ON CL.id = IP.ClientId
				AND CL.status & 2 = 0 -- Should be configured
				AND IP.simPackageID = 726 -- AdminConsole package id
				AND (@defaultWebconsoleClientId IS NULL OR CL.id > @defaultWebconsoleClientId)
			ORDER BY Cl.id ASC
		IF @availableWebConsoleClientId IS NOT NULL
		BEGIN
			-- Make available webconsole client as default.
			SET @defaultWebconsoleClientId = @availableWebConsoleClientId
		END
		GET_DEFAULT_WEBSERVER_CLIENT:
		IF @availableWebConsoleClientId IS NOT NULL
		BEGIN
		SELECT @defaultWebServerClientId = CAST(attrVal AS INT)  FROM APP_ClientProp
			WHERE componentNameId = @defaultWebconsoleClientId
			AND attrName = 'WebServerClientId'
			AND modified = 0
		END
		ELSE
		BEGIN
SELECT @defaultWebServerClientId = clientId FROM SimInstalledpackages WITH(NOLOCK) WHERE simpackageid IN  (252,1174)
		END
		DELETE FROM @MQInfo
		INSERT INTO @MQInfo
		EXEC APPGetMQConnectString @defaultWebServerClientId
		SELECT TOP 1 @defaultMQClientId = mqClientId FROM @MQInfo WHERE errorCode = 0 ORDER BY mqClientId ASC
		IF @defaultMQClientId IS NULL OR @defaultWebServerClientId IS NULL
			GOTO GET_NEXT_WEBCONSOLE_CLIENT
		SELECT @mqConfigInfo = attrVal
			FROM APP_ClientProp
			WHERE componentNameId = @defaultMQClientId
				AND modified = 0
				AND attrName = N'Message Queue Config'
		-- As @defaultWebconsoleClientId is based out of gxglobalparam Webconsole URL hostname, we will just use that.
		--Updating the RedirectUrl in App_ThirdPartyApp if the local commcell multicommcell app is already present.
		UPDATE App_ThirdPartyApp
                	SET props.modify('replace value of (/props/nameValues[@name="RedirectUrl"]/@value)[1] with (sql:variable("@webConsoleUrl"))')
                	WHERE appType = 4
		--Get ServiceCommcell information
		DECLARE @serviceCommcellWebServerInfo XML
		DECLARE @serviceCommcellWebServerInfoResponse XML
		EXEC MCC_GetServiceCommcellWebServerInfo '',@serviceCommcellWebServerInfoResponse OUTPUT,0 /**doSelect**/
		SET @errorCode = ISNULL((SELECT ref.value('(error/@errorCode)[1]', 'INT') FROM @serviceCommcellWebServerInfoResponse.nodes('App_ServiceCommcellWebServerInfoResponse') R(ref)), 0)
		IF @errorCode <> 0
		BEGIN
			SET @errorMessage = ISNULL((SELECT ref.value('(error/@errorMessage)[1]', 'NVARCHAR(MAX)') FROM @serviceCommcellWebServerInfoResponse.nodes('App_ServiceCommcellWebServerInfoResponse') R(ref))
										,'Error getting ServiceCommcell Webserver Information.');
			THROW 51001, @errorMessage, 2
		END
		SET @serviceCommcellWebServerInfo = (select @serviceCommcellWebServerInfoResponse.query('App_ServiceCommcellWebServerInfoResponse/webserverInfo'))
		SET @respXml = (
			SELECT
				[@webConsoleUrl] = @webConsoleURL,
				[@mqConfiguration] = @mqConfigInfo,
				[@csAllNicIpAddress] = (SELECT attrVal FROM APP_ClientProp WHERE componentNameId = 2 AND modified = 0 AND attrName = N'AllNicIpAddress'),
				[@webServerURLs]=@webServerUrls,
				 @serviceCommcellWebServerInfo,
				(SELECT
					[@commCellId] = id,
					[@commCellName] = aliasName,
					[@csGUID] = csGUID,
					[@_type_] = 1,
					[@encNumber] = encNumber,
					[@number] = number,
					[@timezone] = timezone,
					[@ipAddress] = ipAddress,
					[@drIpAddress] = drIpAddress,
					[@flags] = flags,
					[@userName] = userName,
					[@UserPassword] = userPassword,
					[@smtpServer] = smtpServer,
					[@ccOpMode] = ccOpMode
					FROM APP_CommCell
					WHERE clientId = 2
					FOR XML PATH ('commcell'), TYPE),
				(SELECT
					[@allNicIpAddress] = (SELECT attrVal FROM APP_ClientProp WHERE componentNameId = CL.id AND modified = 0 AND attrName = N'AllNicIpAddress'),
					(SELECT
						[@clientId] = id,
						[@clientName] = name,
						[@hostName] = net_hostname,
						[@displayName] = displayName,
						[@_type_] = 3
						FOR XML PATH ('client'), TYPE)
					FROM APP_Client CL
					WHERE id =  @defaultMQClientId
					FOR XML PATH ('mqClient'),
				TYPE),
				(SELECT
					[@allNicIpAddress] = (SELECT attrVal FROM APP_ClientProp WHERE componentNameId = CL.id AND modified = 0 AND attrName = N'AllNicIpAddress'),
					(SELECT
						[@clientId] = id,
						[@clientName] = name,
						[@hostName] = net_hostname,
						[@displayName] = displayName,
						[@_type_] = 3
						FOR XML PATH ('client'), TYPE)
					FROM APP_Client CL
					WHERE id =  @defaultWebconsoleClientId
					FOR XML PATH ('webConsoleClient'),
				TYPE),
				(SELECT
					[@allNicIpAddress] = (SELECT attrVal FROM APP_ClientProp WHERE componentNameId = CL.id AND modified = 0 AND attrName = N'AllNicIpAddress'),
					(SELECT
						[@clientId] = id,
						[@clientName] = name,
						[@hostName] = net_hostname,
						[@displayName] = displayName,
						[@_type_] = 3
						FOR XML PATH ('client'), TYPE)
					FROM APP_Client CL
					WHERE id =  @defaultWebServerClientId
					FOR XML PATH ('webServerClient'),
				TYPE),
				(SELECT
					(SELECT
						(SELECT
						[@clientPassword] = client_password ,
						[@offlineEntity] = offlineEntity,
						[@offlineTimeStamp] = offlineTimeStamp,
						[@clientDescription] = clientDescription,
						[@ClockSkewInSeconds] = clientSkewTime,
						[@cvdPort] = cvdPort,
						[@evmgrcPort] = evmgrcPort,
						[@Status] = status,
						[@spaceCheckFlags] = spaceCheckFlags,
						(SELECT [@path] = jobResultDir FOR XML PATH('jobResulsDir'), TYPE),
						(SELECT [@osId] = simOperatingSystemId FOR XML PATH('osInfo'), TYPE),
						(SELECT [@version] = releaseId FOR XML PATH('versionInfo'), TYPE),
						(SELECT [@clientName] = name, [@commCellName] = csHostName, [@hostName] = net_hostname, [@clientGUID] = GUID, [@displayName] = displayName FOR XML PATH('clientEntity'), TYPE)
					FOR XML PATH('client'), TYPE),
					(SELECT [@specialClientFlags] = specialClientFlags FOR XML PATH('clientProps'), TYPE)
					FROM App_Client WHERE id = 2
				FOR XML PATH('csClient'), TYPE))
				FOR XML PATH ('App_ConfigurationDetailsForMCC')
		)
		IF object_id('tempdb.dbo.#DefaultCommcellConfig') IS NOT Null
			INSERT INTO #DefaultCommcellConfig (errorCode, errorString, respXml)
			VALUES (@errorCode, @errorMessage, @respXml)
		ELSE
			SELECT @errorCode AS 'errorCode', @errorMessage AS 'errorMessage' , @respXml AS 'respXml'
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorMessage  = ERROR_MESSAGE()
	SET @errorCode =  ERROR_NUMBER()
	SELECT @errorCode AS 'errorCode', @errorMessage AS 'errorMessage' , @respXml AS 'respXml'
END CATCH
PROC_EXIT:
GO

IF EXISTS (select * from GxQscripts where name = 'MCC_GetDefaultCommcellConfiguration')
	delete from GxQscripts where name = 'MCC_GetDefaultCommcellConfiguration'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MCC_GetDefaultCommcellConfiguration')
	delete from GXDBVersions where aliasname = 'MCC_GetDefaultCommcellConfiguration'
GO

insert into GXDBVersions values(2, 'MCC_GetDefaultCommcellConfiguration',  '00000000000000000000', 'MCC_GetDefaultCommcellConfiguration', '00000000000000000000')
GO

