

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MCC_GetCompletedSetupsForCompany.sp] ---------- 

/*
	MCC_GetCompletedSetupsForCompany
	This SP returns completed setups for a company in cloud service
*/
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='MCC_GetCompletedSetupsForCompany')
BEGIN
	print '>>> Drop Stored Procedure: MCC_GetCompletedSetupsForCompany <<<'
	drop procedure MCC_GetCompletedSetupsForCompany
END
IF EXISTS (select * from GxQscripts where name='MCC_GetCompletedSetupsForCompany')
	delete from GxQscripts where name = 'MCC_GetCompletedSetupsForCompany'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MCC_GetCompletedSetupsForCompany')
	delete from GXDBVersions where aliasname = 'MCC_GetCompletedSetupsForCompany'
GO
print '... Creating Procedure: MCC_GetCompletedSetupsForCompany'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure MCC_GetCompletedSetupsForCompany
  @i_userId INT
AS
  DECLARE @xmlOut XML
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @completedSetups NVARCHAR(MAX) = ''
DECLARE @isEnabled INT = 0
DECLARE @flags INT = 0
DECLARE @ownerCompany INT = 0
DECLARE @errorCode INT = 0
DECLARE @errorMessage NVARCHAR(MAX) = ''
SET @ownerCompany=  dbo.AppGetOrganizationForUser(@i_userId)
IF(@ownerCompany IS NULL OR @ownerCompany < 0)
BEGIN
	SET @errorCode = 2
	SET @errorMessage = 'Not a valid company user'
	GOTO PROC_EXIT
END
SELECT  @isEnabled = UMDS.enabled, @flags = UMDS.flags FROM UMDSProviders UMDS WHERE UMDS.id = @ownerCompany
IF(@isEnabled = 0)
BEGIN
	SET @errorCode = 3
	SET @errorMessage = 'Company is disabled'
	GOTO PROC_EXIT
END
IF(@flags & 0x0010 = 0x0010)
BEGIN
	-- check if login is disabled or not
	DECLARE @loginDisabled INT = 0
SELECT @loginDisabled = attrVal FROM App_CompanyProp WHERE componentNameId = @ownerCompany AND attrName = 'Disable Login'
	-- if flags = 16 i.e. company deactivated and login is disabled then throw error
	IF(@loginDisabled = 1)
	BEGIN
		SET @errorCode = 4
		SET @errorMessage = 'Company is deactivated and login is disabled'
		GOTO PROC_EXIT
	END
END
IF(@errorCode = 0)
SELECT  @completedSetups = ACP.attrval FROM  App_CompanyProp ACP WHERE ACP.attrName = 'completedSetups' AND ACP.componentNameId = @ownerCompany
PROC_EXIT:
SET @xmlOut = (SELECT
				@completedSetups as '@completedSetups',
				(SELECT
				@errorCode as '@errorCode',
				@errorMessage as '@errorMessage'
				FOR XML PATH('error'), TYPE)
			FOR XML PATH('App_CompletedSetupsDetails'), TYPE)
SELECT @xmlOut
GO

IF EXISTS (select * from GxQscripts where name = 'MCC_GetCompletedSetupsForCompany')
	delete from GxQscripts where name = 'MCC_GetCompletedSetupsForCompany'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MCC_GetCompletedSetupsForCompany')
	delete from GXDBVersions where aliasname = 'MCC_GetCompletedSetupsForCompany'
GO

insert into GXDBVersions values(2, 'MCC_GetCompletedSetupsForCompany',  '00000000000000000000', 'MCC_GetCompletedSetupsForCompany', '00000000000000000000')
GO

