

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MCC_GetCompanyPropertiesForServiceCommcell.sp] ---------- 

--  +==============================================================================+
--  |		 		 Name:  AppGetCompanyProperties()
--  | Description:  Allows for GET of company properties for provided ProviderID
--  +==============================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MCC_GetCompanyPropertiesForServiceCommcell.sp,v $ $Id: MCC_GetCompanyPropertiesForServiceCommcell.sp,v 1.1.2.4.20.1 2021/01/08 08:05:47 njudge Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='MCC_GetCompanyPropertiesForServiceCommcell')
BEGIN
	print '>>> Drop Stored Procedure: MCC_GetCompanyPropertiesForServiceCommcell <<<'
	drop procedure MCC_GetCompanyPropertiesForServiceCommcell
END
IF EXISTS (select * from GxQscripts where name='MCC_GetCompanyPropertiesForServiceCommcell')
	delete from GxQscripts where name = 'MCC_GetCompanyPropertiesForServiceCommcell'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MCC_GetCompanyPropertiesForServiceCommcell')
	delete from GXDBVersions where aliasname = 'MCC_GetCompanyPropertiesForServiceCommcell'
GO
print '... Creating Procedure: MCC_GetCompanyPropertiesForServiceCommcell'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure MCC_GetCompanyPropertiesForServiceCommcell
  @o_xmlText XML OUTPUT
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN TRY
DECLARE @i_providerId  		INTEGER
DECLARE @localeId INT
DECLARE @xmlerrors xml
DECLARE @canSeeProvider INT=1
DECLARE @portNumber INT = 0
DECLARE @tempUserTable TABLE (userIdPrimaryContact INT, userName nvarchar(1024), userDisplayName nvarchar(1024),userEmail nvarchar(MAX))
-- NOTE: May want to investigate changing to TempTable with CLUSTERED INDEX on taskId
DECLARE @tempPlanTable TABLE (
	entityId INT,
	taskId INT,
	jobStartTime INT,
	isStartTimeOverridden INT,
	entityTypeSelectedForJobStartTime INT,
	jobStartTimeForPlan INT,
	numCopies INT DEFAULT NULL,
	numAssocEntities INT DEFAULT NULL,
	rpoInMinutes INT DEFAULT NULL
)
DECLARE @tenantAdminGroupId INT = 0
DECLARE @secAssocXML XML
DECLARE @encryptionXML XML
DECLARE @ownerCompany INT = 0
DECLARE @companyGroup INT = 0
DECLARE @o_errCode integer
DECLARE @o_errString nvarchar(1024)
DECLARE @isPrivacyFeatureEnabled INT= 0
DECLARE @filterxml XML
DECLARE @isJobStartTimeEnabled INT = 0
DECLARE @jobStartTime INT = NULL
DECLARE @authType       integer=1
DECLARE @enableAuthorizeForRestore integer=0
DECLARE @expirationTimeStamp integer = 0
CREATE TABLE #inputConsolidated
	(
		entityType1 INT,
		entityId1 INT,
		entityType2 INT,
		entityId2 INT,
		entityType3 INT,
		entityId3 INT,
		entityType4 INT,
		entityId4 INT,
		entityType5 INT,
		entityId5 INT,
		roleId INT DEFAULT 0,
		permissionId INT DEFAULT 0,
		userOrGroupId INT,
		isUser INT,
		includeAll INT DEFAULT 0,
		customRoleXML XML,
		entityAssociatedBlob XML,
		entityAssociatedModifiedBlob XML,
		roleName varchar(MAX)
	)
	INSERT INTO #inputConsolidated(entityAssociatedBlob, roleId, roleName,userORGroupId,isUser)
		SELECT Entity.query('entity'),
			  ISNULL(Entity.value('(properties/role/@roleId)[1]', 'INT'), -1),
			   ISNULL(Entity.value('(properties/role/@roleName)[1]', 'NVARCHAR(MAX)'), N''),
CASE WHEN ISNULL(Entity.value('(userOrGroup/@_type_)[1]', 'INT'), 0) =13 tHEN  ISNULL(Entity.value('(userOrGroup/@userId)[1]', 'INT'), 0)
WHEN ISNULL(Entity.value('(userOrGroup/@_type_)[1]', 'INT'), 0) =15 tHEN  ISNULL(Entity.value('(userOrGroup/@userGroupId)[1]', 'INT'), 0)
WHEN ISNULL(Entity.value('(userOrGroup/@_type_)[1]', 'INT'), 0) =61 tHEN  ISNULL(Entity.value('(userOrGroup/@providerId)[1]', 'INT'), 0)
			   END,
CASE WHEN ISNULL(Entity.value('(userOrGroup/@_type_)[1]', 'INT'), 0) =13 tHEN  1
WHEN ISNULL(Entity.value('(userOrGroup/@_type_)[1]', 'INT'), 0) =15 tHEN 0
WHEN ISNULL(Entity.value('(userOrGroup/@_type_)[1]', 'INT'), 0) =61 tHEN  2 END
		FROM @o_xmlText.nodes('App_SetSecurityAssociationsThreeWayAssociationRequest/associations') AS Input(Entity)
	UPDATE #inputConsolidated
	SET entityAssociatedModifiedBlob = dbo.getEntityTypeHirearchyXMLFromGenericEntityXML(entityAssociatedBlob)
	UPDATE #inputConsolidated
	SET entityType1 = (SELECT ref.value('@entityType1', 'INT') AS entityType1
					   FROM entityAssociatedModifiedBlob.nodes('entityAssociated') R (ref)),
		entityId1 = (SELECT ref.value('@entityId1', 'INT') AS entityId1
					   FROM entityAssociatedModifiedBlob.nodes('entityAssociated') R (ref)),
		entityType2 = (SELECT ref.value('@entityType2', 'INT') AS entityType2
					   FROM entityAssociatedModifiedBlob.nodes('entityAssociated') R (ref)),
		entityId2 = (SELECT ref.value('@entityId2', 'INT') AS entityId2
					   FROM entityAssociatedModifiedBlob.nodes('entityAssociated') R (ref)),
		entityType3 = (SELECT ref.value('@entityType3', 'INT') AS entityType3
					   FROM entityAssociatedModifiedBlob.nodes('entityAssociated') R (ref)),
		entityId3 = (SELECT ref.value('@entityId3', 'INT') AS entityId3
					   FROM entityAssociatedModifiedBlob.nodes('entityAssociated') R (ref)),
		entityType4 = (SELECT ref.value('@entityType4', 'INT') AS entityType4
					   FROM entityAssociatedModifiedBlob.nodes('entityAssociated') R (ref)),
		entityId4 = (SELECT ref.value('@entityId4', 'INT') AS entityId4
					   FROM entityAssociatedModifiedBlob.nodes('entityAssociated') R (ref)),
		entityType5 = (SELECT ref.value('@entityType5', 'INT') AS entityType5
					   FROM entityAssociatedModifiedBlob.nodes('entityAssociated') R (ref)),
		entityId5 = (SELECT ref.value('@entityId5', 'INT') AS entityId5
					   FROM entityAssociatedModifiedBlob.nodes('entityAssociated') R (ref))
 DECLARE @ProviderListForServiceCommcell TABLE (commcellId int ,providerId int ,providerName nvarchar(MAX))
 INSERT  INTO @ProviderListForServiceCommcell
 SELECT entityId1,id,domainName from
 (SELECT DISTINCT userorGRoupId as providerId,entityId1
 From  #inputConsolidated
 WHERE isUSer=2
 UNION
  SELECT DISTINCT umdsProviderId as providerId,entityId1
 From  #inputConsolidated JOIN UMGroups on userOrGroupId=id and isUser=0 and umdsProviderId<>0
 UNION
SELECT DISTINCT umdsProviderId as providerId,entityId1
 From  #inputConsolidated JOIN UMUSers on userOrGroupId=id and isUser=1 and umdsProviderId<>0) as TBL
 JOIN UMDSProviders on  providerId =id
DELETE TBL
FROM @ProviderListForServiceCommcell TBL JOIN APP_ComponentProp on componentType=1047 and componentId=commcellId
and propertyTypeId=2 and stringVal=providerName
--Delete all other providers except companies
DELETE TBL
FROM @ProviderListForServiceCommcell TBL INNER JOIN UMDSProviders UM on UM.id = TBL.providerId where UM.serviceType <> 5
DECLARE GetOrganizationPropertyCursor CURSOR FOR SELECT DISTINCT providerId from @ProviderListForServiceCommcell
 OPEN GetOrganizationPropertyCursor
    FETCH GetOrganizationPropertyCursor INTO @i_providerId
DECLARE @providerDetailTable TABLE(provideRId int, providerXML XML)
    WHILE   @@FETCH_STATUS = 0
    BEGIN
IF @canSeeProvider = 1
	BEGIN
		IF OBJECT_ID('tempdb.dbo.#getPlans') IS NOT NULL
            DROP TABLE #getPlans
		CREATE TABLE #getPlans
        (
            planId INT
        )
		SET @ownerCompany = dbo.AppGetCompanyForProvider(@i_providerId)
		SET @portNumber = ISNULL((Select fromPortNumber from APP_FirewallTppm with (nolock) where CAST(tppmParams AS INT) = @i_providerId AND tppmType = 4 AND status = 1),0)
SELECT @tenantAdminGroupId=UG.id FROM UMGroups UG where UG.groupFlags&0x10000 <> 0 and UG.umdsProviderId=@ownerCompany
		--@tenantAdminGroupId will be 0 when requested for commcell as company(id=0), or in case of misconfiguration.
		--No need to check for primary contact or plans when Tenanat Admin Group Id was not found. As these properties are set on Tenant Admin Group only.
		IF(@tenantAdminGroupId > 0)
		BEGIN
		INSERT INTO @tempUserTable SELECT UMU.id, UMU.login, UMU.name,UMU.email
						FROM UMUsers UMU  with (nolock)
						INNER JOIN UMUsersProp UUP  with (nolock)
							ON UMU.id=UUP.componentNameId
						INNER JOIN UMUserGroup UUG  with (nolock)
							ON UUG.userId=UUP.componentNameId
						WHERE UUG.groupId= @tenantAdminGroupId
										AND UUP.attrName = 'Primary Contact' and UUP.attrVal=N'1'
		END
		-- Populate the smart clientgroup id associated with this company
		IF @i_providerId > 0
		BEGIN
			SELECT @companyGroup = attrValInt FROM APP_ClientGroup CG
				INNER JOIN App_CompanyProp C ON C.attrVal = CAST(CG.id AS NVARCHAR(MAX))
WHERE C.componentNameId = @i_providerId AND C.attrName = 'Associated Smart Client Group' AND C.modified = 0 AND C.cs_attrName = checksum('Associated Smart Client Group')
		END
		-- create the provider property temporary table
		IF object_id('tempdb.dbo.#OrgPropTbl') IS NOT null DROP TABLE #OrgPropTbl
		CREATE TABLE #OrgPropTbl (
									PropertyName        varchar(256),
									propertyValue          nvarchar(MAX)
								)
		-- Get Encryption from App_company prop.
		-- Commcell with provider Id 0 , does not have default SCG, so use App_Company prop
		INSERT INTO #OrgPropTbl
		SELECT attrName, attrVal FROM  App_CompanyProp WHERE componentNameId=@ownerCompany
AND attrName in('Customization','Default Server Plan','Default Laptop Plan',
'Default Snap Plan','Primary Domain', 'Notification Email','Notification Sender Name',
'Creation Time','Default DB Plan','Default File System Plan','Default Virtual Server Backup Plan',
'Default Virtual Server Replication Plan', 'Authorization Code', 'Enable Auth Code Generation', '7b70af7d447e975e31f8504a337c5458f5d51604cabfbfca348e98db02d459be18cdbd8233a5d807',
'Header Template', 'Footer Template',
'Encryption Settings','Encrypt: Type','Encrypt: Key Length','Encrypt: drToolAccess',
'Prefer Machine Centric Client', 'Allow Users To Enable Privacy' ,'Use UPN For Email',
'EnableTwoFactorAuthentication','AllowOnPremiseStorage', 'completedSetups', 'supportedSolutions', 'PremiseStorageType',
'Disable Login','Disable Backup','Disable Restore', 'API Quota Limit','API Quota Time Frame', 'Always activate with default plan', 'Allow to Manage Other Companies',
'ClientOwnerAssignmentType', 'ClientOwnerAssignmentValue') and modified=0
		UNION
SELECT 'Sub Domain', _ID FROM dbo.SplitStringByDelimiter((SELECT attrVal FROM App_CompanyProp WHERE componentNameId=@ownerCompany  AND attrName = 'Sub Domain' and modified=0 AND cs_attrName = checksum('Sub Domain')),',')
		UNION
		SELECT CONVERT(VARCHAR(256),propertyTypeId), stringVal FROM  APP_ComponentProp WHERE componentId=@i_providerId AND componentType=10 and modified=0
		UNION
SELECT CONVERT(VARCHAR(256),propertyTypeId), CONVERT(NVARCHAR(MAX),longVal) FROM  APP_ComponentProp WITH(NOLOCK) WHERE componentId=@companyGroup AND propertyTypeId=3623 AND modified=0
			IF EXISTS(select 1 from  archGroup AG WHERE (
AG.flags & 33554432 = 33554432 OR
AG.flags & 256 = 256 OR
AG.flags & 16384 = 16384 OR
AG.flags & 8388608 = 8388608
			))
			BEGIN
INSERT INTO #OrgPropTbl values('canViewStoragePool', '1')
			END
DECLARE @enableAutoDiscovery INT = ISNULL((SELECT 1 FROM APP_AdvanceSettings WHERE entityId = @companyGroup AND entityType = 28 AND keyName = 'nEnableAutoDetectApp' AND type = 'INTEGER' AND relativePath = 'iDataAgent' AND enabled = 1 AND value LIKE '2'), 0)
		SET @o_xmlText =(SELECT
					(SELECT ISNULL((UD.login), '') as '@login' , ISNULL((UD.hostName), '') as '@connectName', ISNULL((UD.description), '') as '@description',
										UD.flags as '@flags', UD.enabled as '@enabled', UD.serviceType as '@serviceType', UD.useSecureLdap as '@useSecureLdap', @portNumber as '@port',
(SELECT attrVal from UMDSProviderProp where attrName='Password History Count' and componentNameId=@i_providerId and modified=0) as '@pswdHistoryCount',
										(SELECT attrVal as '@val'   from UMDSProviderProp where attrName='Email Domain' and componentNameId=@i_providerId FOR XML PATH ('emailDomainNames') ,Type),
										(SELECT UD.id as '@id', UD.domainName as '@domainName' FOR XML PATH('shortName'),TYPE),
(SELECT ISNULL((SELECT propertyValue FROM #OrgPropTbl where PropertyName='Disable Login'),0) AS '@disableLogin',
ISNULL((SELECT propertyValue FROM #OrgPropTbl where PropertyName='Disable Backup'),0) AS '@disableBackup',
ISNULL((SELECT propertyValue FROM #OrgPropTbl where PropertyName='Disable Restore'),0) AS '@disableRestore' FOR XML PATH('deactivateOptions'),TYPE),
										(SELECT UD.resourceId as '@id', ISNULL((Select domainName from UMDSproviders UMDS with (nolock) where UMDS.id = UD.resourceId), 'N/A') as '@domainName' FOR XML PATH('resourceProvider'),TYPE)
								FROM UMDSProviders UD with (nolock) where UD.id in (@i_providerId) FOR XML PATH('organization'),TYPE),
								(SELECT P.type          AS '@type',
										P.subType       AS '@subtype',
										P.description   AS '@descripiton',
										P.flag			AS '@planStatusFlag',
										TP.jobStartTime '@jobStartTime',
										TP.isStartTimeOverridden '@isStartTimeOverridden',
										TP.entityTypeSelectedForJobStartTime '@entityTypeSelectedForJobStartTime',
										TP.numCopies '@numCopies',
										TP.numAssocEntities '@numAssocEntities',
										TP.rpoInMinutes '@rpoInMinutes',
										(SELECT COUNT(A.userId) FROM
											(SELECT DISTINCT userId FROM UMUserGroup WHERE groupId IN
												(SELECT CAST(attrVal AS INT) FROM APP_PlanProp WHERE componentNameId = P.id AND attrName IN
('Assigned user group', 'Associated internal user group', 'Associated external user group' ))) A ) AS '@numUsers',
												0  AS '@numDevices',
ISNULL((SELECT CAST(attrVal AS INT) FROM APP_PlanProp WHERE componentNameId = P.id AND attrName = 'Derivation restrictions'), 0)  AS '@restrictions',
										(SELECT P.id            AS '@planId',
												 P.name	        AS '@planName',
158    AS '@_type_'    -- defined in CVEntities.x
										  FOR XML PATH('plan'), TYPE
										),
										(SELECT PP.id           AS '@planId',
												 PP.name	     AS '@planName',
158     AS '@_type_'    -- defined in CVEntities.x
										  FROM	 APP_Plan PP
WHERE	 PP.id IN (SELECT CAST(attrVal AS INT) FROM APP_PlanProp WHERE componentNameId = P.id AND attrName = 'Base plan')
										  FOR XML PATH('parent'), TYPE
										)
									FROM App_Plan P
										INNER JOIN @tempPlanTable TP
ON P.id = TP.entityId WHERE P.flag & 0x40000000 = 0
								 FOR XML PATH('planDetails'),TYPE),
									(SELECT
(SELECT	propertyValue FROM #OrgPropTbl where PropertyName='Primary Domain') AS '@primaryDomain',
(SELECT	propertyValue FROM #OrgPropTbl where PropertyName='Customization') AS '@customization',
(SELECT	propertyValue FROM #OrgPropTbl where PropertyName='Notification Email') AS '@senderSmtp',
(SELECT	propertyValue FROM #OrgPropTbl where PropertyName='Notification Sender Name') AS '@senderName',
(SELECT	propertyValue FROM #OrgPropTbl where PropertyName='Prefer Machine Centric Client') AS '@preferenceMachineCentricClient',
(SELECT	propertyValue FROM #OrgPropTbl where PropertyName='Creation Time') AS '@orgCreationDateTime',
(SELECT propertyValue FROM #OrgPropTbl where PropertyName='Use UPN For Email') AS '@useUPNForEmail',
ISNULL((SELECT propertyValue FROM #OrgPropTbl where PropertyName='AllowOnPremiseStorage'),0) AS '@allowOnPremiseStorage',
ISNULL((SELECT propertyValue FROM #OrgPropTbl where PropertyName='Allow to Manage Other Companies'),0) AS '@canCreateCompanies',
ISNULL((SELECT propertyValue FROM #OrgPropTbl where PropertyName=CONVERT(varchar(256),3623)),1) AS '@showDLP',
									@isPrivacyFeatureEnabled AS '@isPrivacyFeatureEnabledAtCommcell',
(SELECT propertyValue FROM #OrgPropTbl where PropertyName='EnableTwoFactorAuthentication') AS '@enableTwoFactorAuthentication',
ISNULL((SELECT propertyValue FROM #OrgPropTbl where PropertyName='completedSetups'),'') AS '@completedSetups',
									-- for null supportedSolutions and supported solutions value 0, we fetch from GxGlobalParam
ISNULL((SELECT propertyValue FROM #OrgPropTbl where PropertyName='supportedSolutions' AND propertyValue <> '0'),ISNULL((SELECT value FROM GxGlobalParam WITH (NOLOCK) WHERE name = 'supportedSolutions'),4127)) AS '@supportedSolutions',
ISNULL((SELECT propertyValue FROM #OrgPropTbl where PropertyName='canViewStoragePool'),0) AS '@canViewStoragePool',
ISNULL((SELECT propertyValue FROM #OrgPropTbl where PropertyName='PremiseStorageType'),0) AS '@infrastructureType',
(SELECT	propertyValue FROM #OrgPropTbl where PropertyName='Authorization Code' AND ((SELECT propertyValue FROM #OrgPropTbl where PropertyName='Enable Auth Code Generation') = 1)) AS '@authCode',
									@enableAutoDiscovery AS '@enableAutoDiscovery',
ISNULL((SELECT	propertyValue FROM #OrgPropTbl where PropertyName='ClientOwnerAssignmentType'), 0) AS '@autoClientOwnerAssignmentType',
ISNULL((SELECT	propertyValue FROM #OrgPropTbl where PropertyName='ClientOwnerAssignmentValue'), '') AS '@autoClientOwnerAssignmentValue',
ISNULL((SELECT	propertyValue FROM #OrgPropTbl where PropertyName='Enable Auth Code Generation'),0) AS '@enableAuthCodeGen',
(SELECT propertyValue FROM #OrgPropTbl where PropertyName='Allow Users To Enable Privacy') AS '@allowUsersToEnablePrivacy',
ISNULL((SELECT propertyValue FROM #OrgPropTbl where PropertyName='Always activate with default plan'),0) AS '@alwaysActivateWithDefaultPlan',
									(
										SELECT  33554437     AS '@subtype' ,
											(
												SELECT PP.id           AS '@planId', PP.name	     AS '@planName'
										FROM	 #OrgPropTbl t
										inner join APP_Plan PP on pp.id=t.propertyValue
where t.PropertyName='Default Server Plan'
											FOR XML PATH('plan'), TYPE)
FROM	 #OrgPropTbl t1 	where t1.PropertyName='Default Server Plan'
								FOR XML PATH('defaultPlans'), TYPE),
									(
										SELECT  33554439     AS '@subtype' ,
										(
											SELECT PP.id           AS '@planId', PP.name	     AS '@planName'
										FROM	 #OrgPropTbl t
										inner join APP_Plan PP on pp.id=t.propertyValue
WHERE t.PropertyName='Default Laptop Plan'
										  FOR XML PATH('plan'), TYPE
										)
FROM #OrgPropTbl t1 	where t1.PropertyName='Default Laptop Plan'
								FOR XML PATH('defaultPlans'), TYPE),
									(SELECT  67108869     AS '@subtype' ,
								(SELECT PP.id           AS '@planId', PP.name	     AS '@planName'
										FROM	 #OrgPropTbl t
										inner join APP_Plan PP on pp.id=t.propertyValue
where t.PropertyName='Default Snap Plan'
										  FOR XML PATH('plan'), TYPE
										)
FROM	 #OrgPropTbl t1 	where t1.PropertyName='Default Snap Plan'
								FOR XML PATH('defaultPlans'), TYPE),
                                ----
                                	(
										SELECT  33579013     AS '@subtype' ,
											(
												SELECT PP.id           AS '@planId', PP.name	     AS '@planName'
										FROM	 #OrgPropTbl t
										inner join APP_Plan PP on pp.id=t.propertyValue
where t.PropertyName='Default DB Plan'
											FOR XML PATH('plan'), TYPE)
FROM	 #OrgPropTbl t1 	where t1.PropertyName='Default DB Plan'
								FOR XML PATH('defaultPlans'), TYPE),
                                	(
										SELECT  50331655     AS '@subtype' ,
											(
												SELECT PP.id           AS '@planId', PP.name	     AS '@planName'
										FROM	 #OrgPropTbl t
										inner join APP_Plan PP on pp.id=t.propertyValue
where t.PropertyName='Default File System Plan'
											FOR XML PATH('plan'), TYPE)
FROM	 #OrgPropTbl t1 	where t1.PropertyName='Default File System Plan'
								FOR XML PATH('defaultPlans'), TYPE),
                                	(
										SELECT  83886085     AS '@subtype' ,
											(
												SELECT PP.id           AS '@planId', PP.name	     AS '@planName'
										FROM	 #OrgPropTbl t
										inner join APP_Plan PP on pp.id=t.propertyValue
where t.PropertyName='Default Virtual Server Backup Plan'
											FOR XML PATH('plan'), TYPE)
FROM	 #OrgPropTbl t1 	where t1.PropertyName='Default Virtual Server Backup Plan'
								FOR XML PATH('defaultPlans'), TYPE),
                                (
										SELECT  83918853     AS '@subtype' ,
											(
												SELECT PP.id           AS '@planId', PP.name	     AS '@planName'
										FROM	 #OrgPropTbl t
										inner join APP_Plan PP on pp.id=t.propertyValue
where t.PropertyName='Default Virtual Server Replication Plan'
											FOR XML PATH('plan'), TYPE)
FROM	 #OrgPropTbl t1 	where t1.PropertyName='Default Virtual Server Replication Plan'
								FOR XML PATH('defaultPlans'), TYPE),
									(SELECT TU.userDisplayName as '@fullName',TU.userEmail as '@email',
									(SELECT 13 '@_type_', TU.userIdPrimaryContact as '@userId', TU.userName as '@userName'  FOR XML PATH('user'),TYPE)
									FROM @tempUserTable TU FOR XML PATH('primaryContacts'),TYPE),
(SELECT propertyValue AS '@val' FROM #OrgPropTbl WHERE PropertyName='Sub Domain'  FOR XML PATH('additionalDomains'), TYPE),
								(SELECT
ISNULL((SELECT propertyValue FROM #OrgPropTbl where PropertyName = 'Encryption Settings'),3 /*Not Set*/) as  '@encryptionSettings',
ISNULL((SELECT propertyValue FROM #OrgPropTbl where PropertyName = 'Encrypt: Type'),2) as '@cipherType',
ISNULL((SELECT propertyValue FROM #OrgPropTbl where PropertyName = 'Encrypt: drToolAccess'),0) as '@directMediaAccess',
ISNULL((SELECT propertyValue FROM #OrgPropTbl where PropertyName = 'Encrypt: Key Length'),128) as '@encryptKeyLength'
									FOR XML PATH('encryptionInfo'),TYPE),
								(SELECT
(SELECT propertyValue FROM #OrgPropTbl where PropertyName = 'Header Template') as  '@headerTemplate',
(SELECT propertyValue FROM #OrgPropTbl where PropertyName = 'Footer Template') as '@footerTemplate'
									FOR XML PATH('emailTemplateSettings'),TYPE),
								(SELECT @filterxml FOR XML PATH ('globalFiltersInfo'), TYPE),
								(SELECT
									 ISNULL((SELECT	(
													 CASE
WHEN propertyValue = 'a45fabb9712142ea42da80d2c0314cf1f871cea2571f6bda4152f645e2424b592f0ac7691aec175a' THEN 1
													 ELSE 0
													 END
)  FROM #OrgPropTbl where PropertyName='7b70af7d447e975e31f8504a337c5458f5d51604cabfbfca348e98db02d459be18cdbd8233a5d807'),0) AS '@enableDataSecurity'
									 FOR XML PATH('privacy'),TYPE),
								(
									SELECT CASE WHEN userId <> 0 THEN email END AS '@email',			-- Anand and Bhavyan want to display these details as well.
										   CASE WHEN userId <> 0 THEN fullName END AS '@fullName',
										   CASE WHEN userId <> 0 THEN
												(SELECT userId AS '@userId',
														login AS '@userName'
												FOR XML PATH ('user'), TYPE)
										   END,
										   CASE WHEN userGroupId <> 0 THEN
												(SELECT userGroupId AS '@userGroupId',
														userGroupName AS '@userGroupName'
												FOR XML PATH ('userGroup'), TYPE)
										   END,
										   CASE WHEN roleId <> 0 THEN
												(SELECT roleId AS '@roleId',
														roleName AS '@roleName'
												FOR XML PATH ('role'), TYPE
												)
										   END
									FROM dbo.sec_getCommvaultResellersForCompany(@i_providerId)
									FOR XML PATH('operators'), TYPE
								)
								,(
									SELECT attrValInt AS '@roleId'
										   ,R.name AS '@roleName'
									FROM APP_CompanyProp (NOLOCK) CP
										INNER JOIN UMRoles R (NOLOCK)
											ON CP.attrVal = CAST(R.id AS NVARCHAR(MAX))
									WHERE
										componentNameId = @i_providerId
AND attrName = 'Operator Role'
AND CP.modified = 0 AND CP.cs_attrName = checksum('Operator Role')
									FOR XML PATH ('operatorRole'), TYPE
								)
								,(
									SELECT @authType AS '@authType',
										 (SELECT @enableAuthorizeForRestore as '@enableAuthorizeForRestore',
										 (SELECT @expirationTimeStamp as '@time'
											 FOR XML PATH('expirationTime'), TYPE)
										 FOR XML PATH('passkeySettings'), TYPE)
										 FOR XML PATH('advancedPrivacySettings'),TYPE
								)
,(SELECT id as '@IdentityServerId',domainName as '@IdentityServerName','AD' as '@type',1 as '@isConfigured' from UMDSProviders where ownerCompany = @i_providerId and serviceType in  (2,8,9,10,14)  for xml path ('ExternalAuthentication'),type),
(SELECT id as '@IdentityServerId',domainName as '@IdentityServerName','AD' as '@type',0 as '@isConfigured' from UMDSProviders where ownerCompany = @i_providerId and serviceType = 12 and (flags & 8 = 0)  for xml path ('ExternalAuthentication'),type),
(SELECT ATPA.id as '@IdentityServerId',appName as '@IdentityServerName','SAML' as '@type',1 as '@isConfigured' from App_ThirdPartyApp ATPA inner join UMDSProviderProp UPP on UPP.attrVal = ATPA.id INNER JOIN UMDSProviders UP on UP.id = UPP.componentNameId where  UPP.attrName='SAML IDP' and UP.ownerCompany = @i_providerId and UP.serviceType = 11  for xml path ('ExternalAuthentication'),type)
								,(SELECT
ISNULL((SELECT propertyValue FROM #OrgPropTbl where PropertyName = 'API Quota Limit'),0) as  '@APILimit',
ISNULL((SELECT propertyValue FROM #OrgPropTbl where PropertyName = 'API Quota Time Frame'),0) as '@APItimeFrame'
									FOR XML PATH('apiQuota'),TYPE)
								FOR XML PATH('organizationProperties'), TYPE)
						FOR XML PATH('organizationInfo'),TYPE)
	END
INSERT INTO @providerDetailTable
SELECT @i_providerId,@o_xmlText
  FETCH GetOrganizationPropertyCursor INTO @i_providerId
END
 CLOSE GetOrganizationPropertyCursor
 DEALLOCATE GetOrganizationPropertyCursor
declare @redirectList table (id int,appName nvarchar(255),redirectURL nvarchar(255))
insert into @redirectList
select id,appName,
              t2.loc.query('.').value('nameValues[1]/@value','nvarchar(255)') as 'redirectURL'
              from App_ThirdPartyApp  cross apply props.nodes('./props/nameValues') as t2(loc)
              where t2.loc.query('.').value('nameValues[1]/@name','nvarchar(255)') ='RedirectUrl' and
              t2.loc.query('.').value('nameValues[1]/@name','nvarchar(255)') ='RedirectUrl' and
                 appType = 3
delete from @redirectList where id in (select id
              from App_ThirdPartyApp  cross apply props.nodes('./props/nameValues') as t2(loc)
              where t2.loc.query('.').value('nameValues[1]/@name','nvarchar(255)') ='Enable Sso Redirect' and t2.loc.query('.').value('nameValues[1]/@value','int') =0)
SELECT AC.id as id, AC.aliasName as serviceCommcell,RL.redirectURL  redirectURL, Detail.providerXML providerXML
from @redirectList RL
inner join APP_CommCell AC on AC.csGUID = RL.appName
JOIN @ProviderListForServiceCommcell Assoc on commcellId=AC.id
JOIN @providerDetailTable Detail ON Detail.provideRId=Assoc.providerId
inner join APP_CommCellProp ACP on ACP.CommCellId = AC.id
where (ACP.CommcellType & 8 = 8)
END TRY
BEGIN CATCH
CLOSE GetOrganizationPropertyCursor
DEALLOCATE GetOrganizationPropertyCursor
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    set @o_errCode = ERROR_NUMBER()
    set @o_errString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
	SET @o_xmlText = (SELECT '' FOR XML PATH ('Api_OrganizationInfo'),TYPE)
	select @o_xmlText
	GOTO SCRIPT_EXIT
END CATCH
SCRIPT_EXIT:
  	IF OBJECT_ID('tempdb.dbo.#getPlans') IS NOT NULL
            DROP TABLE #getPlans
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'MCC_GetCompanyPropertiesForServiceCommcell')
	delete from GxQscripts where name = 'MCC_GetCompanyPropertiesForServiceCommcell'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MCC_GetCompanyPropertiesForServiceCommcell')
	delete from GXDBVersions where aliasname = 'MCC_GetCompanyPropertiesForServiceCommcell'
GO

insert into GXDBVersions values(2, 'MCC_GetCompanyPropertiesForServiceCommcell',  'v1.1.2.4.20.1', 'MCC_GetCompanyPropertiesForServiceCommcell', 'v1.1.2.4.20.1')
GO

