

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MCC_GetCompanyGuidInCloudService.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--  +-----------------------------------------------------------------------+
--  |           Procedure : "MCC_GetCompanyGuidInCloudService"
--  |   This Procedure is used to set subscribed cloud service details
--  |   on local CS.
--  +-----------------------------------------------------------------------+
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='MCC_GetCompanyGuidInCloudService')
BEGIN
	print '>>> Drop Stored Procedure: MCC_GetCompanyGuidInCloudService <<<'
	drop procedure MCC_GetCompanyGuidInCloudService
END
IF EXISTS (select * from GxQscripts where name='MCC_GetCompanyGuidInCloudService')
	delete from GxQscripts where name = 'MCC_GetCompanyGuidInCloudService'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MCC_GetCompanyGuidInCloudService')
	delete from GXDBVersions where aliasname = 'MCC_GetCompanyGuidInCloudService'
GO
print '... Creating Procedure: MCC_GetCompanyGuidInCloudService'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure MCC_GetCompanyGuidInCloudService
  @i_userId INT 
AS
  DECLARE @companyGuidInCloudService nvarchar(max) = ''
DECLARE @ownerCompanyId INT =  dbo.AppGetOrganizationForUser(@i_userId)
	BEGIN TRY
	IF(@ownerCompanyId IS NOT NULL AND @ownerCompanyId > 0)
	BEGIN
SET @companyGuidInCloudService = (Select attrVal from app_companyprop where componentNameId = @ownerCompanyId and attrName = 'Cloud Service Company Guid' and modified = 0)
	END
	ELSE
	BEGIN
		DECLARE @cloudServiceClientId INT = 0
SET @cloudServiceClientId = (Select  componentNameId from APP_ClientProp where attrName = 'Commcell role' and attrType = 2 and attrVal = 5)
SET @companyGuidInCloudService = (Select attrVal from app_clientprop where componentNameId = @cloudServiceClientId and attrName = 'Cloud Service Company Guid' and modified = 0 )
	END
	END TRY
	BEGIN CATCH
		PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
			ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
			PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
			ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
			ERROR MESSAGE: ' + ERROR_MESSAGE() + '
			ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
			ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	END CATCH
Select @companyGuidInCloudService
GO

IF EXISTS (select * from GxQscripts where name = 'MCC_GetCompanyGuidInCloudService')
	delete from GxQscripts where name = 'MCC_GetCompanyGuidInCloudService'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MCC_GetCompanyGuidInCloudService')
	delete from GXDBVersions where aliasname = 'MCC_GetCompanyGuidInCloudService'
GO

insert into GXDBVersions values(2, 'MCC_GetCompanyGuidInCloudService',  '00000000000000000000', 'MCC_GetCompanyGuidInCloudService', '00000000000000000000')
GO

