

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MCC_GetCommvaultIdTokenDetailsToValidate.sp] ---------- 

SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MCC_GetCommvaultIdTokenDetailsToValidate <<<'

IF EXISTS (select * from sysobjects where name='MCC_GetCommvaultIdTokenDetailsToValidate')
	drop procedure MCC_GetCommvaultIdTokenDetailsToValidate
IF EXISTS (select * from GxQscripts where name='MCC_GetCommvaultIdTokenDetailsToValidate')
	delete from GxQscripts where name = 'MCC_GetCommvaultIdTokenDetailsToValidate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MCC_GetCommvaultIdTokenDetailsToValidate')
	delete from GXDBVersions where aliasname = 'MCC_GetCommvaultIdTokenDetailsToValidate'
GO
print '... Creating Procedure: MCC_GetCommvaultIdTokenDetailsToValidate'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MCC_GetCommvaultIdTokenDetailsToValidate
  @commvaultId NVARCHAR(255),
  @commcellId INTEGER,
  @localuser NVARCHAR(255),
  @samlFeature INT=0
AS
  DECLARE @commvaultIdGuid VARCHAR(255)
  DECLARE @localUserGuid VARCHAR(255)
  DECLARE @password VARCHAR(255)
  DECLARE @oldpassword1 VARCHAR(255)
  DECLARE @oldpassword2 VARCHAR(255)
declare @id_commvaultUser INTEGER
declare @userEntities NVARCHAR(MAX)
declare @xmlText XML
declare @userEntityTable table
(
userName NVARCHAR(255),
userGuid VARCHAR(255)
)
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
 --get all localusers associated with the cloud user from a commcell
IF @samlFeature=3 --CredentialUpdate
BEGIN
	--validation for password updation
	declare @id_localUser INTEGER
	select @id_localUser=id,@localUserGuid=userGuid from UMUsers
	where login = @localuser
    select @id_commvaultUser=cast(attrVal as INT) from UMUsersProp
where attrName='Linked CommvaultId' and componentNameId=@id_localuser and modified=0
	select @commvaultIdGuid= userGuid, @password=password from UMUsers
	where id=@id_commvaultUser
END
ELSE IF @samlFeature = 2 --LinkedCommvaultId
BEGIN
    --validation of local users in cloud
	select @id_commvaultUser = id, @commvaultIdGuid = userGuid ,
	@password = password from UMUsers where login = @commvaultId
	--get list of all local users associated with a cloud user in a commcell
	select @userEntities=coalesce(@userEntities,'')+stringVal from APP_ComponentProp
where componentType = 17 and componentid = @id_commvaultUser and longVal = @commcellId and propertyTypeId = 1
	set @xmlText = @userEntities
	insert into @userEntityTable (userName,userGuid)
	select
	ref.value('@userName','nvarchar(255)'),
	ref.value('@userGUID','nvarchar(255)')
	FROM    @xmlText.nodes('CvEntities_UserEntity') R ( ref )
	select @localUserGuid = userGuid from @userEntityTable
	where userName = @localUser
END
ELSE IF @samlFeature = 4 --CredentialUpdatePull
BEGIN
    --validation of local users in cloud
	select @id_commvaultUser = id, @commvaultIdGuid = userGuid ,
	@password = password from UMUsers where login = @commvaultId
	--get list of all local users associated with a cloud user in a commcell
	select @userEntities=coalesce(@userEntities,'')+stringVal from APP_ComponentProp
where componentType = 17 and componentid = @id_commvaultUser and longVal = @commcellId and propertyTypeId = 1
	set @xmlText = @userEntities
	insert into @userEntityTable (userName,userGuid)
	select
	ref.value('@userName','nvarchar(255)'),
	ref.value('@userGUID','nvarchar(255)')
	FROM    @xmlText.nodes('CvEntities_UserEntity') R ( ref )
	select @localUserGuid = userGuid from @userEntityTable
	where userName = @localUser
	select top 1 @oldpassword1=attrVal from UMUsersprop
	where componentNameId=@id_commvaultUser and attrName='Old Password Hash' and modified=0 order by created desc
	select top 1 @oldpassword2=attrVal from UMUsersprop
	where componentNameId=@id_commvaultUser and attrName='Old Password Hash' and attrVal<>@oldpassword1 and modified=0 order by created desc
END
 select @commvaultIdGuid, @localUserGuid, @password,@oldpassword1,@oldpassword2
GO

IF EXISTS (select * from GxQscripts where name = 'MCC_GetCommvaultIdTokenDetailsToValidate')
	delete from GxQscripts where name = 'MCC_GetCommvaultIdTokenDetailsToValidate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MCC_GetCommvaultIdTokenDetailsToValidate')
	delete from GXDBVersions where aliasname = 'MCC_GetCommvaultIdTokenDetailsToValidate'
GO

insert into GXDBVersions values(2, 'MCC_GetCommvaultIdTokenDetailsToValidate',  '00000000000000000000', 'MCC_GetCommvaultIdTokenDetailsToValidate', '00000000000000000000')
GO

