

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MCC_GetCloudServiceDetailsOnLocalCS.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--  +-----------------------------------------------------------------------+
--  |           Procedure : "MCC_GetCloudServiceDetailsOnLocalCS"
--  |   This Procedure is used to get subscribed cloud services on local CS.
--  | When Customer subscribes to cloud service, cloud details are stored in customer DB.
--  | Every subscription has an entry in App_Commcell table.
--  | Every commcell has security associations in UMSecurityAssociations table.
--  +-----------------------------------------------------------------------+
SET ANSI_NULLS ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='MCC_GetCloudServiceDetailsOnLocalCS')
BEGIN
	print '>>> Drop Stored Procedure: MCC_GetCloudServiceDetailsOnLocalCS <<<'
	drop procedure MCC_GetCloudServiceDetailsOnLocalCS
END
IF EXISTS (select * from GxQscripts where name='MCC_GetCloudServiceDetailsOnLocalCS')
	delete from GxQscripts where name = 'MCC_GetCloudServiceDetailsOnLocalCS'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MCC_GetCloudServiceDetailsOnLocalCS')
	delete from GXDBVersions where aliasname = 'MCC_GetCloudServiceDetailsOnLocalCS'
GO
print '... Creating Procedure: MCC_GetCloudServiceDetailsOnLocalCS'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure MCC_GetCloudServiceDetailsOnLocalCS
  @userId INT, 
  @redirectUrl NVARCHAR(MAX) = ''
AS
DECLARE @xmlText XML
DECLARE @errorCode INT = 0
DECLARE @errorString nvarchar(MAX) = ''
DECLARE @nowTime INT = 0
DECLARE @ownerCompanyId INT = 0
SET @nowTime = dbo.GetUnixTime(GETUTCDATE())
SET @ownerCompanyId = dbo.AppGetOrganizationForUser(@userId)
IF object_id('tempdb.dbo.#CloudServiceDetails') IS NOT Null DROP TABLE #CloudServiceDetails
CREATE TABLE #CloudServiceDetails
(
	csClientId int,
    redirectUrl nvarchar(MAX),
    commcellName nvarchar(MAX),
	companyGuid nvarchar(MAX),
	companyAlias nvarchar(MAX)
)
IF OBJECT_ID('tempdb.dbo.#getMemberUserGroupsHelperOutputTbl') IS NOT NULL
    DROP TABLE #getMemberUserGroupsHelperOutputTbl
CREATE TABLE #getMemberUserGroupsHelperOutputTbl
(
    isUser INT,
    userOrgroupId INT,
    UNIQUE CLUSTERED(isUser, userOrGroupId)
)
IF @userId = 0
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Invalid User'
	GOTO PROC_EXIT
END
-- Security check
-- If user is associated with cloud service then allow.
BEGIN
	-- Insert user groups
	EXEC sec_getMemberUserGroupsHelper @userId
	--Insert domain and company also.
	DECLARE @companyId INT =0
	DECLARE @umdsproviderId INT = (SELECT umdsproviderId from UMUsers where id=@userId)
	DECLARE @userName nvarchar(255) = (select login from UMUsers where id=@userId)
	if(@umdsproviderId<>0)
		BEGIN
SET @companyId = ISNULL((SELECT ownerCompany from UMDSProviders where id=@umdsproviderId and serviceType <> 5),0)
			INSERT INTO #getMemberUserGroupsHelperOutputTbl
			SELECT 2,@umdsproviderID
		END
	IF(@companyId<>0)
	BEGIN
		INSERT INTO #getMemberUserGroupsHelperOutputTbl
			SELECT 2,@companyId
	END
END
-- If redirectUrl is given in input then include only 1 cloud service details
IF(@redirectUrl <> '')
BEGIN
	IF(@ownerCompanyId = 0)
	BEGIN
		-- include cloud service details for given redirectUrl
		-- include cloud service details based on security check
		INSERT INTO #CloudServiceDetails (csClientId)
		SELECT ACP.componentNameId FROM APP_ClientProp ACP
		INNER JOIN App_ClientProp ACP2
ON ACP.attrName = 'Commcell role' AND ACP.attrVal = 5 AND ACP.componentNameId = ACP2.componentNameId AND ACP2.attrName = 'Service commcell end point'
		INNER JOIN App_Commcell AC
			ON ACP.componentNameId = AC.clientId
		INNER JOIN UMSecurityAssociations UMA
ON UMA.entityType1 = 194 AND UMA.entityId1 = AC.id
		INNER JOIN #getMemberUserGroupsHelperOutputTbl member
			ON UMA.isUSer = member.isUSer and UMA.userORGroupId = member.userORGroupId
		WHERE ACP2.attrVal = @redirectUrl
	END
	ELSE IF(@ownerCompanyId > 0)
	BEGIN
		-- include cloud service details for given redirectUrl
		-- include cloud service details based on security check
		INSERT INTO #CloudServiceDetails (csClientId)
		SELECT ACP.componentNameId FROM APP_ClientProp ACP
		INNER JOIN App_CompanyProp ACP2
ON ACP.attrName = 'Commcell role' AND ACP.attrVal = 5 AND ACP.componentNameId = ACP2.attrValInt AND ACP2.attrName = 'Service commcell end point'
		INNER JOIN App_Commcell AC
			ON ACP.componentNameId = AC.clientId
		INNER JOIN UMSecurityAssociations UMA
ON UMA.entityType1 = 194 AND UMA.entityId1 = AC.id
		INNER JOIN #getMemberUserGroupsHelperOutputTbl member
			ON UMA.isUSer = member.isUSer and UMA.userORGroupId = member.userORGroupId
		WHERE ACP2.attrVal = @redirectUrl
	END
END
ELSE  -- redirectUrl is not given, include all cloud services details according to security assoc
BEGIN
	-- Include cloud service subscriptions on which user has rights
	INSERT INTO #CloudServiceDetails (csClientId)
	SELECT ACP.componentNameId FROM APP_ClientProp ACP
	INNER JOIN App_Commcell AC
ON AC.clientId = ACP.componentNameId AND  ACP.attrName = 'Commcell role' AND ACP.attrVal = 5
	INNER JOIN UMSecurityAssociations UMA
ON UMA.entityType1 = 194 AND UMA.entityId1 = AC.id
	INNER JOIN #getMemberUserGroupsHelperOutputTbl member
		ON UMA.isUSer = member.isUSer and UMA.userORGroupId = member.userORGroupId
END
Update CD SET redirectUrl = attrVal FROM #CloudServiceDetails CD
INNER JOIN App_ClientProp ACP ON ACP.componentNameId = CD.csClientId AND ACP.attrName = 'Service commcell end point'
Update CD SET commcellName = aliasName FROM #CloudServiceDetails CD
INNER JOIN App_Commcell CC ON CC.clientId = CD.csClientId
Update CD SET companyAlias = ACP.attrVal FROM #CloudServiceDetails CD
INNER JOIN APP_ClientProp ACP ON ACP.componentNameId = CD.csClientId AND ACP.attrName = 'Cloud Service Company Alias'
Update CD SET companyGuid = ACP.attrVal FROM #CloudServiceDetails CD
INNER JOIN APP_ClientProp ACP ON ACP.componentNameId = CD.csClientId AND ACP.attrName = 'Cloud Service Company Guid'
IF(@ownerCompanyId > 0)
BEGIN
Update #CloudServiceDetails SET redirectUrl = (Select attrVal FROM App_CompanyProp ACP Where componentNameId=@ownerCompanyId AND ACP.attrName = 'Service commcell end point')
END
PROC_EXIT:
	SET @xmlText =
			(SELECT
				(SELECT(SELECT commcellName AS '@commcellName',
				redirectUrl AS '@redirectUrl' FOR XML PATH('cloudService'), TYPE),
				(SELECT companyGuid AS '@GUID', companyAlias AS '@companyAlias' FOR XML PATH('associatedCompany'), TYPE)
			FROM #CloudServiceDetails
			FOR XML PATH('cloudServices'), TYPE)
			FOR XML PATH ('App_CloudServiceDetailsList'), TYPE)
SELECT @xmlText
GO

IF EXISTS (select * from GxQscripts where name = 'MCC_GetCloudServiceDetailsOnLocalCS')
	delete from GxQscripts where name = 'MCC_GetCloudServiceDetailsOnLocalCS'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MCC_GetCloudServiceDetailsOnLocalCS')
	delete from GXDBVersions where aliasname = 'MCC_GetCloudServiceDetailsOnLocalCS'
GO

insert into GXDBVersions values(2, 'MCC_GetCloudServiceDetailsOnLocalCS',  '00000000000000000000', 'MCC_GetCloudServiceDetailsOnLocalCS', '00000000000000000000')
GO

