

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MCC_GetCloudServiceDetails.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--  +-----------------------------------------------------------------------+
--  |           Procedure : "MCC_GetCloudServiceDetails"
--  |   This Procedure is used to get subscribed cloud service details
--  |   on cloud service CS (e.g. metallic).
--  |   Other details such as Associated company for given user are also returned.
--  +-----------------------------------------------------------------------+
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='MCC_GetCloudServiceDetails')
BEGIN
	print '>>> Drop Stored Procedure: MCC_GetCloudServiceDetails <<<'
	drop procedure MCC_GetCloudServiceDetails
END
IF EXISTS (select * from GxQscripts where name='MCC_GetCloudServiceDetails')
	delete from GxQscripts where name = 'MCC_GetCloudServiceDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MCC_GetCloudServiceDetails')
	delete from GXDBVersions where aliasname = 'MCC_GetCloudServiceDetails'
GO
print '... Creating Procedure: MCC_GetCloudServiceDetails'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure MCC_GetCloudServiceDetails
  @userId INT, 
  @xmlText XML OUTPUT
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @errorCode INT = 0
DECLARE @errorString nvarchar(MAX) = ''
DECLARE @nowTime INT = 0
SET @nowTime = dbo.GetUnixTime(GETUTCDATE())
IF object_id('tempdb.dbo.#associatedCompany') IS NOT Null DROP TABLE #associatedCompany
CREATE TABLE #associatedCompany
(
    companyId INT,
    companyName nvarchar(MAX),
	companyAlias nvarchar(MAX),
	companyGUID nvarchar(MAX)
)
-- Get Commcell Information (i.e. cloud Service)
IF object_id('tempdb.dbo.#CommcellInfo') IS NOT Null DROP TABLE #CommcellInfo
CREATE TABLE #CommcellInfo
(
    csGuid nvarchar(80),
    encNumber nvarchar(512),
	commcellName nvarchar(512),
	number int,
	flags int,
	userName nvarchar(512),
	userPassword nvarchar(2048),
	smtpServer nvarchar(512),
	timeZone nvarchar(2048),
	ipAddress nvarchar(50),
	drIpAddress nvarchar(50),
	ccOpMode int
)
-- Get default Commcell Configuration
IF object_id('tempdb.dbo.#DefaultCommcellConfig') IS NOT Null DROP TABLE #DefaultCommcellConfig
CREATE TABLE #DefaultCommcellConfig
(
    errorCode INT,
    errorString nvarchar(MAX),
	respXml XML
)
-- get default commcell configuration
exec MCC_GetDefaultCommcellConfiguration
DECLARE @respXml XML = (SELECT TOP(1) respXml from #DefaultCommcellConfig)
DROP TABLE #DefaultCommcellConfig
INSERT INTO #CommcellInfo (csGuid, encNumber, commcellName, number, flags, userName, userPassword, smtpServer, timeZone, ipAddress, drIpAddress, ccOpMode)
SELECT  GGF.value('@csGUID[1]', 'NVARCHAR(80)') as csGuid, GGF.value('@encNumber[1]', 'nvarchar(512)') as encNumber, GGF.value('@commCellName[1]', 'NVARCHAR(512)') as commcellName,  GGF.value('@number[1]', 'int') as number,
		GGF.value('@flags[1]', 'int') as flags, GGF.value('@userName[1]', 'NVARCHAR(512)') as userName, GGF.value('@UserPassword[1]', 'NVARCHAR(2048)') as userPassword,
		GGF.value('@smtpServer[1]', 'NVARCHAR(512)') as smtpServer, GGF.value('@timezone[1]', 'NVARCHAR(2048)') as timeZone,  GGF.value('@ipAddress[1]', 'NVARCHAR(50)') as ipAddress, GGF.value('@drIpAddress[1]', 'NVARCHAR(50)') as drIpAddress,
		GGF.value('@ccOpMode[1]', 'int') as ccOpMode
        FROM    @respXml.nodes('App_ConfigurationDetailsForMCC/commcell') GFI ( GGF )
DECLARE @redirectUrl NVARCHAR(MAX) = ''
SELECT
	@redirectUrl = ISNULL(ref.value('@webConsoleUrl', 'nvarchar(MAX)'), '')
FROM    @respXml.nodes('App_ConfigurationDetailsForMCC') R ( ref )
-- Get Commcell client Information (i.e. cloud Service)
IF object_id('tempdb.dbo.#commcellClientInfo') IS NOT Null DROP TABLE #commcellClientInfo
CREATE TABLE #commcellClientInfo
(
	clientName nvarchar(512),
	displayName nvarchar(512),
	hostName nvarchar(512)
)
INSERT INTO #commcellClientInfo (clientName, displayName, hostName)
SELECT  GGF.value('(client/clientEntity/@clientName)[1]', 'NVARCHAR(80)') as clientName,
		GGF.value('(client/clientEntity/@displayName)[1]', 'NVARCHAR(80)') as displayName,
		GGF.value('(client/clientEntity/@hostName)[1]', 'NVARCHAR(80)') as hostName
        FROM    @respXml.nodes('App_ConfigurationDetailsForMCC/csClient') GFI ( GGF )
DECLARE @csClientXML XML = (SELECT(SELECT
				(SELECT clientName AS '@clientName', displayName as '@displayName', hostName as '@hostName', 'E661833B-E09B-4636-8ABF-F99B706C46DE' as '@clientGUID' FOR XML PATH('clientEntity'), TYPE)
				FROM #commcellClientInfo FOR XML PATH('client'), TYPE)
				FOR XML PATH('csClient'), TYPE)
-- Get Associated company information
-- This is the company which has subscribed to above cloud service
-- get the company given user is member of
DECLARE @ownerCompany INT = 0
SELECT @ownerCompany = dbo.AppGetOrganizationForUser(@userId)
INSERT INTO #associatedCompany	(companyId) VALUES (@ownerCompany)
UPDATE AC  SET companyName = UM.hostName, companyAlias=UM.domainName, companyGUID = UM.GUID FROM #associatedCompany AC
INNER JOIN UMDSProviders UM ON
UM.id = AC.companyId
SET @xmlText = (SELECT
				(SELECT commcellName AS '@commcellName',
						@redirectUrl AS '@redirectUrl' FROM #CommcellInfo
			FOR XML PATH('cloudService'), TYPE),
			(SELECT companyId AS '@companyId', companyName AS '@companyName' , companyAlias AS '@companyAlias', companyGUID AS '@GUID' FROM #associatedCompany FOR XML PATH('associatedCompany'), TYPE),
			(SELECT
				(SELECT commcellName AS '@commCellName', '6B03C534-D226-49CB-B82F-4BB57D98FF58' AS '@csGUID' FOR XML PATH('commCell'), TYPE) --using same dummy csGUID for all registrations
				FROM #CommcellInfo FOR XML PATH('commcellInfo'), TYPE),
			@csClientXML
			FOR XML PATH ('App_CloudServiceDetails'), TYPE)
GO

IF EXISTS (select * from GxQscripts where name = 'MCC_GetCloudServiceDetails')
	delete from GxQscripts where name = 'MCC_GetCloudServiceDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MCC_GetCloudServiceDetails')
	delete from GXDBVersions where aliasname = 'MCC_GetCloudServiceDetails'
GO

insert into GXDBVersions values(2, 'MCC_GetCloudServiceDetails',  '00000000000000000000', 'MCC_GetCloudServiceDetails', '00000000000000000000')
GO

