

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MCC_ConvertEntityGUIDSToEntityIds.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- 	+-----------------------------------------------------------------------+
--	| 			Procedure : "MCC_ConvertEntityGUIDSToEntityIds"
--	|	This Procedure is used to check if a user can login
--	|	This SP to be called FROM Evmgrs login and web console login too.
-- 	+-----------------------------------------------------------------------+
SET ANSI_NULLS ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='MCC_ConvertEntityGUIDSToEntityIds')
BEGIN
	print '>>> Drop Stored Procedure: MCC_ConvertEntityGUIDSToEntityIds <<<'
	drop procedure MCC_ConvertEntityGUIDSToEntityIds
END
IF EXISTS (select * from GxQscripts where name='MCC_ConvertEntityGUIDSToEntityIds')
	delete from GxQscripts where name = 'MCC_ConvertEntityGUIDSToEntityIds'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MCC_ConvertEntityGUIDSToEntityIds')
	delete from GXDBVersions where aliasname = 'MCC_ConvertEntityGUIDSToEntityIds'
GO
print '... Creating Procedure: MCC_ConvertEntityGUIDSToEntityIds'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure MCC_ConvertEntityGUIDSToEntityIds
  @xmlInput XML
AS
DECLARE  @entityTableForServiceCommcellConversion table
(
    _type_ INT,                             --_type_ as defined in CvEntities.x and App_Entity
    typeIndex INT,                          --position of _type_ in the given XML
    originalXML XML,                        --XML blob that contains _type_
    parentTag VARCHAR(128),                 --parentTag of the XML blob
    entityGUID VARCHAR(255),
	entityName NVARCHAR(200),               --entity name in XML
    entityId VARCHAR(100),                  --entity ID in XML (It is in varchar because there are some entities that fill GUID as id)
    providerName nvarchar(255),
	idFound INT DEFAULT 0,                  --flag to tell whether we have got the ID or not (Reason we have a separate flag is for those entities that come with wrong name and some ID, we need to populate error message. So cannot just rely ON entityId alone)
    fieldName VARCHAR(64)                  --field name of the entity id in .x (like clientId, applicationId, mediaAgentId, roleId, etc.)
)
INSERT INTO @entityTableForServiceCommcellConversion (_type_,typeIndex,originalXML,parentTag,entityGUID,entityName,providerName)
            SELECT Entities._type_ , Entities.typeIndex , Entities.originalXML,Entities.parentTag,Entities.entityGUID,Entities.entityName,providerName FROM
                    (SELECT ref.value('(@_type_)[1]','int') AS _type_,
                            ROW_NUMBER() OVER (ORDER BY R.ref) AS typeIndex,
                            ref.query('.') AS originalXML,
                            ref.value('local-name(.)','varchar(1024)') AS parentTag,
                            ref.value('(@GUID)[1]','varchar(255)') AS entityGUID,
                        CASE
WHEN ref.value('(@_type_)[1]','int') = 13
								THEN ref.value('(@userName)[1]','nvarchar(255)')
WHEN ref.value('(@_type_)[1]','int') = 15
								THEN ref.value('(@userGroupName)[1]','nvarchar(255)')
WHEN ref.value('(@_type_)[1]','int') = 62
								THEN ref.value('(@externalGroupName)[1]','nvarchar(255)')
							ELSE
								NULL
                            END AS entityName,
						CASE
WHEN ref.value('(@_type_)[1]','int') in (62, 61)
								THEN ref.value('(@providerDomainName)[1]','nvarchar(255)')
							ELSE
								NULL
							END AS providerName
                    FROM @xmlInput.nodes('//.[@_type_]') R(ref)
                    ) Entities
UPDATE @entityTableForServiceCommcellConversion
		SET fieldName = entityIdInXML
	FROM
		@entityTableForServiceCommcellConversion ETSCC
		INNER JOIN
		App_Entity E
			ON ETSCC._type_ = E.entityType
UPDATE @entityTableForServiceCommcellConversion
		SET entityName = UMUsers.login, entityId = UMUsers.id, idFound = 1
	FROM
		@entityTableForServiceCommcellConversion ETSCC
		INNER JOIN UMUsers
			ON UMUsers.userGuid = ETSCC.entityGUID
WHERE _type_ = 13
UPDATE @entityTableForServiceCommcellConversion
		SET entityName = UMUsers.login, entityId = UMUsers.id, idFound = 1
	FROM
		@entityTableForServiceCommcellConversion ETSCC
		INNER JOIN UMUsers
			ON UMUsers.login = ETSCC.entityName
WHERE _type_ = 13 and ETSCC.idFound = 0
UPDATE @entityTableForServiceCommcellConversion
		SET entityName = UMGroups.name, entityId = UMGroups.id, idFound = 1
	FROM
		@entityTableForServiceCommcellConversion ETSCC
		INNER JOIN UMGroups
			ON UMGroups.GUID = ETSCC.entityGUID
WHERE _type_ = 15
UPDATE @entityTableForServiceCommcellConversion
		SET entityId = UMGroups.id, idFound = 1
	FROM
		@entityTableForServiceCommcellConversion ETSCC
		INNER JOIN UMGroups
			ON   entityName = UMGroups.name and ETSCC.idFound = 0
WHERE _type_ = 15
		UPDATE @entityTableForServiceCommcellConversion
		SET entityId = G.id, idFound = 1
	FROM
		@entityTableForServiceCommcellConversion ETSCC
		INNER JOIN UMGroups G
		 ON SUBSTRING(entityName, CHARINDEX('\', entityName, 1)+1, LEN(entityName)) = G.name
		INNER JOIN UMDSProviders Prov
    ON SUBSTRING(entityName, 1, CHARINDEX('\', entityName, 1)-1) = Prov.domainName
    AND Prov.id = G.umdsProviderId
    and ETSCC.idFound = 0
WHERE _type_ =  15 and CHARINDEX('\', entityName, 1) > 0
UPDATE @entityTableForServiceCommcellConversion
		SET entityId = UMGroups.id, idFound = 1
	FROM
		@entityTableForServiceCommcellConversion ETSCC
		INNER JOIN UMGroups
			ON   entityGUID = UMGroups.GUID and ETSCC.idFound = 0
		Inner join UMDSProviders UMDS
			ON	providerName = UMDS.domainName and UMDS.id = UMGroups.umdsProviderId
WHERE _type_ = 62
UPDATE @entityTableForServiceCommcellConversion
		SET entityId = UMGroups.id, idFound = 1
	FROM
		@entityTableForServiceCommcellConversion ETSCC
		INNER JOIN UMGroups
			ON   entityName = UMGroups.name and ETSCC.idFound = 0
		Inner join UMDSProviders UMDS
			ON	providerName = UMDS.domainName and UMDS.id = UMGroups.umdsProviderId
WHERE _type_ = 62
		UPDATE @entityTableForServiceCommcellConversion
		SET entityId = G.id, idFound = 1
	FROM
		@entityTableForServiceCommcellConversion ETSCC
		INNER JOIN UMGroups G
		 ON SUBSTRING(entityName, CHARINDEX('\', entityName, 1)+1, LEN(entityName)) = G.name
		INNER JOIN UMDSProviders Prov
    ON SUBSTRING(entityName, 1, CHARINDEX('\', entityName, 1)-1) = Prov.domainName
    AND Prov.id = G.umdsProviderId
    and ETSCC.idFound = 0
WHERE _type_ =  62 and CHARINDEX('\', entityName, 1) > 0
--external group may also have groupname  = domainNAme\UserGroupName
UPDATE @entityTableForServiceCommcellConversion
		SET entityId = UMDS.id, idFound = 1
	FROM
		@entityTableForServiceCommcellConversion ETSCC
		Inner join UMDSProviders UMDS
			ON	providerName = UMDS.domainName
WHERE _type_ = 61
UPDATE @entityTableForServiceCommcellConversion SET entityId = -32000 WHERE idFound = 0
DECLARE @replaceXML XML = (SELECT
                                (SELECT '(//./@_type_)[' + CAST(typeIndex AS VARCHAR(10)) + ']' AS '@xPathElem',
                                         entityId AS '@xPathVal',
                                         fieldName  AS '@attrName'
                                FOR XML PATH ('entity'), TYPE
                                ),
                                (SELECT '(//./@_type_)[' + CAST(typeIndex AS VARCHAR(10)) + ']' AS '@xPathElem',
                                         _type_  '@xPathVal',
                                         '_type_' AS '@attrName'
                                FOR XML PATH ('entity'), TYPE
                                )
                            FROM @entityTableForServiceCommcellConversion
                            ORDER BY typeIndex, _type_
                      FOR XML PATH (''), TYPE, ROOT ('CustomReplacer'))
DECLARE @replaceString NVARCHAR(MAX) = CAST(@replaceXML AS NVARCHAR(MAX))
DECLARE @inputXMLString NVARCHAR(MAX) = CAST(@xmlInput AS NVARCHAR(MAX))
EXEC ReplaceXmlAttributesNew @inputXMLString OUTPUT, @replaceString, 1, 1
	SET @xmlInput = CAST(@inputXMLString AS XML)
UPDATE @entityTableForServiceCommcellConversion
	SET fieldName = entityNameInXML
	FROM
		@entityTableForServiceCommcellConversion ETSCC
	INNER JOIN
	App_Entity E ON ETSCC._type_ = E.entityType
SET @replaceXML  = (SELECT
                                (SELECT '(//./@_type_)[' + CAST(typeIndex AS VARCHAR(10)) + ']' AS '@xPathElem',
                                         entityName AS '@xPathVal',
                                         fieldName  AS '@attrName'
                                FOR XML PATH ('entity'), TYPE
                                ),
                                (SELECT '(//./@_type_)[' + CAST(typeIndex AS VARCHAR(10)) + ']' AS '@xPathElem',
                                         _type_  '@xPathVal',
                                         '_type_' AS '@attrName'
                                FOR XML PATH ('entity'), TYPE
                                )
                            FROM @entityTableForServiceCommcellConversion
                            ORDER BY typeIndex, _type_
                      FOR XML PATH (''), TYPE, ROOT ('CustomReplacer'))
SET @replaceString  = CAST(@replaceXML AS NVARCHAR(MAX))
SET @inputXMLString  = CAST(@xmlInput AS NVARCHAR(MAX))
EXEC ReplaceXmlAttributesNew @inputXMLString OUTPUT, @replaceString, 1, 1
SET @xmlInput = CAST(@inputXMLString AS XML)
SELECT @xmlInput
GO

IF EXISTS (select * from GxQscripts where name = 'MCC_ConvertEntityGUIDSToEntityIds')
	delete from GxQscripts where name = 'MCC_ConvertEntityGUIDSToEntityIds'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MCC_ConvertEntityGUIDSToEntityIds')
	delete from GXDBVersions where aliasname = 'MCC_ConvertEntityGUIDSToEntityIds'
GO

insert into GXDBVersions values(2, 'MCC_ConvertEntityGUIDSToEntityIds',  '00000000000000000000', 'MCC_ConvertEntityGUIDSToEntityIds', '00000000000000000000')
GO

