

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MCC_ConfigureMulticcappUserAssoc.sp] ---------- 

 SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MCC_ConfigureMulticcappUserAssoc')
BEGIN
	print '>>> Drop Stored Procedure: MCC_ConfigureMulticcappUserAssoc <<<'
	drop procedure MCC_ConfigureMulticcappUserAssoc
END
IF EXISTS (select * from GxQscripts where name='MCC_ConfigureMulticcappUserAssoc')
	delete from GxQscripts where name = 'MCC_ConfigureMulticcappUserAssoc'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MCC_ConfigureMulticcappUserAssoc')
	delete from GXDBVersions where aliasname = 'MCC_ConfigureMulticcappUserAssoc'
GO
print '... Creating Procedure: MCC_ConfigureMulticcappUserAssoc'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MCC_ConfigureMulticcappUserAssoc
  @PROTOCOL CHAR(10),
  @IN_OUT_XML XML OUT,
  @THIRDPARTYAPPID INT,
  @ERROR INT OUT,
  @ERRORSTRING VARCHAR(100) OUT
AS
/*
ENTITY TYPE
			1. all users ----12
			2. User ---------13
			3. all groups ---14
			4. UserGroup ----15
			5. NameServer ---61
			*/
/*
OPTYPE:
			0 NONE
			1 ADD
            2 UPDATE
            3 DELETE
            4 OVERWRITE
			*/
DECLARE @THIRDPARTYCOMPONENTID INT = 1034 --#define CV_COMPONENT_MULTICOMMCELL_APP
SET @ERROR = 0
SET @ERRORSTRING = 'SUCCESS'
BEGIN TRY
IF (@PROTOCOL = 'SET')
BEGIN
	DECLARE @TEMPASSOCTABLE TABLE(FLAG INT,ENTITYTYPE INT , USERID INT, USERGROUPID INT ,PROVIDERID INT, OPTYPE INT)
	INSERT  INTO @TEMPASSOCTABLE
			 SELECT ISNULL((t.x.value('(flags/@exclude)[1]','int')),0) AS FLAG,
					t.x.value('@_type_','int') AS ENTITYTYPE,
					t.x.value('@userId','int') AS USERID,
					t.x.value('@userGroupId','int') AS USERGROUPID,
					ISNULL((t.x.value('@providerId','int')),0) AS PROVIDERID,
					ISNULL((t.x.value('@opId','int')),0) AS OPTYPE
			 FROM  @in_out_xml.nodes('assocTree') AS t(x)
			 --IF assocTree does not have ROUTER_CS_MULTICOMMCELL_USER_LOGIN but is present in App_ComponentProp
			 --That means GUI is not sending Hidden Users. So we need to add it back to assocTree.
DECLARE @multicommcellPublicUserId INT = (SELECT top 1 id from UMUsers where login = '_+_MulticommcellPublicUser_')
	IF EXISTS(SELECT 1 from APP_ComponentProp where componentType = @THIRDPARTYCOMPONENTID and componentId = @THIRDPARTYAPPID and propertyTypeId = 13 and longlongVal = @multicommcellPublicUserId) AND NOT EXISTS (SELECT 1 from @TEMPASSOCTABLE where ENTITYTYPE = 13 and USERID = @multicommcellPublicUserId)
		INSERT INTO @TEMPASSOCTABLE (FLAG,ENTITYTYPE,USERID,USERGROUPID,PROVIDERID,OPTYPE) values(0,13,@multicommcellPublicUserId,0,0,0)
	-- OpType support to ADD/REMOVE associations instead of overwriting everything for MultiCommcell App.
	IF EXISTS (SELECT TOP(1) 1 FROM @TEMPASSOCTABLE WHERE OPTYPE IN (1,3))
	BEGIN
		-- ADD Entries where OPTYPE = 1 /*ADD*/
		-- Delete from @TEMPASSOCTABLE if associations are already present in APP_COMPONENTPROP
		DELETE TEMPASSOC FROM @TEMPASSOCTABLE TEMPASSOC INNER JOIN APP_COMPONENTPROP COMPPROP
		ON COMPPROP.COMPONENTTYPE = @THIRDPARTYCOMPONENTID AND COMPPROP.componentId = @THIRDPARTYAPPID AND COMPPROP.propertyTypeId = TEMPASSOC.ENTITYTYPE
			AND COMPPROP.dataType = 1 AND COMPPROP.longlongVal = CASE ENTITYTYPE WHEN 12 THEN 0 WHEN 13 THEN USERID WHEN 14 THEN 0 WHEN 15 THEN USERGROUPID WHEN 61 THEN PROVIDERID END
			AND TEMPASSOC.OPTYPE = 1
		-- INSERT associations in APP_COMPONENTPROP
		INSERT INTO APP_COMPONENTPROP
			SELECT @THIRDPARTYCOMPONENTID,@THIRDPARTYAPPID, ENTITYTYPE, 1,FLAG,
			CASE ENTITYTYPE WHEN 12 THEN 0 WHEN 13 THEN USERID WHEN 14 THEN 0 WHEN 15 THEN USERGROUPID WHEN 61 THEN PROVIDERID END,'', 0,0
			FROM @TEMPASSOCTABLE WHERE OPTYPE = 1
		-- DELETE Entries where OPTYPE = 3 /*DELETE*/
		DELETE COMPPROP FROM APP_COMPONENTPROP COMPPROP INNER JOIN @TEMPASSOCTABLE TEMPASSOC
		ON COMPPROP.COMPONENTTYPE = @THIRDPARTYCOMPONENTID AND COMPPROP.componentId = @THIRDPARTYAPPID AND COMPPROP.propertyTypeId = TEMPASSOC.ENTITYTYPE
			AND COMPPROP.dataType = 1 AND COMPPROP.longlongVal = CASE ENTITYTYPE WHEN 12 THEN 0 WHEN 13 THEN USERID WHEN 14 THEN 0 WHEN 15 THEN USERGROUPID WHEN 61 THEN PROVIDERID END
			AND TEMPASSOC.OPTYPE = 3
	END
	ELSE  -- OVERWRITE
	BEGIN
		DELETE FROM APP_COMPONENTPROP WHERE COMPONENTTYPE = @THIRDPARTYCOMPONENTID and COMPONENTID = @THIRDPARTYAPPID  and PROPERTYTYPEID IN (12,13,14,15,61)
		INSERT INTO APP_COMPONENTPROP
				SELECT @THIRDPARTYCOMPONENTID,@THIRDPARTYAPPID, ENTITYTYPE, 1,FLAG,
				CASE ENTITYTYPE WHEN 12 THEN 0 WHEN 13 THEN USERID WHEN 14 THEN 0 WHEN 15 THEN USERGROUPID WHEN 61 THEN PROVIDERID END,'', 0,0
		FROM @TEMPASSOCTABLE
	END
END
ELSE IF (@PROTOCOL = 'GET')
BEGIN
	SET @IN_OUT_XML  = (SELECT  PROPERTYTYPEID AS '@_type_',
			CASE PROPERTYTYPEID WHEN 13 THEN LONGLONGVAL  ELSE NULL END AS '@userId',
			CASE PROPERTYTYPEID WHEN 15 THEN LONGLONGVAL  ELSE NULL END AS '@userGroupId',
			CASE PROPERTYTYPEID WHEN 61 THEN LONGLONGVAL  ELSE NULL END AS '@providerId',
			CASE LONGVAL WHEN 0 THEN NULL ELSE LONGVAL END				AS 'flags/@exclude'
	FROM APP_COMPONENTPROP  WITH(NOLOCK) WHERE COMPONENTTYPE = @THIRDPARTYCOMPONENTID AND COMPONENTID = @THIRDPARTYAPPID AND PROPERTYTYPEID NOT IN (1,2) FOR XML PATH ('assocTree'),root('Associations'))
END
ELSE
BEGIN
	SET @ERROR = 1
	SET @ERRORSTRING = 'INCORRECT PROTOCOL'
END
END TRY
BEGIN CATCH
SET @ERROR     = ERROR_NUMBER()
SET @ERRORSTRING  = 'PROCEDURE [' + ERROR_PROCEDURE() + '] ERROR LINE [' +CONVERT(VARCHAR(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
END CATCH
GO

IF EXISTS (select * from GxQscripts where name = 'MCC_ConfigureMulticcappUserAssoc')
	delete from GxQscripts where name = 'MCC_ConfigureMulticcappUserAssoc'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MCC_ConfigureMulticcappUserAssoc')
	delete from GXDBVersions where aliasname = 'MCC_ConfigureMulticcappUserAssoc'
GO

insert into GXDBVersions values(2, 'MCC_ConfigureMulticcappUserAssoc',  '00000000000000000000', 'MCC_ConfigureMulticcappUserAssoc', '00000000000000000000')
GO

