

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MCC_ComputeMulticcappUserAssoc.sp] ---------- 

/*
INPUT  --> Userid and thirdparty app id
OUTUP --> USER_STATUS ::	UNKNOWN = 0
							INCLUDED = 1
							EXCLUDE = 2
							DISABLED = 4
Usage of APP_COMPONENTPROP
	COLUMNS 	 --- 			USAGE
longlongval 	----> Ids of users/groups/nameservers
longVal 		----> Exclude flag . 1 IMPLIES ITS EXCLUDED
ComponentId 	----> app_Thirdparty(id)
componentTypeid ----> 1034 (CV_COMPONENT_MULTICOMMCELL_APP)
propertyTypeId  ----> ENTITY TYPE
							1.all users ----- 12
							2. User----------13
							3. all groups ----14
							4. UserGroup-----15
							5. NameServer----61
special type "All NameServer" -> propertyTypeId = 61 and longlongval = 0
*/
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='MCC_ComputeMulticcappUserAssoc')
BEGIN
	print '>>> Drop Stored Procedure: MCC_ComputeMulticcappUserAssoc <<<'
	drop procedure MCC_ComputeMulticcappUserAssoc
END
IF EXISTS (select * from GxQscripts where name='MCC_ComputeMulticcappUserAssoc')
	delete from GxQscripts where name = 'MCC_ComputeMulticcappUserAssoc'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MCC_ComputeMulticcappUserAssoc')
	delete from GXDBVersions where aliasname = 'MCC_ComputeMulticcappUserAssoc'
GO
print '... Creating Procedure: MCC_ComputeMulticcappUserAssoc'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure MCC_ComputeMulticcappUserAssoc
  @USERID INT,
  @THIRDPARTYAPPID INT
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
-- CONSTANTS DECLARATIONS BEGIN
DECLARE @COMPONENTTYPEID 		INT = 1034
DECLARE @ALL_USERS 				INT = 12
DECLARE @USER_ENTITY 			INT = 13
DECLARE @ALL_SIMPANA_GROUPS 	INT = 14
DECLARE @USERGROUP_ENTITY  		INT = 15
DECLARE @PROVIDER_ENTITY 		INT = 61
DECLARE @UNKNOWN 				INT = 0
DECLARE @INCLUDE 				INT = 1
DECLARE @EXCLUDE 				INT = 2
DECLARE @DISABLED 				INT = 4
DECLARE @USER_STATUS 			INT = @UNKNOWN
DECLARE @ALLPROVIDERSSELECTED 	INT = 0
DECLARE @PROVIDERID				INT = 0
DECLARE @OWNERCOMPANYID			INT = dbo.AppGetOrganizationForUser(@USERID)
-- CONSTANTS DECLARATIONS END
IF (SELECT isEnabled FROM APP_THIRDPARTYAPP WHERE ID = @THIRDPARTYAPPID) = 0
BEGIN
	SET @USER_STATUS = 0
	GOTO DONE
END
--1. IF ALL USERS ARE SELECTED
IF EXISTS(SELECT 1 FROM APP_COMPONENTPROP   WHERE LONGLONGVAL = 0 AND COMPONENTID = @THIRDPARTYAPPID AND COMPONENTTYPE = @COMPONENTTYPEID AND PROPERTYTYPEID = @ALL_USERS)
	SET @USER_STATUS = @INCLUDE
--2. EXPLICIT SELECTION OR EXCLUSIONS FOR USER
SELECT @USER_STATUS = LONGVAL + 1 FROM  APP_COMPONENTPROP   WHERE LONGLONGVAL = @USERID AND COMPONENTID = @THIRDPARTYAPPID AND COMPONENTTYPE = @COMPONENTTYPEID AND PROPERTYTYPEID = @USER_ENTITY
IF @USER_STATUS = @EXCLUDE
	GOTO DONE
--EXTERNAL PROVIDERS
SET @PROVIDERID = ISNULL((SELECT UMDSPROVIDERID FROM UMUSERS WHERE ID = @USERID),0)
IF @PROVIDERID > 0
BEGIN
--3. IF ALL PROVIDERS SELECTED (CURRENTLY WE CAN'T CONVEVY THIS FROM GUI BUT MAY BE REQUIRED SOME TIME)
	IF EXISTS(SELECT 1 FROM APP_COMPONENTPROP WHERE LONGLONGVAL = 0 AND COMPONENTID = @THIRDPARTYAPPID AND COMPONENTTYPE = @COMPONENTTYPEID AND PROPERTYTYPEID = @PROVIDER_ENTITY AND MODIFIED = 0)
	BEGIN
		SET @ALLPROVIDERSSELECTED = 1
		SET @USER_STATUS = @INCLUDE
	END
--4. EXTERNAL PROVIDERS EXPLICITLY INCLUDED/EXCLUDED
	SELECT @USER_STATUS = LONGVAL + 1 FROM APP_COMPONENTPROP WHERE LONGLONGVAL = @PROVIDERID AND COMPONENTID = @THIRDPARTYAPPID AND COMPONENTTYPE = @COMPONENTTYPEID AND PROPERTYTYPEID = @PROVIDER_ENTITY AND MODIFIED = 0
END
IF @USER_STATUS = @EXCLUDE
	GOTO DONE
IF @USER_STATUS <> @INCLUDE AND @PROVIDERID > 0 AND @OWNERCOMPANYID > 0
	SELECT @USER_STATUS = LONGVAL + 1 FROM APP_COMPONENTPROP WHERE LONGLONGVAL = @OWNERCOMPANYID AND COMPONENTID = @THIRDPARTYAPPID AND COMPONENTTYPE = @COMPONENTTYPEID AND PROPERTYTYPEID = @PROVIDER_ENTITY AND MODIFIED = 0
-- GROUPS THAT USER BELONGS TO
DECLARE @USERGROUPS TABLE (UGROUPID INT)
DECLARE @CONFIGUREDGROUPSTABLE TABLE (GROUPID INT,  FLAG INT)
DECLARE @AGGFUNC INT = 0
INSERT INTO @USERGROUPS SELECT GROUPID FROM UMUSERGROUP WHERE USERID = @USERID
--1. INSERT ALL LOCAL GROUPS TO TEMP TABLE IF ALL GROUPS ENTITY IS SELECTED
IF EXISTS(SELECT 1 FROM APP_COMPONENTPROP WHERE LONGLONGVAL = 0 AND COMPONENTID = @THIRDPARTYAPPID AND COMPONENTTYPE = @COMPONENTTYPEID AND PROPERTYTYPEID = @ALL_SIMPANA_GROUPS AND MODIFIED = 0)
	INSERT INTO @CONFIGUREDGROUPSTABLE SELECT  ID, @INCLUDE
										FROM UMGROUPS UMG
										JOIN @USERGROUPS UG ON  UG.UGROUPID = UMG.ID  AND UMDSPROVIDERID = 0
IF @PROVIDERID > 0
BEGIN
--2. INSERT ALL EXTERNAL GROUPS IF ALL NAMESERVERS ARE SELECTED
IF @ALLPROVIDERSSELECTED = 1
	INSERT INTO @CONFIGUREDGROUPSTABLE SELECT  ID, @INCLUDE
										FROM UMDSGROUPS UMG
										JOIN @USERGROUPS UG ON  UG.UGROUPID = UMG.ID
--3. INSERT OTHER EXTERNAL GROUPS IF NAME SERVERS ARE EXPLICTLY INCLUDED/EXCLUDED
INSERT INTO @CONFIGUREDGROUPSTABLE SELECT  UDSG.ID,  CP.LONGVAL + 1
									FROM UMDSGROUPS UDSG
									JOIN APP_COMPONENTPROP  CP   ON CP.LONGLONGVAL = UDSG.UMDSPROVIDERID
									JOIN @USERGROUPS UG ON  UG.UGROUPID = UDSG.ID
		WHERE COMPONENTID = @THIRDPARTYAPPID AND COMPONENTTYPE = @COMPONENTTYPEID AND PROPERTYTYPEID = @PROVIDER_ENTITY AND MODIFIED = 0 AND LONGLONGVAL > 0
END
--4. INSERT OTHER INTERNAL/EXTERNAL GROUPS THAT ARE EXPLICITLY INCLUDED/EXCLUDED
INSERT INTO @CONFIGUREDGROUPSTABLE SELECT LONGLONGVAL, LONGVAL + 1
									FROM APP_COMPONENTPROP  ACP
									JOIN @USERGROUPS UG ON  UG.UGROUPID = ACP.LONGLONGVAL
		WHERE COMPONENTID = @THIRDPARTYAPPID AND COMPONENTTYPE = @COMPONENTTYPEID AND PROPERTYTYPEID = @USERGROUP_ENTITY  AND MODIFIED = 0 AND LONGLONGVAL > 0
SELECT  @AGGFUNC = (@AGGFUNC|FLAG) FROM @CONFIGUREDGROUPSTABLE
IF( @AGGFUNC & 2  = 2)
	SET @USER_STATUS = @EXCLUDE
ELSE IF (@AGGFUNC = 1)
	SET @USER_STATUS = @INCLUDE
IF @USER_STATUS = @EXCLUDE
	GOTO DONE
--CHECK IF USER HAPPENS TO BE DISABLED
IF((SELECT ENABLED FROM UMUSERS WHERE ID = @USERID) = 0)
	SET @USER_STATUS = @DISABLED
DONE:
-- FINAL USER STATUS AFTER COMPUTATIONS
SELECT @USER_STATUS
GO

IF EXISTS (select * from GxQscripts where name = 'MCC_ComputeMulticcappUserAssoc')
	delete from GxQscripts where name = 'MCC_ComputeMulticcappUserAssoc'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MCC_ComputeMulticcappUserAssoc')
	delete from GXDBVersions where aliasname = 'MCC_ComputeMulticcappUserAssoc'
GO

insert into GXDBVersions values(2, 'MCC_ComputeMulticcappUserAssoc',  '00000000000000000000', 'MCC_ComputeMulticcappUserAssoc', '00000000000000000000')
GO

