

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MCC_CheckCloudServiceUser.sp] ---------- 

/*
			MCC_CheckCloudServiceUser.sp
	checks if given user is cloud service user and returns mapped user Id.
	userType = 1(cloud service user created in cloud inside company), 2: (on-prim cloud service user)
	GUID is csGuid for on-prim cs.
*/
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='MCC_CheckCloudServiceUser')
BEGIN
	print '>>> Drop Stored Procedure: MCC_CheckCloudServiceUser <<<'
	drop procedure MCC_CheckCloudServiceUser
END
IF EXISTS (select * from GxQscripts where name='MCC_CheckCloudServiceUser')
	delete from GxQscripts where name = 'MCC_CheckCloudServiceUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MCC_CheckCloudServiceUser')
	delete from GXDBVersions where aliasname = 'MCC_CheckCloudServiceUser'
GO
print '... Creating Procedure: MCC_CheckCloudServiceUser'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure MCC_CheckCloudServiceUser
  @login NVARCHAR(255),
  @GUID NVARCHAR(50),
  @companyGuid NVARCHAR(1024) = '',
  @userType INT = 0
AS
  DECLARE @O_MAPPEDUSERID INT
  DECLARE @O_COMPANYGUID NVARCHAR(MAX)
  DECLARE @O_USERTYPE INT
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @R_MAPPEDUSERID INT = -2
DECLARE @R_COMPANYGUID NVARCHAR(MAX) = ''
DECLARE @R_USERTYPE INT = 0
DECLARE @companyId INT = 0
DECLARE @companyAlias NVARCHAR(1024) = ''
IF(@login = '')
	GOTO PROC_EXIT
IF(@companyGuid = '')
BEGIN
	SET @companyGuid = NULL
END
DECLARE @thirdPartyAppId INT = ISNULL((SELECT ID FROM APP_ThirdPartyApp WHERE APPNAME = @GUID),0)
IF(@thirdPartyAppId = 0)
	GOTO PROC_EXIT
--get companyId  to which third party app is associated
IF EXISTS(SELECT TOP(1) 1 FROM App_ComponentProp
WHERE componentType = 1034
		AND componentId = @thirdPartyAppId
AND propertyTypeId = 5)  -- check if third party app is for on-prim CS registered to cloud
BEGIN
	SET @companyId = ISNULL((SELECT ACP.longlongVal FROM App_ComponentProp ACP INNER JOIN UMDSProviders UMDS
ON UMDS.id = ACP.longlongVal AND UMDS.serviceType = 5
WHERE (@companyGuid IS NULL OR UMDS.GUID=@companyGuid) AND ACP.componentType = 1034 AND ACP.componentId = @thirdPartyAppId AND ACP.propertyTypeId = 61), 0)
END
IF(@companyId = 0)
	GOTO PROC_EXIT
SELECT @companyAlias = domainName, @R_COMPANYGUID = GUID  FROM UMDSProviders WHERE id = @companyId
SET @R_USERTYPE = 2 -- on-prim user in cloud service
--get mapped userId
-- check if user is AD User
DECLARE @pos INT =CHARINDEX('\',@login,1)
DECLARE @userId INT = 0, @userCompanyId INT = 0;
IF @pos  <> 0
BEGIN
	-- AD user
	DECLARE @umdsProviderId INT = 0
	SELECT @userId = id, @umdsProviderId = umdsproviderId FROM UMUsers WHERE login = @login
	-- verify ownerCompany of AD matches with associated company in third party app
	SELECT @userCompanyId = UM1.ownerCompany FROM UMDSProviders UM1
INNER JOIN UMDSProviders UM2 ON UM1.ownerCompany = UM2.id  AND UM2.serviceType = 5
			WHERE UM1.id = @umdsProviderId
	IF(@userCompanyId = @companyId)
		SET @R_MAPPEDUSERID = @userId
END
ELSE
BEGIN
	-- commcell company user
	DECLARE @mappedUserLogin NVARCHAR(MAX) = ''
	SET @mappedUserLogin = @companyAlias + '\' + @login
	-- verify company of user matches with company associated with TP app.
	SET @R_MAPPEDUSERID = ISNULL(
		(SELECT U.id FROM UMUsers U  INNER JOIN
UMDSProviders UM ON U.umdsproviderId = UM.id AND UM.serviceType = 5
				WHERE U.login = @mappedUserLogin AND U.umdsproviderId = @companyId), 0)
END
PROC_EXIT:
SELECT @R_MAPPEDUSERID, @R_COMPANYGUID, @R_USERTYPE
GO

IF EXISTS (select * from GxQscripts where name = 'MCC_CheckCloudServiceUser')
	delete from GxQscripts where name = 'MCC_CheckCloudServiceUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MCC_CheckCloudServiceUser')
	delete from GXDBVersions where aliasname = 'MCC_CheckCloudServiceUser'
GO

insert into GXDBVersions values(2, 'MCC_CheckCloudServiceUser',  '00000000000000000000', 'MCC_CheckCloudServiceUser', '00000000000000000000')
GO

