

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/LiveMountValidateRequest.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems,  Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems,  Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/LiveMountValidateRequest.sp,v $ $Id: LiveMountValidateRequest.sp,v 1.4.50.2 2018/03/27 08:08:13 jiechen Exp $";
-- 	+---------------------------------------------------+
--	| 			PROCEDURE : "LiveMountValidateRequest"			|
-- 	+---------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: LiveMountValidateRequest <<<'

IF EXISTS (select * from sysobjects where name='LiveMountValidateRequest')
	drop procedure LiveMountValidateRequest
IF EXISTS (select * from GxQscripts where name='LiveMountValidateRequest')
	delete from GxQscripts where name = 'LiveMountValidateRequest'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LiveMountValidateRequest')
	delete from GXDBVersions where aliasname = 'LiveMountValidateRequest'
GO
print '... Creating Procedure: LiveMountValidateRequest'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure LiveMountValidateRequest
  @i_uid INT,
  @i_xmlText XML
AS
  DECLARE @r_ReturnResult XML;
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @vmName NVARCHAR(1024)
DECLARE @vmClientId INT
DECLARE @dcId	INT
DECLARE @errorCode INT
DECLARE @errorMsg  VARCHAR(512)
CREATE TABLE #tempNameList(name NVARCHAR(1024))
SET	@vmName 	= ISNULL (( SELECT ref.value('vmClient[1]/@clientName', 'NVARCHAR(512)')
					FROM  @i_xmlText.nodes ('Ida_ValidateLiveMountReq') R(ref)), '')
SET @dcId = ISNULL (( SELECT ref.value('dataCenter[1]/@dataCenterId', 'INT')
					FROM  @i_xmlText.nodes ('Ida_ValidateLiveMountReq') R(ref)), 0)
SET	@vmClientId 	= ISNULL (( SELECT ref.value('vmClient[1]/@clientId', 'INT')
					FROM  @i_xmlText.nodes ('Ida_ValidateLiveMountReq') R(ref)), 0)
IF NOT EXISTS (SELECT	*
FROM	APP_VMProp V
	INNER JOIN JMBkpStats B
		ON V.VMclientId = @vmClientId
		AND	V.jobId = B.jobId
		AND V.commCellId = B.commCellId)
BEGIN
	SET @errorCode = 1
	SET @errorMsg = 'Backups are not found for this VM. Live Mount cannot proceed.'
	GOTO END_OF_SP
END
-- Check if the VM is VMware VM or not
IF NOT EXISTS (SELECT	*
FROM	APP_VMProp V, JMBkpStats B, APP_Application A, APP_InstanceProp I
WHERE	V.VMclientId = @vmClientId
	AND	V.jobId = B.jobId
	AND V.commCellId = B.commCellId
	AND B.appId = A.id
	AND A.instance = I.componentNameId
	AND I.attrName = 'Virtual Server Instance Type'
	AND I.attrVal = '101')
BEGIN
	SET @errorCode = 1
	SET @errorMsg = 'This VM is not protected by VMware agent. Live Mount is supported for VMware VMs only.'
	GOTO END_OF_SP
END
SET @vmName = (SELECT name FROM APP_Client WHERE id = @vmClientId)
SET @vmName = @vmName + 'VM'
DECLARE @vmNameLen INT
SELECT @vmNameLen = LEN(@vmName)
DECLARE @suffix INT = 0
-- Get the VMs being created
INSERT INTO #tempNameList
SELECT ISNULL(vmo.value('vmEntity[1]/@vmName', 'NVARCHAR(1024)'), '')
FROM (SELECT J.jobId, CAST(J.value AS XML) AS value
	FROM TM_JobOptions J
	WHERE J.optionId = 30050685
	AND J.jobId IN
	(SELECT DISTINCT JI.jobId
		FROM JMJobInfo JI, TM_JobOptions JO
		WHERE JI.jobId = JO.jobId
			AND JO.optionId = 1815939405
			AND value = 23
			AND JI.opType = 85)) I
CROSS APPLY I.value.nodes ('virtualMachineOption') M(vmo)
--Get the existing VM names in the same datacenter
INSERT INTO #tempNameList
SELECT V.name FROM App_VM V, App_VMHost H WHERE V.name LIKE @vmName + '%' AND V.vHostId = H.id AND H.vDataCenterId = @dcId AND V.removalTimeStamp IS NULL
--Get the existing client names
INSERT INTO #tempNameList
SELECT name FROM APP_Client C WHERE name LIKE @vmName + '%'
DELETE FROM #tempNameList WHERE name not like @vmName + '%'
-- Find the suffix
IF NOT EXISTS (SELECT * FROM #tempNameList WHERE name = @vmName)
	SET @vmName = @vmName -- No change
ELSE
BEGIN
	SELECT @suffix = MAX(CASE WHEN ISNUMERIC(substring(name, @vmNameLen + 1, len(name) - @vmNameLen)) = 1
			THEN CONVERT(integer, substring(name, @vmNameLen + 1, len(name) - @vmNameLen))
			ELSE 0 END)
	FROM #tempNameList
	SET @suffix = @suffix + 1
	SET @vmName = @vmName + CAST(@suffix AS NVARCHAR(12))
END
END_OF_SP:
SELECT @vmName AS 'vmClient/@vmName',
( SELECT @errorCode '@errorCode', @errorMsg '@errorMessage'
	FOR XML PATH('error'), TYPE
)
FOR XML PATH(''),
ROOT('Ida_ValidateLiveMountResp')
DROP TABLE #tempNameList
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'LiveMountValidateRequest')
	delete from GxQscripts where name = 'LiveMountValidateRequest'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LiveMountValidateRequest')
	delete from GXDBVersions where aliasname = 'LiveMountValidateRequest'
GO

insert into GXDBVersions values(2, 'LiveMountValidateRequest',  '00010004005000020000', 'LiveMountValidateRequest', '00010004005000020000')
GO

