

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/LiveMountGetSrcVMInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems,  Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems,  Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/LiveMountGetSrcVMInfo.sp,v $ $Id: LiveMountGetSrcVMInfo.sp,v 1.6.14.24 2020/05/02 07:21:41 gstoops Exp $";
-- 	+---------------------------------------------------+
--	| 			PROCEDURE : "LiveMountGetSrcVMInfo"			|
-- 	+---------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='LiveMountGetSrcVMInfo')
BEGIN
	print '>>> Drop Stored Procedure: LiveMountGetSrcVMInfo <<<'
	drop procedure LiveMountGetSrcVMInfo
END
IF EXISTS (select * from GxQscripts where name='LiveMountGetSrcVMInfo')
	delete from GxQscripts where name = 'LiveMountGetSrcVMInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LiveMountGetSrcVMInfo')
	delete from GXDBVersions where aliasname = 'LiveMountGetSrcVMInfo'
GO
print '... Creating Procedure: LiveMountGetSrcVMInfo'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure LiveMountGetSrcVMInfo
  @i_clientId INTEGER,
  @i_refTime INTEGER,
  @i_precedence INTEGER,
  @i_instanceId INTEGER
AS
  DECLARE @o_vmClientId INTEGER;
  DECLARE @o_jobId INTEGER;
  DECLARE @o_appId INTEGER;
  DECLARE @o_copyId INTEGER;
  DECLARE @o_vmName NVARCHAR(510);
  DECLARE @o_vmGUID NVARCHAR(510);
  DECLARE @o_precedence INTEGER;
  DECLARE @o_isSnapJob INT;
  DECLARE @o_vmToolsVersion INT;
  DECLARE @o_errorCode INT;
  DECLARE @o_srcVsInstanceType INT;
  DECLARE @o_childJobId INTEGER;
  DECLARE @o_childAppId INTEGER;
  DECLARE @o_archfileId INTEGER;
  DECLARE @o_vmHardwareVersion NVARCHAR(510);
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @jobId				INTEGER = 0
DECLARE @appId				INTEGER = 0
DECLARE @copyId				INTEGER = 0
DECLARE @vmGUID				NVARCHAR(510) = N''
DECLARE @clientName			NVARCHAR(510) = N''
DECLARE @errorCode			INT = 0
DECLARE @opType				INT
DECLARE @isSnapLiveMountAllowed NVARCHAR(8) = N'true'
DECLARE @snapJobId			INT
DECLARE @isV2Client			INT = 0
DECLARE @destinationInstanceType INT = 101
declare @childJobId int = NULL
declare @childAppId int = NULL
DECLARE @isSnapAllowed      INT = 0
DECLARE @lastBackupJobId	INT = 0
DECLARE @lastBackupJobIsV2	INT = 0
DECLARE @lastBackupJobOpType INT = 0
DECLARE @lastBackupJobAppId	INT  = 0
SET @o_isSnapJob =0
SET @o_srcVsInstanceType = 0
SET @o_childJobId = 0
SELECT
		   @lastBackupJobIsV2 = [IndexingV2_VSA],
		   @lastBackupJobId  = B.jobId,
		   @lastBackupJobOpType = B.opType,
		   @lastBackupJobAppId = B.appId
	 FROM (SELECT attrName, attrVal
			   FROM APP_ClientProp  cProp
			   WHERE cProp.componentNameId = @i_clientId
			   AND cProp.modified = 0) as clients
	 PIVOT (
				MAX(attrVal) FOR attrName IN
					( [Last Backup JobID], [IndexingV2_VSA])
		   ) AS PV
	 INNER JOIN JMBkpStats B
		ON B.jobId = [Last Backup JobID]
--in case of v2 backup, the last backup job id field hold child job Id incase of syncthetic full job, so we need to fetch the parentAppId to get vendor type.
IF @lastBackupJobIsV2 = 1 AND  @lastBackupJobOpType  = 14  --backupLevel 14 is syncthetic full job
BEGIN
	select @lastBackupJobAppId = parentAppid
		from JMJobDataLink JL
		WHERE JL.childJobId = @lastBackupJobId
		and JL.childAppid = @lastBackupJobAppId
END
SET @isV2Client = isnull((select attrVal from app_clientprop where componentNameId =@i_clientId and attrName = 'IndexingV2_VSA' and attrVal = '1' and modified =0),0)
SELECT	@o_srcVsInstanceType  = CAST(I.attrVal AS INT)
		FROM APP_Application A
		INNER JOIN APP_InstanceProp I
		ON  A.instance = I.componentNameId AND A.id = @lastBackupJobAppId
		AND I.attrName = 'Virtual Server Instance Type'
		AND I.attrVal in ('101','501','102')
IF @i_instanceId > 0
BEGIN
	SELECT @destinationInstanceType = CAST(attrVal AS INT)
		FROM APP_InstanceProp
		WHERE componentNameId = @i_instanceId
		AND attrName = 'Virtual Server Instance Type'
END
IF object_id('tempdb.dbo.#vmBackupDetails') IS NOT null DROP TABLE #vmBackupDetails -- To collect the list of copies for identified archFileId/jobId
CREATE TABLE #vmBackupDetails
   (
               jobId INTEGER,
               copyPrecedence INT,
               isSnapCopy     INT,
	       childJobId INTEGER,
	       childAppId INT
   )
-- Check if the VM is VMware VM or Redhat VM or Hyper-V VM
IF @o_srcVsInstanceType = 0
BEGIN
SET @errorCode = (1949 | (CAST(POWER(2, 24) AS BIGINT) * 19))
	GOTO END_OF_SP
END
-- when copy precedence set to 0, get the latest backup jobId for the given client id and refTime and find the available copy (highest copy precedence by ranking)
-- when copy procedence set > 0, find the latest backup jobId for the given client id and refTime based on the copy precedence set.
SET @isSnapLiveMountAllowed = ISNULL((SELECT TOP 1 value FROM GXGlobalParam WHERE modified = 0 AND name = N'AllowSnapLiveMount'), 'true')
IF (@isSnapLiveMountAllowed = 'true' AND @destinationInstanceType = 101)
BEGIN
	 SET @isSnapAllowed = 1
	 IF @isV2Client = 1
	 BEGIN
		 INSERT INTO #vmBackupDetails
			SELECT	MAX((CASE WHEN (J.opType = 60) THEN J.jobIdActedOn ELSE J.jobId END)),
					AGS.copy,
					AGS.isSnapCopy,
					MAX(JDL.childJobId),
					JDL.childAppid
				FROM APP_VMProp V
				INNER JOIN JMBkpStats J
					ON  V.jobId = J.jobId
						 AND VMclientId = @i_clientId
						 AND V.commCellId = J.commCellId
						 AND J.servEndDate <= @i_refTime
						 AND J.status IN (1, 3)
						 AND J.agedTime = 0
						 AND V.attrVal in (0,3)
						 AND V.attrName = 'vmStatus'
				INNER JOIN JMJobDataLink JDL
					ON JDL.parentJobId = (CASE WHEN (J.opType = 60) THEN J.jobIdActedOn ELSE J.jobId END) --verify for snaptotape case
				INNER JOIN APP_Application  A
					ON A.id = JDL.childAppid
					AND A.clientId = VMclientId
				INNER JOIN JMJobDataStats JDS
					 ON JDS.archGrpId= J.dataArchGrpId
					 AND JDS.commCellId = J.commCellId
					 AND JDS.jobId = JDL.childJobId
					 AND JDS.disabled not in (64) --CVA_BAD_JOB_FLAG -64  -- Job is marked BAD by the user
				INNER JOIN archGroupCopy AGS
					ON AGS.id  = JDS.archGrpCopyId
				GROUP BY (CASE WHEN (J.opType = 60) THEN J.jobIdActedOn ELSE J.jobId END), JDS.commCellId,  JDS.archGrpCopyId, AGS.copy, AGS.isSnapCopy, JDL.childAppid
				HAVING MIN(JDS.status) = 100 AND MAX(JDS.status) = 100	 -- status 100 represents it is completely copied, so max, min of 100 will make sure all the dataType of each copy will have status marked completed
	 END
	 ELSE
	 BEGIN
			 INSERT INTO #vmBackupDetails
			 SELECT	MAX((CASE WHEN (J.opType = 60) THEN J.jobIdActedOn ELSE J.jobId END)),
					AGS.copy,
					AGS.isSnapCopy,
					MAX((CASE WHEN (J.opType = 60) THEN J.jobId ELSE 0 END)),
					NULL
				FROM APP_VMProp V
				INNER JOIN JMBkpStats J
					ON  V.jobId = J.jobId
						 AND VMclientId = @i_clientId
						 AND V.commCellId = J.commCellId
						 AND J.servEndDate <= @i_refTime
						 AND J.status IN (1, 3)
						 AND J.agedTime = 0
						 AND V.attrVal in (0,3)
						 AND V.attrName = 'vmStatus'
				INNER JOIN JMJobDataStats JDS
					 ON JDS.archGrpId= J.dataArchGrpId
					 AND JDS.commCellId = J.commCellId
					 AND JDS.jobId = (CASE WHEN (J.opType = 60) THEN J.jobIdActedOn ELSE J.jobId END)
					 AND JDS.disabled not in (64) --CVA_BAD_JOB_FLAG -64  -- Job is marked BAD by the user
				INNER JOIN archGroupCopy AGS
					ON AGS.id  = JDS.archGrpCopyId
				GROUP BY (CASE WHEN (J.opType = 60) THEN J.jobIdActedOn ELSE J.jobId END), JDS.commCellId,  JDS.archGrpCopyId, AGS.copy, AGS.isSnapCopy
				HAVING MIN(JDS.status) = 100 AND MAX(JDS.status) = 100	 -- status 100 represents it is completely copied, so max, min of 100 will make sure all the dataType of each copy will have status marked completed
	 END
END
ELSE
BEGIN
	 IF @isV2Client = 1
	 BEGIN
		 INSERT INTO #vmBackupDetails
			SELECT	MAX((CASE WHEN (J.opType = 60) THEN J.jobIdActedOn ELSE J.jobId END)),
					AGS.copy,
					AGS.isSnapCopy,
					MAX(JDL.childJobId),
					JDL.childAppid
				FROM APP_VMProp V
				INNER JOIN JMBkpStats J
					ON  V.jobId = J.jobId
						 AND VMclientId = @i_clientId
						 AND V.commCellId = J.commCellId
						 AND J.servEndDate <= @i_refTime
						 AND J.status IN (1, 3)
						 AND J.agedTime = 0
						 AND V.attrVal in (0,3)
						 AND V.attrName = 'vmStatus'
						 AND J.opType NOT IN (59, 65) -- SNAPBACKUP = 59, SNAPBACKUP3RD = 65 -- Snap Backup: CVOptype enum
				INNER JOIN JMJobDataLink JDL
					ON JDL.parentJobId = (CASE WHEN (J.opType = 60) THEN J.jobIdActedOn ELSE J.jobId END) --verify for snaptotape case
				INNER JOIN APP_Application  A
					ON A.id = JDL.childAppid
					AND A.clientId = VMclientId
				INNER JOIN JMJobDataStats JDS
					 ON JDS.archGrpId= J.dataArchGrpId
					 AND JDS.commCellId = J.commCellId
					 AND JDS.jobId = JDL.childJobId
					 AND JDS.disabled not in (64) --CVA_BAD_JOB_FLAG -64  -- Job is marked BAD by the user
				INNER JOIN archGroupCopy AGS
					ON AGS.id  = JDS.archGrpCopyId
				GROUP BY (CASE WHEN (J.opType = 60) THEN J.jobIdActedOn ELSE J.jobId END), JDS.commCellId,  JDS.archGrpCopyId, AGS.copy, AGS.isSnapCopy, JDL.childAppid
				HAVING MIN(JDS.status) = 100 AND MAX(JDS.status) = 100	 -- status 100 represents it is completely copied, so max, min of 100 will make sure all the dataType of each copy will have status marked completed
	 END
	 ELSE
	 BEGIN
			 INSERT INTO #vmBackupDetails
			 SELECT	MAX((CASE WHEN (J.opType = 60) THEN J.jobIdActedOn ELSE J.jobId END)),
					AGS.copy,
					AGS.isSnapCopy,
					MAX((CASE WHEN (J.opType = 60) THEN J.jobId ELSE 0 END)),
					NULL
				FROM APP_VMProp V
				INNER JOIN JMBkpStats J
					ON  V.jobId = J.jobId
						 AND VMclientId = @i_clientId
						 AND V.commCellId = J.commCellId
						 AND J.servEndDate <= @i_refTime
						 AND J.status IN (1, 3)
						 AND J.agedTime = 0
						 AND V.attrVal in (0,3)
						 AND V.attrName = 'vmStatus'
						 AND J.opType NOT IN (59, 65) -- SNAPBACKUP = 59, SNAPBACKUP3RD = 65 -- Snap Backup: CVOptype enum
				INNER JOIN JMJobDataStats JDS
					 ON JDS.archGrpId= J.dataArchGrpId
					 AND JDS.commCellId = J.commCellId
					 AND JDS.jobId = (CASE WHEN (J.opType = 60) THEN J.jobIdActedOn ELSE J.jobId END)
					 AND JDS.disabled not in (64) --CVA_BAD_JOB_FLAG -64  -- Job is marked BAD by the user
				INNER JOIN archGroupCopy AGS
					ON AGS.id  = JDS.archGrpCopyId
				GROUP BY (CASE WHEN (J.opType = 60) THEN J.jobIdActedOn ELSE J.jobId END), JDS.commCellId,  JDS.archGrpCopyId, AGS.copy, AGS.isSnapCopy
				HAVING MIN(JDS.status) = 100 AND MAX(JDS.status) = 100	 -- status 100 represents it is completely copied, so max, min of 100 will make sure all the dataType of each copy will have status marked completed
	 END
END
IF @isSnapAllowed = 0
	DELETE #vmBackupDetails WHERE isSnapCopy =1
IF ISNULL(@i_precedence,0) !=0
BEGIN
	IF EXISTS (SELECT * FROM #vmBackupDetails WHERE copyPrecedence = @i_precedence)
		SELECT	top 1 @jobId = jobId,
				@o_isSnapJob = isSnapCopy,
				@o_childJobId = childJobId,
				@childAppId = childAppId
			FROM #vmBackupDetails
			WHERE copyPrecedence = @i_precedence
			ORDER BY  jobId desc
	ELSE
	BEGIN
		SET @jobId = 0
		SET @o_childJobId = 0
	END
END
ELSE
BEGIN
	SELECT  top 1
				@jobId = jobId,
				@o_isSnapJob = isSnapCopy,
				@i_precedence = copyPrecedence,
				@o_childJobId = childJobId,
				@childAppId = childAppId
			FROM #vmBackupDetails
			ORDER BY  jobId DESC, copyPrecedence ASC
END
SELECT @appId = appId FROM JMBkpStats where jobId = @jobId
IF (@jobId = 0 OR @appId = 0  OR ISNULL(@i_precedence,0) = 0)
BEGIN
SET @errorCode = (1943 | (CAST(POWER(2, 24) AS BIGINT) * 19))
	GOTO END_OF_SP
END
SELECT @clientName = name FROM APP_Client WHERE id = @i_clientId
IF ISNULL(@clientName, '') = ''
BEGIN
SET @errorCode = (1944 | (CAST(POWER(2, 24) AS BIGINT) * 19))
	GOTO END_OF_SP
END
SELECT @vmGUID = attrVal FROM APP_VMProp WHERE jobId = @jobId AND VMClientID = @i_clientId AND attrName = 'vmGUID'
IF ISNULL(@vmGUID, '') = ''
BEGIN
SET @errorCode = (1945 | (CAST(POWER(2, 24) AS BIGINT) * 19))
	GOTO END_OF_SP
END
--fetch vmHardwareVersion.
SELECT @o_vmHardwareVersion = attrVal FROM App_Clientprop WHERE componentNameid = @i_clientId AND attrName = 'Virtual Machine Hardware Version' AND modified = 0
--fetch vmToolsVersion.
DECLARE @strVmToolsVersion nvarchar(256);
SELECT @strVmToolsVersion = attrVal FROM App_Clientprop WHERE componentNameid = @i_clientId AND attrName = 'Virtual Machine Tools Version' AND modified = 0
SET @o_vmToolsVersion =
	CASE
		WHEN ISNULL(@strVmToolsVersion,'') = '' THEN -1
		WHEN @strVmToolsVersion = 'Not installed' THEN 0
		WHEN @strVmToolsVersion = 'Not running' THEN 1
		WHEN @strVmToolsVersion = 'Out of date' THEN 2
		WHEN @strVmToolsVersion = 'Current' THEN 3
		WHEN @o_srcVsInstanceType = 102 AND ISNULL(@strVmToolsVersion,'') != '' THEN 3 --for Hyper-v if toolsVersion is set with value than 'Not installed', then we need to send as Current.
	END
END_OF_SP:
IF object_id('tempdb.dbo.#vmBackupDetails') IS NOT null DROP TABLE #vmBackupDetails
if (@childJobId is not NULL)
	set @o_childJobId = @childJobId
if(@childAppId is not NULL)
	set @o_childAppId = @childAppId
if ( @o_isSnapJob =1 )
begin
select @o_archfileId = archfileid from SMVolume where jobid = @childJobId
IF ISNULL(@i_precedence,0) !=0
begin
select @copyId = AGC.id from archGroupCopy AGC
inner join archGroup AG
on AGC.archGroupId = AG.id
inner join app_application A
on A.dataArchGrpID = AG.id
and A.id = @appId
where AGC.copy = @i_precedence
end
end
SELECT @i_clientId, @jobId, @appId, @copyId, @clientName, @vmGUID, @i_precedence, @o_isSnapJob,@o_vmToolsVersion, @errorCode, @o_srcVsInstanceType, @o_childJobId, @o_childAppId, @o_archfileId, @o_vmHardwareVersion
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'LiveMountGetSrcVMInfo')
	delete from GxQscripts where name = 'LiveMountGetSrcVMInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LiveMountGetSrcVMInfo')
	delete from GXDBVersions where aliasname = 'LiveMountGetSrcVMInfo'
GO

insert into GXDBVersions values(2, 'LiveMountGetSrcVMInfo',  '00010006001400240000', 'LiveMountGetSrcVMInfo', '00010006001400240000')
GO

