

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/LicenseIncrement.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Sergio Bonilla
--	Date:   12/28/2006
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/LicenseIncrement.sp,v $ $Id: LicenseIncrement.sp,v 1.9.86.4 2019/01/30 19:19:43 miyengar Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
-- @i_clientId can be client ID or Library ID
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='LicenseIncrement')
BEGIN
	print '>>> Drop Stored Procedure: LicenseIncrement <<<'
	drop procedure LicenseIncrement
END
IF EXISTS (select * from GxQscripts where name='LicenseIncrement')
	delete from GxQscripts where name = 'LicenseIncrement'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LicenseIncrement')
	delete from GXDBVersions where aliasname = 'LicenseIncrement'
GO
print '... Creating Procedure: LicenseIncrement'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure LicenseIncrement
  @i_clientId INT,
  @i_licType INT,
  @i_appType INT,
  @i_bConfigure INT,
  @i_flags INT,
  @i_quantity INT,
  @i_sError VARCHAR(MAX) OUT
AS
DECLARE	@bUpdateAAL	INT
DECLARE	@aalIsEval	INT
DECLARE @aalEvalDays	INT
DECLARE	@licEvalFld	VARCHAR(64)
DECLARE	@licPermFld	VARCHAR(64)
DECLARE	@newlicEncFld	VARCHAR(64)
DECLARE @LicUsageData	VARCHAR(2048)
DECLARE @newEncFld	VARCHAR(2048)
DECLARE @licUsageId	INT
DECLARE	@nEval		INT
DECLARE	@licUsed	INT
DECLARE	@licTotal	INT
DECLARE	@opType		VARCHAR(255)
DECLARE	@installFlag	INT
DECLARE	@clName		VARCHAR(255)
DECLARE	@clOSId		INT
DECLARE	@clRelId	INT
DECLARE @expDate	INT
DECLARE	@opTime		DATETIME
DECLARE	@buildStr	VARCHAR(255)
DECLARE @str0		VARCHAR(32) = '0'
DECLARE	@commcellId	INT = 2
SET @i_sError = ''
IF EXISTS (SELECT * FROM LicUsage WITH(NOLOCK) WHERE cid = @i_clientId AND licType = @i_licType AND appType = @i_appType AND (@i_bConfigure > 0 AND opType = 'Install' OR @i_bConfigure = 0 AND opType = 'UnInstall'))
	goto SP_EXIT
SET @bUpdateAAL = 1
IF @i_bConfigure = 0
BEGIN
IF (@i_flags & 0x2) > 0
		goto SP_EXIT
	IF NOT EXISTS (SELECT * FROM LicUsage WITH(NOLOCK) WHERE cid = @i_clientId AND licType = @i_licType AND appType = @i_appType AND opType = 'Install' AND installFlag = 0 AND eval = 0)
		SET @bUpdateAAL = 0
END
IF @bUpdateAAL > 0
BEGIN
	-------------------------------------
	-- Get AAL Info
	SET @nEval = -1
	SET @licTotal = 0
	SET @licUsed = 0
	SET @licEvalFld = ''
	SET @licPermFld = ''
	SELECT @licEvalFld = RTRIM(eval_fld1), @licPermFld = RTRIM(perm_fld1) FROM LicAAL WITH(NOLOCK) WHERE simLicAppTypeId = @i_licType AND commcellId = @commcellId
	IF LEN(@licPermFld) > 0
	BEGIN
		EXEC dbo.xp_getAALInfo2 @licPermFld, @licTotal OUTPUT, @licUsed OUTPUT, @aalIsEval OUTPUT, @aalEvalDays OUTPUT
		IF @i_bConfigure > 0 AND @licTotal >= @licUsed + 1
		BEGIN
			SET @nEval = 0
			SET @licUsed = @licUsed + 1
		END
		IF @i_bConfigure = 0 AND @licUsed - 1 >= 0
		BEGIN
			SET @nEval = 0
			SET @licUsed = @licUsed - 1
		END
	END
	ELSE IF @i_bConfigure = 0
	BEGIN
		SET @i_sError = 'Perm license [' + cast(@i_licType as varchar(64)) + '] is not available to release'
		goto SP_EXIT
	END
	IF @nEval < 0 AND LEN(@licEvalFld) > 0
	BEGIN
		EXEC dbo.xp_getAALInfo2 @licEvalFld, @licTotal OUTPUT, @licUsed OUTPUT, @aalIsEval OUTPUT, @aalEvalDays OUTPUT
		IF @i_bConfigure > 0 AND @licTotal >= @licUsed + 1
		BEGIN
			SET @nEval = 1
			SET @licUsed = @licUsed + 1
		END
	END
	-------------------------------------
	-- Update AAL fields
	IF @i_licType NOT IN (100001, 100002, 100003, 100004, 100005, 100006) OR @i_quantity > 0
	BEGIN
		SET @newlicEncFld = ''
		EXEC dbo.xp_buildAALFld @i_licType, @licTotal, @licUsed, @aalEvalDays, @aalIsEval, @newlicEncFld OUTPUT
		IF @nEval > 0
			UPDATE LicAAL SET eval_fld1 = REPLACE(@newlicEncFld, CHAR(0), '') WHERE simLicAppTypeId = @i_licType AND commcellId = @commcellId
		ELSE IF @nEval = 0
			UPDATE LicAAL SET perm_fld1 = REPLACE(@newlicEncFld, CHAR(0), '') WHERE simLicAppTypeId = @i_licType AND commcellId = @commcellId
	END
END
-- UPDATE LicUsage TABLE
IF @bUpdateAAL = 0 OR @nEval >= 0
BEGIN
	SET @installFlag = 0
	SET @opTime = GetUTCDate()
	IF @i_bConfigure = 0
	BEGIN
		SET @opType = 'UnInstall'
		SET @expDate = 0
		SET @nEval = 0
	END
	ELSE
	BEGIN
		SET @opType = 'Install'
		IF @aalEvalDays > dbo.getUNIXTime('2010-01-01')
			SET @expDate = @aalEvalDays
		ELSE IF @aalEvalDays > 0
			SET @expDate = dbo.getUNIXTime(GetDate()) + @aalEvalDays * 24 * 60 * 60
		ELSE
			SET @expDate = 0
	END
	SET @licUsageId = 0
	SELECT @licUsageId = id, @LicUsageData = EncryptedField FROM LicUsage WITH(NOLOCK) WHERE cid = @i_clientId AND licType = @i_licType AND appType = @i_appType
	IF @licUsageId > 0
	BEGIN
		DECLARE @nOpType INT
		DECLARE @nOpTime INT
		SET @nOpTime = dbo.GetUnixTime(@opTime)
		IF @opType = 'Install'
			SET @nOpType = 1
		ELSE
			SET @nOpType = 0
		EXEC UpdateLicUsageManaged @LicUsageData, @nOpType, @nOpTime, @expDate, @nEval, @newEncFld OUTPUT
		UPDATE	LicUsage
		SET	opType = @opType, opTimeUTC = @opTime, expiryDateUTC = dbo.getDateTime(@expDate), Eval = @nEval, EncryptedField = REPLACE(@newEncFld, CHAR(0), ''), UsedCapacity = @i_quantity
		WHERE	id = @licUsageId
	END
	ELSE
	BEGIN
		SELECT	@clName = net_hostName, @clOSId = SimOperatingSystemId, @clRelId = releaseId
		FROM	APP_Client WITH(NOLOCK)
		WHERE	id = @i_clientId
SET @buildStr = ISNULL((SELECT TOP 1 build FROM LicUsage WITH(NOLOCK) WHERE cid = @i_clientId AND releaseId = @clRelId), '0(' + 'BUILD80' + ')')
		-- LicUsage table
SET @LicUsageData =	@clName + ':-' + CAST(@i_clientId AS VARCHAR(64)) + ':-' + CAST(@i_licType AS VARCHAR(64)) + ':-' +
CAST(@i_appType AS VARCHAR(64)) + ':-' + @opType + ':-' + CAST(dbo.GetUnixTime(@opTime) AS VARCHAR(64)) + ':-' +
@str0 + ':-' + CAST(@nEval AS VARCHAR(64)) + ':-' + CAST(@expDate AS VARCHAR(64)) + ':-' + CAST(@clRelId AS VARCHAR(64)) + ':-' +
CAST(@clOSId AS VARCHAR(64)) + ':-' + @buildStr + ':-' + @str0
		EXEC pswEncryptionManaged @LicUsageData, @newEncFld OUTPUT
		IF @newEncFld IS NOT NULL AND LEN(@newEncFld) > 0
		BEGIN
			INSERT INTO LicUsage
			SELECT @clName, @i_clientId, @i_licType, @i_appType, @opType, @opTime, 0, @nEval, dbo.GetDateTime(@expDate), @clRelId, REPLACE(@newEncFld, CHAR(0), ''), @clOSId, @buildStr, 0, 0, @i_quantity
		END
		ELSE
		BEGIN
			SET @i_sError = 'Failed to encrypt password for client [' + cast(@i_clientId as varchar(64)) + '] license [' + cast(@i_licType as varchar(64)) + ']'
			goto SP_EXIT
		END
	END
END
SP_EXIT:
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'LicenseIncrement')
	delete from GxQscripts where name = 'LicenseIncrement'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LicenseIncrement')
	delete from GXDBVersions where aliasname = 'LicenseIncrement'
GO

insert into GXDBVersions values(2, 'LicenseIncrement',  '00010009008600040000', 'LicenseIncrement', '00010009008600040000')
GO

