

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/LicenseActivation.sp] ---------- 

-- ----------------------------------------------------------------------
--
--  Copyright (c) CommVault Systems
--  All Rights Reserved
--
--  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF CommVault Systems
--  The copyright notice above does not evidence any
--  actual or intended publication of such source code.
--
--  File name   : LicenseActivation.sp
--
--  Description : update the Licensing tables while a new License is applied
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/LicenseActivation.sp,v $ $Id: LicenseActivation.sp,v 1.99.2.48 2020/12/22 17:27:06 leiwang Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
-- @i_clientId can be client ID or Library ID
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='LicenseActivation')
BEGIN
	print '>>> Drop Stored Procedure: LicenseActivation <<<'
	drop procedure LicenseActivation
END
IF EXISTS (select * from GxQscripts where name='LicenseActivation')
	delete from GxQscripts where name = 'LicenseActivation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LicenseActivation')
	delete from GXDBVersions where aliasname = 'LicenseActivation'
GO
print '... Creating Procedure: LicenseActivation'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure LicenseActivation
  @i_licXML VARCHAR(MAX),
  @i_encLicKey VARCHAR(8000),
  @i_CSName VARCHAR(255),
  @i_CSHostName VARCHAR(255),
  @i_CSHomeDir VARCHAR(255),
  @i_releaseId INT,
  @i_flags INT,
  @i_localeId INT
AS
  DECLARE @o_errorCode INT
  DECLARE @o_bNewRel INT
  DECLARE @o_errorStr nvarchar(max)
SET NOCOUNT ON
	BEGIN TRANSACTION
	DECLARE	@CSLocalIPs		TABLE (t_csID INT)
	DECLARE	@evalExpTimeLics	TABLE (t_licType INT, t_expTime INT)
	DECLARE	@newLicTypesInKey	TABLE (t_licType INT, t_cellLevel INT, t_permQty INT, t_evalQty INT, t_oldPermTotal INT, t_oldPermUsed INT, t_oldEvalTotal INT, t_oldEvalUsed INT, t_evalInstalls INT, t_oldExpTime INT, t_expTime INT, t_licInherited INT)
	DECLARE	@CCLicTypesToConfig	TABLE (t_licType INT)
	DECLARE	@LicTypesToRemove	TABLE (t_licType INT, t_licName VARCHAR(256))
	DECLARE	@tempSPResult		TABLE (t_id INT)
	DECLARE	@CommcellID		INT
	DECLARE	@CSClientID		INT
	DECLARE	@MachIDInKey		INT
	DECLARE	@DRMachIDInKey		INT
	DECLARE	@newRepMachIDInKey	INT
	DECLARE	@csIdInKey		INT
	DECLARE	@OEMIdInKey		INT
	DECLARE	@isCSEvalInKey		INT
	DECLARE	@relnumInKey		INT
	DECLARE	@keyTypeInKey		INT
	DECLARE	@rmkcInKey		INT
	DECLARE	@evalDaysInKey		INT
	DECLARE	@expDateInKey		INT
	DECLARE @csGUIDInKey		VARCHAR(64)
DECLARE	@enclicInKey		VARCHAR(8000)
DECLARE	@licTypeList		VARCHAR(8000)
	DECLARE @commcellFlagInKey		INT = 0
	DECLARE @upperCapLimit		VARCHAR(32)
DECLARE	@EncLicKeyInDB		VARCHAR(8000)
	DECLARE	@MachIDInCslTbl		INT
	DECLARE	@MachIDInDB		INT
	DECLARE	@DRMachIDInDB		INT
	DECLARE	@newRepMachIDInDB	INT
	DECLARE	@csIdInDB		INT
	DECLARE	@OEMIdInDB		INT
	DECLARE	@isCSEvalInDB		INT
	DECLARE	@relnumInDB		INT
	DECLARE	@keyTypeInDB		INT
	DECLARE	@rmkcInDB		INT
	DECLARE	@evalDaysInDB		INT
	DECLARE	@expDateInDB		INT
DECLARE	@enclicInDB		VARCHAR(8000)
	DECLARE	@ccIdInDB		INT
	DECLARE @csGUIDInDB		VARCHAR(64)
	DECLARE	@licUpdateTime		INT
	DECLARE @ccOpMode		INT
	DECLARE	@licName		VARCHAR(256)
DECLARE	@cslFld			VARCHAR(48)
	DECLARE	@licWithQty		VARCHAR(30)
	DECLARE	@licType		INT
	DECLARE	@licPermQty		INT
	DECLARE	@licEvalQty		INT
	DECLARE @bCellLevel		INT
DECLARE	@licPermFld		VARCHAR(64)
DECLARE	@licEvalFld		VARCHAR(64)
	DECLARE @newExpDate		INT
	DECLARE @licUsageId		INT
	DECLARE	@evalLicTotal		INT
	DECLARE	@evalLicUsed		INT
	DECLARE	@permLicTotal		INT
	DECLARE	@permLicUsed		INT
	DECLARE	@EvalLicInstalled	INT
	DECLARE	@LicExpTime		INT
	DECLARE	@LicLevelExpTime	INT
DECLARE @licEncField		VARCHAR(2048)
DECLARE @newlicEncField		VARCHAR(2048)
	DECLARE @csIdStr		VARCHAR(64)
	DECLARE @csidEncStr		VARCHAR(64)
	DECLARE	@CCLicError		VARCHAR(MAX)
	DECLARE	@UNLIMITED		INT = -1
	DECLARE	@NOTSET			INT = -2
	DECLARE @CSLocalIPString VARCHAR(1024)
	DECLARE	@csId			INT = 0
	DECLARE @evalExpDate	INT
	DECLARE @currentTime 	DATETIME = GETUTCDATE()
	DECLARE @metricsUrl 	NVARCHAR(1024) = 'Default'
	DECLARE @licInherited	INT = 0
	DECLARE @bCapacityBasedLicense INT = 0
	DECLARE @licInheritedType	INT = 0
	DECLARE @commcellFlagInDB INT = 0
	DECLARE @licnotapplicable VARCHAR(1024) = ''
	DECLARE @licnotappliedlictype INT = -1
	DECLARE @isLicenseReapply INT = 0
BEGIN TRY
	SET @ccIdInDB		= 0
	SET @CommcellID		= 2
	SET @CSClientID 	= ISNULL((SELECT clientID FROM APP_Platform WHERE platformType = 1), 0)
	SET @csidEncStr 	= ''
	SET @licUpdateTime	= dbo.GetUNIXTime(@currentTime)
	SET @upperCapLimit	= 'UpperCapacityLimit'
	SET @i_encLicKey = REPLACE(@i_encLicKey, CHAR(13),'')
	-------------------------------------
	-- VALIDATE INPUT LICENSE KEY
	EXEC dbo.xp_RetrieveValidateLicKeyInfo @i_encLicKey, @MachIDInKey OUTPUT, @DRMachIDInKey OUTPUT, @newRepMachIDInKey OUTPUT, @csIdInKey OUTPUT, @OEMIdInKey OUTPUT, @isCSEvalInKey OUTPUT,
				@relnumInKey OUTPUT, @keyTypeInKey OUTPUT, @rmkcInKey OUTPUT, @evalDaysInKey OUTPUT, @expDateInKey OUTPUT, @enclicInKey OUTPUT, @licTypeList OUTPUT, @csGUIDInKey OUTPUT, @commcellFlagInKey OUTPUT
	SET @csGUIDInKey = REPLACE(@csGUIDInKey, CHAR(0), '')
	SET @o_errorCode = @@ERROR
	IF @o_errorCode != 0
	BEGIN
SET @o_errorCode =(553 | (CAST(POWER(2, 24) AS BIGINT) * 1))
		SET @o_errorStr =  dbo.SubsArgs0(@i_localeId,@o_ErrorCode)
		goto SP_EXIT
	END
	IF @expDateInKey <> 0 AND @expDateInKey < @licUpdateTime
	BEGIN
		DECLARE @expDate VARCHAR(32) = ''
SET @o_errorCode = (589 | (CAST(POWER(2, 24) AS BIGINT) * 1))
		SELECT @expDate = DATENAME(month, dbo.GetDateTime(@expDateInKey)) + ' ' + DATENAME(day, dbo.GetDateTime(@expDateInKey)) +','+DATENAME(year, dbo.GetDateTime(@expDateInKey))
		SET @o_errorStr =  dbo.SubsArgs1(@i_localeId,@o_ErrorCode,@expDate)
		goto SP_EXIT
	END
SELECT @licInheritedType = CASE WHEN @commcellFlagInKey = (2|1) THEN (2|1)
WHEN @commcellFlagInKey = 1 THEN 1
WHEN @commcellFlagInKey = (4|2|1) THEN (4|2|1)
ELSE 0
								END
IF @licInheritedType = 1
	BEGIN
		SET @metricsUrl = ''
		select @metricsUrl = ISNULL(value,'') from GXGlobalParam where name = 'CommservSurveyDownloadsite'
	END
ELSE IF @licInheritedType = (2|1)
	BEGIN
		SET @metricsUrl = ''
		select @metricsUrl = ISNULL(value,'') from GXGlobalParam where name = 'CommservSurveyPrivateDownloadsite'
	END
	IF LEN(@metricsUrl) = 0
	BEGIN
SET @o_errorCode = (588 | (CAST(POWER(2, 24) AS BIGINT) * 1))
		SET @o_errorStr =  dbo.SubsArgs0(@i_localeId,@o_ErrorCode)
		goto SP_EXIT
	END
	-------------------------------------
	SET @i_releaseId = CASE @i_releaseId
WHEN 16 THEN 0x00000B00
WHEN 15 THEN 0x00000A00
WHEN 14 THEN 0x00000900
WHEN 13 THEN 0x00000800
						ELSE @i_releaseId
						END
	-- CHECK RELEASE ID
	IF @relnumInKey < @i_releaseId
	BEGIN
		declare @i_releaseIdStr varchar(16)
		declare @relnumInKeyStr varchar(16)
set @i_releaseIdStr = CASE @i_releaseId	WHEN 0x00000B00 THEN '11' WHEN 0x00000A00 THEN '10' WHEN 0x00000900 THEN  '9.0'
WHEN 0x00000800 THEN  '8.0' ELSE '< 8.0' END
set @relnumInKeyStr = CASE @relnumInKey WHEN 0x00000B00 THEN '11' WHEN 0x00000A00 THEN '10' WHEN 0x00000900 THEN  '9.0'
WHEN 0x00000800 THEN  '8.0' ELSE '< 8.0' END
SET @o_errorCode = (163 | (CAST(POWER(2, 24) AS BIGINT) * 1))
		SET @o_errorStr  = dbo.SubsArgs2(@i_localeId,@o_ErrorCode,@relnumInKeyStr, @i_releaseIdStr)
		goto SP_EXIT
	END
	-------------------------------------
	-- GET NEW LICENSE LIST
	DECLARE GetLicTypesInKey CURSOR FOR SELECT _ID FROM dbo.SplitIDString(@licTypeList)
	OPEN GetLicTypesInKey
	FETCH NEXT FROM GetLicTypesInKey INTO @licWithQty
	WHILE @@FETCH_STATUS = 0
	BEGIN
		-------------------------------------
		-- Get license type & quantity
		DECLARE @delimPos	INT
		DECLARE @LicTypeLL	BIGINT
		DECLARE @strInt 	VARCHAR(64)
		DECLARE @bEval			INT
		DECLARE @oldEvalTime	INT = 0
		DECLARE @oldExpTime		INT = 0
		SET @delimPos	= CHARINDEX(':', @licWithQty)
		IF @delimPos <= 0
			BREAK
		SET @strInt	= substring(@licWithQty, 1, @delimPos - 1)
		SET @LicTypeLL	= CAST(@strInt AS BIGINT)
		SET @strInt	= substring(@licWithQty, @delimPos + 1, LEN(@licWithQty) - @delimPos)
		SET @delimPos = CHARINDEX(':', @strInt)
		IF @delimPos > 0
		BEGIN
			DECLARE @temp VARCHAR(128) = @strInt
			SET @strInt	= substring(@temp, @delimPos + 1, LEN(@temp) - @delimPos)
			SET @LicLevelExpTime = CAST(REPLACE(@strInt, CHAR(0), '') AS INT)
			SET @strInt	= substring(@temp, 1, @delimPos - 1)
		END
		ELSE
			SET @LicLevelExpTime = 0
		IF ISNUMERIC(substring(@strInt, len(@strInt), 1)) = 0
			SET @strInt = substring(@strInt, 1, len(@strInt)-1)
		SET @licPermQty	= CAST(@strInt AS INT)
IF @LicTypeLL & 0x80000000 > 0
SET @licType = @LicTypeLL + 0x80000000
		ELSE
			SET @licType = @LicTypeLL
		IF @licType IN (100002, 100004, 100005, 100006, 100015, 100016, 100031,100034,100036,100038, 100041, 100042, 100043, 100044, 100045, 100046, 100047, 100048, 100049, 100050) AND @licPermQty > 0
			SET @licPermQty = @licPermQty * 1024
		IF @licType = 100012
			SET @licType  = 203
IF @LicTypeLL & 0x80000000 > 0 OR @isCSEvalInKey > 0
		BEGIN
			SET @licEvalQty = @licPermQty
			if @isCSEvalInKey > 0
				SET @licPermQty = 0
			else
				SET @licPermQty = @NOTSET
		END
		ELSE
			SET @licEvalQty = @NOTSET
		IF NOT EXISTS (SELECT * FROM simLicAppTypeV2 WHERE id = @licType)
		BEGIN
			IF @licnotappliedlictype <> @licType
			BEGIN
				SET @licnotappliedlictype = @licType
				SET @licnotapplicable = CONCAT(@licnotapplicable, @licType, ';')
			END
			FETCH NEXT FROM GetLicTypesInKey INTO @licWithQty
			CONTINUE
		END
		-------------------------------------
		-- Get last AAL record info in CS DB
		SET @evalLicTotal	= 0
		SET @evalLicUsed	= 0
		SET @permLicTotal	= 0
		SET @permLicUsed	= 0
		SET @oldExpTime		= 0
		SET @licEvalFld		= ''
		SET @licPermFld		= ''
		SELECT @licEvalFld = RTRIM(eval_fld1), @licPermFld = RTRIM(perm_fld1) FROM LicAAL WHERE simLicAppTypeId = @licType AND commcellId = @CommcellID
		SET @o_errorCode = @@ERROR
		IF @o_errorCode != 0
		BEGIN
SET @o_errorCode =(552 | (CAST(POWER(2, 24) AS BIGINT) * 1))
			SET @o_errorStr =  dbo.SubsArgs1(@i_localeId,@o_ErrorCode,cast(@licType as varchar(64)))
			BREAK
		END
		IF LEN(@licEvalFld) > 0
		BEGIN
			EXEC dbo.xp_getAALInfo2 @licEvalFld, @evalLicTotal OUTPUT, @evalLicUsed OUTPUT, @bEval OUTPUT, @oldExpTime OUTPUT
			SET @o_errorCode = @@ERROR
			IF @o_errorCode != 0
			BEGIN
SET @o_errorCode =(552 | (CAST(POWER(2, 24) AS BIGINT) * 1))
				SET @o_errorStr =  dbo.SubsArgs1(@i_localeId,@o_ErrorCode,cast(@licType as varchar(64)))
				BREAK
			END
		END
		IF LEN(@licPermFld) > 0
		BEGIN
			EXEC dbo.xp_getAALInfo @licPermFld, @permLicTotal OUTPUT, @permLicUsed OUTPUT
		END
		-------------------------------------
		-- Store the info
		IF NOT EXISTS (select * from @newLicTypesInKey where t_licType = @licType)
			INSERT INTO @newLicTypesInKey
			SELECT	@licType,
				ISNULL((SELECT TOP 1 isCellLevel FROM simAppTypeLicTypeMap WHERE simLicAppType = @licType), 0),
				@licPermQty, @licEvalQty, @permLicTotal, @permLicUsed, @evalLicTotal, @evalLicUsed,
				(SELECT COUNT(*) FROM LicUsage WHERE LicType = @licType AND Eval = 1 AND OpType = 'Install' AND installFlag = 0), @oldExpTime, @LicLevelExpTime,
				CASE WHEN @lictype > 100000 AND (@licPermQty = 0 OR @licPermQty = @NOTSET) AND (@licEvalQty = 0 OR @licEvalQty = @NOTSET)
AND (@licInheritedType = 1 OR @licInheritedType = (2|1)) THEN 1 ELSE 0 END
		ELSE
			UPDATE @newLicTypesInKey
			SET	t_evalQty = @licEvalQty, t_oldExpTime = @oldExpTime, t_expTime = @LicLevelExpTime
			WHERE	t_licType = @licType
		FETCH NEXT FROM GetLicTypesInKey INTO @licWithQty
	END
	CLOSE GetLicTypesInKey
	DEALLOCATE GetLicTypesInKey
	-------------------------------------
	-- CHECK WHETHER THE LICENSE KEY IS ALREADY APPLIED
	SELECT TOP 1 @MachIDInCslTbl = machineId, @EncLicKeyInDB = EncLicKey, @cslFld = fld1 FROM LicCSL ORDER BY id DESC
	IF EXISTS (SELECT 1 FROM LicUsageBasedConfig WITH (NOLOCK) WHERE attrname = 'LicNotApplied')
	BEGIN
		DECLARE @licnotapplied VARCHAR(1024) = ''
		SELECT @licnotapplied = attrVal FROM LicUsageBasedConfig WITH (NOLOCK) WHERE attrname = 'LicNotApplied'
		IF EXISTS (SELECT 1 FROM SimLicAppTypeV2 S WITH (NOLOCK) INNER JOIN dbo.Split(@licnotapplied, ';') C ON S.id = C.Data)
			SET @isLicenseReapply = 1
	END
	IF @EncLicKeyInDB IS NOT NULL AND @EncLicKeyInDB = @i_encLicKey AND @isLicenseReapply = 0
	BEGIN
SET @o_errorCode = (331 | (CAST(POWER(2, 24) AS BIGINT) * 1))
		SET @o_errorStr = dbo.SubsArgs0(@i_localeId,@o_ErrorCode)
		goto SP_EXIT
	END
	-------------------------------------
	-- Don't allow mixed licenses
IF EXISTS (SELECT * FROM @newLicTypesInKey WHERE t_licType > 100000
				AND ((t_permQty > 0 AND t_evalQty = @UNLIMITED) OR (t_evalQty > 0 AND t_permQty = @UNLIMITED)))
	BEGIN
SET @o_errorCode = (586 | (CAST(POWER(2, 24) AS BIGINT) * 1))
		SET @o_errorStr = dbo.SubsArgs0(@i_localeId,@o_errorCode)
		goto SP_EXIT
	END
	-------------------------------------
	-- Make sure that VM & VM socket licenses are mutually exclusive
IF	0 < (SELECT count(*) FROM @newLicTypesInKey WHERE t_licType IN (100019, 100018))
		OR
1 < (SELECT count(*) FROM licAAL WHERE simLicAppTypeId IN (100019, 100018))
	BEGIN
		DECLARE @licVMInKey		INT = -1
		DECLARE @licVMInDB		INT = 0
		DECLARE @licVMSocketInKey	INT = -1
		DECLARE @licVMSocketInDB	INT = 0
SET @licVMInKey = (SELECT CASE WHEN t_permQty <> 0 OR t_evalQty <> 0 THEN 1 ELSE 0 END FROM @newLicTypesInKey WHERE t_licType = 100019)
SET @licVMInDB = (SELECT count(*) FROM licAAL WHERE simLicAppTypeId = 100019 AND commcellId = @CommcellID)
SET @licVMSocketInKey = (SELECT CASE WHEN t_permQty <> 0 OR t_evalQty <> 0 THEN 1 ELSE 0 END FROM @newLicTypesInKey WHERE t_licType = 100018)
SET @licVMSocketInDB = (SELECT count(*) FROM licAAL WHERE simLicAppTypeId = 100018 AND commcellId = @CommcellID)
		IF	@licVMInKey > 0 AND (@licVMSocketInKey > 0 OR @licVMSocketInDB > 0 AND @licVMSocketInKey <> 0) OR
			@licVMSocketInKey > 0 AND (@licVMInKey > 0 OR @licVMInDB > 0 AND @licVMInKey <> 0) OR
			@licVMSocketInDB > 0 AND @licVMInDB > 0 AND (@licVMSocketInKey <> 0 OR @licVMSocketInKey IS NULL) AND (@licVMInKey <> 0 OR @licVMSocketInKey IS NULL)
		BEGIN
DECLARE @sLicVM		varchar(126) = dbo.SubsArgs0(@i_localeId, (571 | (CAST(POWER(2, 24) AS BIGINT) * 1)))
DECLARE @sLicVMSocket	varchar(126) = dbo.SubsArgs0(@i_localeId, (570 | (CAST(POWER(2, 24) AS BIGINT) * 1)))
SET @o_errorCode = (582 | (CAST(POWER(2, 24) AS BIGINT) * 1))
			SET @o_errorStr = dbo.SubsArgs2(@i_localeId,@o_errorCode, @sLicVM, @sLicVMSocket)
			goto SP_EXIT
		END
	END
	--Delete rows from RptClientGroupQuotaUsage for regular license file
IF @licInheritedType = 0
		DELETE FROM RptClientGroupQuotaUsage where clientGroupId = 0
	-------------------------------------
	--Support -1 & 0 quantity for CLA: INSERT issed quantity INTO LicUsageBasedCOnfig table for CLA licenses
	SET @evalExpDate = @licUpdateTime + @evalDaysInKey * 24 *60 * 60
	IF @expDateInKey > dbo.getUNIXTime('2000-01-01')
		SET @newExpDate = @expDateInKey
	ELSE
		SET @newExpDate = @evalExpDate
	SET @o_errorCode = 0
	DECLARE CLAIssuedQty CURSOR FOR
SELECT t_licType, t_permQty, t_evalQty, t_expTime, t_licInherited FROM @newLicTypesInKey WHERE t_licType > 100000
	OPEN CLAIssuedQty
	FETCH NEXT FROM CLAIssuedQty INTO @licType, @licPermQty, @licEvalQty, @LicLevelExpTime, @licInherited
	WHILE @@FETCH_STATUS = 0
	BEGIN
		DECLARE	@CLAIssued	INT = 0
		DECLARE	@ExpTime	INT	= 0
		DECLARE	@newEncFld	VARCHAR(1024)
		IF @licPermQty NOT IN (0, @NOTSET)
		BEGIN
			IF @expDateInKey > 0 OR @evalDaysInKey > 0
				SET @ExpTime = @newExpDate
			SET @CLAIssued = @licPermQty
		END
		IF @licEvalQty NOT IN (0, @NOTSET) -- Support Mixed Mode
		BEGIN
			IF @LicLevelExpTime > 0
				SET @ExpTime = @LicLevelExpTime
			ELSE
				SET @ExpTime = @newExpDate
			SET @CLAIssued = @CLAIssued + @licEvalQty
			IF @CLAIssued < 0
				SET @CLAIssued = -1
		END
		-- If the issued qty is > 0 or it is a member commcell (remove lictype check later on when we extend it to other licenses)
		IF @CLAIssued > 0 OR @licInherited = 1
			SET @bCapacityBasedLicense = 1
		DECLARE @updateCALConfigQty TABLE ( o_errCode INT, o_totalQty INT, o_exptime BIGINT, o_errorStr VARCHAR(2048))
		INSERT INTO @updateCALConfigQty
		EXEC LicUpdateCapacityIssuedQty 0,@licType,@CLAIssued,@ExpTime
		SELECT @o_errorCode = o_errCode, @o_errorStr = o_errorStr FROM @updateCALConfigQty
		DELETE FROM @updateCALConfigQty
		IF @o_errorCode > 0
			BREAK
		FETCH NEXT FROM CLAIssuedQty INTO @licType, @licPermQty, @licEvalQty, @LicLevelExpTime, @licInherited
	END
	CLOSE CLAIssuedQty
	DEALLOCATE CLAIssuedQty
	IF @o_errorCode > 0
		goto SP_EXIT
	-------------------------------------
	-------------------------------------
	-- GET LOCAL CS IP: No need for IP check if regKey is set or it's DBUpgrade
IF (@i_flags & 0x1) = 0 AND (@i_flags & 0x8) = 0
		INSERT INTO @CSLocalIPs EXEC LicGetCSIPs
	ELSE
		INSERT INTO @CSLocalIPs VALUES (0)
	-------------------------------------
	-- CHECK WHETHER IP GIVEN IN THE LICENSE KEY MATCHES THE CS LOCAL IP
IF @keyTypeInKey <> 0x80 AND @MachIDInKey <> 0xFFFFFFFF AND
NOT EXISTS (select * from @CSLocalIPs where t_csID IN (0, @MachIDInKey)) AND (@DRMachIDInKey = 0xFFFFFFFF OR NOT EXISTS (select * from @CSLocalIPs where t_csID IN (0, @DRMachIDInKey)))
	BEGIN
SET @o_errorCode = (340 | (CAST(POWER(2, 24) AS BIGINT) * 1))
		SET @CSLocalIPString =''
		select @CSLocalIPString = coalesce(@CSLocalIPString + ',', '') + dbo.GetIPAddressString(t_csID)
		from @CSLocalIPs
		if len(@CSLocalIPString) >0
			select @CSLocalIPString = substring(@CSLocalIPString,2,len(@CSLocalIPString))
		SET @o_errorStr = dbo.SubsArgs2(@i_localeId,@o_ErrorCode, dbo.GetIPAddressString(@MachIDInKey) +
(CASE @DRMachIDInKey WHEN 0xFFFFFFFF THEN '' ELSE ', ' + dbo.GetIPAddressString(@DRMachIDInKey) END),@CSLocalIPString )
		goto SP_EXIT
	END
	------------------------------------
	-- GET PREVIOUS LICENSE KEY
	IF @EncLicKeyInDB IS NOT NULL
	BEGIN
		EXEC dbo.xp_RetrieveValidateLicKeyInfo @EncLicKeyInDB, @MachIDInDB OUTPUT, @DRMachIDInDB OUTPUT, @newRepMachIDInDB OUTPUT, @csIdInDB OUTPUT, @OEMIdInDB OUTPUT, @isCSEvalInDB OUTPUT,
				@relnumInDB OUTPUT, @keyTypeInDB OUTPUT, @rmkcInDB OUTPUT, @evalDaysInDB OUTPUT, @expDateInDB OUTPUT, @enclicInDB OUTPUT, @licTypeList OUTPUT, @csGUIDInDB OUTPUT, @commcellFlagInDB OUTPUT
		SET @csGUIDInDB = REPLACE(@csGUIDInDB, CHAR(0), '')
		IF LEN(@csGUIDInDB) = 0
		BEGIN
			SET @csGUIDInDB = ISNULL((SELECT CSGUID FROM APP_CommCell WHERE id = 2), '')
			IF LEN(@csGUIDInDB) = 0
				SET @csGUIDInDB = newid()
		END
		-------------------------------------
		-- Get IP from LicUsage table
		IF @MachIDInDB  <> @MachIDInCslTbl
			SET @MachIDInDB = @MachIDInCslTbl
		-------------------------------------
		-- IP CHECK
		-- If the input license key has dynamic address, Don't need to check for any ip conditions
IF @MachIDInKey <> 0xFFFFFFFF
		BEGIN
IF @keyTypeInKey = 0x80
			BEGIN
IF @MachIDInDB <> 0xFFFFFFFF AND @MachIDInDB <> @MachIDInKey AND @MachIDInDB <> @DRMachIDInKey
				BEGIN
SET @o_errorCode = (554 | (CAST(POWER(2, 24) AS BIGINT) * 1))
					SET @o_errorStr = dbo.SubsArgs2(@i_localeId,@o_ErrorCode, dbo.GetIPAddressString(@MachIDInKey) +
(CASE @DRMachIDInKey WHEN 0xFFFFFFFF THEN '' ELSE ', ' + dbo.GetIPAddressString(@DRMachIDInKey) END) , dbo.GetIPAddressString(@MachIDInDB) )
					goto SP_EXIT
				END
IF @newRepMachIDInKey <> 0xFFFFFFFF AND NOT EXISTS (select * from @CSLocalIPs where t_csID IN (0, @newRepMachIDInKey))
				BEGIN
SET @o_errorCode = (555 | (CAST(POWER(2, 24) AS BIGINT) * 1))
					SET @CSLocalIPString =''
					select @CSLocalIPString = coalesce(@CSLocalIPString + ',', '') + dbo.GetIPAddressString(t_csID)
					from @CSLocalIPs
					if len(@CSLocalIPString) >0
						select @CSLocalIPString = substring(@CSLocalIPString,2,len(@CSLocalIPString))
					SET @o_errorStr = dbo.SubsArgs2(@i_localeId,@o_ErrorCode,dbo.GetIPAddressString(@newRepMachIDInKey) , @CSLocalIPString)
					goto SP_EXIT
				END
				SET @MachIDInKey = @newRepMachIDInKey
			END
			-- Special case when DR IP change on the new DR machine, check against the new DR IP
ELSE IF @MachIDInDB <> 0xFFFFFFFF AND NOT EXISTS (select * from @CSLocalIPs where t_csID IN (0, @MachIDInDB)) AND
(@DRMachIDInDB = 0xFFFFFFFF OR NOT EXISTS (select * from @CSLocalIPs where t_csID IN (0, @DRMachIDInDB))) AND
(@DRMachIDInKey = 0xFFFFFFFF OR NOT EXISTS (select * from @CSLocalIPs where t_csID IN (0, @DRMachIDInKey)))
			BEGIN
SET @o_errorCode = (556 | (CAST(POWER(2, 24) AS BIGINT) * 1))
				SET @CSLocalIPString =''
				select @CSLocalIPString = coalesce(@CSLocalIPString + ',', '') + dbo.GetIPAddressString(t_csID)
				from @CSLocalIPs
				if len(@CSLocalIPString) >0
					select @CSLocalIPString = substring(@CSLocalIPString,2,len(@CSLocalIPString))
				declare @locStringArg1 varchar(1024)
				set @locStringArg1 = dbo.GetIPAddressString(@MachIDInDB) +
(CASE @DRMachIDInDB WHEN 0xFFFFFFFF THEN '' ELSE ', ' + dbo.GetIPAddressString(@DRMachIDInDB) END) +
(CASE @DRMachIDInKey WHEN 0xFFFFFFFF THEN '' ELSE ' , new DR IP  ' + dbo.GetIPAddressString(@DRMachIDInKey) END)
				SET @o_errorStr = dbo.SubsArgs2(@i_localeId,@o_ErrorCode,dbo.GetIPAddressString(@newRepMachIDInKey) , @CSLocalIPString)
				goto SP_EXIT
			END
		END
		-------------------------------------
		-- The activation key in the license key should not be lesser than the one in the database.
IF @rmkcInKey < @rmkcInDB AND (@i_flags & 0x2) = 0
		BEGIN
SET @o_errorCode = (428 | (CAST(POWER(2, 24) AS BIGINT) * 1))
			SET @o_errorStr = dbo.SubsArgs0(@i_localeId,@o_errorCode)
			goto SP_EXIT
		END
		-------------------------------------
		-- GET CS INFO
		-- for DBUpgrade, get CS names from APP_Client table, otherwise get from registry
IF (@i_flags & 0x8) > 0
		BEGIN
			SELECT @i_CSName = name, @i_CSHostName = net_hostName
			FROM	APP_Client
			WHERE	id in (select clientId from APP_Platform where platformType = 1)
		END
		-------------------------------------
		-- GET CC INFO
		SELECT TOP 1 @ccIdInDB = commcellId FROM LicCSL ORDER BY id DESC
		IF @ccIdInDB = 0
		BEGIN
SET @o_errorCode = (382 | (CAST(POWER(2, 24) AS BIGINT) * 1))
			SET @o_errorStr = dbo.SubsArgs1(@i_localeId,@o_errorCode,@i_CSName)
			goto SP_EXIT
		END
		SELECT @csId = number, @ccOpMode = ccOpMode
		FROM	APP_CommCell
		WHERE	id = @CommcellID
		IF @DRMachIDInKey <> -1 AND @DRMachIDInKey IN (select t_csID from @CSLocalIPs)
SET @ccOpMode = 1004
		ELSE IF @isCSEvalInKey = 0
SET @ccOpMode = 1002
		-------------------------------------
		-- CHECK WHETHER THE EARLIER LICENSE INFO MATCHES THE CURRENT LICENSE INFO: NOT ALLOW PERM TO EVAL
		IF @isCSEvalInDB = 0 AND @isCSEvalInKey > 0
		BEGIN
SET @o_errorCode = (150 | (CAST(POWER(2, 24) AS BIGINT) * 1))
			SET @o_errorStr = dbo.SubsArgs0(@i_localeId,@o_errorCode)
			goto SP_EXIT
		END
		-------------------------------------
		-- CHECK CSGUID
IF (@i_flags & 0x8) = 0
		BEGIN
IF LEN(@csGUIDInKey) = 0 AND @ccOpMode <> 1000
			BEGIN
SET @o_errorCode = (580 | (CAST(POWER(2, 24) AS BIGINT) * 1))
				SET @o_errorStr  = dbo.SubsArgs1(@i_localeId,@o_ErrorCode,@csGUIDInDB)
				goto SP_EXIT
			END
			IF LEN(@csGUIDInKey) > 0 AND @csGUIDInDB <> @csGUIDInKey
			BEGIN
SET @o_errorCode = (584 | (CAST(POWER(2, 24) AS BIGINT) * 1))
				DECLARE @SNO1 NVARCHAR(32)
				DECLARE @Reg1 NVARCHAR(32)
				DECLARE @SNO2 NVARCHAR(32)
				DECLARE @Reg2 NVARCHAR(32)
				SELECT @SNO1 = Sno, @Reg1 = RegNo FROM GetSNoRegCode(@csGUIDInKey)
				SELECT @SNO2 = Sno, @Reg2 = RegNo FROM GetSNoRegCode(@csGUIDInDB)
				SET @o_errorStr = dbo.SubsArgs4(@i_localeId,@o_errorCode,@SNO1,@Reg1,@SNO2,@Reg2)
				goto SP_EXIT
			END
		END
		-------------------------------------
		-- CHECK LICENSE REMOVAL
IF (@i_flags & 0x10) = 0 OR @keyTypeInKey = 0x01 OR @keyTypeInKey  = 0x40
		BEGIN
			-------------------------------------
			--getListOfRemovLicTypesNeedChk
			INSERT INTO @LicTypesToRemove
			SELECT t_licType, (select short_name from SimLicAppTypeV2 where id = t_licType)
			FROM	@newLicTypesInKey
WHERE	t_licType IN (	71, 82, 84,
85, 90, 91,
105, -1, -1, 111,
-1 ) AND
				(t_permQty = 0 AND t_permQty < t_oldPermTotal OR t_evalQty = 0 AND t_permQty >= 0 AND t_evalInstalls > t_permQty)
			-------------------------------------
			--@LicTypesToRemove
			SET @o_errorCode = 0
			SET @o_errorStr = ''
			DECLARE @LicList NVARCHAR(2048) = ''
			DECLARE GetLicTypesToRemove CURSOR FOR SELECT t_licType INT, t_licName FROM @LicTypesToRemove
			OPEN GetLicTypesToRemove
			FETCH NEXT FROM GetLicTypesToRemove INTO @licType, @licName
			WHILE @@FETCH_STATUS = 0
			BEGIN
				DELETE @tempSPResult
				INSERT INTO @tempSPResult
				EXEC MMS2GetLicenseInUse @licName, @licType
				SELECT	@LicList = @LicList + @licName , @o_errorCode = @o_errorCode + 1
				FROM @tempSPResult WHERE t_id > 0
				FETCH NEXT FROM GetLicTypesToRemove INTO @licType, @licName
			END
			CLOSE GetLicTypesToRemove
			DEALLOCATE GetLicTypesToRemove
			IF @o_errorCode > 0
			BEGIN
SET @o_errorCode = (587 | (CAST(POWER(2, 24) AS BIGINT) * 1))
				SET	@o_errorStr = dbo.SubsArgs1(@i_localeId,@o_ErrorCode,@LicList)
				goto SP_EXIT
			END
			ELSE
				SET @o_errorStr = ''
		END
	END
	ELSE IF @isCSEvalInKey > 0
SET @ccOpMode = 1000
	ELSE
SET @ccOpMode = 1002
	-------------------------------------
	-- EncLicCSLfld
	IF @csGUIDInDB IS NULL OR LEN(@csGUIDInDB) = 0
		SET @csGUIDInDB = newid()
	--Convert GUID to upper case and store it as license key generation fails with lower case character in guid
	SET @csGUIDInDB = UPPER(@csGUIDInDB)
	IF @csId <= 0
	BEGIN
		SET @csIdStr = SUBSTRING(@csGUIDInDB, LEN(@csGUIDInDB) - 6, LEN(@csGUIDInDB))
		SET @csId = dbo.ConvertHexToInt(@csIdStr)
	END
	SET @csIdStr= CAST(@csId AS VARCHAR(64))
	SET @cslFld = ''
	EXEC dbo.xp_EncCSLFLD @csId, @OEMIdInKey, @MachIDInKey, @isCSEvalInKey, @relnumInKey, @evalDaysInKey, @expDateInKey, @enclicInKey, @cslFld OUTPUT
	IF LEN(@cslFld) = 0
	BEGIN
SET @o_errorCode = (20 | (CAST(POWER(2, 24) AS BIGINT) * 1))
		SET @o_errorStr =  dbo.SubsArgs0(@i_localeId,@o_ErrorCode)
		goto SP_EXIT
	END
	-------------------------------------
	-- INSERT NEW CSL & SimLicenses RECORD
	INSERT INTO LicCSL VALUES (@MachIDInKey, @DRMachIDInKey, @licUpdateTime, @csIdInKey, @i_encLicKey, @OEMIdInKey, 1, REPLACE(@cslFld, CHAR(0), ''), @rmkcInKey)
	IF @i_licXML IS NOT NULL AND @isLicenseReapply = 0
		INSERT INTO SimLicenses VALUES (@rmkcInKey, @keyTypeInKey, @i_licXML)
	-------------------------------------
	-- Update LicAal table
IF (@i_flags & 0x10) = 0 OR @keyTypeInKey = 0x01 OR @keyTypeInKey = 0x40
	BEGIN
		-------------------------------------
		-- Adjust Cell level license quantity
		UPDATE @newLicTypesInKey
		--SET	t_permQty = CASE WHEN t_permQty > 1 THEN 1 ELSE t_permQty END, t_evalQty = CASE WHEN t_evalQty > 1 THEN 1 ELSE t_evalQty END
		--Fix for CELL level license was showing as not consumed for some licenses that are unlimited MR:72712
		SET	t_permQty = CASE WHEN (t_permQty > 1 OR (t_permQty=@UNLIMITED)) THEN 1 ELSE t_permQty END, t_evalQty = CASE WHEN (t_evalQty > 1 OR  (t_evalQty=@UNLIMITED)) THEN 1 ELSE t_evalQty END
WHERE	t_cellLevel > 0 AND t_licType < 100000
		-------------------------------------
		-- For each license
		DECLARE getLicList CURSOR FOR SELECT t_licType, t_cellLevel, t_permQty, t_evalQty, t_oldPermTotal, t_oldPermUsed, t_oldEvalTotal, t_oldEvalUsed, t_evalInstalls, t_expTime, t_licInherited FROM @newLicTypesInKey
		OPEN getLicList
		FETCH NEXT FROM getLicList INTO @licType, @bCellLevel, @licPermQty, @licEvalQty, @permLicTotal, @permLicUsed, @evalLicTotal, @evalLicUsed, @EvalLicInstalled, @LicLevelExpTime, @licInherited
		WHILE @@FETCH_STATUS = 0
		BEGIN
			DECLARE	@newEvalUsed	INT
			DECLARE	@newPermUsed	INT
			-------------------------------------
			-- Build new values for AAL fld
			--SET @newEvalUsed = @evalLicUsed
			SET @newEvalUsed = @EvalLicInstalled
			SET @newPermUsed = @permLicUsed
			-------------------------------------
			-- CC level licenses
IF @bCellLevel > 0 AND @licType < 100000
			BEGIN
				-------------------------------------
				-- DeConfigure CC Level license
				IF @licPermQty = 0 AND @licEvalQty = 0 AND (@permLicUsed > 0 OR @evalLicUsed > 0)
				BEGIN
					EXEC LicUpdateCCLevelLicense @licType, 0, @i_flags, @CCLicError OUTPUT
					IF LEN(@CCLicError) > 0
					BEGIN
						SELECT	@o_errorStr = 'A Commcell level license [' + cast(@licType as varchar(64)) + '] de-configure failed: ' + @CCLicError, @o_errorCode = @o_errorCode + 1
						BREAK
					END
					SET @evalLicUsed = 0
					SET @permLicUsed = 0
					SET @EvalLicInstalled = 0
				END
				-------------------------------------
				-- Configure CC Level license after AAL table is updated
				ELSE IF (@permLicUsed + @evalLicUsed) = 0 AND (@licPermQty > 0 OR @licEvalQty > 0)
				BEGIN
					INSERT INTO @CCLicTypesToConfig VALUES (@licType)
				SET @newEvalUsed = 0
				SET @newPermUsed = 0
				END
			END
			-------------------------------------
			-- Check whether enough licenses are issued
IF @licType > 100000
			BEGIN
				DECLARE @totalIssuedQty INT = 0
				IF @licEvalQty > 0
					SET @totalIssuedQty = @licEvalQty
				IF @licPermQty > 0
					SET @totalIssuedQty = @totalIssuedQty + @licPermQty
				IF (@licEvalQty != @UNLIMITED AND @licPermQty != @UNLIMITED) AND (@totalIssuedQty < @permLicUsed+@evalLicUsed)
AND @licInherited = 0 AND @licType < 100011
				BEGIN
					--Variable for @usedPermBytes/@issuedPermByte.
					DECLARE @usedPermBytes BIGINT
					DECLARE @issuedPermBytes BIGINT
					SET	@usedPermBytes	 = CONVERT(bigint, CONVERT(bigint, @permLicUsed+@evalLicUsed) * 1024*1024*1024)
					SET	@issuedPermBytes = CONVERT(bigint, CONVERT(bigint, @totalIssuedQty) * 1024*1024*1024)
SET @o_errorCode = (569 | (CAST(POWER(2, 24) AS BIGINT) * 1))
					SET @o_errorStr =dbo.SubsArgs3(@i_localeId,@o_errorCode, DBO.GetAutoSizeStr(@usedPermBytes), DBO.GetAutoSizeStr(@issuedPermBytes),  ISNULL((select short_name from SimLicAppTypeV2 where id = @licType),'')  )
					BREAK
				END
				-------------------------------------
				-- Support -1 & 0 quantity for CLA
				UPDATE @newLicTypesInKey
				SET t_permQty = 0, t_evalQty = 0
				WHERE t_licType = @licType AND (t_permQty = @UNLIMITED OR t_evalQty = @UNLIMITED)
				SET @newEvalUsed = 0
			END
			ELSE IF @licEvalQty >= 0 AND @licEvalQty < @EvalLicInstalled OR @licPermQty >= 0 AND @licPermQty < @permLicUsed
			BEGIN
				IF @licPermQty >= 0 AND @licPermQty < @permLicUsed
				BEGIN
SET @o_errorCode = (557 | (CAST(POWER(2, 24) AS BIGINT) * 1))
					set @o_errorStr =dbo.SubsArgs3(@i_localeId,@o_errorCode,ISNULL((select short_name from SimLicAppTypeV2 where id = @licType),''), cast(@licPermQty as varchar(64)), cast(@permLicUsed as varchar(64)))
					BREAK
				END
ELSE IF @licType < 100000 AND (@licPermQty >= 0 AND (@licPermQty - @newPermUsed) < @EvalLicInstalled OR @isCSEvalInKey > 0 AND @licEvalQty < @EvalLicInstalled)
				BEGIN
SET @o_errorCode = (558 | (CAST(POWER(2, 24) AS BIGINT) * 1))
					set @o_errorStr = dbo.SubsArgs3(@i_localeId,@o_errorCode,ISNULL((select short_name from SimLicAppTypeV2 where id = @licType),''), cast(@licEvalQty as varchar(64)), cast(@EvalLicInstalled as varchar(64)))
					BREAK
				END
				-------------------------------------
				-- Need to reset used count to 0 since all the eval install can be converted to perm, otherwise we may end with used eval > issued eval
				SET @newEvalUsed = 0
			END
			-------------------------------------
			-- CONVERT EVAL TO PERM, Skip for capacity as they will be taken care in computeDateUsage
IF (@i_flags & 0x4) = 0 AND @ccOpMode <> 1000 AND (@licPermQty = @UNLIMITED OR @EvalLicInstalled <= (@licPermQty - @permLicUsed)) AND @licType NOT IN (100002,100004,100005,100006)
			BEGIN
				IF @EvalLicInstalled > 0 AND (@licPermQty < 0 OR @EvalLicInstalled <= (@licPermQty - @newPermUsed))
				BEGIN
					SET @newExpDate = 0
					SET @newEvalUsed = 0
					SET @newPermUsed = @newPermUsed + @EvalLicInstalled
				END
				DECLARE getEvalLicUsageInstalls CURSOR FOR SELECT id, EncryptedField FROM LicUsage WHERE LicType = @licType AND Eval = 1 AND OpType = 'Install' AND installFlag = 0
				OPEN getEvalLicUsageInstalls
				FETCH NEXT FROM getEvalLicUsageInstalls INTO @licUsageId, @licEncField
				WHILE @@FETCH_STATUS = 0
				BEGIN
					-------------------------------------
					-- Update EncryptedField
					EXEC ExtendLicUsageExpDateManaged @licEncField, @newExpDate, @newlicEncField OUTPUT
					-------------------------------------
					-- Update licUsage
					UPDATE LicUsage
					SET	Eval = 0, expiryDateUTC = dbo.GetDateTime(@newExpDate), EncryptedField = REPLACE(@newlicEncField, CHAR(0), '')
					WHERE	id = @licUsageId
					FETCH NEXT FROM getEvalLicUsageInstalls INTO @licUsageId, @licEncField
				END
				CLOSE getEvalLicUsageInstalls
				DEALLOCATE getEvalLicUsageInstalls
			END
			-------------------------------------
			-- UPDATE/INSERT LicAAL table
			IF (@licPermQty <> 0 OR @licEvalQty <> 0)
			BEGIN
IF @licType > 100000
				BEGIN
					SET @newEvalUsed = 0
					SET @newPermUsed = 0
				END
				DECLARE	@newEvalExpTime INT
				IF @LicLevelExpTime > 0
					SET @newEvalExpTime = @LicLevelExpTime
				ELSE
					SET @newEvalExpTime = @evalExpDate
				-------------------------------------
				-- Build new AAL fields: _cslencAALfld_
				IF @licEvalQty > @NOTSET AND @licEvalQty <> 0
					EXEC dbo.xp_buildAALFld @licType, @licEvalQty, @newEvalUsed, @newEvalExpTime, 1, @licEvalFld OUTPUT
				ELSE
					SET @licEvalFld = ''
				IF @licPermQty <> 0
				BEGIN
					DECLARE @AalIsEval	INT
					DECLARE @AalEvalDays	INT
					SET @AalIsEval = 1
IF @ccOpMode = 1000
						SET @AalEvalDays = @evalExpDate
					ELSE IF @expDateInKey > dbo.getUNIXTime('2000-01-01')
						SET @AalEvalDays = @expDateInKey
					ELSE
					BEGIN
						SET @AalIsEval = 0
						SET @AalEvalDays = 0
					END
					EXEC dbo.xp_buildAALFld @licType, @licPermQty, @newPermUsed, @AalEvalDays, @AalIsEval, @licPermFld OUTPUT
				END
				ELSE
					SET @licPermFld = ''
				-------------------------------------
				-- UPDATE/INSERT LicAAL table
				IF EXISTS (SELECT * FROM LicAAL WHERE simLicAppTypeId = @licType AND commcellId = @CommcellID)
					UPDATE LicAAL
					SET	eval_fld1 = (CASE @licEvalQty WHEN @NOTSET THEN eval_fld1 ELSE REPLACE(@licEvalFld, CHAR(0), '') END),
						perm_fld1 = (CASE @licPermQty WHEN @NOTSET THEN perm_fld1 ELSE REPLACE(@licPermFld, CHAR(0), '') END)
					WHERE	simLicAppTypeId = @licType AND commcellId = @CommcellID
				ELSE
					INSERT INTO LicAAL
					SELECT	@licType, (CASE @licEvalQty WHEN @NOTSET THEN '' ELSE REPLACE(@licEvalFld, CHAR(0), '') END), (CASE @licPermQty WHEN @NOTSET THEN '' ELSE REPLACE(@licPermFld, CHAR(0), '') END), @CommcellID
			END
			FETCH NEXT FROM getLicList INTO @licType, @bCellLevel, @licPermQty, @licEvalQty, @permLicTotal, @permLicUsed, @evalLicTotal, @evalLicUsed, @EvalLicInstalled, @LicLevelExpTime, @licInherited
		END
		CLOSE getLicList
		DEALLOCATE getLicList
		IF @o_errorCode > 0
		BEGIN
			IF @o_errorCode >= 1000
SET @o_errorCode = (2 | (CAST(POWER(2, 24) AS BIGINT) * 1))
			ELSE
SET @o_errorCode = (153 | (CAST(POWER(2, 24) AS BIGINT) * 1))
			goto SP_EXIT
		END
		-------------------------------------
		-- DELETE LicAAL table
		UPDATE @newLicTypesInKey
		SET	t_evalQty = (CASE WHEN t_evalQty = @NOTSET AND t_permQty <> @NOTSET THEN 0 ELSE t_evalQty END), t_permQty = (CASE WHEN t_permQty = @NOTSET AND t_evalQty <> @NOTSET THEN 0 ELSE t_permQty END)
		WHERE	t_licType IN ( 100002, 100004, 100005, 100006 )
		DELETE	LicAAL
		FROM	@newLicTypesInKey WHERE simLicAppTypeId = t_licType AND t_permQty = 0 AND t_evalQty = 0 AND commcellId = @CommcellID
		UPDATE	LicAAL
		SET	eval_fld1 = ''
		FROM	@newLicTypesInKey WHERE simLicAppTypeId = t_licType AND t_evalQty = 0 AND commcellId = @CommcellID
		UPDATE	LicAAL
		SET	perm_fld1 = ''
		FROM	@newLicTypesInKey WHERE simLicAppTypeId = t_licType AND t_permQty = 0 AND commcellId = @CommcellID
		-------------------------------------
		--If it is replaceMachid, we should still populate entries for capacity based in LicUsageBasedConfig table. In case of licensing server or child commcell licInheritedType might be lost
IF @keyTypeInKey = 0x80 AND EXISTS (SELECT * FROM LicUsageBasedConfig WITH (NOLOCK) where attrname = 'LicData')
			SET @bCapacityBasedLicense = 1
		-- DELETE Capacity based licenses
		DELETE	LicUsageBasedConfig
		WHERE	attrName NOT Like '1000% issued'
		DELETE	LicUsage
		FROM	@newLicTypesInKey
WHERE	licType = t_licType AND t_licType > 100000 AND t_permQty = 0 AND t_evalQty = 0
		-------------------------------------
		-- UpdateLicUsageForUsageBasedLicenses: insert licUsage table
		INSERT INTO @CCLicTypesToConfig
		SELECT	t_licType
		FROM	@newLicTypesInKey
		WHERE	t_licType IN ( 100002, 100004, 100005, 100006 ) AND (t_permQty > 0 OR t_evalQty > 0 )
		--Upadate Encrypted field in LicUsageBasedConfig
DECLARE @nIntervalToCalcUsage INT = 90
		DECLARE @bOverrideLicExpiration INT = 0
		DECLARE @nNumberOfTimesLicReset INT = 0
		DECLARE @nLastCalculationTime INT = 0
		DECLARE @nLastOverRrideTime INT = 0
DECLARE @nNumOfResetsLimit INT = 8
DECLARE @nUpperCapacityLimit INT = 110
		DECLARE @sIPAddress NVARCHAR(20) = ''
		DECLARE	@FormatedData	NVARCHAR(512)
		DECLARE @licData	NVARCHAR(8) = 'LicData' --SZ_LIC_DATA
		DECLARE @licUsageBasedLicData	NVARCHAR(32) = 'LicUsageBasedLicData' --SZ_LIC_DATA_CAL
		select @sIPAddress = dbo.GetIPAddressString(@MachIDInKey)
		SELECT @nLastCalculationTime = dbo.GetUnixTime(GETUTCDATE())
SET @FormatedData = @sIPAddress + ':-' +
CAST(@nIntervalToCalcUsage AS VARCHAR(16)) + ':-' +
CAST(@bOverrideLicExpiration AS VARCHAR(16)) + ':-' +
CAST(@nNumberOfTimesLicReset AS VARCHAR(16)) + ':-' +
CAST(@nLastCalculationTime AS VARCHAR(16)) + ':-' +
CAST(@nLastOverRrideTime AS VARCHAR(16)) + ':-' +
CAST(@nNumOfResetsLimit AS VARCHAR(16)) + ':-' +
CAST(@nUpperCapacityLimit AS VARCHAR(16)) + ':-'  +
CAST(@licInheritedType AS VARCHAR(16)) + ':-'
		SET @newEncFld = ''
		EXEC pswEncryptionManaged @FormatedData, @newEncFld OUTPUT
		IF @newEncFld <> ''
		BEGIN
			SET @newEncFld = REPLACE(@newEncFld, CHAR(0), '')
			IF EXISTS (SELECT * FROM LicUsageBasedConfig WITH (NOLOCK) where attrname = @licUsageBasedLicData)
				UPDATE LicUsageBasedConfig
				SET attrVal = @newEncFld
				WHERE attrname = @licUsageBasedLicData
			ELSE
				INSERT INTO LicUsageBasedConfig
				SELECT @licUsageBasedLicData, 1, @newEncFld
			IF @bCapacityBasedLicense = 1
			BEGIN
				IF EXISTS (SELECT * FROM LicUsageBasedConfig WITH (NOLOCK) where attrname = @licData)
					UPDATE LicUsageBasedConfig
					SET attrVal = @newEncFld
					WHERE attrname = @licData
				ELSE
					INSERT INTO LicUsageBasedConfig
					SELECT @licData, 1, @newEncFld
			END
			-- We should set licInheritedType here because it is used in LicGetQuotaUsage SP which is called before this value is set in CPP code
			INSERT INTO LicUsageBasedConfig
			SELECT 'InheritedLicType', 1, @licInheritedType --SZ_INHERITED_LI_TYPE
		END
	END
	-- Clear the IP invalid status in Licusagebasedconfig table
	EXEC @o_errorCode = LicUpdateIpStatus 0
	IF @o_errorCode <> 0 goto SP_EXIT
	-------------------------------------
	-- Add CS ID in GxGlobalParam table
IF NOT EXISTS (select * from GxGlobalParam where name = 'CSLicenseId')
	BEGIN
		EXEC pswEncryptionManaged @csIdStr, @csidEncStr OUTPUT
		SET @csidEncStr = REPLACE(@csidEncStr, CHAR(0), '')
		INSERT INTO GxGlobalParam
SELECT 'CSLicenseId', @csidEncStr, @licUpdateTime, 0
	END
	-------------------------------------
	-- InsertDefaultEntries
IF @i_flags & 0x8 = 0
	BEGIN
		-------------------------------------
		-- INSERT DEFAULT ENTRIES
		IF @CSClientID = 0
		BEGIN
			DECLARE	@clOSId		INT
IF (@i_flags & 0x40) = 0
SET @clOSId = 21
			ELSE
SET @clOSId = 98
DECLARE @LicUsageData	VARCHAR(2048)
DECLARE @EncValue	VARCHAR(2048)
			DECLARE @str0		VARCHAR(32) = '0'
			EXEC pswEncryptionManaged @i_CSHostName, @EncValue OUTPUT
			SET @CSClientID = 2
			DECLARE @newcsGUIDInDB		VARCHAR(64)
			SET @newcsGUIDInDB = newid()
			-------------------------------------
			-- Add client
			-- This code can be called during DBUpgrade even before sqladmin_cv DB user is called.
			-- So, execute as login.
			EXECUTE AS LOGIN = 'sqladmin_cv'
			SET IDENTITY_INSERT APP_Client ON
			INSERT INTO APP_Client (id, name, simOperatingSystemId, net_hostname, client_password, refTime, modified, offlineEntity, offlineTimeStamp, csHostName,
						clientDescription, jobResultDir, clientSkewTime, cvdPort, evmgrcPort, status, releaseId, spaceCheckFlags,ccpId, ccpTime, origCCId,GUID)
VALUES(@CSClientID, @i_CSName, @clOSId, @i_CSHostName, REPLACE(@EncValue, CHAR(0), ''), 0, 0, 0, 0, @i_CSHostName, N'', N'', 0, 8400, 8402, 0, 16, 0, 0, 0, 2, @newcsGUIDInDB)
			SET IDENTITY_INSERT APP_Client OFF
			REVERT
			-------------------------------------
			-- Add Platform
			INSERT INTO APP_Platform SELECT @CSClientID, 1, RTRIM(@i_CSHomeDir), 0
			-------------------------------------
			-- LicUsage table
SET @LicUsageData =	@i_CSHostName + ':-' + CAST(@CSClientID AS VARCHAR(64)) + ':-' + '50331648' + ':-' +
CAST(1000 AS VARCHAR(64)) + ':-' + (CASE 1 WHEN 0 THEN 'UnInstall' ELSE 'Install' END)  + ':-' + CAST(@licUpdateTime AS VARCHAR(64)) + ':-' +
@str0 + ':-' + @str0 + ':-' + @str0 + ':-' + CAST(16 AS VARCHAR(64)) + ':-' +
CAST(@clOSId AS VARCHAR(64)) + ':-' + '0(' + 'BUILD80' + ')' + ':-' + @str0
			EXEC pswEncryptionManaged @LicUsageData, @EncValue OUTPUT
			INSERT INTO LicUsage
SELECT @i_CSHostName, @CSClientID, 0x03000000, 1000, 'Install', @currentTime, 0, 0, dbo.GetDateTime(0), 16,
REPLACE(@EncValue, CHAR(0), ''), @clOSId, '0(' + 'BUILD80' + ')', 0, 0, 0
		END
		-------------------------------------
		-- INSERT/UPDATE APP_CommCell table
		IF NOT EXISTS (SELECT * FROM APP_CommCell WHERE id = @CommcellID)
		BEGIN
			DECLARE @CCID INT
			-- This code can be called during DBUpgrade even before sqladmin_cv DB user is called.
			-- So, execute as login.
			EXECUTE AS LOGIN = 'sqladmin_cv'
			SET IDENTITY_INSERT APP_CommCell ON
			INSERT INTO APP_CommCell (id, number, clientId, parentId, aliasName, flags, refTime, userName, userPassword, smtpServer, timeZone, ipAddress, modified, ccOpMode, drIpAddress, encNumber, csGUID, type)
			VALUES(@CommcellID, @csId, @CSClientID, 1, @i_CSName, 0, 0, N'', N'1', N'', N'', dbo.GetIPAddressString(@MachIDInKey), 0, @ccOpMode, N'', @csidEncStr, @csGUIDInDB, 1)
			SET IDENTITY_INSERT APP_CommCell OFF
			REVERT
		END
		ELSE
		BEGIN
			DECLARE @flags INT
			SET @flags = (SELECT flags FROM APP_CommCell where id = @CommcellID)				-- From 10.0, the flag "Add new users to view all by default" is being set to off by default
			UPDATE	APP_CommCell
			SET	number = (CASE WHEN number < 0 THEN @csId ELSE number END),
				ipAddress = dbo.GetIPAddressString(@MachIDInKey), flags = @flags, ccOpMode = @ccOpMode
			WHERE	id = @CommcellID
		END
		-------------------------------------
		-- INSERT into SimInstalledPackages table
		DECLARE @packageid integer
IF (@i_flags & 0x40) = 0
SET @packageid = 801
		ELSE
SET @packageid = 851
		IF NOT EXISTS (SELECT 1 FROM SimInstalledPackages where SimPackageId = @packageid)
		BEGIN
			DECLARE @ssipCreateIfNotExists integer = 1
			DECLARE  @ssipClientId integer = @CSClientID
			DECLARE  @ssipPackageID integer = @packageid
			DECLARE  @ssipOpTime datetime = @currentTime
			DECLARE  @ssipOpType char(25) = 'Install'
			DECLARE  @ssipUserID integer = 0
			DECLARE  @ssipHighestSP integer = 0
			DECLARE  @ssipAdditionalPatches nvarchar(1) = ''
			DECLARE  @ssipMissingPatches nvarchar(1) = ''
			DECLARE  @ssipNode nvarchar(255) = ''
			DECLARE  @ssipIsActive integer = 1
			DECLARE  @ssipSpMinorVersion integer = 0
			DECLARE  @ssipBaseline integer = 0
			DECLARE  @ssipBaselineDeltaSP nvarchar(1) = ''
			DECLARE  @ssipBaselineDeltaUpdate nvarchar(1) = ''
			DECLARE  @ssipTransactionID integer = 0
			DECLARE  @ssipRevisionID integer = 0
			DECLARE  @ssipFriendlyName varchar(256) = ''
			DECLARE  @ssipUpdatePackNum integer = 0
			DECLARE  @ssipUPTransactionID integer = 0
--- CODE BELOW HERE IS FROM simSetInstalledPackage.spb  ----------
-- in order to use, variables to be declared are...
-- INPUT : @ssipCreateIfNotExists integer, @ssipClientId integer, @ssipPackageID integer, @ssipOpTime datetime, @ssipOpType char(25), @ssipUserID integer, @ssipHighestSP integer,ssipAdditionalPatches ntext, @ssipMissingPatches ntext, @ssipNodenvarchar(255), @ssipIsActive integer, @ssipSpMinorVersion integer, @ssipBaseline integer, @ssipBaselineDeltaSP ntext, @ssipBaselineDeltaUpdate ntext, @ssipTransactionID integer = 0, @ssipRevisionID integer = 0, @ssipUPTransactionID integer = 0
DECLARE @releaseId integer
SELECT @releaseId = releaseId FROM APP_Client WITH (NOLOCK) WHERE id = @ssipClientId
DECLARE @isCSSPUpgrade INTEGER = 0
DECLARE @oldCSRelease INTEGER = 0
DECLARE @oldCSSPMajor INTEGER = 0
DECLARE @oldCSSPMinor INTEGER = 0
DECLARE @oldCSSPTransId INTEGER = 0
-- Check PatchSPVersion table for entry
DECLARE @spVersionInfo TABLE ( id int )
DECLARE @buildNum INT = dbo.GetBuildNum(@releaseId)
INSERT @spVersionInfo
EXEC simGetSPVersionID @releaseId, @buildNum, @ssipHighestSP, @ssipSpMinorVersion, @ssipTransactionId, @ssipRevisionId, @ssipFriendlyName, @ssipUpdatePackNum, @ssipUPTransactionID
DECLARE @patchSPVersionId integer
SELECT @patchSPVersionId = id FROM @spVersionInfo
IF EXISTS (SELECT 1 FROM simInstalledPackages WITH (NOLOCK) WHERE ClientId = @ssipClientId AND simPackageID = @ssipPackageId)
BEGIN
IF @ssipClientId = 2 AND @ssipPackageID = 20
	BEGIN
		DECLARE @spComparison INTEGER
		DECLARE @oldCSUpdatePackNum INTEGER
		SELECT @oldCSRelease = P.Release, @oldCSSPMajor = P.SPMajor, @oldCSSPMinor = P.SPMinor, @oldCSSPTransId = P.TransactionId, @oldCSUpdatePackNum = S.UPNumber
		FROM simInstalledPackages S WITH(NOLOCK) JOIN PatchSPVersion P WITH(NOLOCK) ON S.SPVersionID = P.Id WHERE S.ClientId = @ssipClientId AND S.simPackageID = @ssipPackageID
		SET @spComparison = dbo.CompareServicePackLevel(@ssipHighestSP, @ssipSpMinorVersion, @ssipTransactionID, @oldCSSPMajor, @oldCSSPMinor, @oldCSSPTransId)
IF @oldCSRelease > 0 AND ((16 > @oldCSRelease) OR (@spComparison > 0) OR (@spComparison = 0 AND @ssipUpdatePackNum > @oldCSUpdatePackNum))  -- ServicePack upgrade
		BEGIN
			SET @isCSSPUpgrade = 1
		END
	END
	UPDATE simInstalledPackages
	SET OpTime = CASE WHEN @ssipOpTime <> 0 THEN @ssipOpTime ELSE OpTime END,
		OpType = CASE WHEN @ssipOpType <> '' THEN @ssipOpType ELSE OpType END,
		UserID = @ssipUserID,
		HighestSP = @ssipHighestSP,
		AdditionalPatches = @ssipAdditionalPatches,
		MissingPatches = @ssipMissingPatches,
		Node = @ssipNode,
		IsActive = @ssipIsActive,
		SpMinorVersion = @ssipSpMinorVersion,
		Baseline = @ssipBaseline,
		BaselineDeltaSP = @ssipBaselineDeltaSP,
		BaselineDeltaUpdate = @ssipBaselineDeltaUpdate,
		SPVersionID = @patchSPVersionId,
		UPNumber = @ssipUpdatePackNum
	WHERE ClientId = @ssipClientId AND simPackageID = @ssipPackageId
	-- Invalidate all RCs which did not have latest media
	IF @isCSSPUpgrade = 1
	BEGIN
		UPDATE PatchUpdateAgentInfo
		SET inSyncWithCS = 0, packageStatus = 0
		WHERE isDeleted = 0 AND clientId <> 2
			AND NOT EXISTS (SELECT * FROM PatchMultiCache M WITH(NOLOCK) JOIN PatchSPVersion P WITH(NOLOCK) ON M.SPVersionID = P.Id
WHERE P.Release = 16 AND M.ClientId = PatchUpdateAgentInfo.ClientId AND P.SPMajor = @ssipHighestSP AND P.SPMinor = @ssipSpMinorVersion AND P.TransactionId = @ssipTransactionID)
	END
END
ELSE IF (@ssipCreateIfNotExists & 1) > 0
BEGIN
	INSERT INTO simInstalledPackages(ClientId,simPackageID,OpTime,OpType,UserID,HighestSP,AdditionalPatches,MissingPatches,Node,IsActive,SpMinorVersion,Baseline,BaselineDeltaSP,BaselineDeltaUpdate,SPVersionID)
	VALUES(@ssipClientId, @ssipPackageID, @ssipOpTime, @ssipOpType, @ssipUserID, @ssipHighestSP, @ssipAdditionalPatches, @ssipMissingPatches, @ssipNode, @ssipIsActive, @ssipSpMinorVersion, @ssipBaseline, @ssipBaselineDeltaSP, @ssipBaselineDeltaUpdate, @patchSPVersionId)
END
IF (@ssipCreateIfNotExists & 2) > 0
	EXEC SetInstalledUpdateSummary @ssipClientId, @ssipPackageID, 'UpdateSync', @ssipHighestSP, @ssipUpdatePackNum, @ssipAdditionalPatches, @ssipMissingPatches
		END
	END
	-------------------------------------
	-- For Evaluation Extend license, extend the eval period by the eval days
IF (@i_flags & 0x10) = 0 OR @keyTypeInKey = 0x02
	BEGIN
		SET @newExpDate = @evalExpDate
		-------------------------------------
		-- ExtendAllEvalLicInstalls
		INSERT INTO @evalExpTimeLics
		SELECT t_licType, (CASE t_expTime WHEN 0 THEN @newExpDate ELSE t_expTime END)
		FROM @newLicTypesInKey
		WHERE t_evalQty <> 0 AND (t_expTime > 0 AND t_oldExpTime <> t_expTime OR @evalDaysInKey > 0 AND t_expTime = 0 AND t_oldExpTime > dbo.getUNIXTime('2000-01-01'))
		-------------------------------------
		-- ExtendAllEvalLicInstalls
		IF @evalDaysInKey > 0 OR EXISTS (SELECT * FROM @evalExpTimeLics)
		BEGIN
			DECLARE getEvalLicInstalls CURSOR FOR
				SELECT	id, licType, EncryptedField, dbo.getUnixTime(ExpiryDateUTC)
				FROM	LicUsage
WHERE	id > 0 AND eval > 0 AND OpType='Install' AND licType NOT IN (16777216, 50331648, 33554432) AND
						(@evalDaysInKey > 0 OR licType IN (SELECT t_licType FROM @evalExpTimeLics))
			OPEN getEvalLicInstalls
			FETCH NEXT FROM getEvalLicInstalls INTO @licUsageId, @licType, @licEncField, @LicExpTime
			WHILE @@FETCH_STATUS = 0
			BEGIN
				-------------------------------------
				-- Update EncryptedField
				SET @newExpDate = ISNULL((SELECT t_expTime FROM @evalExpTimeLics WHERE t_licType = @licType), @newExpDate)
IF @keyTypeInKey = 0x02
					SET @newExpDate = @LicExpTime + @evalDaysInKey * 24 * 60 * 60
				EXEC ExtendLicUsageExpDateManaged @licEncField, @newExpDate, @newlicEncField OUTPUT
				-------------------------------------
				-- Update licUsage
				UPDATE LicUsage
				SET	expiryDateUTC = dbo.GetDateTime(@newExpDate), EncryptedField = REPLACE(@newlicEncField, CHAR(0), '')
				WHERE	id = @licUsageId
				FETCH NEXT FROM getEvalLicInstalls INTO @licUsageId, @licType, @licEncField, @LicExpTime
			END
			CLOSE getEvalLicInstalls
			DEALLOCATE getEvalLicInstalls
		END
		IF @expDateInKey > 0
			SET @newExpDate = @expDateInKey
		ELSE
			SET @newExpDate = 0
		DECLARE getPermWithExpDateLicInstalls CURSOR FOR
			SELECT	id, EncryptedField
			FROM	LicUsage
WHERE	id > 0 AND OpType='Install' AND licType NOT IN (16777216, 50331648, 33554432) AND eval = 0 AND (dbo.GetUNIXTime(expiryDateUTC) > 0 OR @expDateInKey > 0)
		OPEN getPermWithExpDateLicInstalls
		FETCH NEXT FROM getPermWithExpDateLicInstalls INTO @licUsageId, @licEncField
		WHILE @@FETCH_STATUS = 0
		BEGIN
			-------------------------------------
			-- Update EncryptedField
			EXEC ExtendLicUsageExpDateManaged @licEncField, @newExpDate, @newlicEncField OUTPUT
			-------------------------------------
			-- Update licUsage
			UPDATE LicUsage
			SET	expiryDateUTC = dbo.GetDateTime(@newExpDate), EncryptedField = REPLACE(@newlicEncField, CHAR(0), '')
			WHERE	id = @licUsageId
			FETCH NEXT FROM getPermWithExpDateLicInstalls INTO @licUsageId, @licEncField
		END
		CLOSE getPermWithExpDateLicInstalls
		DEALLOCATE getPermWithExpDateLicInstalls
		-------------------------------------
		-- CONFIGURE CELL LEVEL LICENSES
		-- UpdateLicUsageForUsageBasedLicenses: insert licUsage table
		DECLARE getCCLicList CURSOR FOR SELECT t_licType FROM @CCLicTypesToConfig
		OPEN getCCLicList
		FETCH NEXT FROM getCCLicList INTO @licType
		WHILE @@FETCH_STATUS = 0
		BEGIN
			IF @licType IN ( 100002, 100004, 100005, 100006)
			BEGIN
				DECLARE @nAppType INT
				SET @nAppType = ISNULL((SELECT appTypeId FROM simAppTypeLicTypeMap WHERE simLicAppType = @licType), 0)
				EXEC LicenseIncrement @CSClientID, @licType, @nAppType, 1, @i_flags, 0, @CCLicError OUTPUT
			END
			ELSE
				EXEC LicUpdateCCLevelLicense @licType, 1, @i_flags, @CCLicError OUTPUT
			IF LEN(@CCLicError) > 0
			BEGIN
				SELECT	@o_errorStr = 'A Commcell level license [' + cast(@licType as varchar(64)) + '] configure failed: ' + @CCLicError, @o_errorCode = @o_errorCode + 1
				BREAK
			END
			FETCH NEXT FROM getCCLicList INTO @licType
		END
		CLOSE getCCLicList
		DEALLOCATE getCCLicList
		IF @o_errorCode > 0
		BEGIN
SET @o_errorCode = (392 | (CAST(POWER(2, 24) AS BIGINT) * 1))
			SET @o_errorStr = dbo.SubsArgs1(@i_localeId,@o_ErrorCode,cast(@licType as varchar(64)))
			goto SP_EXIT
		END
	END
	-------------------------------------
	-- For Migration: When installing a new perm commserver or converting eval CS to perm, add entry in GXCounter table
	-- updateCounterTblForMigration
	IF (@EncLicKeyInDB IS NULL OR @isCSEvalInDB > 0) AND @isCSEvalInKey = 0
	BEGIN
		IF NOT EXISTS (SELECT * FROM GxCounter WHERE name = 'startMigAFile')
		BEGIN
			DECLARE @nArchFileID INT
			SET @nArchFileID = ISNULL((SELECT MAX(id) FROM ArchFile), 0)
			INSERT INTO GxCounter VALUES ('startMigAFile', @nArchFileID, @nArchFileID)
		END
	END
	-------------------------------------
	-- OEM ID UPDATE: SetDefOEMProps
IF @EncLicKeyInDB IS NULL OR LEN(@EncLicKeyInDB) = 0 OR (@OEMIdInKey <> @OEMIdInDB AND (@i_flags & 0x20) > 0)
	BEGIN
		DECLARE @oemUpdateFlag INT
		IF @EncLicKeyInDB IS NULL OR @ccIdInDB = -1
			SET @oemUpdateFlag = 2
		ELSE
			SET @oemUpdateFlag = 1
		EXEC LicUpdateOEMProps @OEMIdInKey, @csIdInKey, @csidEncStr, @i_CSHostName, @licUpdateTime, @oemUpdateFlag
	END
	-------------------------------------
	-- If there is a valid dr machine id, then update the DR ip address
IF (@i_flags & 0x8) = 0
	BEGIN
		UPDATE	APP_CommCell
		SET	DRIPAddress = dbo.GetIPAddressString(@DRMachIDInKey), ccOpMode = @ccOpMode
		WHERE	ID = @CommcellID AND DRIPAddress <> dbo.GetIPAddressString(@DRMachIDInKey)
	END
	ELSE
	BEGIN
		UPDATE	APP_CommCell
		SET	number = @csId
		WHERE	ID = @CommcellID AND number < 0
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @o_errorCode = ERROR_NUMBER()
	SET @o_errorStr = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' + 'Error Message [' +ERROR_MESSAGE() + '].'
END CATCH
IF LEN(@licnotapplicable) > 0
BEGIN
	IF EXISTS (SELECT 1 FROM LicUsageBasedConfig WITH (NOLOCK) WHERE attrname = 'LicNotApplied')
	DELETE FROM LicUsageBasedConfig WHERE attrname = 'LicNotApplied'
	INSERT INTO LicUsageBasedConfig
	SELECT 'LicNotApplied', 1, @licnotapplicable
END
SP_EXIT:
	IF @o_errorCode = 0
	BEGIN
		SET @o_errorStr = ''
		COMMIT TRANSACTION
	END
	ELSE
		ROLLBACK TRANSACTION
	SELECT @o_errorCode, (CASE WHEN @relnumInDB >= @relnumInKey THEN 0 ELSE 1 END), @o_errorStr
SET NOCOUNT OFF
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'LicenseActivation')
	delete from GxQscripts where name = 'LicenseActivation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LicenseActivation')
	delete from GXDBVersions where aliasname = 'LicenseActivation'
GO

insert into GXDBVersions values(2, 'LicenseActivation',  '00010099000200480000', 'LicenseActivation', '00010099000200480000')
GO

