

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/Lic_Peak_LicenseUsage.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/Lic_Peak_LicenseUsage.sp,v $ $Id: Lic_Peak_LicenseUsage.sp,v 1.1.2.11 2020/01/05 03:52:38 bheemesh Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='Lic_Peak_LicenseUsage')
BEGIN
	print '>>> Drop Stored Procedure: Lic_Peak_LicenseUsage <<<'
	drop procedure Lic_Peak_LicenseUsage
END
IF EXISTS (select * from GxQscripts where name='Lic_Peak_LicenseUsage')
	delete from GxQscripts where name = 'Lic_Peak_LicenseUsage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='Lic_Peak_LicenseUsage')
	delete from GXDBVersions where aliasname = 'Lic_Peak_LicenseUsage'
GO
print '... Creating Procedure: Lic_Peak_LicenseUsage'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure Lic_Peak_LicenseUsage
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @i_CommServUniqueId INT = 0, 
  @i_Option INT = -1,
  @i_RptType INT = -1,
  @i_NoOfMonths INT = 12,
  @i_MonthString VARCHAR(20) = ''
AS
SET NOCOUNT ON
----This stored procedure has the various queries to be used by V3 License Peak Report & Subclient Peak Report on cloud (introduced in SP14)----
--@i_Option=0 to 3 - history of CCL/SCL backup, archive, snap, replicate
--@i_Option=4 to 7 - history of CCL/SCL protectedVM, vmOnly, ACV, vmWithApp
--@i_Option=8 to 16 - history of CCL/SCL VM Socket, archived VM, endpoint users, sharing users, ediscovery users, app users, FSonlyServer, DLO, AppServer
--@i_Option=17 to 23 - 17-CCL/SCL capacity license details, 18-CCL/SCL VSA jobs excluded from capacity, 19-CCL/SCL app user jobs excluded from capacity, 20-CCL/SCL ACV jobs excluded from capacity, 21-CCL/SCL DLP jobs excluded from capacity, 22-CCL/SCL EdgeDrive jobs excluded from capacity, 23-CCL/SCL ArchivedVM jobs excluded from capacity
--@i_Option=24 to 27 - details of CCL/SCL protected vm, vm only, acv, vm with app
--@i_Option=28 - CCL/SCL vm socket details
--@i_Option=29 - CCL/SCL archived vm details
--@i_Option=30 to 32 - details of CCL/SCL endpoint users, sharing users and ediscovery users
--@i_Option=33 - CCL/SCL app user details
--@i_Option=34 to 36 - CCL/SCL FSO, DLO & AppServer with Usages
--@i_Option=37 to 39 - CCL/SCL FSO, DLO & AppServer without Usages
----get misc details
--@i_Option=40 - get list of past N months for peak usages
--@i_Option=41 - get current usage summary
----new licenses
--@i_Option=42 - history of CCL/SCL commvault complete
--@i_Option=43 - history of CCL/SCL VMLiveSync
--@i_Option=44 - File system only summary
--@i_Option=45 - Live sync for VM details
--@i_Option=46 - history of CCL/SCL FSonlyVM
--@i_Option=47 to 48 - history of CCL/SCL OI, VOI
--@i_Option=49 to 50 - OI/VOI details
--@i_Option=51 to 52 - CCL/SCL OI/VOI jobs excluded from capacity
----common variables and computations - start----
DECLARE @i_QueryId_CCLSummary INT = 234 --CCL Summary
DECLARE @i_QueryId_SCLSummary INT = 235 --SCL Summary
DECLARE @i_QueryId_CCLUsage INT = 237 --CCL Usage
DECLARE @i_QueryId_SCLUsage INT = 238 --SCL Usage
DECLARE @usageType INT = -1
DECLARE @capacityFlag INT = -1
DECLARE @licType INT = -1
DECLARE @vmFlag1 INT = -1
DECLARE @vmFlag2 INT = -1
DECLARE @queryId INT = -1
DECLARE @peakType INT = @i_RptType
--past N months to be used by options that display peak graphs
IF (@i_Option BETWEEN 0 AND 16) OR (@i_Option IN (42,43)) OR (@i_Option BETWEEN 46 AND 48)
BEGIN
	DECLARE @monthStart DATETIME = GETDATE()
    DECLARE @monthTable TABLE (MonthStart DATETIME)
    DECLARE @cnt INT = @i_NoOfMonths
    WHILE @cnt > 0
    BEGIN
        INSERT @monthTable
        SELECT DATEADD(month, DATEDIFF(month, 0, @monthStart), 0)
        SET @monthStart=DATEADD(month, -1, @monthStart)
        SET @cnt=@cnt-1
    END
END
--month to be used by monthly peak details
IF (@i_Option BETWEEN 17 AND 39) OR (@i_Option IN (44,45)) OR (@i_Option BETWEEN 49 AND 52)
BEGIN
	DECLARE @month DATETIME = NULL
	SET @month=CONVERT(DATE,@i_MonthString)
	IF @month=NULL OR @month > GETDATE()
	BEGIN
		SET @month=DATEADD(DAY,-DAY(GETDATE())+1, CAST(GETDATE() AS DATE))
	END
END
--find if commvault complete is purchased or not
DECLARE @commvaultComplete INT = 0
IF EXISTS (SELECT 1 FROM Lic_LicenseInfo WITH(NOLOCK) WHERE lictype=205 AND CommServUniqueId=@i_CommServUniqueId) AND EXISTS (SELECT 1 FROM Lic_LicenseInfo LiB INNER JOIN Lic_LicenseInfo LiA ON LiA.LicType=100004 AND LiB.PermTotal=LiA.PermTotal AND LiB.EvalTotal=LiA.EvalTotal AND LiB.TermDate=LiA.TermDate AND LiA.CommServUniqueId=@i_CommServUniqueId WHERE LiB.LicType=100002 AND LiB.CommServUniqueId=@i_CommServUniqueId)
BEGIN
	SET @commvaultComplete=1
END
--find if activity is enabled
DECLARE @isActivityEnabled INT = 0
SELECT @isActivityEnabled=CASE WHEN (C.CommCellSurveyServices & 4)=4 THEN 1 ELSE 0 END FROM cf_CommcellIdNameMap C WITH (NOLOCK) WHERE C.ID=@i_CommServUniqueId
--if activity is not enabled, always return empty resultset when displaying details
IF (@i_Option BETWEEN 17 AND 39) OR (@i_Option=45) OR (@i_Option BETWEEN 49 AND 52)
BEGIN
	IF @isActivityEnabled=0
		GOTO LIC_ERROR
END
IF (@i_Option BETWEEN 17 AND 23) OR (@i_Option IN (51,52)) OR (@i_Option BETWEEN 34 AND 36)
BEGIN
	IF object_id('tempdb.dbo.#NoNeedBackupSet') IS NOT NULL DROP TABLE #NoNeedBackupSet
	CREATE TABLE #NoNeedBackupSet (apptype INT)
	INSERT INTO #NoNeedBackupSet VALUES
	(6),(32),(15),(9),(24),(25),(27),(31),(40),(2),(22),(23),(5),(48),(51),(47),(59),(67),(68),(65),(76),(75),(77),(80),(104),(4),(16),(70),(81),(61),(79),(53),(600),(601),(602),(604),(605),(606),(607),(128)
	IF object_id('tempdb.dbo.#NeedInstance') IS NOT NULL DROP TABLE #NeedInstance
	CREATE TABLE #NeedInstance (apptype INT)
	INSERT INTO #NeedInstance VALUES
	(3),(4),(16),(6),(7),(5),(126), (51),(52), (9),(8),(15),(14),(45), (2),(22),(23), (27),(31), (32),(35), (44), (37), (106), (54), (53), (55), (56),(60), (59), (57), (62), (67),(68),(69), (70),(77),(82),(80),(81),(90),(103),(104),(125),(58), (124), (131), (128),(79), (61), (134), (64), (135)
END
----common variables and computations - end----
IF @i_Option BETWEEN 0 AND 3 --history of CCL/SCL backup, archive, snap, replicate
BEGIN
	IF @i_Option=0 SET @usageType=1
	ELSE IF @i_Option=1 SET @usageType=2
	ELSE IF @i_Option=2 SET @usageType=3
	ELSE IF @i_Option=3 SET @usageType=4
	IF @peakType=0 SET @queryId=@i_QueryId_CCLSummary ELSE SET @queryId=@i_QueryId_SCLSummary
	IF object_id('tempdb.dbo.#H') IS NOT NULL DROP TABLE #H
	CREATE TABLE #H(MonthStart DATETIME, Usage DECIMAL(18,3))
	INSERT #H
	SELECT MonthStart, CAST(SUM(Usage)*1.0/1024/1024 AS DECIMAL(18,3)) AS Usage
	FROM Lic_PeakSummary P WITH(NOLOCK)
	INNER JOIN cf_SurveyResultFuncV1(@queryId, @i_CommServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON P.CommServUniqueId=SR.CommServUniqueId
	WHERE UsageType=@usageType AND CapacityFlag=0 AND PeakType=@peakType
	GROUP BY MonthStart
	SELECT M.MonthStart AS Month, ISNULL(Usage,0) AS Usage
	FROM @monthTable M
	LEFT JOIN #H H ON H.MonthStart=M.MonthStart
	IF object_id('tempdb.dbo.#H') IS NOT NULL DROP TABLE #H
END
ELSE IF @i_Option BETWEEN 4 AND 7--history of CCL/SCL protectedVM, vmOnly, ACV, vmWithApp
BEGIN
	IF @i_Option=4 BEGIN SET @vmFlag1=2 SET @vmFlag2=3 END
	ELSE IF @i_Option=5 BEGIN SET @vmFlag1=2 SET @vmFlag2=2 END
	ELSE IF @i_Option=6 BEGIN SET @vmFlag1=3 SET @vmFlag2=4 END
	ELSE IF @i_Option=7 BEGIN SET @vmFlag1=3 SET @vmFlag2=3 END
	IF @peakType=0 SET @queryId=@i_QueryId_CCLSummary ELSE SET @queryId=@i_QueryId_SCLSummary
	IF object_id('tempdb.dbo.#H1') IS NOT NULL DROP TABLE #H1
	CREATE TABLE #H1(MonthStart DATETIME, Usage BIGINT)
	INSERT #H1
	SELECT MonthStart, SUM(Usage) AS Usage
	FROM Lic_PeakSummary P WITH(NOLOCK)
	INNER JOIN cf_SurveyResultFuncV1(@queryId, @i_CommServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON P.CommServUniqueId=SR.CommServUniqueId
	WHERE UsageType=19 AND VMFlag IN (@vmFlag1,@vmFlag2) AND PeakType=@peakType
	GROUP BY MonthStart
	SELECT M.MonthStart AS Month, ISNULL(Usage,0) AS Usage
	FROM @monthTable M
	LEFT JOIN #H1 H ON H.MonthStart=M.MonthStart
	IF object_id('tempdb.dbo.#H1') IS NOT NULL DROP TABLE #H1
END
ELSE IF (@i_Option BETWEEN 8 AND 16) OR (@i_Option IN (43,46,47,48))--history of CCL/SCL VM Socket, archived VM, endpoint users, sharing users, ediscovery users, application user, FSonlyServer, FSonlyVM, DLO, AppServer, VMLiveSync, OI, VOI
BEGIN
	IF @i_Option=8 SET @usageType=20
	ELSE IF @i_Option=9 SET @usageType=21
	ELSE IF @i_Option=10 SET @usageType=22
	ELSE IF @i_Option=11 SET @usageType=23
	ELSE IF @i_Option=12 SET @usageType=24
	ELSE IF @i_Option=13 SET @usageType=18
	ELSE IF @i_Option=14 BEGIN SET @usageType=29 SET @licType=100029 END
	ELSE IF @i_Option=15 SET @usageType=28
	ELSE IF @i_Option=16 SET @usageType=27
	ELSE IF @i_Option=43 SET @usageType=26
	ELSE IF @i_Option=46 BEGIN SET @usageType=29 SET @licType=200017 END
	ELSE IF @i_Option=47 SET @usageType=30
	ELSE IF @i_Option=48 SET @usageType=31
	IF @peakType=0 SET @queryId=@i_QueryId_CCLSummary ELSE SET @queryId=@i_QueryId_SCLSummary
	IF object_id('tempdb.dbo.#H2') IS NOT NULL DROP TABLE #H2
	CREATE TABLE #H2(MonthStart DATETIME, Usage BIGINT)
	IF @i_Option NOT IN (14,46)
	BEGIN
		INSERT #H2
		SELECT MonthStart, SUM(Usage) AS Usage
		FROM Lic_PeakSummary P WITH(NOLOCK)
		INNER JOIN cf_SurveyResultFuncV1(@queryId, @i_CommServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON P.CommServUniqueId=SR.CommServUniqueId
		WHERE UsageType=@usageType AND PeakType=@peakType
		GROUP BY MonthStart
	END
	ELSE
	BEGIN
		INSERT #H2
		SELECT MonthStart, SUM(Usage) AS Usage
		FROM Lic_PeakSummary P WITH(NOLOCK)
		INNER JOIN cf_SurveyResultFuncV1(@queryId, @i_CommServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON P.CommServUniqueId=SR.CommServUniqueId
		WHERE UsageType=@usageType AND LicType=@licType AND PeakType=@peakType
		GROUP BY MonthStart
	END
	SELECT M.MonthStart AS Month, ISNULL(Usage,0) AS Usage
	FROM @monthTable M
	LEFT JOIN #H2 H ON H.MonthStart=M.MonthStart
	IF object_id('tempdb.dbo.#H2') IS NOT NULL DROP TABLE #H2
END
ELSE IF (@i_Option BETWEEN 17 AND 23) OR (@i_Option IN (51,52))--17-CCL/SCL capacity license details, 18-CCL/SCL VSA jobs excluded from capacity, 19-CCL/SCL app user jobs excluded from capacity, 20-CCL/SCL ACV jobs excluded from capacity, 21-CCL/SCL DLP jobs excluded from capacity, 22-CCL/SCL EdgeDrive jobs excluded from capacity, 23-CCL/SCL ArchivedVM jobs excluded from capacity, 51-CCL/SCL OI jobs excluded from capacity, 52-CCL/SCL VOI jobs excluded from capacity
BEGIN
	IF @i_Option=17 SET @capacityFlag=0
	ELSE IF @i_Option=18 SET @capacityFlag=1
	ELSE IF @i_Option=19 SET @capacityFlag=2
	ELSE IF @i_Option=20 SET @capacityFlag=4
	ELSE IF @i_Option=21 SET @capacityFlag=16
	ELSE IF @i_Option=22 SET @capacityFlag=8
	ELSE IF @i_Option=23 SET @capacityFlag=32
	ELSE IF @i_Option=51 SET @capacityFlag=64
	ELSE IF @i_Option=52 SET @capacityFlag=128
	IF @peakType=0 SET @queryId=@i_QueryId_CCLUsage ELSE SET @queryId=@i_QueryId_SCLUsage
	IF object_id('tempdb.dbo.#CP1') IS NOT NULL DROP TABLE #CP1
	CREATE TABLE #CP1(JobType VARCHAR(25), ClientId INT, ClientName NVARCHAR(255), SubclientId INT, SubclientName NVARCHAR(128), LicType INT, LicName NVARCHAR(256),
		AppTypeId INT, AppTypeName VARCHAR(256), BackupSetId INT, BackupSetName NVARCHAR(128), InstanceId INT, InstanceName NVARCHAR(512), SPId INT, SPName NVARCHAR(144),
		JobId INT, AppSizeMB BIGINT, OrgGUID VARCHAR(40), Organization NVARCHAR(1024), PlanName NVARCHAR(1024))
	INSERT #CP1
	SELECT DISTINCT CASE WHEN UsageType=1 THEN 'Backup' WHEN UsageType=2 THEN 'Archive' WHEN UsageType=3 THEN 'Snapshot' ELSE 'Replication' END AS JobType,
	ISNULL(P.ClientId,0) AS ClientId, ISNULL(CL.ClientName,'N/A') AS ClientName, ISNULL(P.SubclientId,0) AS SubclientId, ISNULL(SCL.SubclientName,'N/A') AS SubclientName,
	ISNULL(LicType,0) AS LicType, ISNULL(L.name,'N/A') AS LicName, ISNULL(SCL.AppTypeId,0) AS AppTypeId, ISNULL(SCL.AgentName,'N/A') AS AppTypeName,
	ISNULL(SCL.BackupSetId,0) AS BackupSetId, ISNULL(SCL.BackupSetName,'N/A') AS BackupSetName, ISNULL(SCL.InstanceId,0) AS InstanceId, ISNULL(SCL.InstanceName,'N/A') AS InstanceName, ISNULL(SP.PolicyId,0) AS SPId, ISNULL(SP.PolicyName,'N/A') AS SPName,
	ISNULL(JobId,0) AS JobId, ISNULL(AppSizeMB,0) AS AppSizeMB, ISNULL(CONVERT(VARCHAR(40),OrgGUID),'N/A') AS OrgGUID, ISNULL(T.TenantName,'N/A') AS Organization, ISNULL(PlanName,'N/A') AS PlanName
	FROM Lic_PeakUsage P WITH(NOLOCK)
	INNER JOIN cf_SurveyResultFuncV1(@queryId, @i_CommServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON P.CommServUniqueId=SR.CommServUniqueId
	LEFT JOIN cf_SurveyLicType L WITH(NOLOCK) ON L.id = P.LicType
	LEFT JOIN cf_SurveyClient CL WITH(NOLOCK) ON CL.ClientId=P.ClientId AND CL.CommServUniqueId=@i_CommServUniqueId
	LEFT JOIN cf_SurveySubclientAssociation SCL WITH(NOLOCK) ON SCL.ClientId=P.ClientId AND SCL.AppId=P.SubclientId AND SCL.CommServUniqueId=@i_CommServUniqueId
	LEFT JOIN cf_SurveyCopyBasicRetention SP WITH(NOLOCK) ON SP.PolicyId=SCL.DataPolicyId AND SP.CommServUniqueId=@i_CommServUniqueId
	LEFT JOIN cf_SurveyTenants T WITH(NOLOCK) ON T.TenantGUID=P.OrgGUID AND T.CommServUniqueId=@i_CommServUniqueId
	WHERE UsageType IN (1,2,3,4) AND CapacityFlag=@capacityFlag AND PeakType=@peakType AND MonthStart=@month
	UPDATE #CP1
	SET BackupsetName = 'N/A'
	WHERE AppTypeId IN (SELECT apptype FROM #NoNeedBackupSet)
	UPDATE #CP1
	SET InstanceName = 'N/A'
	WHERE AppTypeId NOT IN (SELECT apptype FROM #NeedInstance)
	SELECT JobType, ClientId, ClientName, SubclientId, SubclientName, LicType, LicName, AppTypeId, AppTypeName, BackupSetId, BackupSetName,
	InstanceId, InstanceName, SPId, SPName, JobId, AppSizeMB, OrgGUID, Organization, PlanName
	FROM #CP1
	IF object_id('tempdb.dbo.#CP1') IS NOT NULL DROP TABLE #CP1
	IF object_id('tempdb.dbo.#NoNeedBackupSet') IS NOT NULL DROP TABLE #NoNeedBackupSet
	IF object_id('tempdb.dbo.#NeedInstance') IS NOT NULL DROP TABLE #NeedInstance
	IF @i_Option<>17 AND @i_Option<>18 AND @i_Option<>23
	BEGIN
		SELECT CASE WHEN UsageType=1 THEN 'Backup' WHEN UsageType=2 THEN 'Archive' WHEN UsageType=3 THEN 'Snapshot' ELSE 'Replication' END AS JobType,
		ISNULL(ClientId,0) AS ClientId, ISNULL(ClientName,'N/A') AS ClientName, ISNULL(SubclientId,0) AS SubclientId, ISNULL(SubclientName,'N/A') AS SubclientName,
		ISNULL(LicType,0) AS LicType, ISNULL(L.name,'N/A') AS LicName, ISNULL(AppTypeId,0) AS AppTypeId, ISNULL(A.name,'N/A') AS AppTypeName,
		ISNULL(BackupSetId,0) AS BackupSetId, ISNULL(BackupSetName,'N/A') AS BackupSetName, ISNULL(InstanceId,0) AS InstanceId, ISNULL(InstanceName,'N/A') AS InstanceName, ISNULL(SPId,0) AS SPId, ISNULL(SPName,'N/A') AS SPName,
		ISNULL(JobId,0) AS JobId, ISNULL(AppSizeMB,0) AS AppSizeMB, ISNULL(CONVERT(VARCHAR(40),OrgGUID),'N/A') AS OrgGUID, ISNULL(Organization,'N/A') AS Organization, ISNULL(PlanName,'N/A') AS PlanName
		FROM Lic_PeakUsage P WITH(NOLOCK)
		INNER JOIN cf_SurveyResultFuncV1(@queryId, @i_CommServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON P.CommServUniqueId=SR.CommServUniqueId
		LEFT JOIN cf_SurveyLicType L WITH(NOLOCK) ON L.id = P.LicType
		LEFT JOIN cf_SurveyAgentType A WITH(NOLOCK) ON A.id = P.AppTypeId AND A.id > 0
		WHERE UsageType IN (1,2,3,4) AND CapacityFlag=@capacityFlag AND PeakType=@peakType AND MonthStart=@month
	END
	ELSE
	BEGIN
		IF object_id('tempdb.dbo.#VSAJobs') IS NOT NULL DROP TABLE #VSAJobs
        CREATE TABLE #VSAJobs(ParentId INT, ParentName NVARCHAR(255), VMId INT, VMName NVARCHAR(255), ParentJobId INT, ChildJobid INT, JobTypeName VARCHAR(15), SubclientId INT, AppSizeMB BIGINT, Organization NVARCHAR(1024), OrgGUID UNIQUEIDENTIFIER, PlanName NVARCHAR(1024), SubclientName NVARCHAR(255), BackupsetId INT, BackupSetName NVARCHAR(1024), InstanceId INT, InstanceName NVARCHAR(1024), SPId INT, SPName NVARCHAR(1024))
		INSERT #VSAJobs
		SELECT DISTINCT ISNULL(ClientId,-1), ISNULL(ClientName,'N/A'), ISNULL(ClientId,-1), ISNULL(ClientName,'N/A'), ISNULL(JobId,-1), ISNULL(JobId,-1),
		CASE WHEN U1.UsageType=1 THEN 'Backup' WHEN U1.UsageType=2 THEN 'Archive' WHEN U1.UsageType=3 THEN 'Snapshot' WHEN U1.UsageType=4 THEN 'Replication' END,
		ISNULL(SubclientId,-1), ISNULL(AppSizeMB,0), ISNULL(Organization,'N/A'), OrgGUID, ISNULL(PlanName,'N/A'), 'N/A', 0, 'N/A', 0, 'N/A', 0, 'N/A'
		FROM Lic_PeakUsage U1 WITH (NOLOCK)
		INNER JOIN cf_SurveyResultFuncV1(@queryId, @i_CommServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON U1.CommServUniqueId=SR.CommServUniqueId
		WHERE UsageType IN (1,2,3,4) AND CapacityFlag=@capacityFlag AND U1.AppTypeId=106
		AND U1.PeakType=@peakType AND U1.MonthStart=@month
		UPDATE U1
		SET U1.ParentId=ISNULL(U19.ClientId,-1), U1.ParentName=ISNULL(CL.ClientName,'N/A'), U1.ParentJobId=ISNULL(U19.CapacityFlag,-1), U1.SubclientId=ISNULL(U19.SubclientId,-1)
		FROM #VSAJobs U1
		LEFT JOIN Lic_PeakUsage U19 WITH (NOLOCK) ON U19.JobId=U1.ChildJobid
		INNER JOIN cf_SurveyResultFuncV1(@queryId, @i_CommServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON U19.CommServUniqueId=SR.CommServUniqueId
		LEFT JOIN cf_SurveyClient CL WITH(NOLOCK) ON CL.ClientId=U19.ClientId AND CL.CommServUniqueId=@i_CommServUniqueId
		WHERE ((U19.UsageType IN (19,21) AND @capacityFlag=0) OR (U19.UsageType IN (19) AND @capacityFlag=1) OR (U19.UsageType IN (21) AND @capacityFlag=32))
		AND U19.PeakType=@peakType AND U19.MonthStart=@month
		UPDATE U1
		SET U1.SubclientName=ISNULL(SCL.SubclientName,'N/A'), U1.BackupsetId=ISNULL(SCL.BackupsetId,-1), U1.BackupSetName=ISNULL(SCL.BackupsetName,'N/A'), U1.InstanceId=ISNULL(SCL.InstanceId,-1), U1.InstanceName=ISNULL(SCL.InstanceName,'N/A'), U1.SPId=ISNULL(SP.PolicyId,-1), U1.SPName=ISNULL(SP.PolicyName,'N/A')
		FROM #VSAJobs U1
		LEFT JOIN cf_SurveySubclientAssociation SCL WITH(NOLOCK) ON SCL.ClientId=U1.ParentId AND SCL.AppId=U1.SubclientId AND SCL.CommServUniqueId=@i_CommServUniqueId
		LEFT JOIN cf_SurveyCopyBasicRetention SP WITH(NOLOCK) ON SP.PolicyId=SCL.DataPolicyId AND SP.CommServUniqueId=@i_CommServUniqueId
		SELECT JobTypeName AS JobType, VMId AS ClientId, VMName AS ClientName, SubclientId, SubclientName,
		143 AS LicType, 'Virtual Server' AS LicName, 106 AS AppTypeId, 'Virtual Server' AS AppTypeName,
		BackupsetId, BackupSetName, InstanceId, InstanceName, SPId, SPName,
		ChildJobId AS JobId, ISNULL(AppSizeMB,0) AS AppSizeMB, ISNULL(CONVERT(VARCHAR(40),OrgGUID),'N/A') AS OrgGUID, Organization, PlanName,
		ParentId AS "Virtualization Client ID", ParentName AS "Virtualization Client", ParentJobId AS "Parent Job ID"
		FROM #VSAJobs
		UNION
		SELECT CASE WHEN UsageType=1 THEN 'Backup' WHEN UsageType=2 THEN 'Archive' WHEN UsageType=3 THEN 'Snapshot' ELSE 'Replication' END AS JobType,
		ISNULL(ClientId,0) AS ClientId, ISNULL(ClientName,'N/A') AS ClientName, ISNULL(SubclientId,0) AS SubclientId, ISNULL(SubclientName,'N/A') AS SubclientName,
		ISNULL(LicType,0) AS LicType, ISNULL(L.name,'N/A') AS LicName, ISNULL(AppTypeId,0) AS AppTypeId, ISNULL(A.name,'N/A') AS AppTypeName,
		ISNULL(BackupSetId,0) AS BackupSetId, ISNULL(BackupSetName,'N/A') AS BackupSetName, ISNULL(InstanceId,0) AS InstanceId, ISNULL(InstanceName,'N/A') AS InstanceName, ISNULL(SPId,0) AS SPId, ISNULL(SPName,'N/A') AS SPName,
		ISNULL(JobId,0) AS JobId, ISNULL(AppSizeMB,0) AS AppSizeMB, ISNULL(CONVERT(VARCHAR(40),OrgGUID),'N/A') AS OrgGUID, ISNULL(Organization,'N/A') AS Organization, ISNULL(PlanName,'N/A') AS PlanName
		, 0, 'N/A', 0
		FROM Lic_PeakUsage C WITH(NOLOCK)
		INNER JOIN cf_SurveyResultFuncV1(@queryId, @i_CommServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON C.CommServUniqueId=SR.CommServUniqueId
		LEFT JOIN cf_SurveyLicType L WITH(NOLOCK) ON L.id = C.LicType
		LEFT JOIN cf_SurveyAgentType A WITH(NOLOCK) ON A.id = C.AppTypeId AND A.id > 0
		WHERE (UsageType IN (1,2,3,4) AND CapacityFlag=@capacityFlag AND C.AppTypeId<>106 AND PeakType=@peakType AND MonthStart=@month)
		IF object_id('tempdb.dbo.#VSAJobs') IS NOT NULL DROP TABLE #VSAJobs
	END
END
ELSE IF @i_Option BETWEEN 24 AND 27--details of CCL/SCL protected vm, vm only, acv, vm with app
BEGIN
	IF @i_Option=24 BEGIN SET @vmFlag1=2 SET @vmFlag2=3 END
	ELSE IF @i_Option=25 BEGIN SET @vmFlag1=2 SET @vmFlag2=2 END
	ELSE IF @i_Option=26 BEGIN SET @vmFlag1=3 SET @vmFlag2=4 END
	ELSE IF @i_Option=27 BEGIN SET @vmFlag1=3 SET @vmFlag2=3 END
	IF @peakType=0 SET @queryId=@i_QueryId_CCLUsage ELSE SET @queryId=@i_QueryId_SCLUsage
	SELECT DISTINCT ISNULL(ObjectId,0) AS VMId, ISNULL(CL.ClientName,'N/A') AS VMName, ISNULL(A.name,'N/A') AS Package, CASE WHEN VMFlag IN (2,3) THEN 'Yes' ELSE 'No' END AS IsVMProtected,
	ISNULL(JobId,0) AS VMProtectionJob, ISNULL(AppSizeMB,0) AS ProtectedVMSize,
	ISNULL(CONVERT(VARCHAR(40),OrgGUID),'N/A') AS OrgGUID, ISNULL(T.TenantName,'N/A') AS Organization, ISNULL(PlanName,'N/A') AS PlanName
	FROM Lic_PeakUsage P WITH(NOLOCK)
	INNER JOIN cf_SurveyResultFuncV1(@queryId, @i_CommServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON P.CommServUniqueId=SR.CommServUniqueId
	LEFT JOIN cf_SurveyAgentType A WITH(NOLOCK) ON A.id = P.AppTypeId AND A.id > 0
	LEFT JOIN cf_SurveyClient CL WITH(NOLOCK) ON CL.ClientId=P.ObjectId AND CL.CommServUniqueId=@i_CommServUniqueId
	LEFT JOIN cf_SurveyTenants T WITH(NOLOCK) ON T.TenantGUID=P.OrgGUID AND T.CommServUniqueId=@i_CommServUniqueId
	WHERE UsageType=19 AND VMFlag IN (@vmFlag1,@vmFlag2) AND PeakType=@peakType AND MonthStart=@month
END
ELSE IF @i_Option=28--CCL/SCL vm socket details
BEGIN
	IF @peakType=0 SET @queryId=@i_QueryId_CCLUsage ELSE SET @queryId=@i_QueryId_SCLUsage
	SELECT DISTINCT ISNULL(ObjectName,'N/A') AS HypervisorHost, ISNULL(AppSizeMB,0) AS Sockets,
	ISNULL(CONVERT(VARCHAR(40),OrgGUID),'N/A') AS OrgGUID, ISNULL(T.TenantName,'N/A') AS Organization, ISNULL(PlanName,'N/A') AS PlanName
	FROM Lic_PeakUsage P WITH(NOLOCK)
	INNER JOIN cf_SurveyResultFuncV1(@queryId, @i_CommServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON P.CommServUniqueId=SR.CommServUniqueId
	LEFT JOIN cf_SurveyTenants T WITH(NOLOCK) ON T.TenantGUID=P.OrgGUID AND T.CommServUniqueId=@i_CommServUniqueId
	WHERE UsageType=20 AND PeakType=@peakType AND MonthStart=@month
END
ELSE IF @i_Option=29--CCL/SCL archived vm details
BEGIN
	IF @peakType=0 SET @queryId=@i_QueryId_CCLUsage ELSE SET @queryId=@i_QueryId_SCLUsage
	SELECT DISTINCT ISNULL(ObjectId,0) AS VMId, ISNULL(CL.ClientName,'N/A') AS VMName, ISNULL(JobId,0) AS VMArchiveJob, ISNULL(AppSizeMB,0) AS ArchivedVMSize,
	ISNULL(CONVERT(VARCHAR(40),OrgGUID),'N/A') AS OrgGUID, ISNULL(T.TenantName,'N/A') AS Organization, ISNULL(PlanName,'N/A') AS PlanName
	FROM Lic_PeakUsage P WITH(NOLOCK)
	INNER JOIN cf_SurveyResultFuncV1(@queryId, @i_CommServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON P.CommServUniqueId=SR.CommServUniqueId
	LEFT JOIN cf_SurveyClient CL WITH(NOLOCK) ON CL.ClientId=P.ObjectId AND CL.CommServUniqueId=@i_CommServUniqueId
	LEFT JOIN cf_SurveyTenants T WITH(NOLOCK) ON T.TenantGUID=P.OrgGUID AND T.CommServUniqueId=@i_CommServUniqueId
	WHERE UsageType=21 AND PeakType=@peakType AND MonthStart=@month
END
ELSE IF @i_Option BETWEEN 30 AND 32--details of CCL/SCL endpoint users, sharing users and ediscovery users
BEGIN
	IF @i_Option=30 SET @usageType=22
	ELSE IF @i_Option=31 SET @usageType=23
	ELSE IF @i_Option=32 SET @usageType=24
	IF @peakType=0 SET @queryId=@i_QueryId_CCLUsage ELSE SET @queryId=@i_QueryId_SCLUsage
	SELECT DISTINCT ISNULL(ObjectId,0) AS UserId, ISNULL(E.UserName,'N/A') AS UserName, ISNULL(E.UserLogin,'N/A') AS UserLogin, ISNULL(E.UserEmail,'N/A') AS UserEmail, ISNULL(E.Associations,'N/A') AS Associations,
	ISNULL(CONVERT(VARCHAR(40),OrgGUID),'N/A') AS OrgGUID, ISNULL(T.TenantName,'N/A') AS Organization, ISNULL(PlanName,'N/A') AS PlanName
	FROM Lic_PeakUsage P WITH(NOLOCK)
	INNER JOIN cf_SurveyResultFuncV1(@queryId, @i_CommServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON P.CommServUniqueId=SR.CommServUniqueId
	LEFT JOIN cf_SurveyTenants T WITH(NOLOCK) ON T.TenantGUID=P.OrgGUID AND T.CommServUniqueId=@i_CommServUniqueId
	LEFT JOIN cf_SurveyEndusers E WITH(NOLOCK) ON E.UserId=P.ObjectId AND E.CommServUniqueId=@i_CommServUniqueId
	WHERE UsageType=@usageType AND PeakType=@peakType AND MonthStart=@month
END
ELSE IF @i_Option=33--CCL/SCL app user details
BEGIN
	IF @peakType=0 SET @queryId=@i_QueryId_CCLUsage ELSE SET @queryId=@i_QueryId_SCLUsage
	--get sharepoint online users
	IF object_id('tempdb.dbo.#AppUsers') IS NOT NULL DROP TABLE #AppUsers
    CREATE TABLE #AppUsers(Smtp NVARCHAR(1024), OrgGUID UNIQUEIDENTIFIER, Organization NVARCHAR(1024), PlanName NVARCHAR(1024), LicName VARCHAR(128), VMFlag INT)
	INSERT #AppUsers
	SELECT DISTINCT ObjectName, OrgGUID, ISNULL(T.TenantName,'N/A'), PlanName, ISNULL(L.name,'N/A') AS LicName, VMFlag
	FROM Lic_PeakUsage Usage WITH(NOLOCK)
	INNER JOIN cf_SurveyResultFuncV1(@queryId, @i_CommServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON Usage.CommServUniqueId=SR.CommServUniqueId
	LEFT JOIN cf_SurveyLicType L WITH(NOLOCK) ON L.id = Usage.LicType
	LEFT JOIN cf_SurveyTenants T WITH(NOLOCK) ON T.TenantGUID=Usage.OrgGUID AND T.CommServUniqueId=@i_CommServUniqueId
	WHERE UsageType=18 AND PeakType=@peakType AND MonthStart=@month
	AND LicType=200012
	--remove rows with default plan if any row with non-default plan is present for the same user
	DELETE A1 FROM #AppUsers A1
	INNER JOIN #AppUsers A2 ON A1.Smtp=A2.Smtp AND (A1.OrgGUID=A2.OrgGUID OR (A1.OrgGUID IS NULL AND A2.OrgGUID IS NULL))
	WHERE A1.PlanName='N/A' AND A2.PlanName<>'N/A'
	--get the rest of the application users
	INSERT #AppUsers
	SELECT DISTINCT ObjectName, OrgGUID, ISNULL(T.TenantName, 'N/A'), PlanName, ISNULL(L.name,'N/A') AS LicName, VMFlag
	FROM Lic_PeakUsage Usage WITH(NOLOCK)
	INNER JOIN cf_SurveyResultFuncV1(@queryId, @i_CommServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON Usage.CommServUniqueId=SR.CommServUniqueId
	LEFT JOIN cf_SurveyLicType L WITH(NOLOCK) ON L.id = Usage.LicType
	LEFT JOIN cf_SurveyTenants T WITH(NOLOCK) ON T.TenantGUID=Usage.OrgGUID AND T.CommServUniqueId=@i_CommServUniqueId
	WHERE UsageType=18 AND PeakType=@peakType AND MonthStart=@month
	AND LicType<>200012
	--find whether compliance search, content indexing and case manager is enabled for each user
	DECLARE @enablerTable TABLE (SMTP NVARCHAR(1024), OrgGUID UNIQUEIDENTIFIER, enabler INT)
	INSERT INTO @enablerTable
	SELECT DISTINCT Smtp, OrgGUID, ISNULL(SUM(DISTINCT p),0)
	FROM #AppUsers Usage
	OUTER APPLY
	(SELECT p FROM
		(SELECT POWER(2,n) FROM
			(VALUES (0),(1),(2)) Nos(n)
		)Powers(p)
		WHERE p&Usage.VMFlag = p
	)Bitmask
	GROUP BY Smtp,OrgGUID
	SELECT ISNULL(Smtp,'N/A') AS SMTP, ISNULL(CONVERT(VARCHAR(40),OrgGUID),'N/A') AS OrgGUID, ISNULL(Organization,'N/A') AS Organization, ISNULL(PlanName,'N/A') AS PlanName,
	CASE WHEN [Exchange Mailbox Classic Users] > 0 THEN 1 ELSE 0 END "Exchange Mailbox", CASE WHEN [Exchange Mailbox Users] > 0 THEN 1 ELSE 0 END "Exchange OnePass",
	CASE WHEN [SharePoint Online Users] > 0 THEN 1 ELSE 0 END "SharePoint Online", CASE WHEN [Gmail Users] > 0 THEN 1 ELSE 0 END "Gmail", CASE WHEN [GDrive Users] > 0 THEN 1 ELSE 0 END "GDrive",
	CASE WHEN [OneDrive Users] > 0 THEN 1 ELSE 0 END "OneDrive", CASE WHEN [Salesforce Users] > 0 THEN 1 ELSE 0 END "Salesforce", CASE WHEN [Notes Users] > 0 THEN 1 ELSE 0 END "Notes",
	CASE WHEN Checker&1>0 THEN 1 ELSE 0 END AS 'CI Enabled', CASE WHEN Checker&2>0 THEN 1 ELSE 0 END AS 'CM Enabled', CASE WHEN Checker&4>0 THEN 1 ELSE 0 END AS 'CS Enabled'
	FROM (
		SELECT Usage.Smtp, Usage.OrgGUID, Organization, PlanName, LicName, E.enabler AS Checker
		FROM #AppUsers Usage
		LEFT JOIN @enablerTable E ON Usage.Smtp = E.SMTP AND (Usage.OrgGUID = E.OrgGUID OR (Usage.OrgGUID IS NULL and E.OrgGUID IS NULL))
	) AS SourceTable
	PIVOT
	(
		COUNT(LicName)
		FOR LicName IN ([Exchange Mailbox Users],[Exchange Mailbox Classic Users],[SharePoint Online Users],[Gmail Users],[GDrive Users],[OneDrive Users],[Salesforce Users],[Notes Users])
	) AS PivotTable
	IF object_id('tempdb.dbo.#AppUsers') IS NOT NULL DROP TABLE #AppUsers
END
ELSE IF @i_Option BETWEEN 34 AND 36--CCL/SCL FSO, DLO & AppServer with Usages
BEGIN
	IF @i_Option=34 SET @usageType=29 ELSE IF @i_Option=35 SET @usageType=28 ELSE IF @i_Option=36 SET @usageType=27
	IF @peakType=0 SET @queryId=@i_QueryId_CCLUsage ELSE SET @queryId=@i_QueryId_SCLUsage
	IF object_id('tempdb.dbo.#C1') IS NOT NULL DROP TABLE #C1
	CREATE TABLE #C1(UsageType INT, ClientId INT, ClientName NVARCHAR(255), SubclientId INT, SubclientName NVARCHAR(128), LicType INT, AppTypeId INT, AgentName VARCHAR(256), BackupSetId INT,
		BackupSetName NVARCHAR(128), InstanceId INT, InstanceName NVARCHAR(512), SPId INT, SPName NVARCHAR(144), JobId INT, AppSizeMB BIGINT, OrgGUID UNIQUEIDENTIFIER, Organization NVARCHAR(1024), PlanName NVARCHAR(1024))
	IF object_id('tempdb.dbo.#C2') IS NOT NULL DROP TABLE #C2
	CREATE TABLE #C2(ClientId INT, LicType INT)
	INSERT #C1
	SELECT DISTINCT UsageType, C.ClientId, CL.ClientName, C.SubclientId, SCL.SubclientName, LicType, SCL.AppTypeId, SCL.AgentName,
	SCL.BackupSetId, SCL.BackupsetName BackupSetName, SCL.InstanceId, SCL.InstanceName, SP.PolicyId, SP.PolicyName SPName, JobId, AppSizeMB, OrgGUID, ISNULL(T.TenantName,'N/A'), PlanName
	FROM Lic_PeakUsage C WITH(NOLOCK)
	INNER JOIN cf_SurveyResultFuncV1(@queryId, @i_CommServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON C.CommServUniqueId=SR.CommServUniqueId
	LEFT JOIN cf_SurveyClient CL WITH(NOLOCK) ON CL.ClientId=C.ClientId AND CL.CommServUniqueId=@i_CommServUniqueId
	LEFT JOIN cf_SurveySubclientAssociation SCL WITH(NOLOCK) ON SCL.ClientId=C.ClientId AND SCL.AppId=C.SubclientId AND SCL.CommServUniqueId=@i_CommServUniqueId
	LEFT JOIN cf_SurveyCopyBasicRetention SP WITH(NOLOCK) ON SP.PolicyId=SCL.DataPolicyId AND SP.CommServUniqueId=@i_CommServUniqueId
	LEFT JOIN cf_SurveyTenants T WITH(NOLOCK) ON T.TenantGUID=C.OrgGUID AND T.CommServUniqueId=@i_CommServUniqueId
	WHERE UsageType IN (1,2,3,4) AND PeakType=@peakType AND MonthStart=@month
	UPDATE #C1
	SET BackupsetName = 'N/A'
	WHERE AppTypeId IN (SELECT apptype FROM #NoNeedBackupSet)
	UPDATE #C1
	SET InstanceName = 'N/A'
	WHERE AppTypeId NOT IN (SELECT apptype FROM #NeedInstance)
	INSERT #C2
	SELECT DISTINCT ClientId, LicType
	FROM Lic_PeakUsage U WITH(NOLOCK)
	INNER JOIN cf_SurveyResultFuncV1(@queryId, @i_CommServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON U.CommServUniqueId=SR.CommServUniqueId
	WHERE U.UsageType=@usageType AND U.PeakType=@peakType AND U.MonthStart=@month
	SELECT CASE WHEN UsageType=1 THEN 'Backup' WHEN UsageType=2 THEN 'Archive' WHEN UsageType=3 THEN 'Snapshot' ELSE 'Replication' END AS JobType,
	ISNULL(C1.ClientId,0) AS ClientId, ISNULL(ClientName,'N/A') AS ClientName, ISNULL(SubclientId,0) AS SubclientId, ISNULL(SubclientName,'N/A') AS SubclientName,
	ISNULL(C2.LicType,0) AS LicType, ISNULL(L2.name,'N/A') AS LicName,
	ISNULL(C1.LicType,0) AS ActualLicType, ISNULL(L1.name,'N/A') AS ActualLicName, ISNULL(AppTypeId,0) AS AppTypeId, ISNULL(AgentName,'N/A') AS AppTypeName,
	ISNULL(BackupSetId,0) AS BackupSetId, ISNULL(BackupSetName,'N/A') AS BackupSetName, ISNULL(InstanceId,0) AS InstanceId, ISNULL(InstanceName,'N/A') AS InstanceName,
	ISNULL(SPId,0) AS SPId, ISNULL(SPName,'N/A') AS SPName, ISNULL(JobId,0) AS JobId, ISNULL(AppSizeMB,0) AS AppSizeMB,
	ISNULL(CONVERT(VARCHAR(40),OrgGUID),'N/A') AS OrgGUID, ISNULL(Organization,'N/A') AS Organization, ISNULL(PlanName,'N/A') AS PlanName
	FROM #C1 C1
	INNER JOIN #C2 C2 ON C1.ClientId=C2.ClientId
	LEFT JOIN cf_SurveyLicType L1 WITH(NOLOCK) ON L1.id = C1.LicType
	LEFT JOIN cf_SurveyLicType L2 WITH(NOLOCK) ON L2.id = C2.LicType
	IF object_id('tempdb.dbo.#C1') IS NOT NULL DROP TABLE #C1
	IF object_id('tempdb.dbo.#C2') IS NOT NULL DROP TABLE #C2
	IF object_id('tempdb.dbo.#NoNeedBackupSet') IS NOT NULL DROP TABLE #NoNeedBackupSet
	IF object_id('tempdb.dbo.#NeedInstance') IS NOT NULL DROP TABLE #NeedInstance
END
ELSE IF @i_Option BETWEEN 37 AND 39--CCL/SCL FSO, DLO & AppServer without Usages
BEGIN
	IF object_id('tempdb.dbo.#C3') IS NOT NULL DROP TABLE #C3
	CREATE TABLE #C3(ClientId INT, ClientName NVARCHAR(255), LicType INT, OrgGUID UNIQUEIDENTIFIER, Organization NVARCHAR(1024), PlanName NVARCHAR(1024))
	IF object_id('tempdb.dbo.#C4') IS NOT NULL DROP TABLE #C4
	CREATE TABLE #C4(ClientId INT)
	INSERT #C3
	SELECT DISTINCT C.ClientId, CL.ClientName, LicType, OrgGUID, ISNULL(T.TenantName,'N/A'), PlanName
	FROM Lic_PeakUsage C WITH(NOLOCK)
	INNER JOIN cf_SurveyResultFuncV1(@queryId, @i_CommServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON C.CommServUniqueId=SR.CommServUniqueId
	LEFT JOIN cf_SurveyClient CL WITH(NOLOCK) ON CL.ClientId=C.ClientId AND CL.CommServUniqueId=@i_CommServUniqueId
	LEFT JOIN cf_SurveyTenants T WITH(NOLOCK) ON T.TenantGUID=C.OrgGUID AND T.CommServUniqueId=@i_CommServUniqueId
	WHERE UsageType=@usageType AND PeakType=@peakType AND MonthStart=@month
	INSERT #C4
	SELECT DISTINCT ClientId
	FROM Lic_PeakUsage U WITH(NOLOCK)
	INNER JOIN cf_SurveyResultFuncV1(@queryId, @i_CommServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON U.CommServUniqueId=SR.CommServUniqueId
	WHERE UsageType IN (1,2,3,4) AND PeakType=@peakType AND MonthStart=@month
	SELECT ISNULL(C1.ClientId,0) AS ClientId, ISNULL(ClientName,'N/A') AS ClientName, ISNULL(C1.LicType,0) AS LicType, ISNULL(L.name,'N/A') AS LicName,
	ISNULL(CONVERT(VARCHAR(40),OrgGUID),'N/A') AS OrgGUID, ISNULL(Organization,'N/A') AS Organization, ISNULL(PlanName,'N/A') AS PlanName
	FROM #C3 C1
	LEFT JOIN #C4 C2 ON C1.ClientId = C2.ClientId
	LEFT JOIN cf_SurveyLicType L WITH(NOLOCK) ON L.id = C1.LicType
	WHERE C2.ClientId IS NULL
	IF object_id('tempdb.dbo.#C3') IS NOT NULL DROP TABLE #C3
	IF object_id('tempdb.dbo.#C4') IS NOT NULL DROP TABLE #C4
END
ELSE IF @i_Option=40--get list of past N months for peak usages
BEGIN
	DECLARE @dateTable TABLE (monthValue VARCHAR(20), monthLabel VARCHAR(20))
	DECLARE @date DATETIME = GETDATE()
    DECLARE @counter INT = @i_NoOfMonths
    --default month to be displayed in list
    INSERT INTO @dateTable VALUES('9999-01-01','Current Month')
    WHILE @counter > 0
    BEGIN
        INSERT @dateTable
        SELECT CAST(DATEADD(DAY,-DAY(@date)+1, CAST(@date AS DATE)) AS DATE), CONVERT(VARCHAR(10),DATENAME(month, @date))+', '+CONVERT(VARCHAR(4),YEAR(@date))
        SET @date=DATEADD(month, -1, @date)
        SET @counter=@counter-1
    END
    SELECT monthValue, monthLabel FROM @dateTable
END
ELSE IF @i_Option=41--get current usage summary
BEGIN
	DECLARE @allLicenses TABLE (LicUsageType INT, LicUsageTypeName VARCHAR(128), Usage BIGINT, Purchased BIGINT, PermTotal INT, EvalTotal INT, TermDate DATETIME)
	INSERT @allLicenses
	EXEC Lic_Current_LicenseUsage @i_UserId, @i_GroupId, @i_CommServUniqueId, 0
	DECLARE @nVOIToOI INT = 0
	SELECT TOP 1 @nVOIToOI=AppTypeId FROM Lic_CurrentSummary WITH(NOLOCK) WHERE UsageType=30 AND CommServUniqueId=@i_CommServUniqueId
	IF @nVOIToOI > 0
	BEGIN
		UPDATE @allLicenses SET Usage=Usage+@nVOIToOI WHERE LicUsageType=100032
		UPDATE @allLicenses SET Usage=Usage-@nVOIToOI WHERE LicUsageType=100033
	END
	DECLARE @completeUsed BIGINT = 0
	SELECT @completeUsed=SUM(Usage) FROM @allLicenses WHERE LicUsageType IN (100002,100004)
	--always show only commvault complete. No need to display backup & archive seperately even if commvault complete is not purchased
	SELECT CASE WHEN @commvaultComplete=1 AND LicUsageType=100002 THEN -1 ELSE LicUsageType END AS LicUsageType, CASE WHEN LicUsageType=100002 THEN 'Commvault Complete' ELSE LicUsageTypeName END AS LicUsageTypeName,
	CASE WHEN LicUsageType=100002 THEN @completeUsed ELSE Usage END AS Usage, Purchased, PermTotal, EvalTotal, TermDate, CASE WHEN LicUsageType=100032 THEN @nVOIToOI ELSE @commvaultComplete END AS CommvaultComplete
	FROM @allLicenses WHERE (@commvaultComplete=1 AND LicUsageType=100002) OR LicUsageType NOT IN (100002,100004)
	UNION
	SELECT DISTINCT LicUsageType, 'Commvault Complete' AS LicUsageTypeName, @completeUsed AS Usage, -1 AS Purchased, -1 AS PermTotal, -1 AS EvalTotal, '1970-01-01 00:00:00.000' AS TermDate, @commvaultComplete AS CommvaultComplete
	FROM @allLicenses WHERE @commvaultComplete=0 AND LicUsageType=100002
END
ELSE IF @i_Option=42 --history of CCL/SCL commvault complete
BEGIN
	IF @peakType=0 SET @queryId=@i_QueryId_CCLSummary ELSE SET @queryId=@i_QueryId_SCLSummary
	IF object_id('tempdb.dbo.#H3') IS NOT NULL DROP TABLE #H3
	CREATE TABLE #H3(MonthStart DATETIME, Usage DECIMAL(18,3))
	INSERT #H3
	SELECT DISTINCT MonthStart, CAST(SUM(Usage)*1.0/1024/1024 AS DECIMAL(18,3)) AS Usage
	FROM Lic_PeakSummary P WITH(NOLOCK)
	INNER JOIN cf_SurveyResultFuncV1(@queryId, @i_CommServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON P.CommServUniqueId=SR.CommServUniqueId
	WHERE UsageType IN (1,2) AND CapacityFlag=0 AND PeakType=@peakType GROUP BY MonthStart
	SELECT M.MonthStart AS Month, ISNULL(Usage,0) AS Usage
	FROM @monthTable M
	LEFT JOIN #H3 H ON H.MonthStart=M.MonthStart
	IF object_id('tempdb.dbo.#H3') IS NOT NULL DROP TABLE #H3
END
ELSE IF @i_Option=44--File system only summary
BEGIN
	IF @peakType=0 SET @queryId=@i_QueryId_CCLSummary ELSE SET @queryId=@i_QueryId_SCLSummary
	IF object_id('tempdb.dbo.#F') IS NOT NULL DROP TABLE #F
	CREATE TABLE #F(LicType INT, Used BIGINT)
	INSERT #F
	SELECT LicType, SUM(Usage) AS Used
    FROM Lic_PeakSummary P WITH(NOLOCK)
	INNER JOIN cf_SurveyResultFuncV1(@queryId, @i_CommServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON P.CommServUniqueId=SR.CommServUniqueId
    WHERE UsageType=29 AND PeakType=@peakType AND MonthStart=@month
    GROUP BY LicType
	DECLARE @fsonlyTbl TABLE(LicType INT, Used INT)
    INSERT INTO @fsonlyTbl VALUES (100029, 0), (200017, 0)
    UPDATE T SET T.Used=F.Used
    FROM @fsonlyTbl T
    INNER JOIN #F F ON F.LicType=T.LicType
    SELECT LicType, ISNULL(L.name,'N/A') AS LicName, Used
	FROM @fsonlyTbl F
	LEFT JOIN cf_SurveyLicType L WITH(NOLOCK) ON L.id = F.LicType
	IF object_id('tempdb.dbo.#F') IS NOT NULL DROP TABLE #F
END
ELSE IF @i_Option=45--Live sync for VM details
BEGIN
	--Live sync pair is counted based on distinct sourcenames. SourceClientNames doesn't always match its clientId. Hence do not join with cf_SurveyClient table to get sourcename
	IF @peakType=0 SET @queryId=@i_QueryId_CCLUsage ELSE SET @queryId=@i_QueryId_SCLUsage
	SELECT DISTINCT ISNULL(ClientId,0) AS SourceClientId, ISNULL(ClientName,'N/A') AS SourceClientName, 'N/A' AS SourceGUID,
	ISNULL(ObjectName,'N/A') AS DestinationName, ISNULL(CONVERT(VARCHAR(40),OrgGUID),'N/A') AS OrgGUID, ISNULL(T.TenantName,'N/A') AS Organization, ISNULL(PlanName,'N/A') AS PlanName
    FROM Lic_PeakUsage P WITH(NOLOCK)
	INNER JOIN cf_SurveyResultFuncV1(@queryId, @i_CommServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON P.CommServUniqueId=SR.CommServUniqueId
	LEFT JOIN cf_SurveyTenants T WITH(NOLOCK) ON T.TenantGUID=P.OrgGUID AND T.CommServUniqueId=@i_CommServUniqueId
	WHERE UsageType=26 AND PeakType=@peakType AND MonthStart=@month
END
ELSE IF @i_Option BETWEEN 49 AND 50--details of CCL/SCL OI & VOI
BEGIN
	IF @i_Option=49 SET @usageType=30
	ELSE IF @i_Option=50 SET @usageType=31
	IF @peakType=0 SET @queryId=@i_QueryId_CCLUsage ELSE SET @queryId=@i_QueryId_SCLUsage
	SELECT DISTINCT ISNULL(P.ClientId,0) AS ClientId, ISNULL(CL.ClientName,'N/A') AS ClientName,
	ISNULL(CONVERT(VARCHAR(40),OrgGUID),'N/A') AS OrgGUID, ISNULL(T.TenantName,'N/A') AS Organization, ISNULL(PlanName,'N/A') AS PlanName
	FROM Lic_PeakUsage P WITH(NOLOCK)
	INNER JOIN cf_SurveyResultFuncV1(@queryId, @i_CommServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON P.CommServUniqueId=SR.CommServUniqueId
	LEFT JOIN cf_SurveyClient CL WITH(NOLOCK) ON CL.ClientId=P.ClientId AND CL.CommServUniqueId=@i_CommServUniqueId
	LEFT JOIN cf_SurveyTenants T WITH(NOLOCK) ON T.TenantGUID=P.OrgGUID AND T.CommServUniqueId=@i_CommServUniqueId
	WHERE UsageType=@usageType AND PeakType=@peakType AND MonthStart=@month
END
LIC_ERROR:
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'Lic_Peak_LicenseUsage')
	delete from GxQscripts where name = 'Lic_Peak_LicenseUsage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='Lic_Peak_LicenseUsage')
	delete from GXDBVersions where aliasname = 'Lic_Peak_LicenseUsage'
GO

insert into GXDBVersions values(2, 'Lic_Peak_LicenseUsage',  '00010001000200110000', 'Lic_Peak_LicenseUsage', '00010001000200110000')
GO

