

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/Lic_GetMetallicStorageUsageByContainer.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/Lic_GetMetallicStorageUsageByContainer.sp
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='Lic_GetMetallicStorageUsageByContainer')
BEGIN
	print '>>> Drop Stored Procedure: Lic_GetMetallicStorageUsageByContainer <<<'
	drop procedure Lic_GetMetallicStorageUsageByContainer
END
IF EXISTS (select * from GxQscripts where name='Lic_GetMetallicStorageUsageByContainer')
	delete from GxQscripts where name = 'Lic_GetMetallicStorageUsageByContainer'
GO

IF EXISTS (select * from GXDBVersions where aliasname='Lic_GetMetallicStorageUsageByContainer')
	delete from GXDBVersions where aliasname = 'Lic_GetMetallicStorageUsageByContainer'
GO
print '... Creating Procedure: Lic_GetMetallicStorageUsageByContainer'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure Lic_GetMetallicStorageUsageByContainer
  @i_licType integer = 0
AS
  DECLARE @o_licenseType INTEGER
  DECLARE @o_storagePoolId INTEGER
  DECLARE @o_storagePoolName NVARCHAR(144)
  DECLARE @o_deviceId INTEGER
  DECLARE @o_container VARCHAR(64)
  DECLARE @o_usedSpace BIGINT
--This will turn off message: "x rows affected".
SET NOCOUNT ON
IF OBJECT_ID('tempdb.dbo.#tempMetallicStorageUsageByContainer') IS NOT NULL
BEGIN
INSERT INTO #tempMetallicStorageUsageByContainer (licenseType, deviceId, storagepoolId,storagePoolName, container,usedSpace)
SELECT	MD.LicenseType, MD.DeviceId, 0, '', CP.value('metallicCredentialInfo[1]/@container', 'varchar(64)') Container, (1.0 * MD.UsedSpaceInBytes/1024/1024)
FROM	MMMetallicStorage MD WITH(READUNCOMMITTED)
		INNER JOIN App_Credentials C WITH(READUNCOMMITTED) ON MD.CredentialId = C.CredentialId
		CROSS APPLY C.credentialInfo.nodes('/App_AdditionalCredInfo') CN(CP)
WHERE 	(@i_licType = 0 OR MD.LicenseType = @i_licType) AND (MD.UsedSpaceInBytes > 0)
UPDATE #tempMetallicStorageUsageByContainer
SET storagepoolId = temp.StoragepoolId,
    storagePoolName = temp.StoragepoolName
    FROM  (SELECT MS.deviceId AS DeviceId, AG.id AS StoragepoolId, AG.NAME AS StoragepoolName
           FROM archGroup AG WITH (READUNCOMMITTED)
    INNER JOIN MMDataPath MP WITH (READUNCOMMITTED) ON AG.defaultCopy = MP.copyId
    INNER JOIN MMDrivePool DP WITH (READUNCOMMITTED) ON MP.DrivePoolId = DP.DrivePoolId
    INNER JOIN MMMasterPool MMP WITH (READUNCOMMITTED) ON DP.MasterPoolId = MMP.MasterPoolId
    INNER JOIN MMMountPath MO WITH (READUNCOMMITTED) ON MO.MasterPoolId = MMP.MasterPoolId
    INNER JOIN MMMountPathToStorageDevice MSD WITH (READUNCOMMITTED) ON MSD.MountPathId = MO.MountPathId
    INNER JOIN #tempMetallicStorageUsageByContainer MS WITH (READUNCOMMITTED)  ON MS.deviceId = MSD.DeviceId
WHERE (AG.flags & (256 | 8388608 ) > 0) ) AS temp
    WHERE #tempMetallicStorageUsageByContainer.DeviceId = temp.DeviceId
--SELECT licenseType,storagepoolId,storagePoolName, deviceId, container,usedSpace FROM #MetallicStorageUsageByContainer
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'Lic_GetMetallicStorageUsageByContainer')
	delete from GxQscripts where name = 'Lic_GetMetallicStorageUsageByContainer'
GO

IF EXISTS (select * from GXDBVersions where aliasname='Lic_GetMetallicStorageUsageByContainer')
	delete from GXDBVersions where aliasname = 'Lic_GetMetallicStorageUsageByContainer'
GO

insert into GXDBVersions values(2, 'Lic_GetMetallicStorageUsageByContainer',  '00000000000000000000', 'Lic_GetMetallicStorageUsageByContainer', '00000000000000000000')
GO

