

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/Lic_Current_LicenseUsage.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/Lic_Current_LicenseUsage.sp,v $ $Id: Lic_Current_LicenseUsage.sp,v 1.1.2.13 2020/01/05 03:49:33 bheemesh Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='Lic_Current_LicenseUsage')
BEGIN
	print '>>> Drop Stored Procedure: Lic_Current_LicenseUsage <<<'
	drop procedure Lic_Current_LicenseUsage
END
IF EXISTS (select * from GxQscripts where name='Lic_Current_LicenseUsage')
	delete from GxQscripts where name = 'Lic_Current_LicenseUsage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='Lic_Current_LicenseUsage')
	delete from GXDBVersions where aliasname = 'Lic_Current_LicenseUsage'
GO
print '... Creating Procedure: Lic_Current_LicenseUsage'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure Lic_Current_LicenseUsage
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @i_CommServUniqueId INT = 0, 
  @i_Option INT = -1,
  @i_TimeZone VARCHAR(25) = '-04:00'
AS
SET NOCOUNT ON
----This stored procedure has the various queries to be used by V3 License Summary Report on cloud (introduced in SP14)----
--@i_Option=0 - summary of all licenses
--@i_Option=1 - capacity license summary
--@i_Option=2 - virtualization license summary
--@i_Option=3 - user license summary
--@i_Option=4 - dummy license summary
--@i_Option=5 - rest of the main licenses not displayed in landing page
--@i_Option=6 - agent and feature licenses
--@i_Option=7 to 10 - capacity usage summary (7-backup, 8-archive, 9-snapshot, 10-replication)
--@i_Option=11 - all capacity usage details
--@i_Option=12 to 17 - excluded job details (12-VSA, 13-AppUser, 14-ACV, 15-DLP, 16-EdgeDrive, 17-ArchivedVM)
--@i_Option=18 to 21 - vm details (18-protected vm, 19-vm only, 20-ACV, 21-vm with app)
--@i_Option=22 - vm socket details
--@i_Option=23 - archived vm details
--@i_Option=24 to 26 - endpoint details (24-users, 25-sharing users, 26-eDiscovery users)
--@i_Option=27 - app user details
--@i_Option=28 to 30 - FSO, DLO & AppServer with Usages
--@i_Option=31 to 33 - FSO, DLO & AppServer without Usages
----get misc details
--@i_Option=34 - get list of CommCells
--@i_Option=35 - get details of selected CommCell
--@i_Option=36 - find whether vm socket or protected vm license is purchased
----new licenses
--@i_Option=37 - commvault complete capacity license summary
--@i_Option=38 - File system only summary
--@i_Option=39 - Live sync for VM details
--@i_Option=40 to 41 - OI/VOI details
--@i_Option=42 to 43 - excluded job details (42-OI, 43-VOI)
--@i_Option=44 - commvault complete OI license summary
--@i_Option=45 - object store usage details
----common variables and computations - start----
DECLARE @i_QueryId_LicenseInfo INT = 232 --License Info
DECLARE @i_QueryId_CurrentSummary INT = 233 --Current Summary
DECLARE @i_QueryId_CurrentUsage INT = 236 --Current Usage
DECLARE @usageType INT = -1
DECLARE @capacityFlag INT = -1
DECLARE @vmFlag1 INT = -1
DECLARE @vmFlag2 INT = -1
--find if commvault complete is purchased or not
DECLARE @commvaultComplete INT = 0
IF EXISTS (SELECT 1 FROM Lic_LicenseInfo WITH(NOLOCK) WHERE lictype=205 AND CommServUniqueId=@i_CommServUniqueId) AND EXISTS (SELECT 1 FROM Lic_LicenseInfo LiB INNER JOIN Lic_LicenseInfo LiA ON LiA.LicType=100004 AND LiB.PermTotal=LiA.PermTotal AND LiB.EvalTotal=LiA.EvalTotal AND LiB.TermDate=LiA.TermDate AND LiA.CommServUniqueId=@i_CommServUniqueId WHERE LiB.LicType=100002 AND LiB.CommServUniqueId=@i_CommServUniqueId)
BEGIN
	SET @commvaultComplete=1
END
--find if activity is enabled
DECLARE @isActivityEnabled INT = 0
SELECT @isActivityEnabled=CASE WHEN (C.CommCellSurveyServices & 4)=4 THEN 1 ELSE 0 END FROM cf_CommcellIdNameMap C WITH (NOLOCK) WHERE C.ID=@i_CommServUniqueId
--if activity is not enabled, always return empty resultset when displaying details
IF (@i_Option BETWEEN 11 AND 33) OR (@i_Option BETWEEN 39 AND 43) OR @i_Option=45
BEGIN
	IF @isActivityEnabled=0
		GOTO LIC_ERROR
END
IF (@i_Option BETWEEN 11 AND 17) OR (@i_Option BETWEEN 28 AND 30) OR (@i_Option BETWEEN 42 AND 43) OR @i_Option=45
BEGIN
	IF object_id('tempdb.dbo.#NoNeedBackupSet') IS NOT NULL DROP TABLE #NoNeedBackupSet
	CREATE TABLE #NoNeedBackupSet (apptype INT)
	INSERT INTO #NoNeedBackupSet VALUES
	(6),(32),(15),(9),(24),(25),(27),(31),(40),(2),(22),(23),(5),(48),(51),(47),(59),(67),(68),(65),(76),(75),(77),(80),(104),(4),(16),(70),(81),(61),(79),(53),(600),(601),(602),(604),(605),(606),(607),(128)
	IF object_id('tempdb.dbo.#NeedInstance') IS NOT NULL DROP TABLE #NeedInstance
	CREATE TABLE #NeedInstance (apptype INT)
	INSERT INTO #NeedInstance VALUES
	(3),(4),(16),(6),(7),(5),(126), (51),(52), (9),(8),(15),(14),(45), (2),(22),(23), (27),(31), (32),(35), (44), (37), (106), (54), (53), (55), (56),(60), (59), (57), (62), (67),(68),(69), (70),(77),(82),(80),(81),(90),(103),(104),(125),(58), (124), (131), (128),(79), (61), (134), (64), (135)
END
----common variables and computations - end----
IF @i_Option=0--license summary
BEGIN
	IF object_id('tempdb.dbo.#R') IS NOT NULL DROP TABLE #R
	CREATE TABLE #R(LicUsageType INT, LicUsageTypeName VARCHAR(100), UsageType INT)
	IF object_id('tempdb.dbo.#U') IS NOT NULL DROP TABLE #U
	CREATE TABLE #U(UsageType INT, Usage BIGINT)
	IF object_id('tempdb.dbo.#L') IS NOT NULL DROP TABLE #L
	CREATE TABLE #L(LicType INT, PermTotal BIGINT, EvalTotal BIGINT, TermDate DATETIME)
	INSERT INTO #R VALUES
	(100002, 'Backup', 1), (100004, 'Archive', 2), (100005, 'Snapshot', 3), (100006, 'Replication', 4), (100018, 'VM Sockets', 20), (100019, 'Protected VMs', 19), (100027, 'Application Class Virtual', -1),
	(100021, 'Archived VMs', 21), (100024, 'Endpoint Users', 22), (100025, 'Sharing Users', 23), (100026, 'eDiscovery Users', 24), (100028, 'Application Users', 18), (100029, 'File System only Server', 29),
	(200017, 'File System only VM', -4), (200002, 'Desktop & Laptop only', 28), (100030, 'Application Server', 27), (200001, 'VM only', -2), (200003, 'Advanced VM', -3), (100031, 'Appliance Store Usage (TB)', 8),
	(100016, 'Dedupe Store Space (TB)', 5), (100015, 'Disk Library Space (TB)', 9), (100017, 'Content Indexed Objects (In Millions)', 25), (200016, 'Live Sync for VM', 26), (100032, 'Operating Instances', 30),
	(100033, 'Virtual Operating Instances', 31), (-1, 'Object Store (TB)', 32)
	INSERT #U
	SELECT UsageType, SUM(Usage) AS Usage
	FROM Lic_CurrentSummary C WITH(NOLOCK)
	INNER JOIN cf_SurveyResultFuncV1(@i_QueryId_CurrentSummary, @i_CommServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON C.CommServUniqueId=SR.CommServUniqueId
	WHERE (UsageType IN (1,2,3,4) AND CapacityFlag=0) OR UsageType IN (5,8,9,18,20,21,22,23,24,25,26,27,28,30,31,32) OR (UsageType=19 AND VMFlag IN (2,3)) OR (UsageType = 29 AND LicType=100029)
	GROUP BY UsageType
	UNION
	SELECT -1, SUM(Usage) AS Usage
	FROM Lic_CurrentSummary C WITH(NOLOCK)
	INNER JOIN cf_SurveyResultFuncV1(@i_QueryId_CurrentSummary, @i_CommServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON C.CommServUniqueId=SR.CommServUniqueId
	WHERE (UsageType=19 AND VMFlag IN (3,4))
	UNION
	SELECT -2, SUM(Usage) AS Usage
	FROM Lic_CurrentSummary C WITH(NOLOCK)
	INNER JOIN cf_SurveyResultFuncV1(@i_QueryId_CurrentSummary, @i_CommServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON C.CommServUniqueId=SR.CommServUniqueId
	WHERE (UsageType=19 AND VMFlag=2)
	UNION
	SELECT -3, SUM(Usage) AS Usage
	FROM Lic_CurrentSummary C WITH(NOLOCK)
	INNER JOIN cf_SurveyResultFuncV1(@i_QueryId_CurrentSummary, @i_CommServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON C.CommServUniqueId=SR.CommServUniqueId
	WHERE (UsageType=19 AND VMFlag=3)
	UNION
	SELECT -4, SUM(Usage) AS Usage
	FROM Lic_CurrentSummary C WITH(NOLOCK)
	INNER JOIN cf_SurveyResultFuncV1(@i_QueryId_CurrentSummary, @i_CommServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON C.CommServUniqueId=SR.CommServUniqueId
	WHERE (UsageType=29 AND LicType = 200017)
	INSERT #L
	SELECT LicType, PermTotal, EvalTotal, TermDate
	FROM Lic_LicenseInfo C WITH(NOLOCK)
	INNER JOIN cf_SurveyResultFuncV1(@i_QueryId_LicenseInfo, @i_CommServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON C.CommServUniqueId=SR.CommServUniqueId
	WHERE LicType > 1000
	SELECT R.LicUsageType,R.LicUsageTypeName,ISNULL(U.Usage,0) AS Usage,
	CASE WHEN R.LicUsageType IN (100002,100004,100005,100006,100015,100016,100031) THEN
		CASE WHEN (ISNULL(L.PermTotal,0)>=0 AND ISNULL(L.EvalTotal,0)>=0) THEN (ISNULL(L.PermTotal,0)/1024+ISNULL(L.EvalTotal,0)/1024)
		ELSE CASE WHEN (ISNULL(L.PermTotal,0)=-1 OR ISNULL(L.EvalTotal,0)=-1) THEN -1
		ELSE 0
		END
	END
	ELSE
		CASE WHEN (ISNULL(L.PermTotal,0)>0 OR ISNULL(L.PermTotal,0)=-1) THEN ISNULL(L.PermTotal,0)
		WHEN (ISNULL(L.EvalTotal,0)>0 OR ISNULL(L.EvalTotal,0)=-1) THEN ISNULL(L.EvalTotal,0)
		ELSE 0
		END
	END AS Purchased,
	CASE WHEN R.LicUsageType IN (100002,100004,100005,100006) THEN ISNULL(L.PermTotal,0)/1024 ELSE L.PermTotal END AS PermTotal,
	CASE WHEN R.LicUsageType IN (100002,100004,100005,100006) THEN ISNULL(L.EvalTotal,0)/1024 ELSE L.EvalTotal END AS EvalTotal,
	L.TermDate AS TermDate
	FROM #R R
	LEFT JOIN #U U ON R.UsageType=U.UsageType
	LEFT JOIN #L L ON L.LicType=R.LicUsageType
	IF object_id('tempdb.dbo.#R') IS NOT NULL DROP TABLE #R
	IF object_id('tempdb.dbo.#U') IS NOT NULL DROP TABLE #U
	IF object_id('tempdb.dbo.#L') IS NOT NULL DROP TABLE #L
END
ELSE IF @i_Option=1--capacity license summary
BEGIN
	DECLARE @capacityLicenses TABLE (LicType INT, LicTypeName VARCHAR(128), Usage BIGINT, Purchased BIGINT, PermTotal INT, EvalTotal INT, TermDate DATETIME)
	INSERT @capacityLicenses
	EXEC Lic_Current_LicenseUsage @i_UserId, @i_GroupId, @i_CommServUniqueId, 0
	DECLARE @completeUsed BIGINT = 0
	SELECT @completeUsed=SUM(Usage) FROM @capacityLicenses WHERE LicType IN (100002,100004)
	SELECT CASE WHEN @commvaultComplete=1 AND LicType=100002 THEN -1 ELSE LicType END AS LicType, CASE WHEN @commvaultComplete=1 AND LicType=100002 THEN 'Commvault Complete' ELSE LicTypeName END AS LicTypeName,
	CASE WHEN @commvaultComplete=1 AND LicType=100002 THEN CAST(@completeUsed*1.0/1024/1024 AS DECIMAL(18,2)) ELSE CAST(Usage*1.0/1024/1024 AS DECIMAL(18,2)) END AS Usage, ISNULL(Purchased,0) AS Purchased, ISNULL(PermTotal,0) AS PermTotal, ISNULL(EvalTotal,0) AS EvalTotal, ISNULL(TermDate,'1970-01-01 00:00:00.000') AS TermDate
	FROM @capacityLicenses WHERE (@commvaultComplete=1 AND LicType IN (100002,100005,100006)) OR (@commvaultComplete=0 AND LicType IN (100002,100004,100005,100006))
	ORDER BY CASE WHEN LicType = 100002 THEN 1 WHEN LicType = 100005 THEN 2 WHEN LicType = 100006 THEN 3 WHEN LicType = 100004 THEN 4 END
END
ELSE IF @i_Option=2--virtualization license summary
BEGIN
	DECLARE @virtualizationLicenses TABLE (LicType INT, LicTypeName VARCHAR(128), Usage BIGINT, Purchased BIGINT, PermTotal INT, EvalTotal INT, TermDate DATETIME)
	INSERT @virtualizationLicenses
	EXEC Lic_Current_LicenseUsage @i_UserId, @i_GroupId, @i_CommServUniqueId, 0
	SELECT LicType, LicTypeName, Usage, ISNULL(Purchased,0) AS Purchased, ISNULL(PermTotal,0) AS PermTotal, ISNULL(EvalTotal,0) AS EvalTotal, ISNULL(TermDate,'1970-01-01 00:00:00.000') AS TermDate
	FROM @virtualizationLicenses WHERE LicType IN (100018, 100019, 100027, 100021)
	ORDER BY CASE WHEN LicType = 100018 THEN 1 WHEN LicType = 100019 THEN 2 WHEN LicType = 100027 THEN 3 WHEN LicType = 100021 THEN 4 END
END
ELSE IF @i_Option=3--user license summary
BEGIN
	DECLARE @userLicenses TABLE (LicType INT, LicTypeName VARCHAR(128), Usage BIGINT, Purchased BIGINT, PermTotal INT, EvalTotal INT, TermDate DATETIME)
	INSERT @userLicenses
	EXEC Lic_Current_LicenseUsage @i_UserId, @i_GroupId, @i_CommServUniqueId, 0
	SELECT LicType, LicTypeName, Usage, ISNULL(Purchased,0) AS Purchased, ISNULL(PermTotal,0) AS PermTotal, ISNULL(EvalTotal,0) AS EvalTotal, ISNULL(TermDate,'1970-01-01 00:00:00.000') AS TermDate
	FROM @userLicenses WHERE LicType IN (100024, 100025, 100026, 100028)
	ORDER BY CASE WHEN LicType = 100024 THEN 1 WHEN LicType = 100025 THEN 2 WHEN LicType = 100026 THEN 3 WHEN LicType = 100028 THEN 4 END
END
ELSE IF @i_Option=4--dummy license summary
BEGIN
	DECLARE @dummyLicenses TABLE (LicType INT, LicTypeName VARCHAR(128), Usage BIGINT, Purchased BIGINT, PermTotal INT, EvalTotal INT, TermDate DATETIME)
	INSERT @dummyLicenses
	EXEC Lic_Current_LicenseUsage @i_UserId, @i_GroupId, @i_CommServUniqueId, 0
	SELECT LicType, LicTypeName, Usage, ISNULL(Purchased,0) AS Purchased, ISNULL(PermTotal,0) AS PermTotal, ISNULL(EvalTotal,0) AS EvalTotal, ISNULL(TermDate,'1970-01-01 00:00:00.000') AS TermDate
	FROM @dummyLicenses WHERE LicType IN (100029, 200017, 200002, 100030, 200001, 200003, 200016)
	ORDER BY CASE WHEN LicType = 100030 THEN 1 WHEN LicType = 100029 THEN 2
	WHEN LicType = 200003 THEN 3 WHEN LicType = 200017 THEN 4 WHEN LicType = 200001 THEN 5
	WHEN LicType = 200002 THEN 6 WHEN LicType = 200016 THEN 7 END
END
ELSE IF @i_Option=5--rest of the main licenses not displayed in landing page
BEGIN
	DECLARE @otherLicenses TABLE (LicType INT, LicTypeName VARCHAR(128), Used BIGINT, Purchased BIGINT, PermTotal INT, EvalTotal INT, TermDate DATETIME)
	INSERT @otherLicenses
	EXEC Lic_Current_LicenseUsage @i_UserId, @i_GroupId, @i_CommServUniqueId, 0
	SELECT LicType, LicTypeName, Used, ISNULL(Purchased,0) AS Purchased, ISNULL(PermTotal,0) AS PermTotal, ISNULL(EvalTotal,0) AS EvalTotal, ISNULL(TermDate,'1970-01-01 00:00:00.000') AS TermDate
	FROM @otherLicenses WHERE LicType IN (100015, 100016, 100017, 100031, -1)
END
ELSE IF @i_Option=6--agent and feature licenses
BEGIN
	SELECT DISTINCT ISNULL(LicType,0) AS LicType, ISNULL(L.name,'N/A') AS LicName, PermTotal, PermUsed, EvalTotal, EvalUsed, ISNULL(TermDate,'1970-01-01 00:00:00.000') AS TermDate,
	CASE WHEN @isActivityEnabled=0 THEN 0 ELSE ISNULL(I.ClientId,0) END AS ClientId, CASE WHEN @isActivityEnabled=0 THEN 'N/A' ELSE ISNULL(CL.ClientName,'N/A') END AS ClientName,
	CASE WHEN @isActivityEnabled=0 THEN 0 ELSE ISNULL(AppTypeId,0) END  AS AppTypeId, CASE WHEN @isActivityEnabled=0 THEN 'N/A' ELSE ISNULL(A.name,'N/A') END AS AppTypeName,
	CASE WHEN @isActivityEnabled=0 THEN '1970-01-01 00:00:00.000' ELSE ISNULL(I.InstallDate,'1970-01-01 00:00:00.000') END AS InstallDate
	FROM Lic_LicenseInfo I WITH(NOLOCK)
	INNER JOIN cf_SurveyResultFuncV1(@i_QueryId_LicenseInfo, @i_CommServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON I.CommServUniqueId=SR.CommServUniqueId
	LEFT JOIN cf_SurveyLicType L WITH(NOLOCK) ON L.id = I.LicType
	LEFT JOIN cf_SurveyAgentType A WITH(NOLOCK) ON A.id = I.AppTypeId AND A.id > 0
	LEFT JOIN cf_SurveyClient CL WITH(NOLOCK) ON CL.ClientId = I.ClientId AND CL.CommServUniqueId=@i_CommServUniqueId
	WHERE LicType < 1000
END
ELSE IF @i_Option BETWEEN 7 AND 10--capacity license summary (7-backup, 8-archive, 9-snapshot, 10-replication)
BEGIN
	IF @i_Option=7 SET @usageType=1 ELSE IF @i_Option=8 SET @usageType=2 ELSE IF @i_Option=9 SET @usageType=3 ELSE IF @i_Option=10 SET @usageType=4
	SELECT CASE WHEN UsageType=1 THEN 'Backup' WHEN UsageType=2 THEN 'Archive' WHEN UsageType=3 THEN 'Snapshot' ELSE 'Replication' END AS JobType,
	ISNULL(LicType,0) AS LicType, ISNULL(L.name,'N/A') AS LicName, ISNULL(AppTypeId,0) AS AppTypeId, ISNULL(A.name,'N/A') AS AppTypeName, ISNULL(Usage,0) AS AppSizeMB
	FROM Lic_CurrentSummary C WITH(NOLOCK)
	INNER JOIN cf_SurveyResultFuncV1(@i_QueryId_CurrentSummary, @i_CommServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON C.CommServUniqueId=SR.CommServUniqueId
	LEFT JOIN cf_SurveyLicType L WITH(NOLOCK) ON L.id = C.LicType
	LEFT JOIN cf_SurveyAgentType A WITH(NOLOCK) ON A.id = C.AppTypeId AND A.id > 0
	WHERE UsageType=@usageType AND CapacityFlag=0
END
ELSE IF (@i_Option BETWEEN 11 AND 17) OR (@i_Option BETWEEN 42 AND 43) OR @i_Option=45--11-capacity license details, 12-VSA jobs excluded from capacity, 13-app user jobs excluded from capacity, 14-ACV jobs excluded from capacity, 15-DLP jobs excluded from capacity, 16-EdgeDrive jobs excluded from capacity, 17-ArchivedVM jobs excluded from capacity, 42-OI jobs excluded from capacity, 43-VOI jobs excluded from capacity, 45-object store capacity
BEGIN
	IF @i_Option=11 SET @capacityFlag=0 ELSE IF @i_Option=12 SET @capacityFlag=1 ELSE IF @i_Option=13 SET @capacityFlag=2 ELSE IF @i_Option=14 SET @capacityFlag=4 ELSE IF @i_Option=15 SET @capacityFlag=16 ELSE IF @i_Option=16 SET @capacityFlag=8 ELSE IF @i_Option=17 SET @capacityFlag=32 ELSE IF @i_Option=42 SET @capacityFlag=64 ELSE IF @i_Option=43 SET @capacityFlag=128 ELSE IF @i_Option=45 SET @capacityFlag=256
	IF @i_Option=12
	BEGIN
		--no need to show VSA exclusions if corresponding license is not purchased
		DECLARE @virtualProps TABLE (LicType INT, LicTypeName VARCHAR(128), Usage BIGINT, Purchased BIGINT, PermTotal INT, EvalTotal INT, TermDate DATETIME)
		INSERT @virtualProps
		EXEC Lic_Current_LicenseUsage @i_UserId, @i_GroupId, @i_CommServUniqueId, 0
		DECLARE @vmSockFlag INT = 0, @protVmFlag INT = 0
		SELECT @vmSockFlag=ISNULL(Purchased,0) FROM @virtualProps WHERE LicType=100018
		SELECT @protVmFlag=ISNULL(Purchased,0) FROM @virtualProps WHERE LicType=100019
		--timezone variable will be reused for getting input here
		IF @i_TimeZone='0'
		BEGIN
			IF @vmSockFlag<>-1 AND @vmSockFlag<=0
				GOTO LIC_ERROR
		END
		ELSE IF @i_TimeZone='1'
		BEGIN
			IF @protVmFlag<>-1 AND @protVmFlag<=0
				GOTO LIC_ERROR
		END
	END
	IF object_id('tempdb.dbo.#CP1') IS NOT NULL DROP TABLE #CP1
	CREATE TABLE #CP1(JobType VARCHAR(25), ClientId INT, ClientName NVARCHAR(255), SubclientId INT, SubclientName NVARCHAR(128), LicType INT, LicName NVARCHAR(256),
		AppTypeId INT, AppTypeName VARCHAR(256), BackupSetId INT, BackupSetName NVARCHAR(128), InstanceId INT, InstanceName NVARCHAR(512), SPId INT, SPName NVARCHAR(144),
		JobId INT, AppSizeMB BIGINT, OrgGUID VARCHAR(40), Organization NVARCHAR(1024), PlanName NVARCHAR(1024))
	INSERT #CP1
	SELECT DISTINCT CASE WHEN UsageType=32 THEN 'Object store capacity' WHEN UsageType=1 THEN 'Backup' WHEN UsageType=2 THEN 'Archive' WHEN UsageType=3 THEN 'Snapshot' ELSE 'Replication' END AS JobType,
	ISNULL(C.ClientId,0) AS ClientId, ISNULL(CL.ClientName,'N/A') AS ClientName, ISNULL(C.SubclientId,0) AS SubclientId, ISNULL(SCL.SubclientName,'N/A') AS SubclientName,
	ISNULL(LicType,0) AS LicType, ISNULL(L.name,'N/A') AS LicName, ISNULL(SCL.AppTypeId,0) AS AppTypeId, ISNULL(SCL.AgentName,'N/A') AS AppTypeName,
	ISNULL(SCL.BackupsetId,0) AS BackupSetId, ISNULL(SCL.BackupsetName,'N/A') AS BackupSetName, ISNULL(SCL.InstanceId,0) AS InstanceId, ISNULL(SCL.InstanceName,'N/A') AS InstanceName, ISNULL(SP.PolicyId,0) AS SPId, ISNULL(SP.PolicyName,'N/A') AS SPName,
	ISNULL(JobId,0) AS JobId, ISNULL(AppSizeMB,0) AS AppSizeMB, ISNULL(CONVERT(VARCHAR(40),OrgGUID),'N/A') AS OrgGUID, ISNULL(T.TenantName,'N/A') AS Organization, ISNULL(PlanName,'N/A') AS PlanName
	FROM Lic_CurrentUsage C WITH(NOLOCK)
	INNER JOIN cf_SurveyResultFuncV1(@i_QueryId_CurrentUsage, @i_CommServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON C.CommServUniqueId=SR.CommServUniqueId
	LEFT JOIN cf_SurveyLicType L WITH(NOLOCK) ON L.id = C.LicType
	LEFT JOIN cf_SurveyClient CL WITH(NOLOCK) ON CL.ClientId=C.ClientId AND CL.CommServUniqueId=@i_CommServUniqueId
	LEFT JOIN cf_SurveySubclientAssociation SCL WITH(NOLOCK) ON SCL.ClientId=C.ClientId AND SCL.AppId=C.SubclientId AND SCL.CommServUniqueId=@i_CommServUniqueId
	LEFT JOIN cf_SurveyCopyBasicRetention SP WITH(NOLOCK) ON SP.PolicyId=SCL.DataPolicyId AND SP.CommServUniqueId=@i_CommServUniqueId
	LEFT JOIN cf_SurveyTenants T WITH(NOLOCK) ON T.TenantGUID=C.OrgGUID AND T.CommServUniqueId=@i_CommServUniqueId
	WHERE (UsageType IN (1,2,3,4,32) AND CapacityFlag=@capacityFlag)
	UPDATE #CP1
	SET BackupsetName = 'N/A'
	WHERE AppTypeId IN (SELECT apptype FROM #NoNeedBackupSet)
	UPDATE #CP1
	SET InstanceName = 'N/A'
	WHERE AppTypeId NOT IN (SELECT apptype FROM #NeedInstance)
	SELECT JobType, ClientId, ClientName, SubclientId, SubclientName, LicType, LicName, AppTypeId, AppTypeName, BackupSetId, BackupSetName,
	InstanceId, InstanceName, SPId, SPName, JobId, AppSizeMB, OrgGUID, Organization, PlanName
	FROM #CP1
	IF object_id('tempdb.dbo.#CP1') IS NOT NULL DROP TABLE #CP1
	IF object_id('tempdb.dbo.#NoNeedBackupSet') IS NOT NULL DROP TABLE #NoNeedBackupSet
	IF object_id('tempdb.dbo.#NeedInstance') IS NOT NULL DROP TABLE #NeedInstance
	IF @i_Option<>11 AND @i_Option<>12 AND @i_Option<>17
	BEGIN
		SELECT CASE WHEN UsageType=32 THEN 'Object store capacity' WHEN UsageType=1 THEN 'Backup' WHEN UsageType=2 THEN 'Archive' WHEN UsageType=3 THEN 'Snapshot' ELSE 'Replication' END AS JobType,
		ISNULL(ClientId,0) AS ClientId, ISNULL(ClientName,'N/A') AS ClientName, ISNULL(SubclientId,0) AS SubclientId, ISNULL(SubclientName,'N/A') AS SubclientName,
		ISNULL(LicType,0) AS LicType, ISNULL(L.name,'N/A') AS LicName, ISNULL(AppTypeId,0) AS AppTypeId, ISNULL(A.name,'N/A') AS AppTypeName,
		ISNULL(BackupSetId,0) AS BackupSetId, ISNULL(BackupSetName,'N/A') AS BackupSetName, ISNULL(InstanceId,0) AS InstanceId, ISNULL(InstanceName,'N/A') AS InstanceName, ISNULL(SPId,0) AS SPId, ISNULL(SPName,'N/A') AS SPName,
		ISNULL(JobId,0) AS JobId, ISNULL(AppSizeMB,0) AS AppSizeMB, ISNULL(CONVERT(VARCHAR(40),OrgGUID),'N/A') AS OrgGUID, ISNULL(Organization,'N/A') AS Organization, ISNULL(PlanName,'N/A') AS PlanName
		FROM Lic_CurrentUsage C WITH(NOLOCK)
		INNER JOIN cf_SurveyResultFuncV1(@i_QueryId_CurrentUsage, @i_CommServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON C.CommServUniqueId=SR.CommServUniqueId
		LEFT JOIN cf_SurveyLicType L WITH(NOLOCK) ON L.id = C.LicType
		LEFT JOIN cf_SurveyAgentType A WITH(NOLOCK) ON A.id = C.AppTypeId AND A.id > 0
		WHERE (UsageType IN (1,2,3,4,32) AND CapacityFlag=@capacityFlag)
	END
	ELSE
	BEGIN
		IF object_id('tempdb.dbo.#VSAJobs') IS NOT NULL DROP TABLE #VSAJobs
        CREATE TABLE #VSAJobs(ParentId INT, ParentName NVARCHAR(255), VMId INT, VMName NVARCHAR(255), ParentJobId INT, ChildJobid INT, JobTypeName VARCHAR(15), SubclientId INT, AppSizeMB BIGINT, Organization NVARCHAR(1024), OrgGUID UNIQUEIDENTIFIER, PlanName NVARCHAR(1024), SubclientName NVARCHAR(255), BackupsetId INT, BackupSetName NVARCHAR(1024), InstanceId INT, InstanceName NVARCHAR(1024), SPId INT, SPName NVARCHAR(1024))
		INSERT #VSAJobs
		SELECT DISTINCT ISNULL(ClientId,-1), ISNULL(ClientName,'N/A'), ISNULL(ClientId,-1), ISNULL(ClientName,'N/A'), ISNULL(JobId,-1), ISNULL(JobId,-1),
		CASE WHEN U1.UsageType=1 THEN 'Backup' WHEN U1.UsageType=2 THEN 'Archive' WHEN U1.UsageType=3 THEN 'Snapshot' WHEN U1.UsageType=4 THEN 'Replication' END,
		ISNULL(SubclientId,-1), ISNULL(AppSizeMB,0), ISNULL(Organization,'N/A'), OrgGUID, ISNULL(PlanName,'N/A'), 'N/A', 0, 'N/A', 0, 'N/A', 0, 'N/A'
		FROM Lic_CurrentUsage U1 WITH (NOLOCK)
		INNER JOIN cf_SurveyResultFuncV1(@i_QueryId_CurrentUsage, @i_CommServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON U1.CommServUniqueId=SR.CommServUniqueId
		WHERE UsageType IN (1,2,3,4) AND CapacityFlag=@capacityFlag AND U1.AppTypeId=106
		UPDATE U1
		SET U1.ParentId=ISNULL(U19.ClientId,-1), U1.ParentName=ISNULL(CL.ClientName,'N/A'), U1.ParentJobId=ISNULL(U19.CapacityFlag,-1), U1.SubclientId=ISNULL(U19.SubclientId,-1)
		FROM #VSAJobs U1
		LEFT JOIN Lic_CurrentUsage U19 WITH (NOLOCK) ON U19.JobId=U1.ChildJobid
		INNER JOIN cf_SurveyResultFuncV1(@i_QueryId_CurrentUsage, @i_CommServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON U19.CommServUniqueId=SR.CommServUniqueId
		LEFT JOIN cf_SurveyClient CL WITH(NOLOCK) ON CL.ClientId=U19.ClientId AND CL.CommServUniqueId=@i_CommServUniqueId
		WHERE (U19.UsageType IN (19,21) AND @capacityFlag=0) OR (U19.UsageType IN (19) AND @capacityFlag=1) OR (U19.UsageType IN (21) AND @capacityFlag=32)
		UPDATE U1
		SET U1.SubclientName=ISNULL(SCL.SubclientName,'N/A'), U1.BackupsetId=ISNULL(SCL.BackupsetId,-1), U1.BackupSetName=ISNULL(SCL.BackupsetName,'N/A'), U1.InstanceId=ISNULL(SCL.InstanceId,-1), U1.InstanceName=ISNULL(SCL.InstanceName,'N/A'), U1.SPId=ISNULL(SP.PolicyId,-1), U1.SPName=ISNULL(SP.PolicyName,'N/A')
		FROM #VSAJobs U1
		LEFT JOIN cf_SurveySubclientAssociation SCL WITH(NOLOCK) ON SCL.ClientId=U1.ParentId AND SCL.AppId=U1.SubclientId AND SCL.CommServUniqueId=@i_CommServUniqueId
		LEFT JOIN cf_SurveyCopyBasicRetention SP WITH(NOLOCK) ON SP.PolicyId=SCL.DataPolicyId AND SP.CommServUniqueId=@i_CommServUniqueId
		SELECT JobTypeName AS JobType, VMId AS ClientId, VMName AS ClientName, SubclientId, SubclientName,
		143 AS LicType, 'Virtual Server' AS LicName, 106 AS AppTypeId, 'Virtual Server' AS AppTypeName,
		BackupsetId, BackupSetName, InstanceId, InstanceName, SPId, SPName,
		ChildJobId AS JobId, ISNULL(AppSizeMB,0) AS AppSizeMB, ISNULL(CONVERT(VARCHAR(40),OrgGUID),'N/A') AS OrgGUID, Organization, PlanName,
		ParentId AS "Virtualization Client ID", ParentName AS "Virtualization Client", ParentJobId AS "Parent Job ID"
		FROM #VSAJobs
		UNION
		SELECT CASE WHEN UsageType=1 THEN 'Backup' WHEN UsageType=2 THEN 'Archive' WHEN UsageType=3 THEN 'Snapshot' ELSE 'Replication' END AS JobType,
		ISNULL(ClientId,0) AS ClientId, ISNULL(ClientName,'N/A') AS ClientName, ISNULL(SubclientId,0) AS SubclientId, ISNULL(SubclientName,'N/A') AS SubclientName,
		ISNULL(LicType,0) AS LicType, ISNULL(L.name,'N/A') AS LicName, ISNULL(AppTypeId,0) AS AppTypeId, ISNULL(A.name,'N/A') AS AppTypeName,
		ISNULL(BackupSetId,0) AS BackupSetId, ISNULL(BackupSetName,'N/A') AS BackupSetName, ISNULL(InstanceId,0) AS InstanceId, ISNULL(InstanceName,'N/A') AS InstanceName, ISNULL(SPId,0) AS SPId, ISNULL(SPName,'N/A') AS SPName,
		ISNULL(JobId,0) AS JobId, ISNULL(AppSizeMB,0) AS AppSizeMB, ISNULL(CONVERT(VARCHAR(40),OrgGUID),'N/A') AS OrgGUID, ISNULL(Organization,'N/A') AS Organization, ISNULL(PlanName,'N/A') AS PlanName
		, 0, 'N/A', 0
		FROM Lic_CurrentUsage C WITH(NOLOCK)
		INNER JOIN cf_SurveyResultFuncV1(@i_QueryId_CurrentUsage, @i_CommServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON C.CommServUniqueId=SR.CommServUniqueId
		LEFT JOIN cf_SurveyLicType L WITH(NOLOCK) ON L.id = C.LicType
		LEFT JOIN cf_SurveyAgentType A WITH(NOLOCK) ON A.id = C.AppTypeId AND A.id > 0
		WHERE (UsageType IN (1,2,3,4) AND CapacityFlag=@capacityFlag AND C.AppTypeId<>106)
		IF object_id('tempdb.dbo.#VSAJobs') IS NOT NULL DROP TABLE #VSAJobs
	END
END
ELSE IF @i_Option BETWEEN 18 AND 21--vm details (18-protected vm, 19-vm only, 20-ACV, 21-vm with app)
BEGIN
	IF @i_Option=18 BEGIN SET @vmFlag1=2 SET @vmFlag2=3 END
	ELSE IF @i_Option=19 BEGIN SET @vmFlag1=2 SET @vmFlag2=2 END
	ELSE IF @i_Option=20 BEGIN SET @vmFlag1=3 SET @vmFlag2=4 END
	ELSE IF @i_Option=21 BEGIN SET @vmFlag1=3 SET @vmFlag2=3 END
	SELECT DISTINCT ISNULL(ObjectId,0) AS VMId, ISNULL(CL.ClientName,'N/A') AS VMName, ISNULL(A.name,'N/A') AS Package, CASE WHEN VMFlag IN (2,3) THEN 'Yes' ELSE 'No' END AS IsVMProtected,
	ISNULL(JobId,0) AS VMProtectionJob, ISNULL(AppSizeMB,0) AS ProtectedVMSize,
	ISNULL(CONVERT(VARCHAR(40),OrgGUID),'N/A') AS OrgGUID, ISNULL(T.TenantName,'N/A') AS Organization, ISNULL(PlanName,'N/A') AS PlanName
	FROM Lic_CurrentUsage C WITH(NOLOCK)
	INNER JOIN cf_SurveyResultFuncV1(@i_QueryId_CurrentUsage, @i_CommServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON C.CommServUniqueId=SR.CommServUniqueId
	LEFT JOIN cf_SurveyAgentType A WITH(NOLOCK) ON A.id = C.AppTypeId AND A.id > 0
	LEFT JOIN cf_SurveyClient CL WITH(NOLOCK) ON CL.ClientId=C.ObjectId AND CL.CommServUniqueId=@i_CommServUniqueId
	LEFT JOIN cf_SurveyTenants T WITH(NOLOCK) ON T.TenantGUID=C.OrgGUID AND T.CommServUniqueId=@i_CommServUniqueId
	WHERE UsageType=19 AND VMFlag IN (@vmFlag1,@vmFlag2)
END
ELSE IF @i_Option=22--vm socket details
BEGIN
	SELECT DISTINCT ISNULL(ObjectName,'N/A') AS HypervisorHost, ISNULL(AppSizeMB,0) AS Sockets,
	ISNULL(CONVERT(VARCHAR(40),OrgGUID),'N/A') AS OrgGUID, ISNULL(T.TenantName,'N/A') AS Organization, ISNULL(PlanName,'N/A') AS PlanName
	FROM Lic_CurrentUsage C WITH(NOLOCK)
	INNER JOIN cf_SurveyResultFuncV1(@i_QueryId_CurrentUsage, @i_CommServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON C.CommServUniqueId=SR.CommServUniqueId
	LEFT JOIN cf_SurveyTenants T WITH(NOLOCK) ON T.TenantGUID=C.OrgGUID AND T.CommServUniqueId=@i_CommServUniqueId
	WHERE UsageType=20
END
ELSE IF @i_Option=23--archived vm details
BEGIN
	SELECT DISTINCT ISNULL(ObjectId,0) AS VMId, ISNULL(CL.ClientName,'N/A') AS VMName, ISNULL(JobId,0) AS VMArchiveJob, ISNULL(AppSizeMB,0) AS ArchivedVMSize,
	ISNULL(CONVERT(VARCHAR(40),OrgGUID),'N/A') AS OrgGUID, ISNULL(T.TenantName,'N/A') AS Organization, ISNULL(PlanName,'N/A') AS PlanName
	FROM Lic_CurrentUsage C WITH(NOLOCK)
	INNER JOIN cf_SurveyResultFuncV1(@i_QueryId_CurrentUsage, @i_CommServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON C.CommServUniqueId=SR.CommServUniqueId
	LEFT JOIN cf_SurveyClient CL WITH(NOLOCK) ON CL.ClientId=C.ObjectId AND CL.CommServUniqueId=@i_CommServUniqueId
	LEFT JOIN cf_SurveyTenants T WITH(NOLOCK) ON T.TenantGUID=C.OrgGUID AND T.CommServUniqueId=@i_CommServUniqueId
	WHERE UsageType=21
END
ELSE IF @i_Option BETWEEN 24 AND 26--endpoint details (24-users, 25-sharing users, 26-eDiscovery users)
BEGIN
	IF @i_Option=24 SET @usageType=22 ELSE IF @i_Option=25 SET @usageType=23 ELSE IF @i_Option=26 SET @usageType=24
	SELECT DISTINCT ISNULL(ObjectId,0) AS UserId, ISNULL(E.UserName,'N/A') AS UserName, ISNULL(E.UserLogin,'N/A') AS UserLogin, ISNULL(E.UserEmail,'N/A') AS UserEmail, ISNULL(E.Associations,'N/A') AS Associations,
	ISNULL(CONVERT(VARCHAR(40),OrgGUID),'N/A') AS OrgGUID, ISNULL(T.TenantName,'N/A') AS Organization, ISNULL(PlanName,'N/A') AS PlanName
	FROM Lic_CurrentUsage C WITH(NOLOCK)
	INNER JOIN cf_SurveyResultFuncV1(@i_QueryId_CurrentUsage, @i_CommServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON C.CommServUniqueId=SR.CommServUniqueId
	LEFT JOIN cf_SurveyTenants T WITH(NOLOCK) ON T.TenantGUID=C.OrgGUID AND T.CommServUniqueId=@i_CommServUniqueId
	LEFT JOIN cf_SurveyEndusers E WITH(NOLOCK) ON E.UserId=C.ObjectId AND E.CommServUniqueId=@i_CommServUniqueId
	WHERE UsageType=@usageType
END
ELSE IF @i_Option=27--application user details
BEGIN
	--get sharepoint online users
	IF object_id('tempdb.dbo.#AppUsers') IS NOT NULL DROP TABLE #AppUsers
    CREATE TABLE #AppUsers(Smtp NVARCHAR(1024), OrgGUID UNIQUEIDENTIFIER, Organization NVARCHAR(1024), PlanName NVARCHAR(1024), LicName VARCHAR(128), VMFlag INT)
	INSERT #AppUsers
	SELECT DISTINCT ObjectName, OrgGUID, ISNULL(T.TenantName,'N/A'), PlanName, ISNULL(L.name,'N/A') AS LicName, VMFlag
	FROM Lic_CurrentUsage Usage WITH(NOLOCK)
	INNER JOIN cf_SurveyResultFuncV1(@i_QueryId_CurrentUsage, @i_CommServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON Usage.CommServUniqueId=SR.CommServUniqueId
	LEFT JOIN cf_SurveyLicType L WITH(NOLOCK) ON L.id = Usage.LicType
	LEFT JOIN cf_SurveyTenants T WITH(NOLOCK) ON T.TenantGUID=Usage.OrgGUID AND T.CommServUniqueId=@i_CommServUniqueId
	WHERE UsageType=18
	AND LicType=200012
	--remove rows with default plan if any row with non-default plan is present for the same user
	DELETE A1 FROM #AppUsers A1
	INNER JOIN #AppUsers A2 ON A1.Smtp=A2.Smtp AND (A1.OrgGUID=A2.OrgGUID OR (A1.OrgGUID IS NULL AND A2.OrgGUID IS NULL))
	WHERE A1.PlanName='N/A' AND A2.PlanName<>'N/A'
	--get the rest of the application users
	INSERT #AppUsers
	SELECT DISTINCT ObjectName, OrgGUID, ISNULL(T.TenantName,'N/A'), PlanName, ISNULL(L.name,'N/A') AS LicName, VMFlag
	FROM Lic_CurrentUsage Usage WITH(NOLOCK)
	INNER JOIN cf_SurveyResultFuncV1(@i_QueryId_CurrentUsage, @i_CommServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON Usage.CommServUniqueId=SR.CommServUniqueId
	LEFT JOIN cf_SurveyLicType L WITH(NOLOCK) ON L.id = Usage.LicType
	LEFT JOIN cf_SurveyTenants T WITH(NOLOCK) ON T.TenantGUID=Usage.OrgGUID AND T.CommServUniqueId=@i_CommServUniqueId
	WHERE UsageType=18
	AND LicType<>200012
	--find whether compliance search, content indexing and case manager is enabled for each user
	DECLARE @enablerTable TABLE (SMTP NVARCHAR(1024), OrgGUID UNIQUEIDENTIFIER, enabler INT)
	INSERT INTO @enablerTable
	SELECT DISTINCT Smtp, OrgGUID, ISNULL(SUM(DISTINCT p),0)
	FROM #AppUsers Usage
	OUTER APPLY
	(SELECT p FROM
		(SELECT POWER(2,n) FROM
			(VALUES (0),(1),(2)) Nos(n)
		)Powers(p)
		WHERE p&Usage.VMFlag = p
	)Bitmask
	GROUP BY Smtp,OrgGUID
	--summarize all appuser details
	SELECT ISNULL(Smtp,'N/A') AS SMTP, ISNULL(CONVERT(VARCHAR(40),OrgGUID),'N/A') AS OrgGUID, ISNULL(Organization,'N/A') AS Organization, ISNULL(PlanName,'N/A') AS PlanName,
	CASE WHEN [Exchange Mailbox Classic Users] > 0 THEN 1 ELSE 0 END "Exchange Mailbox", CASE WHEN [Exchange Mailbox Users] > 0 THEN 1 ELSE 0 END "Exchange OnePass",
	CASE WHEN [SharePoint Online Users] > 0 THEN 1 ELSE 0 END "SharePoint Online", CASE WHEN [Gmail Users] > 0 THEN 1 ELSE 0 END "Gmail", CASE WHEN [GDrive Users] > 0 THEN 1 ELSE 0 END "GDrive",
	CASE WHEN [OneDrive Users] > 0 THEN 1 ELSE 0 END "OneDrive", CASE WHEN [Salesforce Users] > 0 THEN 1 ELSE 0 END "Salesforce", CASE WHEN [Notes Users] > 0 THEN 1 ELSE 0 END "Notes",
	CASE WHEN Checker&1>0 THEN 1 ELSE 0 END AS 'CI Enabled', CASE WHEN Checker&2>0 THEN 1 ELSE 0 END AS 'CM Enabled', CASE WHEN Checker&4>0 THEN 1 ELSE 0 END AS 'CS Enabled'
	FROM (
		SELECT Usage.Smtp, Usage.OrgGUID, Organization, PlanName, LicName, E.enabler AS Checker
		FROM #AppUsers Usage
		LEFT JOIN @enablerTable E ON Usage.Smtp = E.SMTP AND (Usage.OrgGUID = E.OrgGUID OR (Usage.OrgGUID IS NULL and E.OrgGUID IS NULL))
	) AS SourceTable
	PIVOT
	(
		COUNT(LicName)
		FOR LicName IN ([Exchange Mailbox Users],[Exchange Mailbox Classic Users],[SharePoint Online Users],[Gmail Users],[GDrive Users],[OneDrive Users],[Salesforce Users],[Notes Users])
	) AS PivotTable
	IF object_id('tempdb.dbo.#AppUsers') IS NOT NULL DROP TABLE #AppUsers
END
ELSE IF @i_Option BETWEEN 28 AND 30--FSO, DLO & AppServer with Usages
BEGIN
	IF @i_Option=28 SET @usageType=29 ELSE IF @i_Option=29 SET @usageType=28 ELSE IF @i_Option=30 SET @usageType=27
	IF object_id('tempdb.dbo.#C1') IS NOT NULL DROP TABLE #C1
	CREATE TABLE #C1(UsageType INT, ClientId INT, ClientName NVARCHAR(255), SubclientId INT, SubclientName NVARCHAR(128), LicType INT, AppTypeId INT, AgentName VARCHAR(256), BackupSetId INT,
		BackupSetName NVARCHAR(128), InstanceId INT, InstanceName NVARCHAR(512), SPId INT, SPName NVARCHAR(144), JobId INT, AppSizeMB BIGINT, OrgGUID UNIQUEIDENTIFIER, Organization NVARCHAR(1024), PlanName NVARCHAR(1024))
	IF object_id('tempdb.dbo.#C2') IS NOT NULL DROP TABLE #C2
	CREATE TABLE #C2(ClientId INT, LicType INT)
	INSERT #C1
	SELECT DISTINCT UsageType, C.ClientId, CL.ClientName, C.SubclientId, SCL.SubclientName, LicType, SCL.AppTypeId, SCL.AgentName, SCL.BackupsetId BackupSetId,
	SCL.BackupsetName BackupSetName, SCL.InstanceId, SCL.InstanceName, SP.PolicyId, SP.PolicyName SPName, JobId, AppSizeMB, OrgGUID, ISNULL(T.TenantName,'N/A'), PlanName
	FROM Lic_CurrentUsage C WITH(NOLOCK)
	INNER JOIN cf_SurveyResultFuncV1(@i_QueryId_CurrentUsage, @i_CommServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON C.CommServUniqueId=SR.CommServUniqueId
	LEFT JOIN cf_SurveyClient CL WITH(NOLOCK) ON CL.ClientId=C.ClientId AND CL.CommServUniqueId=@i_CommServUniqueId
	LEFT JOIN cf_SurveySubclientAssociation SCL WITH(NOLOCK) ON SCL.ClientId=C.ClientId AND SCL.AppId=C.SubclientId AND SCL.CommServUniqueId=@i_CommServUniqueId
	LEFT JOIN cf_SurveyCopyBasicRetention SP WITH(NOLOCK) ON SP.PolicyId=SCL.DataPolicyId AND SP.CommServUniqueId=@i_CommServUniqueId
	LEFT JOIN cf_SurveyTenants T WITH(NOLOCK) ON T.TenantGUID=C.OrgGUID AND T.CommServUniqueId=@i_CommServUniqueId
	WHERE UsageType IN (1,2,3,4)
	UPDATE #C1
	SET BackupsetName = 'N/A'
	WHERE AppTypeId IN (SELECT apptype FROM #NoNeedBackupSet)
	UPDATE #C1
	SET InstanceName = 'N/A'
	WHERE AppTypeId NOT IN (SELECT apptype FROM #NeedInstance)
	INSERT #C2
	SELECT DISTINCT ClientId, LicType
	FROM Lic_CurrentUsage U WITH(NOLOCK)
	INNER JOIN cf_SurveyResultFuncV1(@i_QueryId_CurrentUsage, @i_CommServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON U.CommServUniqueId=SR.CommServUniqueId
	WHERE U.UsageType=@usageType
	SELECT CASE WHEN UsageType=1 THEN 'Backup' WHEN UsageType=2 THEN 'Archive' WHEN UsageType=3 THEN 'Snapshot' ELSE 'Replication' END AS JobType,
	ISNULL(C1.ClientId,0) AS ClientId, ISNULL(ClientName,'N/A') AS ClientName, ISNULL(SubclientId,0) AS SubclientId, ISNULL(SubclientName,'N/A') AS SubclientName,
	ISNULL(C2.LicType,0) AS LicType, ISNULL(L2.name,'N/A') AS LicName,
	ISNULL(C1.LicType,0) AS ActualLicType, ISNULL(L1.name,'N/A') AS ActualLicName, ISNULL(AppTypeId,0) AS AppTypeId, ISNULL(AgentName,'N/A') AS AppTypeName,
	ISNULL(BackupSetId,0) AS BackupSetId, ISNULL(BackupSetName,'N/A') AS BackupSetName, ISNULL(InstanceId,0) AS InstanceId, ISNULL(InstanceName,'N/A') AS InstanceName,
	ISNULL(SPId,0) AS SPId, ISNULL(SPName,'N/A') AS SPName, ISNULL(JobId,0) AS JobId, ISNULL(AppSizeMB,0) AS AppSizeMB,
	ISNULL(CONVERT(VARCHAR(40),OrgGUID),'N/A') AS OrgGUID, ISNULL(Organization,'N/A') AS Organization, ISNULL(PlanName,'N/A') AS PlanName
	FROM #C1 C1
	INNER JOIN #C2 C2 ON C1.ClientId=C2.ClientId
	LEFT JOIN cf_SurveyLicType L1 WITH(NOLOCK) ON L1.id = C1.LicType
	LEFT JOIN cf_SurveyLicType L2 WITH(NOLOCK) ON L2.id = C2.LicType
	IF object_id('tempdb.dbo.#C1') IS NOT NULL DROP TABLE #C1
	IF object_id('tempdb.dbo.#C2') IS NOT NULL DROP TABLE #C2
	IF object_id('tempdb.dbo.#NoNeedBackupSet') IS NOT NULL DROP TABLE #NoNeedBackupSet
	IF object_id('tempdb.dbo.#NeedInstance') IS NOT NULL DROP TABLE #NeedInstance
END
ELSE IF @i_Option BETWEEN 31 AND 33--FSO, DLO & AppServer without Usages
BEGIN
	IF @i_Option=31 SET @usageType=29 ELSE IF @i_Option=32 SET @usageType=28 ELSE IF @i_Option=33 SET @usageType=27
	IF object_id('tempdb.dbo.#C3') IS NOT NULL DROP TABLE #C3
	CREATE TABLE #C3(ClientId INT, ClientName NVARCHAR(255), LicType INT, OrgGUID UNIQUEIDENTIFIER, Organization NVARCHAR(1024), PlanName NVARCHAR(1024))
	IF object_id('tempdb.dbo.#C4') IS NOT NULL DROP TABLE #C4
	CREATE TABLE #C4(ClientId INT)
	INSERT #C3
	SELECT DISTINCT C.ClientId, CL.ClientName, LicType, OrgGUID, ISNULL(T.TenantName, 'N/A'), PlanName
	FROM Lic_CurrentUsage C WITH(NOLOCK)
	INNER JOIN cf_SurveyResultFuncV1(@i_QueryId_CurrentUsage, @i_CommServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON C.CommServUniqueId=SR.CommServUniqueId
	LEFT JOIN cf_SurveyClient CL WITH(NOLOCK) ON CL.ClientId=C.ClientId AND CL.CommServUniqueId=@i_CommServUniqueId
	LEFT JOIN cf_SurveyTenants T WITH(NOLOCK) ON T.TenantGUID=C.OrgGUID AND T.CommServUniqueId=@i_CommServUniqueId
	WHERE UsageType=@usageType
	INSERT #C4
	SELECT DISTINCT ClientId
	FROM Lic_CurrentUsage U WITH(NOLOCK)
	INNER JOIN cf_SurveyResultFuncV1(@i_QueryId_CurrentUsage, @i_CommServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON U.CommServUniqueId=SR.CommServUniqueId
	WHERE UsageType IN (1,2,3,4)
	SELECT ISNULL(C1.ClientId,0) AS ClientId, ISNULL(ClientName,'N/A') AS ClientName, ISNULL(C1.LicType,0) AS LicType, ISNULL(L.name,'N/A') AS LicName,
	ISNULL(CONVERT(VARCHAR(40),OrgGUID),'N/A') AS OrgGUID, ISNULL(Organization,'N/A') AS Organization, ISNULL(PlanName,'N/A') AS PlanName
	FROM #C3 C1
	LEFT JOIN #C4 C2 ON C1.ClientId = C2.ClientId
	LEFT JOIN cf_SurveyLicType L WITH(NOLOCK) ON L.id = C1.LicType
	WHERE C2.ClientId IS NULL
	IF object_id('tempdb.dbo.#C3') IS NOT NULL DROP TABLE #C3
	IF object_id('tempdb.dbo.#C4') IS NOT NULL DROP TABLE #C4
END
ELSE IF @i_Option=34--get list of CommCells
BEGIN
	SELECT CommServUniqueId AS CommServUniqueId, ISNULL(N.CustomerName,'N/A') + ' - ' + ISNULL(N.CommServName,'N/A') + ' - ' + dbo.ConvertBigIntToHexStr(C.CommCellID) AS 'CommCell ID in Hex'
	FROM cf_SurveyResultFuncV1(2, 0, 1, NULL, NULL, @i_UserId, @i_GroupId) C
	LEFT JOIN
	cf_CommcellIdNameMap N WITH(NOLOCK) ON C.CommServUniqueId=N.id
END
ELSE IF @i_Option=35--get details of selected CommCell
BEGIN
	DECLARE @expiry DATETIME = '1970-01-01 00:00:00.000'
	SELECT TOP 1 @expiry=ISNULL(ExpiryDate,'1970-01-01 00:00:00.000')
	FROM Lic_LicenseInfo I WITH(NOLOCK)
	INNER JOIN cf_SurveyResultFuncV1(@i_QueryId_LicenseInfo, @i_CommServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON I.CommServUniqueId=SR.CommServUniqueId
	DECLARE @commcell TABLE (csUniqueId INT, ccId VARCHAR(32), csGuid VARCHAR(256), customerName NVARCHAR(256), csName NVARCHAR(256), csVersion VARCHAR(256), csTZ VARCHAR(256), modifiedTime DATETIME, licUsageCollectionTime DATETIME)
	INSERT @commcell
	SELECT TOP 1 C.ID, C.CommCellID, C.CommServGUID, C.CustomerName, C.CommServName, CS.CommServVersion, CS.CommServTZ, SWITCHOFFSET(CONVERT(DATETIMEOFFSET,CS.LogDateUTC), @i_TimeZone), SWITCHOFFSET(CONVERT(DATETIMEOFFSET,dbo.GetDateTime(CS.LicUsageCollectionTime)), @i_TimeZone)
	FROM cf_CommcellIdNameMap C WITH(NOLOCK)
	INNER JOIN cf_SurveyResultFuncV1(2, @i_CommServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON C.ID=SR.CommServUniqueId
	LEFT JOIN cf_SurveyCSDetailsInfo CS ON CS.SurveyResultId=SR.SurverResultId
	WHERE C.ID=@i_CommServUniqueId
	SELECT csUniqueId AS CommServUniqueId, dbo.ConvertBigIntToHexStr(ccId) AS 'CommCellID', ccId AS 'CommCellIDinDecimal',
	(customerName+' - '+csName) AS CommCell, STUFF(STUFF(RIGHT(csGuid,10),4,0,'-'),8,0,'-') AS 'RegistrationCode', csVersion AS Version,
	modifiedTime AS 'LastUploadTime', csTZ AS 'TimeZone', @isActivityEnabled AS isActivityEnabled, licUsageCollectionTime AS 'UsageCollectionTime',
	CASE WHEN @expiry=CONVERT(DATE, '01-01-1970') THEN 'N/A' ELSE FORMAT(@expiry, 'MMM dd, yyyy') END AS 'LicenseExpiry'
	FROM @commcell
END
ELSE IF @i_Option=36--find whether vm socket or protected vm license is purchased
BEGIN
	DECLARE @virtualizationProps TABLE (LicType INT, LicTypeName VARCHAR(128), Usage BIGINT, Purchased BIGINT, PermTotal INT, EvalTotal INT, TermDate DATETIME)
	INSERT @virtualizationProps
	EXEC Lic_Current_LicenseUsage @i_UserId, @i_GroupId, @i_CommServUniqueId, 0
	DECLARE @vmSocketFlag INT = 0, @protectedVmFlag INT = 0
	SELECT @vmSocketFlag=ISNULL(Purchased,0) FROM @virtualizationProps WHERE LicType=100018
	SELECT @protectedVmFlag=ISNULL(Purchased,0) FROM @virtualizationProps WHERE LicType=100019
	DECLARE @virtualLicType INT = 0 --0-both licenses not purchased, 1-vmsocket purchased, 2-protectedvm purchased
	IF @vmSocketFlag=-1 OR @vmSocketFlag>0--vm socket is purchased in these cases
		SET @virtualLicType = 1
	IF @protectedVmFlag=-1 OR @protectedVmFlag>0--protected vm is purchased in these cases
		SET @virtualLicType = 2
	SELECT @isActivityEnabled AS isActivityEnabled, @virtualLicType AS virtualLicType
END
ELSE IF @i_Option=37--commvault complete capacity license summary
BEGIN
	SELECT CASE WHEN UsageType=1 THEN 'Backup' WHEN UsageType=2 THEN 'Archive' END AS JobType,
	ISNULL(LicType,0) AS LicType, ISNULL(L.name,'N/A') AS LicName, ISNULL(AppTypeId,0) AS AppTypeId, ISNULL(A.name,'N/A') AS AppTypeName, ISNULL(Usage,0) AS AppSizeMB
	FROM Lic_CurrentSummary C WITH(NOLOCK)
	INNER JOIN cf_SurveyResultFuncV1(@i_QueryId_CurrentSummary, @i_CommServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON C.CommServUniqueId=SR.CommServUniqueId
	LEFT JOIN cf_SurveyLicType L WITH(NOLOCK) ON L.id = C.LicType
	LEFT JOIN cf_SurveyAgentType A WITH(NOLOCK) ON A.id = C.AppTypeId AND A.id > 0
	WHERE UsageType IN (1,2) AND CapacityFlag=0
END
ELSE IF @i_Option=38--File system only summary
BEGIN
	IF object_id('tempdb.dbo.#F') IS NOT NULL DROP TABLE #F
	CREATE TABLE #F(LicType INT, Used BIGINT)
	INSERT #F
	SELECT LicType, SUM(Usage) AS Used
    FROM Lic_CurrentSummary C WITH(NOLOCK)
	INNER JOIN cf_SurveyResultFuncV1(@i_QueryId_CurrentSummary, @i_CommServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON C.CommServUniqueId=SR.CommServUniqueId
    WHERE UsageType=29
    GROUP BY LicType
	DECLARE @fsonlyTbl TABLE(LicType INT, Used INT)
    INSERT INTO @fsonlyTbl VALUES (100029, 0), (200017, 0)
    UPDATE T SET T.Used=F.Used
    FROM @fsonlyTbl T
    INNER JOIN #F F ON F.LicType=T.LicType
    SELECT LicType, ISNULL(L.name,'N/A') AS LicName, Used
	FROM @fsonlyTbl F
	LEFT JOIN cf_SurveyLicType L WITH(NOLOCK) ON L.id = F.LicType
	IF object_id('tempdb.dbo.#F') IS NOT NULL DROP TABLE #F
END
ELSE IF @i_Option=39--Live sync for VM details
BEGIN
	--Live sync pair is counted based on distinct sourcenames. SourceClientNames doesn't always match its clientId. Hence do not join with cf_SurveyClient table to get sourcename
	SELECT DISTINCT ISNULL(ClientId,0) AS SourceClientId, ISNULL(ClientName,'N/A') AS SourceClientName, 'N/A' AS SourceGUID,
	ISNULL(ObjectName,'N/A') AS DestinationName, ISNULL(CONVERT(VARCHAR(40),OrgGUID),'N/A') AS OrgGUID, ISNULL(T.TenantName,'N/A') AS Organization, ISNULL(PlanName,'N/A') AS PlanName
    FROM Lic_CurrentUsage C WITH(NOLOCK)
	INNER JOIN cf_SurveyResultFuncV1(@i_QueryId_CurrentUsage, @i_CommServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON C.CommServUniqueId=SR.CommServUniqueId
	LEFT JOIN cf_SurveyTenants T WITH(NOLOCK) ON T.TenantGUID=C.OrgGUID AND T.CommServUniqueId=@i_CommServUniqueId
	WHERE UsageType=26
END
ELSE IF @i_Option BETWEEN 40 AND 41--OI/VOI details (40-OI, 41-VOI)
BEGIN
	IF @i_Option=40 SET @usageType=30 ELSE IF @i_Option=41 SET @usageType=31
	SELECT DISTINCT ISNULL(C.ClientId,0) AS ClientId, ISNULL(CL.ClientName,'N/A') AS ClientName,
	ISNULL(CONVERT(VARCHAR(40),OrgGUID),'N/A') AS OrgGUID, ISNULL(T.TenantName,'N/A') AS Organization, ISNULL(PlanName,'N/A') AS PlanName
	FROM Lic_CurrentUsage C WITH(NOLOCK)
	INNER JOIN cf_SurveyResultFuncV1(@i_QueryId_CurrentUsage, @i_CommServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON C.CommServUniqueId=SR.CommServUniqueId
	LEFT JOIN cf_SurveyClient CL WITH(NOLOCK) ON CL.ClientId=C.ClientId AND CL.CommServUniqueId=@i_CommServUniqueId
	LEFT JOIN cf_SurveyTenants T WITH(NOLOCK) ON T.TenantGUID=C.OrgGUID AND T.CommServUniqueId=@i_CommServUniqueId
	WHERE UsageType=@usageType
END
ELSE IF @i_Option=44--commvault complete OI license summary
BEGIN
	DECLARE @OILicenses TABLE (LicType INT, LicTypeName VARCHAR(128), Usage BIGINT, Purchased BIGINT, PermTotal INT, EvalTotal INT, TermDate DATETIME)
	INSERT @OILicenses
	EXEC Lic_Current_LicenseUsage @i_UserId, @i_GroupId, @i_CommServUniqueId, 0
	DECLARE @nVOIToOI INT = 0
	SELECT TOP 1 @nVOIToOI=AppTypeId FROM Lic_CurrentSummary WITH(NOLOCK) WHERE UsageType=30 AND CommServUniqueId=@i_CommServUniqueId
	IF @nVOIToOI > 0
	BEGIN
		UPDATE @OILicenses SET LicTypeName=LicTypeName+' *(includes '+CONVERT(VARCHAR(10),@nVOIToOI) +' Virtual OI)', Usage=Usage+@nVOIToOI WHERE LicType=100032
		UPDATE @OILicenses SET Usage=Usage-@nVOIToOI WHERE LicType=100033
	END
	SELECT LicType, LicTypeName, Usage, ISNULL(Purchased,0) AS Purchased, ISNULL(PermTotal,0) AS PermTotal, ISNULL(EvalTotal,0) AS EvalTotal, ISNULL(TermDate,'1970-01-01 00:00:00.000') AS TermDate
	FROM @OILicenses WHERE LicType IN (100032, 100033)
	ORDER BY CASE WHEN LicType = 100032 THEN 1 WHEN LicType = 100033 THEN 2 END
END
LIC_ERROR:
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'Lic_Current_LicenseUsage')
	delete from GxQscripts where name = 'Lic_Current_LicenseUsage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='Lic_Current_LicenseUsage')
	delete from GXDBVersions where aliasname = 'Lic_Current_LicenseUsage'
GO

insert into GXDBVersions values(2, 'Lic_Current_LicenseUsage',  '00010001000200130000', 'Lic_Current_LicenseUsage', '00010001000200130000')
GO

