

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/Lic_CUR_GetLicenseUsage.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/Lic_CUR_GetLicenseUsage.sp,v $ $Id: Lic_CUR_GetLicenseUsage.sp,v 1.1.2.15.8.1 2021/01/15 15:41:20 lgeorge Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='Lic_CUR_GetLicenseUsage')
BEGIN
	print '>>> Drop Stored Procedure: Lic_CUR_GetLicenseUsage <<<'
	drop procedure Lic_CUR_GetLicenseUsage
END
IF EXISTS (select * from GxQscripts where name='Lic_CUR_GetLicenseUsage')
	delete from GxQscripts where name = 'Lic_CUR_GetLicenseUsage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='Lic_CUR_GetLicenseUsage')
	delete from GXDBVersions where aliasname = 'Lic_CUR_GetLicenseUsage'
GO
print '... Creating Procedure: Lic_CUR_GetLicenseUsage'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure Lic_CUR_GetLicenseUsage
  @option INT, 	
  @i_userId INT,
  @GUID VARCHAR(100) = NULL,
  @capacityType INT = NULL,
  @timezone VARCHAR(20) = '00:00'
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
	DECLARE @userHasRights INT = 0
	EXEC commserv.dbo.sec_checkPermissionOnEntity @i_userId, '1,2', @userHasRights OUTPUT, 1, 2
	IF @userHasRights = 0
	BEGIN
		--allow non admin users to access LSR through REST api if they have view permission set at commcell entity level
		EXEC commserv.dbo.sec_checkPermissionOnEntity @i_userId, '31', @userHasRights OUTPUT, 1, 2
		IF @userHasRights = 0
			RETURN
	END
	DECLARE @orgGUID UNIQUEIDENTIFIER = TRY_CAST(@GUID AS UNIQUEIDENTIFIER)
	DECLARE @sqlQuery NVARCHAR(MAX) = '';
	IF @option = 1  -- Get License Summary Usage for Capacity
	BEGIN
		DECLARE @commvaultComplete INT = 0, @completeUsed BIGINT = 0
		IF EXISTS (SELECT 1 FROM Lic_LicenseInfo WITH(NOLOCK) WHERE lictype=205) AND EXISTS (SELECT 1 FROM Lic_LicenseInfo LiB INNER JOIN Lic_LicenseInfo LiA ON LiA.LicType=100004 AND LiB.PermTotal=LiA.PermTotal AND LiB.EvalTotal=LiA.EvalTotal AND LiB.TermDate=LiA.TermDate WHERE LiB.LicType=100002)
		BEGIN
			SET @commvaultComplete=1
			SELECT @completeUsed=SUM(CASE WHEN @orgGUID IS NULL OR OrgGUID = @orgGUID THEN Usage ELSE 0 END) FROM Lic_CUR_UsageSummary_vw WHERE LicUsageType IN (100002,100004)
		END
		SELECT CASE WHEN @commvaultComplete=1 AND LicUsageType=100002 THEN 'Commvault Complete' ELSE LicUsageTypeName END AS Dial, Purchased, PermTotal, EvalTotal AS Eval,
		CASE WHEN @commvaultComplete=1 AND LicUsageType=100002 THEN @completeUsed/(1024.00*1024.00) ELSE SUM(CASE WHEN @orgGUID IS NULL OR OrgGUID = @orgGUID THEN Usage  ELSE 0 END) /(1024.00*1024.00) END AS Usage
		, ISNULL(TermDate, CONVERT(DATETIME, '1970-01-01 00:00:00.000')) as TermDate,
		CONVERT(VARCHAR(12), ISNULL(TermDate, CONVERT(DATETIME, '1970-01-01 00:00:00.000')), 106) As EvalExpiryDate
		FROM Lic_CUR_UsageSummary_vw
		WHERE (@commvaultComplete=1 AND LicUsageType IN (100002,100005,100006)) OR (@commvaultComplete=0 AND LicUsageType IN (100002,100004,100005,100006)) --AND (@orgGUID IS NULL OR OrgGUID = @orgGUID)
		GROUP BY LicUsageType,LicUsageTypeName, Purchased, EvalTotal, TermDate, PermTotal
		ORDER BY CASE WHEN LicUsageType = 100002 THEN 1 WHEN LicUsageType = 100005 THEN 2 WHEN LicUsageType = 100006 THEN 3  WHEN LicUsageType = 100004 THEN 4 END
	END
	ELSE IF @option = 2 -- Get License Usage for Backup, Snapshot, Replication and Archive
	BEGIN
		IF object_id('tempdb.dbo.#VSAJobs') IS NOT NULL DROP TABLE #VSAJobs
        CREATE TABLE #VSAJobs(ParentId INT, ParentName NVARCHAR(255), VMId INT, VMName NVARCHAR(255), ParentJobId INT, ChildJobid INT, JobType INT, JobTypeName VARCHAR(15), SubclientId INT, AppSizeMB BIGINT, Organization NVARCHAR(1024), OrgGUID UNIQUEIDENTIFIER, PlanName NVARCHAR(1024), SubclientName NVARCHAR(255), BackupsetId INT, BackupSetName NVARCHAR(1024), InstanceId INT, InstanceName NVARCHAR(1024), SPId INT, SPName NVARCHAR(1024))
		INSERT #VSAJobs
		SELECT DISTINCT ClientId, ClientName, ClientId, ClientName, JobId, JobId, U1.UsageType, CASE WHEN U1.UsageType=1 THEN 'Backup' WHEN U1.UsageType=2 THEN 'Archive' WHEN U1.UsageType=3 THEN 'Snapshot' WHEN U1.UsageType=4 THEN 'Replication' END,
		SubclientId, AppSizeMB, Organization, OrgGUID, PlanName, 'N/A', 0, 'N/A', 0, 'N/A', 0, 'N/A'
		FROM Lic_CurrentUsage U1 WITH (NOLOCK)
		WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID)
		AND UsageType IN (1,2,3,4) AND CapacityFlag=0 AND U1.AppTypeId=106
		UPDATE U1
		SET U1.ParentJobId=ISNULL(V2.ObjectId,-1), U1.SubclientId=V2.VMFlag
		FROM #VSAJobs U1
		LEFT JOIN Lic_CurrentUsage V2 WITH (NOLOCK) ON V2.SubclientId=U1.SubclientId AND V2.UsageType=U1.JobType
		WHERE V2.UsageType IN (1,2,3,4) AND V2.CapacityFlag=0 AND V2.AppTypeId=106 AND V2.ObjectId>0 AND (@orgGUID IS NULL OR V2.OrgGUID = @orgGUID)
		UPDATE U1
		SET U1.SubclientName=ISNULL(A.subclientName,'N/A'), U1.BackupsetId=ISNULL(B.id,-1), U1.BackupSetName=ISNULL(B.name,'N/A'), U1.InstanceId=ISNULL(I.id,-1), U1.InstanceName=ISNULL(I.name,'N/A'), U1.SPId=ISNULL(AG.id,-1), U1.SPName=ISNULL(AG.name,'N/A')
		, U1.ParentId=ISNULL(A.clientId,-1), U1.ParentName=ISNULL(C.name,'N/A')
		FROM #VSAJobs U1
		LEFT JOIN APP_Application A WITH (NOLOCK) ON A.id=U1.SubclientId
		LEFT JOIN APP_BackupSetName B WITH (NOLOCK) ON B.id=A.backupSet
		LEFT JOIN APP_InstanceName I WITH (NOLOCK) ON I.id=A.instance
		LEFT JOIN archGroup AG WITH (NOLOCK) ON AG.id=A.dataArchGrpID
		LEFT JOIN APP_Client C WITH (NOLOCK) ON A.clientId=C.id
		IF @capacityType = 0
			SELECT 143 AS "License ID", 'Virtual Server' AS License, VMId "Client ID", VMName "Client", 106 AS "Agent ID", 'Virtual Server' AS Agent,
			SubclientId AS "Subclient ID", SubclientName AS Subclient, SPId AS "Storage Policy ID", SPName AS "Storage Policy", BackupSetName AS Backupset,
			InstanceName AS Instance, JobTypeName AS "Job Type", ChildJobId AS "Job ID", AppSizeMB AS Usage, Organization, OrgGUID AS "Organization ID", PlanName As "Plan",
			BackupsetId AS "Backupset ID", InstanceId AS "Instance ID", ParentId AS "Virtualization Client ID", ParentName AS "Virtualization Client", ParentJobId AS "Parent Job ID"
			FROM #VSAJobs
			WHERE JobType=1
			UNION
			SELECT LicType AS "License ID", CASE WHEN Lictype < 1 THEN 'N/A' ELSE LicName END AS License, ClientId AS "Client ID", ClientName AS Client,
			AppTypeId AS "Agent ID", CASE WHEN AppTypeId < 1 THEN 'N/A' ELSE AppTypeName END AS Agent,
			SubclientId AS "Subclient ID", SubclientName AS Subclient, SPId AS "Storage Policy ID", SPName AS "Storage Policy", BackupSetName AS Backupset,
			InstanceName AS Instance, JobType AS "Job Type", JobId AS "Job ID", AppSizeMB AS Usage, Organization, OrgGUID AS "Organization ID", PlanName As "Plan",
			BackupsetId AS "Backupset ID", InstanceId AS "Instance ID", 0, 'N/A', 0
			FROM Lic_CUR_Backups_InCapacity_vw
			WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID)
			AND AppTypeId <> 106
		ELSE IF @capacityType = 1
			SELECT 143 AS "License ID", 'Virtual Server' AS License, VMId "Client ID", VMName "Client", 106 AS "Agent ID", 'Virtual Server' AS Agent,
			SubclientId AS "Subclient ID", SubclientName AS Subclient, SPId AS "Storage Policy ID", SPName AS "Storage Policy", BackupSetName AS Backupset,
			InstanceName AS Instance, JobTypeName AS "Job Type", ChildJobId AS "Job ID", AppSizeMB AS Usage, Organization, OrgGUID AS "Organization ID", PlanName As "Plan",
			BackupsetId AS "Backupset ID", InstanceId AS "Instance ID", ParentId AS "Virtualization Client ID", ParentName AS "Virtualization Client", ParentJobId AS "Parent Job ID"
			FROM #VSAJobs
			WHERE JobType=2
			UNION
			SELECT  LicType AS "License ID", CASE WHEN Lictype < 1 THEN 'N/A' ELSE LicName END AS License, ClientId AS "Client ID", ClientName AS Client,
			AppTypeId AS "Agent ID", CASE WHEN AppTypeId < 1 THEN 'N/A' ELSE AppTypeName END AS Agent,
			SubclientId AS "Subclient ID", SubclientName AS Subclient, SPId AS "Storage Policy ID", SPName AS "Storage Policy", BackupSetName AS Backupset,
			InstanceName AS Instance, JobType AS "Job Type", JobId AS "Job ID", AppSizeMB AS Usage, Organization, OrgGUID AS "Organization ID", PlanName As "Plan",
			BackupsetId AS "Backupset ID", InstanceId AS "Instance ID", 0, 'N/A', 0
			FROM Lic_CUR_Archives_InCapacity_vw
			WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID)
			AND AppTypeId <> 106
		ELSE IF @capacityType = 2
			SELECT 143 AS "License ID", 'Virtual Server' AS License, VMId "Client ID", VMName "Client", 106 AS "Agent ID", 'Virtual Server' AS Agent,
			SubclientId AS "Subclient ID", SubclientName AS Subclient, SPId AS "Storage Policy ID", SPName AS "Storage Policy", BackupSetName AS Backupset,
			InstanceName AS Instance, JobTypeName AS "Job Type", ChildJobId AS "Job ID", AppSizeMB AS Usage, Organization, OrgGUID AS "Organization ID", PlanName As "Plan",
			BackupsetId AS "Backupset ID", InstanceId AS "Instance ID", ParentId AS "Virtualization Client ID", ParentName AS "Virtualization Client", ParentJobId AS "Parent Job ID"
			FROM #VSAJobs
			WHERE JobType=3
			UNION
			SELECT  LicType AS "License ID", CASE WHEN Lictype < 1 THEN 'N/A' ELSE LicName END AS License, ClientId AS "Client ID", ClientName AS Client,
			AppTypeId AS "Agent ID", CASE WHEN AppTypeId < 1 THEN 'N/A' ELSE AppTypeName END AS Agent,
			SubclientId AS "Subclient ID", SubclientName AS Subclient, SPId AS "Storage Policy ID", SPName AS "Storage Policy", BackupSetName AS Backupset,
			InstanceName AS Instance, JobType AS "Job Type", JobId AS "Job ID", AppSizeMB AS Usage, Organization, OrgGUID AS "Organization ID", PlanName As "Plan",
			BackupsetId AS "Backupset ID", InstanceId AS "Instance ID", 0, 'N/A', 0
			FROM Lic_CUR_Snapshots_InCapacity_vw
			WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID)
			AND AppTypeId <> 106
		ELSE IF @capacityType = 3
			SELECT 143 AS "License ID", 'Virtual Server' AS License, VMId "Client ID", VMName "Client", 106 AS "Agent ID", 'Virtual Server' AS Agent,
			SubclientId AS "Subclient ID", SubclientName AS Subclient, SPId AS "Storage Policy ID", SPName AS "Storage Policy", BackupSetName AS Backupset,
			InstanceName AS Instance, JobTypeName AS "Job Type", ChildJobId AS "Job ID", AppSizeMB AS Usage, Organization, OrgGUID AS "Organization ID", PlanName As "Plan",
			BackupsetId AS "Backupset ID", InstanceId AS "Instance ID", ParentId AS "Virtualization Client ID", ParentName AS "Virtualization Client", ParentJobId AS "Parent Job ID"
			FROM #VSAJobs
			WHERE JobType=4
			UNION
			SELECT  LicType AS "License ID", CASE WHEN Lictype < 1 THEN 'N/A' ELSE LicName END AS License, ClientId AS "Client ID", ClientName AS Client,
			AppTypeId AS "Agent ID", CASE WHEN AppTypeId < 1 THEN 'N/A' ELSE AppTypeName END AS Agent,
			SubclientId AS "Subclient ID", SubclientName AS Subclient, SPId AS "Storage Policy ID", SPName AS "Storage Policy", BackupSetName AS Backupset,
			InstanceName AS Instance, JobType AS "Job Type", JobId AS "Job ID", AppSizeMB AS Usage, Organization, OrgGUID AS "Organization ID", PlanName As "Plan",
			BackupsetId AS "Backupset ID", InstanceId AS "Instance ID", 0, 'N/A', 0
			FROM Lic_CUR_Replications_InCapacity_vw
			WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID)
			AND AppTypeId <> 106
		ELSE IF @capacityType = 4
			SELECT 143 AS "License ID", 'Virtual Server' AS License, VMId "Client ID", VMName "Client", 106 AS "Agent ID", 'Virtual Server' AS Agent,
			SubclientId AS "Subclient ID", SubclientName AS Subclient, SPId AS "Storage Policy ID", SPName AS "Storage Policy", BackupSetName AS Backupset,
			InstanceName AS Instance, JobTypeName AS "Job Type", ChildJobId AS "Job ID", AppSizeMB AS Usage, Organization, OrgGUID AS "Organization ID", PlanName As "Plan",
			BackupsetId AS "Backupset ID", InstanceId AS "Instance ID", ParentId AS "Virtualization Client ID", ParentName AS "Virtualization Client", ParentJobId AS "Parent Job ID"
			FROM #VSAJobs
			WHERE JobType IN (1,2)
			UNION
			SELECT  LicType AS "License ID", CASE WHEN Lictype < 1 THEN 'N/A' ELSE LicName END AS License, ClientId AS "Client ID", ClientName AS Client,
			AppTypeId AS "Agent ID", CASE WHEN AppTypeId < 1 THEN 'N/A' ELSE AppTypeName END AS Agent,
			SubclientId AS "Subclient ID", SubclientName AS Subclient, SPId AS "Storage Policy ID", SPName AS "Storage Policy", BackupSetName AS Backupset,
			InstanceName AS Instance, JobType AS "Job Type", JobId AS "Job ID", AppSizeMB AS Usage, Organization, OrgGUID AS "Organization ID", PlanName As "Plan",
			BackupsetId AS "Backupset ID", InstanceId AS "Instance ID", 0, 'N/A', 0
			FROM Lic_CUR_Backups_InCapacity_vw
			WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID)
			AND AppTypeId <> 106
			UNION
			SELECT  LicType AS "License ID", CASE WHEN Lictype < 1 THEN 'N/A' ELSE LicName END AS License, ClientId AS "Client ID", ClientName AS Client,
			AppTypeId AS "Agent ID", CASE WHEN AppTypeId < 1 THEN 'N/A' ELSE AppTypeName END AS Agent,
			SubclientId AS "Subclient ID", SubclientName AS Subclient, SPId AS "Storage Policy ID", SPName AS "Storage Policy", BackupSetName AS Backupset,
			InstanceName AS Instance, JobType AS "Job Type", JobId AS "Job ID", AppSizeMB AS Usage, Organization, OrgGUID AS "Organization ID", PlanName As "Plan",
			BackupsetId AS "Backupset ID", InstanceId AS "Instance ID", 0, 'N/A', 0
			FROM Lic_CUR_Archives_InCapacity_vw
			WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID)
			AND AppTypeId <> 106
		IF object_id('tempdb.dbo.#VSAJobs') IS NOT NULL DROP TABLE #VSAJobs
	END
	ELSE IF @option = 3 -- Get License Summary Usage for Virtualization
	BEGIN
		DECLARE @VSAUsage TABLE(LicUsageType INT, Dial VARCHAR(100), Purchased INT, PermTotal INT,
								Eval INT, Usage INT,  TermDate DATETIME, EvalExpiryDate VARCHAR(12), InputMsg INT)
		DECLARE @VMSocketsPurchased INT = 0
		DECLARE @ProtectedVMsPurchased INT = 0
		INSERT INTO @VSAUsage
		SELECT LicUsageType, LicUsageTypeName As Dial, Purchased, ISNULL(PermTotal, 0) AS PermTotal, ISNULL(EvalTotal, 0)  AS Eval,
		SUM(CASE WHEN @orgGUID IS NULL OR OrgGUID = @orgGUID THEN Usage  ELSE 0 END) Usage,
		ISNULL(TermDate, CONVERT(DATETIME, '1970-01-01 00:00:00.000')) AS TermDate,
		CONVERT(VARCHAR(12),ISNULL(TermDate, CONVERT(DATETIME, '1970-01-01 00:00:00.000')) , 106) As EvalExpiryDate, 0 AS InputMsg
		FROM Lic_CUR_usageSummary_vw
		WHERE LicUsageType IN (100018,100019,100027,100021,100040)-- AND (@orgGUID IS NULL OR OrgGUID = @orgGUID)
		GROUP BY LicUsageType,LicUsageTypeName, Purchased, EvalTotal, TermDate, PermTotal
		ORDER BY CASE WHEN LicUsageType = 100018 THEN 1 WHEN LicUsageType = 100019 THEN 2 WHEN LicUsageType = 100027 THEN 3  WHEN LicUsageType = 100021 THEN 4 WHEN LicUsageType = 100040 THEN 5 END
		SELECT @VMSocketsPurchased = Purchased FROM @VSAUsage WHERE LicUsageType = 100018
		SELECT @ProtectedVMsPurchased = Purchased FROM @VSAUsage WHERE LicUsageType = 100019
		IF @VMSocketsPurchased=0 AND @ProtectedVMsPurchased=0 --(0=not purchased, -1=unlimited purchased, >0=finite quantity purchased)
		BEGIN
			UPDATE @VSAUsage SET InputMsg = 1 WHERE LicUsageType = 100018 --		inputMsg=1;
			UPDATE @VSAUsage SET InputMsg = 1 WHERE LicUsageType = 100019 --		inputMsg=1;
		END
		ELSE
		BEGIN
			IF @VMSocketsPurchased=0
				UPDATE @VSAUsage SET InputMsg = 2 WHERE LicUsageType = 100018 --	inputMsg=2;
			ELSE IF @ProtectedVMsPurchased=0
				UPDATE @VSAUsage SET InputMsg = 2 WHERE LicUsageType = 100019 --	inputMsg=2;
		END
		SELECT * FROM @VSAUsage
	END
	ELSE IF @option = 4 -- Get License Summary Usage for End point
	BEGIN
		SELECT	LicUsageType, LicUsageTypeName As Dial, Purchased, ISNULL(PermTotal, 0) AS PermTotal, ISNULL(EvalTotal, 0)  AS Eval,
				SUM(CASE WHEN @orgGUID IS NULL OR OrgGUID = @orgGUID THEN Usage  ELSE 0 END) Usage,
				ISNULL(TermDate, CONVERT(DATETIME, '1970-01-01 00:00:00.000')) AS TermDate,
				CONVERT(VARCHAR(12), ISNULL(TermDate, CONVERT(DATETIME, '1970-01-01 00:00:00.000')), 106) As EvalExpiryDate
		FROM Lic_CUR_usageSummary_vw
		WHERE LicUsageType IN (100024,100025,100026, 100028) --AND (@orgGUID IS NULL OR OrgGUID = @orgGUID)
		GROUP BY LicUsageType,LicUsageTypeName, Purchased, EvalTotal, TermDate, PermTotal
		ORDER BY CASE WHEN LicUsageType = 100024 THEN 1 WHEN LicUsageType = 100025 THEN 2 WHEN LicUsageType = 100026 THEN 3  WHEN LicUsageType = 100028 THEN 4 END
	END
	ELSE IF @option = 6 -- Get License Summary Usage for other licenses
	BEGIN
		SELECT LicUsageType, LicUsageTypeName As Dial, Purchased, ISNULL(PermTotal, 0) AS PermTotal, ISNULL(EvalTotal, 0)  AS Eval,
				SUM(CASE WHEN @orgGUID IS NULL OR OrgGUID = @orgGUID THEN Usage  ELSE 0 END) Usage,
				ISNULL(TermDate, CONVERT(DATETIME, '1970-01-01 00:00:00.000')) AS TermDate,
				CONVERT(VARCHAR(12), ISNULL(TermDate, CONVERT(DATETIME, '1970-01-01 00:00:00.000')), 106) AS EvalExpiryDate
		FROM Lic_CUR_usageSummary_vw
		WHERE LicUsageType IN (100029, 200017, 200002, 100030, 200001, 200003, 200016, 200021) --AND (@orgGUID IS NULL OR OrgGUID = @orgGUID)
		GROUP BY LicUsageType,LicUsageTypeName, Purchased, EvalTotal, TermDate, PermTotal
		ORDER BY CASE WHEN LicUsageType = 100030 THEN 1 WHEN LicUsageType = 100029 THEN 2 WHEN LicUsageType = -1 THEN 3
		WHEN LicUsageType = 200003 THEN 4 WHEN LicUsageType = 200017 THEN 5 WHEN LicUsageType = 200001 THEN 6 WHEN LicUsageType = -2 THEN 7
		WHEN LicUsageType = 200002 THEN 8 WHEN LicUsageType = 200016 THEN 9 WHEN LicUsageType = 200021 THEN 10 END
	END
	ELSE IF @option = 7 -- Get License Usage for VM Sockets
	BEGIN
		SELECT HypervisorHost AS "Hypervisor Host", Sockets, OrgGUID "Organization ID", Organization, PlanName "Plan"
		FROM Lic_CUR_VMSockets_vw
		WHERE @orgGUID IS NULL OR OrgGUID = @orgGUID
	END
	ELSE IF @option = 8 -- Get License Usage for VM Sockets, Protected VMs Excluded from Capacity
	BEGIN
		--no need to show VSA exclusions if corresponding license is not purchased
		DECLARE @vmSockFlag INT = 0, @protVmFlag INT = 0
		SELECT @vmSockFlag=ISNULL(Purchased,0) FROM Lic_CUR_UsageSummary_vw WHERE LicUsageType=100018
		SELECT @protVmFlag=ISNULL(Purchased,0) FROM Lic_CUR_UsageSummary_vw WHERE LicUsageType=100019
		--capacityType variable will be reused for getting input here
		IF @capacityType=0--call is coming from VM socket details page. Hence show VSA details only if VMSockets license is purchased
		BEGIN
			IF @vmSockFlag<>-1 AND @vmSockFlag<=0
				RETURN
		END
		ELSE IF @capacityType=1--call is coming from protected VM details page. Hence show VSA details only if ProtectedVM license is purchased
		BEGIN
			IF @protVmFlag<>-1 AND @protVmFlag<=0
				RETURN
		END
		IF object_id('tempdb.dbo.#VSAJobsExcluded') IS NOT NULL DROP TABLE #VSAJobsExcluded
        CREATE TABLE #VSAJobsExcluded(ParentId INT, ParentName NVARCHAR(255), VMId INT, VMName NVARCHAR(255), ParentJobId INT, ChildJobid INT, JobTypeName VARCHAR(15), SubclientId INT, AppSizeMB BIGINT, Organization NVARCHAR(1024), OrgGUID UNIQUEIDENTIFIER, PlanName NVARCHAR(1024), SubclientName NVARCHAR(255), BackupsetId INT, BackupSetName NVARCHAR(1024), InstanceId INT, InstanceName NVARCHAR(1024), SPId INT, SPName NVARCHAR(1024))
		INSERT #VSAJobsExcluded
		SELECT DISTINCT ClientId, ClientName, ClientId, ClientName, JobId, JobId, JobType,
		SubclientId, AppSizeMB, Organization, OrgGUID, PlanName, 'N/A', 0, 'N/A', 0, 'N/A', 0, ''
		FROM Lic_CUR_VSAJobs_NotInCapacity_vw U1
		WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID)
		UPDATE U1
		SET U1.ParentJobId=ISNULL(V2.ObjectId,-1), U1.SubclientId=V2.VMFlag
		FROM #VSAJobsExcluded U1
		LEFT JOIN Lic_CurrentUsage V2 WITH (NOLOCK) ON V2.SubclientId=U1.SubclientId AND V2.UsageType=CASE WHEN U1.JobTypeName='Backup' THEN 1 WHEN U1.JobTypeName='Archive' THEN 2 WHEN U1.JobTypeName='Snapshot' THEN 3 ELSE 4 END
		WHERE V2.UsageType IN (1,2,3,4) AND V2.CapacityFlag=1 AND V2.AppTypeId=106 AND V2.ObjectId>0 AND (@orgGUID IS NULL OR V2.OrgGUID = @orgGUID)
		UPDATE U1
		SET U1.SubclientName=ISNULL(A.subclientName,'N/A'), U1.BackupsetId=ISNULL(B.id,-1), U1.BackupSetName=ISNULL(B.name,'N/A'), U1.InstanceId=ISNULL(I.id,-1), U1.InstanceName=ISNULL(I.name,'N/A'), U1.SPId=ISNULL(AG.id,-1), U1.SPName=ISNULL(AG.name,'N/A')
		, U1.ParentId=ISNULL(A.clientId,-1), U1.ParentName=ISNULL(C.name,'N/A')
		FROM #VSAJobsExcluded U1
		LEFT JOIN APP_Application A WITH (NOLOCK) ON A.id=U1.SubclientId
		LEFT JOIN APP_BackupSetName B WITH (NOLOCK) ON B.id=A.backupSet
		LEFT JOIN APP_InstanceName I WITH (NOLOCK) ON I.id=A.instance
		LEFT JOIN archGroup AG WITH (NOLOCK) ON AG.id=A.dataArchGrpID
		LEFT JOIN APP_Client C WITH (NOLOCK) ON A.clientId=C.id
		SELECT 143 AS "License ID", 'Virtual Server' AS License, VMId "Client ID", VMName "Client", 106 AS "Agent ID", 'Virtual Server' AS Agent,
			SubclientId AS "Subclient ID", SubclientName AS Subclient, SPId AS "Storage Policy ID", SPName AS "Storage Policy", BackupSetName AS Backupset,
			InstanceName AS Instance, JobTypeName AS "Job Type", ChildJobId AS "Job ID", AppSizeMB AS Usage, Organization, OrgGUID AS "Organization ID", PlanName As "Plan",
			BackupsetId AS "Backupset ID", InstanceId AS "Instance ID", ParentId AS "Virtualization Client ID", ParentName AS "Virtualization Client", ParentJobId AS "Parent Job ID"
		FROM #VSAJobsExcluded
		IF object_id('tempdb.dbo.#VSAJobsExcluded') IS NOT NULL DROP TABLE #VSAJobsExcluded
	END
	ELSE IF @option = 9 -- Get License Usage for Protected VMs
	BEGIN
		SELECT VMId	"VM ID", VMName "Virtual Machine", VMProtectionJob "VM Protection Job",	ProtectedVMSize "Protected VM Size",
				OrgGUID "Organization ID", Organization, PlanName "Plan"
		FROM Lic_CUR_ProtectedVMs_vw
		WHERE @orgGUID IS NULL OR OrgGUID = @orgGUID
	END
	ELSE IF @option = 10  -- Get License Summary Usage for Other Licenses
	BEGIN
		SELECT LicUsageType, LicUsageTypeName As Dial, Purchased, ISNULL(PermTotal, 0) AS PermTotal, ISNULL(EvalTotal, 0)  AS Eval,
                 ROUND(CASE WHEN LicUsageType = 100017 THEN SUM(Usage)/(1000.00*1000.00) ELSE SUM(Usage)/(1024.00*1024.00) END, 2) AS Usage,
                 TermDate, CASE WHEN TermDate =  CONVERT(DATE, '01-01-1970') THEN 'N/A' ELSE CONVERT(VARCHAR(12), TermDate, 106) END As EvalExpiryDate
        FROM Lic_CUR_usageSummary_vw where LicUsageType IN (100015,100016,100017,100031,-1)
        GROUP BY LicUsageType,LicUsageTypeName, Purchased, EvalTotal, TermDate, PermTotal
        ORDER BY CASE WHEN LicUsageType = 100031 THEN 1 WHEN LicUsageType = 100016 THEN 2 WHEN LicUsageType = 100015 THEN 3  WHEN LicUsageType = 200001 THEN 4 WHEN LicUsageType = 100017 THEN 5 WHEN LicUsageType = -1 THEN 6 END
	END
	ELSE IF @option = 11 -- Get License Usage for ACV Licenses
	BEGIN
		SELECT VMId	"VM ID", VMName "Virtual Machine", Package, isVMProtected "Is VM Protected", VMProtectionJob "VM Protection Job",
			ProtectedVMSize "Protected VM Size",OrgGUID "Organization ID", Organization, PlanName "Plan"
		FROM Lic_CUR_ACVs_vw
		WHERE @orgGUID IS NULL OR OrgGUID = @orgGUID
	END
	ELSE IF @option = 12 -- Get License Usage for ACVs excluded from Capacity
	BEGIN
		SELECT LicType "License ID", CASE WHEN Lictype < 1 THEN 'N/A' ELSE LicName END License, ClientId "Client ID",	ClientName Client, AppTypeId "Agent ID", AppTypeName Agent, SubclientId "Subclient ID", SubclientName Subclient,
				SPId "Storage Policy ID", SPName "Storage Policy", BackupSetName "Backupset", InstanceName "Instance", JobType "Job Type", JobId "Job ID",
				AppSizeMB "Usage", OrgGUID "Organization ID", Organization, PlanName "Plan", BackupSetId "Backupset ID", InstanceId "Instance ID"
		FROM Lic_CUR_ACVJobs_NotInCapacity_vw
		WHERE @orgGUID IS NULL OR OrgGUID = @orgGUID
	END
	ELSE IF @option = 13 -- Get License Usage for Archived VMs
	BEGIN
		SELECT  VMId	"VM ID", VMName "Virtual Machine", VMArchiveJob "VM Archived Job",
			ArchivedVMSize "Archived VM Size",OrgGUID "Organization ID", Organization, PlanName "Plan"
		FROM Lic_CUR_ArchivedVMs_vw
		WHERE @orgGUID IS NULL OR OrgGUID = @orgGUID
	END
	ELSE IF @option = 14 -- Get License Usage for Archived VMs excluded from Capacity
	BEGIN
		IF object_id('tempdb.dbo.#ArchVMJobsExcluded') IS NOT NULL DROP TABLE #ArchVMJobsExcluded
        CREATE TABLE #ArchVMJobsExcluded(ParentId INT, ParentName NVARCHAR(255), VMId INT, VMName NVARCHAR(255), ParentJobId INT, ChildJobid INT, JobTypeName VARCHAR(15), SubclientId INT, AppSizeMB BIGINT, Organization NVARCHAR(1024), OrgGUID UNIQUEIDENTIFIER, PlanName NVARCHAR(1024), SubclientName NVARCHAR(255), BackupsetId INT, BackupSetName NVARCHAR(1024), InstanceId INT, InstanceName NVARCHAR(1024), SPId INT, SPName NVARCHAR(1024))
		INSERT #ArchVMJobsExcluded
		SELECT DISTINCT ClientId, ClientName, ClientId, ClientName, JobId, JobId, JobType,
		SubclientId, AppSizeMB, Organization, OrgGUID, PlanName, 'N/A', 0, 'N/A', 0, 'N/A', 0, ''
		FROM Lic_CUR_ArchviedVMJobs_NotInCapacity_vw U1
		WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID)
		UPDATE U1
		SET U1.ParentJobId=ISNULL(V2.ObjectId,-1), U1.SubclientId=V2.VMFlag
		FROM #ArchVMJobsExcluded U1
		LEFT JOIN Lic_CurrentUsage V2 WITH (NOLOCK) ON V2.SubclientId=U1.SubclientId AND V2.UsageType=CASE WHEN U1.JobTypeName='Backup' THEN 1 WHEN U1.JobTypeName='Archive' THEN 2 WHEN U1.JobTypeName='Snapshot' THEN 3 ELSE 4 END
		WHERE V2.UsageType IN (1,2,3,4) AND V2.CapacityFlag=32 AND V2.AppTypeId=106 AND V2.ObjectId>0 AND (@orgGUID IS NULL OR V2.OrgGUID = @orgGUID)
		UPDATE U1
		SET U1.SubclientName=ISNULL(A.subclientName,'N/A'), U1.BackupsetId=ISNULL(B.id,-1), U1.BackupSetName=ISNULL(B.name,'N/A'), U1.InstanceId=ISNULL(I.id,-1), U1.InstanceName=ISNULL(I.name,'N/A'), U1.SPId=ISNULL(AG.id,-1), U1.SPName=ISNULL(AG.name,'N/A')
		, U1.ParentId=ISNULL(A.clientId,-1), U1.ParentName=ISNULL(C.name,'N/A')
		FROM #ArchVMJobsExcluded U1
		LEFT JOIN APP_Application A WITH (NOLOCK) ON A.id=U1.SubclientId
		LEFT JOIN APP_BackupSetName B WITH (NOLOCK) ON B.id=A.backupSet
		LEFT JOIN APP_InstanceName I WITH (NOLOCK) ON I.id=A.instance
		LEFT JOIN archGroup AG WITH (NOLOCK) ON AG.id=A.dataArchGrpID
		LEFT JOIN APP_Client C WITH (NOLOCK) ON A.clientId=C.id
		SELECT 143 AS "License ID", 'Virtual Server' AS License, VMId "Client ID", VMName "Client", 106 AS "Agent ID", 'Virtual Server' AS Agent,
			SubclientId AS "Subclient ID", SubclientName AS Subclient, SPId AS "Storage Policy ID", SPName AS "Storage Policy", BackupSetName AS Backupset,
			InstanceName AS Instance, JobTypeName AS "Job Type", ChildJobId AS "Job ID", AppSizeMB AS Usage, Organization, OrgGUID AS "Organization ID", PlanName As "Plan",
			BackupsetId AS "Backupset ID", InstanceId AS "Instance ID", ParentId AS "Virtualization Client ID", ParentName AS "Virtualization Client", ParentJobId AS "Parent Job ID"
		FROM #ArchVMJobsExcluded
		IF object_id('tempdb.dbo.#ArchVMJobsExcluded') IS NOT NULL DROP TABLE #ArchVMJobsExcluded
	END
	ELSE IF @option = 15 -- Get License Usage for End point Users
	BEGIN
		SELECT UserId "User ID", UserName "User Name", UserLogin "User Login", UserEmail "E Mail", Associations, OrgGUID "Organization ID", Organization, PlanName "Plan"
		FROM Lic_CUR_EpUsers_vw
		WHERE @orgGUID IS NULL OR OrgGUID = @orgGUID
	END
	ELSE IF @option = 16 -- Get License Usage for DLP excluded from Capacity
	BEGIN
		SELECT LicType "License ID", CASE WHEN Lictype < 1 THEN 'N/A' ELSE LicName END License, ClientId "Client ID",	ClientName Client, AppTypeId "Agent ID", AppTypeName Agent, SubclientId "Subclient ID", SubclientName Subclient,
				SPId "Storage Policy ID", SPName "Storage Policy", BackupSetName "Backupset", InstanceName "Instance", JobType "Job Type", JobId "Job ID",
				AppSizeMB "Usage", OrgGUID "Organization ID", Organization, PlanName "Plan", BackupSetId "Backupset ID", InstanceId "Instance ID"
		FROM Lic_CUR_DLPJobs_NotInCapacity_vw
		WHERE @orgGUID IS NULL OR OrgGUID = @orgGUID
	END
	ELSE IF @option = 17 -- Get License Usage for Endpoint Sharing users
	BEGIN
		SELECT UserId "User ID", UserName "User Name", UserLogin "User Login", UserEmail "E Mail", Associations, OrgGUID "Organization ID", Organization, PlanName "Plan"
		FROM Lic_CUR_EpSharingUsers_vw
		WHERE @orgGUID IS NULL OR OrgGUID = @orgGUID
	END
	ELSE IF @option = 19 -- Get License Usage for EDiscovery USers
	BEGIN
		SELECT UserId "User ID", UserName "User Name", UserLogin "User Login", UserEmail "E Mail", Associations, OrgGUID "Organization ID", Organization, PlanName "Plan"
		FROM Lic_CUR_EpEDiscoveryUsers_vw
		WHERE @orgGUID IS NULL OR OrgGUID = @orgGUID
	END
	ELSE IF @option = 21 -- Get License Usage for File Systems Only Server without Usage
	BEGIN
		SELECT ClientId "Client ID", ClientName Client, OrgGUID "Organization ID", Organization, PlanName "Plan", LicType "License ID", CASE WHEN Lictype < 1 THEN 'N/A' ELSE LicName END License
		FROM Lic_CUR_FSonlyServersWithoutUsage_vw
		WHERE @orgGUID IS NULL OR OrgGUID = @orgGUID
	END
	ELSE IF @option = 22  -- Get License Usage for File System Only servers with Usage
	BEGIN
		SELECT  LicType "License ID", CASE WHEN Lictype < 1 THEN 'N/A' ELSE LicName END License, ActualLicType "Actual License ID", CASE WHEN ActualLicType < 1 THEN 'N/A' ELSE ActualLicName END "Actual License",
				ClientId "Client ID", ClientName Client, AppTypeId "Agent ID", AppTypeName Agent, SubclientId "Subclient ID", SubclientName Subclient,
				SPId "Storage Policy ID", SPName "Storage Policy", BackupSetName "Backupset", InstanceName "Instance", JobType "Job Type", JobId "Job ID",
				AppSizeMB "Usage", OrgGUID "Organization ID", Organization, PlanName "Plan", BackupSetId "Backupset ID", InstanceId "Instance ID"
		FROM Lic_CUR_FSonlyServersWithUsage_vw
		WHERE @orgGUID IS NULL OR OrgGUID = @orgGUID
	END
	ELSE IF @option = 23  -- Get License Usage for DL Only with Usage
	BEGIN
		SELECT ClientId "Client ID", ClientName Client, OrgGUID "Organization ID", Organization, PlanName "Plan"
		FROM Lic_CUR_DLOsWithoutUsage_vw
		WHERE @orgGUID IS NULL OR OrgGUID = @orgGUID
	END
	ELSE IF @option = 24   -- Get License Usage for DL Only without Usage
	BEGIN
		SELECT  LicType "License ID", CASE WHEN Lictype < 1 THEN 'N/A' ELSE LicName END License, ClientId "Client ID",	ClientName Client, AppTypeId "Agent ID", AppTypeName Agent, SubclientId "Subclient ID", SubclientName Subclient,
				SPId "Storage Policy ID", SPName "Storage Policy", BackupSetName "Backupset", InstanceName "Instance", JobType "Job Type", JobId "Job ID",
				AppSizeMB "Usage", OrgGUID "Organization ID", Organization, PlanName "Plan", BackupSetId "Backupset ID", InstanceId "Instance ID"
		FROM Lic_CUR_DLOsWithUsage_vw
		WHERE @orgGUID IS NULL OR OrgGUID = @orgGUID
	END
	ELSE IF @option = 25  -- Get License Usage for Application Servers without Usage
	BEGIN
		SELECT ClientId "Client ID", ClientName Client, OrgGUID "Organization ID", Organization, PlanName "Plan"
		FROM Lic_CUR_AppServersWithoutUsage_vw
		WHERE @orgGUID IS NULL OR OrgGUID = @orgGUID
	END
	ELSE IF @option = 26 -- Get License Usage for Application Servers with Usage
	BEGIN
		SELECT  LicType "License ID", CASE WHEN Lictype < 1 THEN 'N/A' ELSE LicName END License, ClientId "Client ID",	ClientName Client, AppTypeId "Agent ID", AppTypeName Agent, SubclientId "Subclient ID", SubclientName Subclient,
				SPId "Storage Policy ID", SPName "Storage Policy", BackupSetName "Backupset", InstanceName "Instance", JobType "Job Type", JobId "Job ID",
				AppSizeMB "Usage", OrgGUID "Organization ID", Organization, PlanName "Plan", BackupSetId "Backupset ID", InstanceId "Instance ID"
		FROM Lic_CUR_AppServersWithUsage_vw
		WHERE @orgGUID IS NULL OR OrgGUID = @orgGUID
	END
	ELSE IF @option = 27  -- Get License Usage for VM Only
	BEGIN
		SELECT   VMId "VM ID", VMName "Virtual Machine", VMProtectionJob "VM Protection Job",	ProtectedVMSize "Protected VM Size",
				OrgGUID "Organization ID", Organization, PlanName "Plan"
		FROM Lic_CUR_VMOnly_vw
		WHERE @orgGUID IS NULL OR OrgGUID = @orgGUID
	END
	ELSE IF @option = 28  -- Get License Usage for Advanced VMs
	BEGIN
		SELECT   VMId "VM ID", VMName "Virtual Machine", Package, VMProtectionJob "VM Protection Job",	ProtectedVMSize "Protected VM Size",
				OrgGUID "Organization ID", Organization, PlanName "Plan"
		FROM Lic_CUR_VMWithApps_vw
		WHERE @orgGUID IS NULL OR OrgGUID = @orgGUID
	END
	ELSE IF @option = 29 -- Get License Usage for Application Users
	BEGIN
		--get sharepoint online users
		IF object_id('tempdb.dbo.#AppUsers') IS NOT NULL DROP TABLE #AppUsers
        CREATE TABLE #AppUsers(Smtp NVARCHAR(1024), OrgGUID UNIQUEIDENTIFIER, Organization NVARCHAR(1024), PlanName NVARCHAR(1024), LicName VARCHAR(128), VMFlag INT)
		INSERT #AppUsers
		SELECT DISTINCT Smtp, OrgGUID, Organization, PlanName, LicName, VMFlag
		FROM Lic_CUR_ApplicationUsers_vw
		WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID)
		AND LicType=200012
		--remove rows with default plan if any row with non-default plan is present for the same user
		DELETE A1 FROM #AppUsers A1
		INNER JOIN #AppUsers A2 ON A1.Smtp=A2.Smtp AND (A1.OrgGUID=A2.OrgGUID OR (A1.OrgGUID IS NULL AND A2.OrgGUID IS NULL))
		WHERE A1.planname IS NULL AND A2.PlanName IS NOT NULL
		--get the rest of the application users
		INSERT #AppUsers
		SELECT DISTINCT Smtp, OrgGUID, Organization, PlanName, LicName, VMFlag
		FROM Lic_CUR_ApplicationUsers_vw
		WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID)
		AND LicType<>200012
		--find whether compliance search, content indexing and case manager is enabled for each user
		DECLARE @enablerTable TABLE (SMTP NVARCHAR(1024), OrgGUID UNIQUEIDENTIFIER, enabler INT)
		INSERT INTO @enablerTable
		SELECT DISTINCT Smtp, OrgGUID, ISNULL(SUM(DISTINCT p),0)
		FROM #AppUsers Usage
		OUTER APPLY
		(SELECT p FROM
			(SELECT POWER(2,n) FROM
				(VALUES (0),(1),(2)) Nos(n)
			)Powers(p)
			WHERE p&Usage.VMFlag = p
		)Bitmask
		WHERE @orgGUID IS NULL OR OrgGUID = @orgGUID
		GROUP BY Smtp,OrgGUID
		--summarize all appuser details
		SELECT Smtp AS SMTP, OrgGUID "Organization ID", Organization, "Plan", CASE WHEN [Exchange Mailbox] > 0 THEN 1 ELSE 0 END "Exchange Mailbox",
		CASE WHEN [Exchange OnePass] > 0 THEN 1 ELSE 0 END "Exchange OnePass", CASE WHEN [SharePoint Online] > 0 THEN 1 ELSE 0 END "SharePoint Online",
		CASE WHEN [Gmail] > 0 THEN 1 ELSE 0 END "Gmail", CASE WHEN [GDrive] > 0 THEN 1 ELSE 0 END "GDrive", CASE WHEN [OneDrive] > 0 THEN 1 ELSE 0 END "OneDrive",
		CASE WHEN [Salesforce] > 0 THEN 1 ELSE 0 END "Salesforce", CASE WHEN [Notes] > 0 THEN 1 ELSE 0 END "Notes",
		CASE WHEN Checker&1>0 THEN 1 ELSE 0 END AS 'CI Enabled', CASE WHEN Checker&2>0 THEN 1 ELSE 0 END AS 'CM Enabled', CASE WHEN Checker&4>0 THEN 1 ELSE 0 END AS 'CS Enabled'
		FROM (
			SELECT Usage.Smtp, Usage.OrgGUID, Organization, PlanName AS "Plan", LicName, E.enabler AS Checker
			FROM #AppUsers Usage
			LEFT JOIN
			@enablerTable E ON Usage.Smtp = E.SMTP AND (Usage.OrgGUID = E.OrgGUID OR (Usage.OrgGUID IS NULL AND E.OrgGUID IS NULL))
			WHERE @orgGUID IS NULL OR Usage.OrgGUID = @orgGUID
		) AS SourceTable
		PIVOT
		(
			COUNT(LicName)
			FOR LicName IN ([Exchange Mailbox],[Exchange OnePass],[SharePoint Online],[Gmail],[GDrive],[OneDrive],[Salesforce],[Notes])
		) AS PivotTable
		IF object_id('tempdb.dbo.#AppUsers') IS NOT NULL DROP TABLE #AppUsers
	END
	ELSE IF @option = 30 -- Get License Usage for Application Users not in Capacity
	BEGIN
		SELECT LicType "License ID", CASE WHEN Lictype < 1 THEN 'N/A' ELSE LicName END License, ClientId "Client ID",	ClientName Client, AppTypeId "Agent ID", AppTypeName Agent, SubclientId "Subclient ID", SubclientName Subclient,
				SPId "Storage Policy ID", SPName "Storage Policy", BackupSetName "Backupset", InstanceName "Instance", JobType "Job Type", JobId "Job ID",
				AppSizeMB "Usage", OrgGUID "Organization ID", Organization, PlanName "Plan", BackupSetId "Backupset ID", InstanceId "Instance ID"
		FROM Lic_CUR_AppUserJobs_NotInCapacity_vw
		WHERE @orgGUID IS NULL OR OrgGUID = @orgGUID
	END
	ELSE IF @option = 31 -- Get License Usage for Edge drive excluded from Capacity
	BEGIN
		SELECT LicType "License ID", CASE WHEN Lictype < 1 THEN 'N/A' ELSE LicName END License, ClientId "Client ID",	ClientName Client, AppTypeId "Agent ID", AppTypeName Agent, SubclientId "Subclient ID", SubclientName Subclient,
				SPId "Storage Policy ID", SPName "Storage Policy", BackupSetName "Backupset", InstanceName "Instance", JobType "Job Type", JobId "Job ID",
				AppSizeMB "Usage", OrgGUID "Organization ID", Organization, PlanName "Plan", BackupSetId "Backupset ID", InstanceId "Instance ID"
		FROM Lic_CUR_EdgeDriveJobs_NotInCapacity_vw
		WHERE @orgGUID IS NULL OR OrgGUID = @orgGUID
	END
	ELSE IF @option = 32  -- Get License Usage for Agent and Features Licenses
	BEGIN
		SELECT LicType "License ID", CASE WHEN Lictype < 1 THEN 'N/A' ELSE LicName END License, PermTotal "Permanent Total", PermUsed "Permanent Used", EvalTotal "Evaluation Total",
				EvalUsed "Evaluation Used", CASE WHEN TermDate =  CONVERT(DATE, '01-01-1970') THEN NULL ELSE TermDate END "Term End Date",
				ClientId "Client ID", ClientName "Client", AppTypeId "Agent ID", CASE WHEN AppTypeId<=0 THEN '' ELSE ApptypeName END "Agent",
				CASE WHEN InstallDate = CONVERT(DATE, '01-01-1970') THEN NULL ELSE InstallDate END "Install Date"
		FROM Lic_CUR_AgentfeatureLicenses_vw
	END
	ELSE IF @option = 33  -- Get Organization name and GUID
	BEGIN
		SELECT '-1' AS OrgGUID, 'Commcell' AS Organization, 0 AS RowID
		UNION ALL
		SELECT OrgGUID, Organization,  ROW_NUMBER() OVER(ORDER BY Organization) AS RowID FROM
		(SELECT DISTINCT CONVERT(VARCHAR(100),GUID) OrgGUID, domainName Organization FROM UMDSProviders WITH(NOLOCK) WHERE serviceType=5 AND flags=0)T
		ORDER BY RowID
	END
	ELSE IF @option = 34 -- Get Last Collection Timestamp
	BEGIN
		DECLARE @expiry DATETIME = '1970-01-01 00:00:00.000'
		SELECT TOP 1 @expiry=ExpiryDate FROM Lic_CUR_AgentfeatureLicenses_vw
		SELECT CONVERT(DATETIME, SWITCHOFFSET(CONVERT(DATETIMEOFFSET, commserv.dbo.GetDateTimeBig(value)), @timezone)) 'Last Collection Time'
		, CASE WHEN @expiry=CONVERT(DATE, '01-01-1970') THEN 'N/A' ELSE FORMAT(@expiry, 'MMM dd, yyyy') END AS 'License Expiry'
		FROM commserv.dbo.GXGlobalParam WITH(NOLOCK) WHERE name='LicCurrentUsageCollectionTime'
	END
	ELSE IF @option = 35 -- Get License Summary for File Systems Only Servers & VMs
	BEGIN
		DECLARE @fsonlyTbl TABLE(LicType INT, LicName VARCHAR(32), Used INT)
		INSERT INTO @fsonlyTbl VALUES (100029, 'File System only Server',0), (200017, 'File System only VM',0)
		UPDATE T SET T.Used=F.Used
		FROM @fsonlyTbl T
		INNER JOIN
		(
			SELECT LicType, COUNT(DISTINCT ClientId) Used
			FROM Lic_CUR_FSonlyServers_vw
			WHERE @orgGUID IS NULL OR OrgGUID = @orgGUID
			GROUP BY LicType
		)F ON F.LicType=T.LicType
		SELECT LicType "License ID", LicName "License", Used FROM @fsonlyTbl
	END
	ELSE IF @option = 36 -- Get Live Sync pairs for VMs
	BEGIN
		SELECT SourceClientId "Source ID", SourceClientName "Source Name", SourceGUID "Source GUID", DestinationName "Destination Name",
		OrgGUID "Organization ID", Organization, PlanName "Plan"
		FROM Lic_CUR_LiveSyncForVM_vw
		WHERE @orgGUID IS NULL OR OrgGUID = @orgGUID
	END
	ELSE IF @option = 37 -- Get License Summary Usage for OI/VOI licenses
	BEGIN
		DECLARE @summaryTbl TABLE(LicUsageType INT, Dial NVARCHAR(50), Purchased BIGINT, PermTotal BIGINT, Eval BIGINT, Usage BIGINT, TermDate DATETIME, EvalExpiryDate VARCHAR(12))
		INSERT @summaryTbl
		SELECT LicUsageType, LicUsageTypeName As Dial, Purchased, ISNULL(PermTotal, 0) AS PermTotal, ISNULL(EvalTotal, 0)  AS Eval,
				SUM(CASE WHEN @orgGUID IS NULL OR OrgGUID = @orgGUID THEN Usage ELSE 0 END) Usage,
				ISNULL(TermDate, CONVERT(DATETIME, '1970-01-01 00:00:00.000')) AS TermDate,
				CONVERT(VARCHAR(12), ISNULL(TermDate, CONVERT(DATETIME, '1970-01-01 00:00:00.000')), 106) AS EvalExpiryDate
		FROM Lic_CUR_UsageSummary_vw
		WHERE LicUsageType IN (100032, 100033)
		GROUP BY LicUsageType,LicUsageTypeName, Purchased, EvalTotal, TermDate, PermTotal
		IF @orgGUID IS NULL--swapped OI/VOI count needs to be shown only when the report is viewed at commcell level
		BEGIN
			DECLARE @nOIUsers INT = 0, @nVOIUsers INT = 0, @nVOIToOI INT = 0, @isOIValid INT = 0, @isVOIValid INT = 0
			SELECT @nOIUsers=ISNULL(Usage,0) FROM @summaryTbl WHERE LicUsageType = 100032
			SELECT @nVOIUsers=ISNULL(Usage,0) FROM @summaryTbl WHERE LicUsageType = 100033
			EXEC LicCheckOIStatus '', 0, 0, @isOIValid OUTPUT, @isVOIValid OUTPUT
			IF @isOIValid > 0 AND @isVOIValid = 0
				SET @nVOIToOI=@nVOIUsers
			ELSE IF @isOIValid > 0 AND @isVOIValid > 0 AND @nVOIUsers > 0
				EXEC LicVOIToOI @nVOIUsers, @nOIUsers, @nVOIToOI OUTPUT
			IF @nVOIToOI > 0
			BEGIN
				UPDATE @summaryTbl SET Dial=Dial+' *(includes '+CONVERT(VARCHAR(10),@nVOIToOI) +' Virtual OI)', Usage=Usage+@nVOIToOI WHERE LicUsageType=100032
				UPDATE @summaryTbl SET Usage=Usage-@nVOIToOI WHERE LicUsageType=100033
			END
		END
		SELECT * FROM @summaryTbl
		ORDER BY CASE WHEN LicUsageType = 100032 THEN 1 WHEN LicUsageType = 100033 THEN 2 END
	END
	ELSE IF @option = 38  -- Get License Usage for OI
	BEGIN
		SELECT ClientId "Client ID", ClientName Client, OICount "Number of Operating Instances", OrgGUID "Organization ID", Organization, PlanName "Plan"
		FROM Lic_CUR_OIs_vw
		WHERE @orgGUID IS NULL OR OrgGUID = @orgGUID
	END
	ELSE IF @option = 39  -- Get License Usage for VOI
	BEGIN
		SELECT ClientId "Client ID", ClientName Client, OrgGUID "Organization ID", Organization, PlanName "Plan"
		FROM Lic_CUR_VOIs_vw
		WHERE @orgGUID IS NULL OR OrgGUID = @orgGUID
	END
	ELSE IF @option = 40 -- Get License Usage from OIs not in Capacity
	BEGIN
		SELECT LicType "License ID", CASE WHEN Lictype < 1 THEN 'N/A' ELSE LicName END License, ClientId "Client ID",	ClientName Client, AppTypeId "Agent ID", AppTypeName Agent, SubclientId "Subclient ID", SubclientName Subclient,
				SPId "Storage Policy ID", SPName "Storage Policy", BackupSetName "Backupset", InstanceName "Instance", JobType "Job Type", JobId "Job ID",
				AppSizeMB "Usage", OrgGUID "Organization ID", Organization, PlanName "Plan", BackupSetId "Backupset ID", InstanceId "Instance ID"
		FROM Lic_CUR_OIJobs_NotInCapacity_vw
		WHERE @orgGUID IS NULL OR OrgGUID = @orgGUID
	END
	ELSE IF @option = 41 -- Get License Usage from VOIs not in Capacity
	BEGIN
		SELECT LicType "License ID", CASE WHEN Lictype < 1 THEN 'N/A' ELSE LicName END License, ClientId "Client ID",	ClientName Client, AppTypeId "Agent ID", AppTypeName Agent, SubclientId "Subclient ID", SubclientName Subclient,
				SPId "Storage Policy ID", SPName "Storage Policy", BackupSetName "Backupset", InstanceName "Instance", JobType "Job Type", JobId "Job ID",
				AppSizeMB "Usage", OrgGUID "Organization ID", Organization, PlanName "Plan", BackupSetId "Backupset ID", InstanceId "Instance ID"
		FROM Lic_CUR_VOIJobs_NotInCapacity_vw
		WHERE @orgGUID IS NULL OR OrgGUID = @orgGUID
	END
	ELSE IF @option = 42 --Get NFS Object Store usage details
	BEGIN
		SELECT  LicType AS "License ID", CASE WHEN Lictype < 1 THEN 'N/A' ELSE L.short_name END AS License, JobId "Job ID", ClientId AS "Client ID", ClientName AS Client,
			AppTypeId AS "Agent ID", CASE WHEN AppTypeId < 1 THEN 'N/A' ELSE A.name END AS Agent, InstanceId AS "Instance ID", InstanceName AS Instance,
			BackupsetId AS "Backupset ID", BackupSetName AS Backupset, SubclientId AS "Subclient ID", SubclientName AS Subclient, SPId AS "Storage Policy ID", SPName AS "Storage Policy",
			AppSizeMB AS Usage, OrgGUID AS "Organization ID", Organization, PlanName As "Plan"
		FROM Lic_CurrentUsage WITH (NOLOCK)
		LEFT JOIN simLicAppTypeV2 AS L WITH (NOLOCK) ON L.id = dbo.Lic_CurrentUsage.LicType
		LEFT JOIN APP_iDAType AS A WITH (NOLOCK) ON A.type = dbo.Lic_CurrentUsage.AppTypeId
		WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID)
		AND UsageType=32
	END
	ELSE IF @option = 43 -- Get Hyper Scale usage
	BEGIN
		SELECT StoragePoolId "Storage Pool ID", StoragePoolName "Storage Pool Name", TotalCapacityMB "Total Capacity", UsedCapacityMB "Used Capacity", ApplianceType "Appliance Type",
		OrgGUID "Organization ID", Organization, PlanName "Plan"
		FROM Lic_CUR_HyperScale_vw
		WHERE @orgGUID IS NULL OR OrgGUID = @orgGUID
	END
	ELSE IF @option = 44 -- Get DR VM usage
	BEGIN
		SELECT SourceVMId "Source VM ID", SourceVMName "Source VM Name",
		OrgGUID "Organization ID", Organization, PlanName "Plan"
		FROM Lic_CUR_DRVM_vw
		WHERE @orgGUID IS NULL OR OrgGUID = @orgGUID
	END
	ELSE IF @option = 45 -- Get License Usage from DRVMs not in Capacity
	BEGIN
		SELECT LicType "License ID", CASE WHEN Lictype < 1 THEN 'N/A' ELSE LicName END License, ClientId "Client ID",	ClientName Client, AppTypeId "Agent ID", AppTypeName Agent, SubclientId "Subclient ID", SubclientName Subclient,
				SPId "Storage Policy ID", SPName "Storage Policy", BackupSetName "Backupset", InstanceName "Instance", JobType "Job Type", JobId "Job ID",
				AppSizeMB "Usage", OrgGUID "Organization ID", Organization, PlanName "Plan", BackupSetId "Backupset ID", InstanceId "Instance ID"
		FROM Lic_CUR_DRVMJobs_NotInCapacity_vw
		WHERE @orgGUID IS NULL OR OrgGUID = @orgGUID
	END
	ELSE IF @option = 46 -- Get License Summary Usage for Activate
	BEGIN
		SELECT	LicUsageType, LicUsageTypeName As Dial, Purchased, ISNULL(PermTotal, 0) AS PermTotal, ISNULL(EvalTotal, 0)  AS Eval,
				CASE WHEN LicUsageType IN (100035,100037) THEN SUM(CASE WHEN @orgGUID IS NULL OR OrgGUID = @orgGUID THEN Usage  ELSE 0 END) ELSE SUM(CASE WHEN @orgGUID IS NULL OR OrgGUID = @orgGUID THEN Usage  ELSE 0 END)/(1024.00*1024.00) END Usage,
				ISNULL(TermDate, CONVERT(DATETIME, '1970-01-01 00:00:00.000')) AS TermDate,
				CONVERT(VARCHAR(12), ISNULL(TermDate, CONVERT(DATETIME, '1970-01-01 00:00:00.000')), 106) As EvalExpiryDate
		FROM Lic_CUR_usageSummary_vw
		WHERE LicUsageType IN (100034,100035,100036,100037,100038) --AND (@orgGUID IS NULL OR OrgGUID = @orgGUID)
		GROUP BY LicUsageType,LicUsageTypeName, Purchased, EvalTotal, TermDate, PermTotal
		ORDER BY CASE WHEN LicUsageType = 100038 THEN 1 WHEN LicUsageType = 100034 THEN 2 WHEN LicUsageType = 100035 THEN 3 WHEN LicUsageType = 100036 THEN 4 WHEN LicUsageType = 100037 THEN 5 END
	END
	ELSE IF @option = 47 -- Get License Summary Usage for Metallic
	BEGIN
		--MR 296251 - Metallic Licenses T2 to T10 should be displayed only if it is purchased
		DECLARE @metallic TABLE(LicUsageType INT, LicUsageTypeName VARCHAR(50), Usage BIGINT, OrgGUID UNIQUEIDENTIFIER, Organization NVARCHAR(1024), Purchased INT, PermTotal INT, EvalTotal INT, TermDate DATETIME)
		INSERT @metallic
		SELECT	LicUsageType, LicUsageTypeName, Usage, OrgGUID, ISNULL(Organization,''), Purchased, PermTotal, EvalTotal, ISNULL(TermDate,'1970-01-01 00:00:00.000')
		FROM Lic_CUR_usageSummary_vw
		WHERE LicUsageType IN (100041,100042,100043,100044,100045,100046,100047,100048,100049,100050) --AND (@orgGUID IS NULL OR OrgGUID = @orgGUID)
		AND ((LicUsageType=100041) OR (LicUsageType<>100041 AND Purchased>0))
		SELECT	LicUsageType, LicUsageTypeName As Dial, Purchased, ISNULL(PermTotal, 0) AS PermTotal, ISNULL(EvalTotal, 0)  AS Eval,
				SUM(CASE WHEN @orgGUID IS NULL OR OrgGUID = @orgGUID THEN Usage  ELSE 0 END)/(1024.00*1024.00) Usage,
				ISNULL(TermDate, CONVERT(DATETIME, '1970-01-01 00:00:00.000')) AS TermDate,
				CONVERT(VARCHAR(12), ISNULL(TermDate, CONVERT(DATETIME, '1970-01-01 00:00:00.000')), 106) As EvalExpiryDate
		FROM @metallic
		GROUP BY LicUsageType,LicUsageTypeName, Purchased, EvalTotal, TermDate, PermTotal
		ORDER BY CASE WHEN LicUsageType = 100041 THEN 1 WHEN LicUsageType = 100042 THEN 2 WHEN LicUsageType = 100043 THEN 3 WHEN LicUsageType = 100044 THEN 4 WHEN LicUsageType = 100045 THEN 5
		WHEN LicUsageType = 100046 THEN 6 WHEN LicUsageType = 100047 THEN 7 WHEN LicUsageType = 100048 THEN 8 WHEN LicUsageType = 100049 THEN 9 WHEN LicUsageType = 100050 THEN 10 END
	END
	ELSE IF @option = 48 -- Get Activate usage details
	BEGIN
		SET @sqlQuery = N'SELECT'
		IF @capacityType IN (0,1,3)
			SET @sqlQuery += N' ClientId "Client ID", ClientName "Client", AppSizeMB "Usage"'
		ELSE IF @capacityType IN (2,4)
			SET @sqlQuery += N' UserCount "User Count"'
		SET @sqlQuery += N', OrgGUID "Company ID", Organization "Company", PlanName "Plan" FROM'
		IF @capacityType=0
			SET @sqlQuery += N' Lic_CUR_Activate_File_Optimization_vw'
		ELSE IF @capacityType=1
			SET @sqlQuery += N' Lic_CUR_Activate_Ediscovery_Files_vw'
		ELSE IF @capacityType=2
			SET @sqlQuery += N' Lic_CUR_Activate_Ediscovery_Emails_vw'
		ELSE IF @capacityType=3
			SET @sqlQuery += N' Lic_CUR_Activate_Sensitive_Files_vw'
		ELSE IF @capacityType=4
			SET @sqlQuery += N' Lic_CUR_Activate_Sensitive_Emails_vw'
		IF @orgGUID IS NOT NULL
			SET @sqlQuery += N' WHERE OrgGUID = '''+CONVERT(VARCHAR(40),@orgGUID)+''''
		EXEC sp_executesql @sqlQuery
	END
	ELSE IF @option = 50 -- Get Metallic Storage usage details
	BEGIN
		SET @sqlQuery = N'SELECT StoragePoolId "Storage Pool ID", StoragePool "Storage Pool", ContainerId "Container ID", Container, AppSizeMB "Usage", OrgGUID "Company ID", Organization "Company", PlanName "Plan" FROM'
		IF @capacityType=1
			SET @sqlQuery += N' Lic_CUR_Metallic_Storage_vw'
		ELSE IF @capacityType=2
			SET @sqlQuery += N' Lic_CUR_Metallic_Storage_T2_vw'
		ELSE IF @capacityType=3
			SET @sqlQuery += N' Lic_CUR_Metallic_Storage_T3_vw'
		ELSE IF @capacityType=4
			SET @sqlQuery += N' Lic_CUR_Metallic_Storage_T4_vw'
		ELSE IF @capacityType=5
			SET @sqlQuery += N' Lic_CUR_Metallic_Storage_T5_vw'
		ELSE IF @capacityType=6
			SET @sqlQuery += N' Lic_CUR_Metallic_Storage_T6_vw'
		ELSE IF @capacityType=7
			SET @sqlQuery += N' Lic_CUR_Metallic_Storage_T7_vw'
		ELSE IF @capacityType=8
			SET @sqlQuery += N' Lic_CUR_Metallic_Storage_T8_vw'
		ELSE IF @capacityType=9
			SET @sqlQuery += N' Lic_CUR_Metallic_Storage_T9_vw'
		ELSE IF @capacityType=10
			SET @sqlQuery += N' Lic_CUR_Metallic_Storage_T10_vw'
		IF @orgGUID IS NOT NULL
			SET @sqlQuery += N' WHERE OrgGUID = '''+CONVERT(VARCHAR(40),@orgGUID)+''''
		EXEC sp_executesql @sqlQuery
	END
	ELSE IF @option = 51  -- Get OI instances in use
	BEGIN
		SELECT DISTINCT ClientId "Client ID", ClientName "Client", ISNULL(SubclientName, ClientName) "Operating Instance Name",
		CASE CapacityFlag WHEN 4 THEN 'Amazon RDS' WHEN 22 THEN 'Amazon DynamoDB' WHEN 23 THEN 'Azure Cosmos DB SQL API' WHEN 26 THEN 'Amazon Redshift' WHEN 27 THEN 'Amazon DocumentDB' WHEN 32 THEN 'Azure Table Storage' ELSE 'N/A' END "Operating Instance Type",
		OrgGUID "Organization ID", Organization, PlanName "Plan"
		FROM Lic_CurrentUsage WITH (NOLOCK)
		WHERE UsageType = 30
		AND (@orgGUID IS NULL OR OrgGUID = @orgGUID)
	END
END
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'Lic_CUR_GetLicenseUsage')
	delete from GxQscripts where name = 'Lic_CUR_GetLicenseUsage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='Lic_CUR_GetLicenseUsage')
	delete from GXDBVersions where aliasname = 'Lic_CUR_GetLicenseUsage'
GO

insert into GXDBVersions values(2, 'Lic_CUR_GetLicenseUsage',  'v1.1.2.15.8.1', 'Lic_CUR_GetLicenseUsage', 'v1.1.2.15.8.1')
GO

