

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/Lic_CCL_GetLicenseUsage.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/Lic_CCL_GetLicenseUsage.sp,v $ $Id: Lic_CCL_GetLicenseUsage.sp,v 1.1.2.12.8.1 2021/01/15 15:41:24 lgeorge Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='Lic_CCL_GetLicenseUsage')
BEGIN
	print '>>> Drop Stored Procedure: Lic_CCL_GetLicenseUsage <<<'
	drop procedure Lic_CCL_GetLicenseUsage
END
IF EXISTS (select * from GxQscripts where name='Lic_CCL_GetLicenseUsage')
	delete from GxQscripts where name = 'Lic_CCL_GetLicenseUsage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='Lic_CCL_GetLicenseUsage')
	delete from GXDBVersions where aliasname = 'Lic_CCL_GetLicenseUsage'
GO
print '... Creating Procedure: Lic_CCL_GetLicenseUsage'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure Lic_CCL_GetLicenseUsage
  @option INT, 	
  @i_userId INT,
  @monthString VARCHAR(20) = NULL,
  @timezone VARCHAR(20) = '00:00'
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
	DECLARE @i_UMDSProviderId INT = NULL
	DECLARE @orgGUID UNIQUEIDENTIFIER = NULL
	DECLARE @userHasRights INT = 0
	DECLARE @isUserAdmin INT = 0
	EXEC commserv.dbo.sec_checkPermissionOnEntity @i_userId, '1,2', @userHasRights OUTPUT, 1, 2
	IF @userHasRights = 0
	BEGIN
		--allow non admin users to access LSR through REST api if they have view permission set at commcell entity level
		EXEC commserv.dbo.sec_checkPermissionOnEntity @i_userId, '31', @userHasRights OUTPUT, 1, 2
		IF @userHasRights = 0
		BEGIN
			--allow tenant admins to access tenant usage through company usage report
			SELECT @i_UMDSProviderId = UMDS.id, @orgGUID = UMDS.GUID
			FROM commserv.dbo.UMDSProviders UMDS JOIN commserv.dbo.UMUsers U
			ON U.umDSproviderId = UMDS.id AND UMDS.serviceType = 5 --- for Company
			WHERE U.id = @i_userId
			SET @userHasRights = 0
			IF @i_UMDSProviderId IS NOT NULL
				EXEC commserv.dbo.sec_checkPermissionOnEntity @i_userId, '1,2', @userHasRights OUTPUT, 61, @i_UMDSProviderId
			IF @userHasRights = 0 OR @orgGUID IS NULL
				RETURN
		END
		ELSE
			SET @isUserAdmin = 1
	END
	ELSE
		SET @isUserAdmin = 1
	DECLARE @month DATETIME
	SET @month=CONVERT(DATE,@monthString)
	IF @month=NULL OR @month > GETDATE()
	BEGIN
		SET @month=DATEADD(DAY,-DAY(GETDATE())+1, CAST(GETDATE() AS DATE))
	END
	DECLARE @noOfMonths int =12
	DECLARE @monthStart DATETIME = GETDATE()
    DECLARE @monthTable TABLE (MonthStart DATETIME)
    DECLARE @cnt INT = @noOfMonths
    WHILE @cnt > 0
    BEGIN
        INSERT @monthTable
        SELECT DATEADD(month, DATEDIFF(month, 0, @monthStart), 0)
        SET @monthStart=DATEADD(month, -1, @monthStart)
        SET @cnt=@cnt-1
    END
	DECLARE @sqlQuery NVARCHAR(MAX) = '';
	DECLARE @capacityType INT = 0;
	IF @option = 1  -- Get License Peak Usage for Capacity & HyperScale
	BEGIN
		SELECT  M.MonthStart AS Month, ISNULL([CCLBackup],0)/(1024.0*1024.0) AS 'CCLBackup', ISNULL([CCLArchive], 0)/(1024.0*1024.0) AS 'CCLArchive'
		, ISNULL([CCLSnapshot], 0)/(1024.0*1024.0) AS 'CCLSnapshot', ISNULL([CCLReplication], 0)/(1024.0*1024.0) AS 'CCLReplication'
		, (ISNULL([CCLBackup], 0)+ISNULL([CCLArchive], 0))/(1024.0*1024.0) AS 'CCLComplete', ISNULL([CCLHyperScale], 0)/(1024.0*1024.0) AS 'CCLHyperScale'
		, ISNULL([CCLActivateFileOptimization], 0)/(1024.0*1024.0) AS 'CCLActivateFileOptimization', ISNULL([CCLActivateEdiscoveryFiles], 0)/(1024.0*1024.0) AS 'CCLActivateEdiscoveryFiles'
		, ISNULL([CCLActivateSensitiveFiles], 0)/(1024.0*1024.0) AS 'CCLActivateSensitiveFiles', ISNULL([CCLActivateEdiscoveryEmails], 0) AS 'CCLActivateEdiscoveryEmails'
		, ISNULL([CCLActivateSensitiveEmails], 0) AS 'CCLActivateSensitiveEmails', ISNULL([CCLMetallicStorage], 0)/(1024.0*1024.0) AS 'CCLMetallicStorage'
		, ISNULL([CCLMetallicStorageT2], 0)/(1024.0*1024.0) AS 'CCLMetallicStorageT2', ISNULL([CCLMetallicStorageT3], 0)/(1024.0*1024.0) AS 'CCLMetallicStorageT3'
		, ISNULL([CCLMetallicStorageT4], 0)/(1024.0*1024.0) AS 'CCLMetallicStorageT4', ISNULL([CCLMetallicStorageT5], 0)/(1024.0*1024.0) AS 'CCLMetallicStorageT5'
		, ISNULL([CCLMetallicStorageT6], 0)/(1024.0*1024.0) AS 'CCLMetallicStorageT6', ISNULL([CCLMetallicStorageT7], 0)/(1024.0*1024.0) AS 'CCLMetallicStorageT7'
		, ISNULL([CCLMetallicStorageT8], 0)/(1024.0*1024.0) AS 'CCLMetallicStorageT8', ISNULL([CCLMetallicStorageT9], 0)/(1024.0*1024.0) AS 'CCLMetallicStorageT9'
		, ISNULL([CCLMetallicStorageT10], 0)/(1024.0*1024.0) AS 'CCLMetallicStorageT10' FROM
		(SELECT  *	FROM
		(SELECT  MonthStart, 'CCLBackup' BackupType, ISNULL(AppSiZeMB, 0) AS AppSiZeMB  FROM Lic_CCL_Backups_InCapacity_vw WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID)
			UNION ALL
			SELECT  MonthStart, 'CCLSnapshot' BackupType, ISNULL(AppSiZeMB, 0) AS AppSiZeMB FROM Lic_CCL_Snapshots_InCapacity_vw WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID)
			UNION ALL
			SELECT  MonthStart, 'CCLReplication' BackupType, ISNULL(AppSiZeMB, 0) AS AppSiZeMB FROM Lic_CCL_Replications_InCapacity_vw WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID)
			UNION ALL
			SELECT  MonthStart, 'CCLArchive' BackupType, ISNULL(AppSiZeMB, 0) AS AppSiZeMB FROM Lic_CCL_Archives_InCapacity_vw WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID)
			UNION ALL
			SELECT  MonthStart, 'CCLHyperScale' BackupType, ISNULL(UsedCapacityMB, 0) AS AppSiZeMB FROM Lic_CCL_HyperScale_vw WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID)
			UNION ALL
			SELECT  MonthStart, 'CCLActivateFileOptimization' BackupType, ISNULL(AppSiZeMB, 0) AS AppSiZeMB FROM Lic_CCL_Activate_File_Optimization_vw WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID)
			UNION ALL
			SELECT  MonthStart, 'CCLActivateEdiscoveryFiles' BackupType, ISNULL(AppSiZeMB, 0) AS AppSiZeMB FROM Lic_CCL_Activate_Ediscovery_Files_vw WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID)
			UNION ALL
			SELECT  MonthStart, 'CCLActivateSensitiveFiles' BackupType, ISNULL(AppSiZeMB, 0) AS AppSiZeMB FROM Lic_CCL_Activate_Sensitive_Files_vw WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID)
			UNION ALL
			SELECT  MonthStart, 'CCLActivateEdiscoveryEmails' BackupType, ISNULL(UserCount, 0) AS AppSiZeMB FROM Lic_CCL_Activate_Ediscovery_Emails_vw WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID)
			UNION ALL
			SELECT  MonthStart, 'CCLActivateSensitiveEmails' BackupType, ISNULL(UserCount, 0) AS AppSiZeMB FROM Lic_CCL_Activate_Sensitive_Emails_vw WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID)
			UNION ALL
			SELECT  MonthStart, 'CCLMetallicStorage' BackupType, ISNULL(AppSiZeMB, 0) AS AppSiZeMB FROM Lic_CCL_Metallic_Storage_vw WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID)
			UNION ALL
			SELECT  MonthStart, 'CCLMetallicStorageT2' BackupType, ISNULL(AppSiZeMB, 0) AS AppSiZeMB FROM Lic_CCL_Metallic_Storage_T2_vw WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID)
			UNION ALL
			SELECT  MonthStart, 'CCLMetallicStorageT3' BackupType, ISNULL(AppSiZeMB, 0) AS AppSiZeMB FROM Lic_CCL_Metallic_Storage_T3_vw WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID)
			UNION ALL
			SELECT  MonthStart, 'CCLMetallicStorageT4' BackupType, ISNULL(AppSiZeMB, 0) AS AppSiZeMB FROM Lic_CCL_Metallic_Storage_T4_vw WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID)
			UNION ALL
			SELECT  MonthStart, 'CCLMetallicStorageT5' BackupType, ISNULL(AppSiZeMB, 0) AS AppSiZeMB FROM Lic_CCL_Metallic_Storage_T5_vw WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID)
			UNION ALL
			SELECT  MonthStart, 'CCLMetallicStorageT6' BackupType, ISNULL(AppSiZeMB, 0) AS AppSiZeMB FROM Lic_CCL_Metallic_Storage_T6_vw WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID)
			UNION ALL
			SELECT  MonthStart, 'CCLMetallicStorageT7' BackupType, ISNULL(AppSiZeMB, 0) AS AppSiZeMB FROM Lic_CCL_Metallic_Storage_T7_vw WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID)
			UNION ALL
			SELECT  MonthStart, 'CCLMetallicStorageT8' BackupType, ISNULL(AppSiZeMB, 0) AS AppSiZeMB FROM Lic_CCL_Metallic_Storage_T8_vw WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID)
			UNION ALL
			SELECT  MonthStart, 'CCLMetallicStorageT9' BackupType, ISNULL(AppSiZeMB, 0) AS AppSiZeMB FROM Lic_CCL_Metallic_Storage_T9_vw WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID)
			UNION ALL
			SELECT  MonthStart, 'CCLMetallicStorageT10' BackupType, ISNULL(AppSiZeMB, 0) AS AppSiZeMB FROM Lic_CCL_Metallic_Storage_T10_vw WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID)
		) AS SourceTable
		PIVOT
		(
			SUM(AppSiZeMB)
			FOR BackupType IN ([CCLBackup], [CCLSnapshot], [CCLReplication], [CCLArchive], [CCLHyperScale], [CCLActivateFileOptimization],[CCLActivateEdiscoveryFiles],[CCLActivateSensitiveFiles],
			[CCLActivateEdiscoveryEmails],[CCLActivateSensitiveEmails],[CCLMetallicStorage],[CCLMetallicStorageT2],[CCLMetallicStorageT3],[CCLMetallicStorageT4],[CCLMetallicStorageT5],[CCLMetallicStorageT6],
			[CCLMetallicStorageT7],[CCLMetallicStorageT8],[CCLMetallicStorageT9],[CCLMetallicStorageT10])
		) AS PivotTable) T
		RIGHT JOIN @monthTable M
			ON M.MonthStart = T.MonthStart
	END
	ELSE IF @option = 2  -- Get License Peak Usage for OI, Virtualization, Application Users, Endpoint Users and other licenses
	BEGIN
		SELECT T1.Month As Month, ISNULL([VMSockets], 0) AS 'VMSockets', ISNULL([ProtectedVMs], 0) AS 'ProtectedVMs', ISNULL([AcvVMs], 0) AS 'AcvVMs',
			   ISNULL([ArchivedVMs], 0) AS 'ArchivedVMs', ISNULL([MSimUsers], 0) AS 'MSimUsers', ISNULL([EpUsers], 0) AS 'EpUsers',
			   ISNULL([EpSharingUsers], 0) AS 'EpSharingUsers', ISNULL([EpEdiscoveryUsers], 0) AS 'EpEdiscoveryUsers',
			   ISNULL([FSOnlyServer], 0) AS 'FSOnlyServer', ISNULL([FSOnlyVM], 0) AS 'FSOnlyVM', ISNULL([DLO], 0) AS 'DLO' , ISNULL([AppServer], 0) AS 'AppServer',
			   ISNULL([VMonly], 0) AS 'VMonly', ISNULL([AdvancedVM], 0) AS 'AdvancedVM', ISNULL([LiveSyncVM], 0) AS 'LiveSyncVM'
			   , ISNULL([OI], 0) AS 'OI', ISNULL([VOI], 0) AS 'VOI', ISNULL([DRVM], 0) AS 'DRVM'
		FROM
		(SELECT  M.MonthStart AS Month, ISNULL([VMSockets], 0) AS 'VMSockets', ISNULL([OI], 0) AS 'OI' FROM
		(SELECT  *	FROM
		(SELECT MonthStart, 'VMSockets' BackupType, ISNULL(Sockets, 0) AS AppSiZeMB  FROM Lic_CCL_VMSockets_vw WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID)
		UNION ALL
		SELECT MonthStart, 'OI' BackupType, ISNULL(OICount, 0) AS AppSiZeMB  FROM Lic_CCL_OIs_vw WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID)
		) AS SourceTable
		PIVOT
		(
			SUM(AppSiZeMB) FOR BackupType IN ([VMSockets], [OI])
		) AS PivotTable) T
			RIGHT JOIN @monthTable M
					ON M.MonthStart = T.MonthStart) T1
		LEFT JOIN
			(SELECT  M.MonthStart AS Month, ISNULL([MSimUsers], 0) AS 'MSimUsers', ISNULL([LiveSyncVM], 0) AS 'LiveSyncVM'
			FROM
			(SELECT  *	FROM
			(SELECT DISTINCT MonthStart, 'MSimUsers' BackupType, ISNULL(Smtp, '') AS Data  FROM Lic_CCL_ApplicationUsers_vw WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID)
			UNION
			SELECT DISTINCT MonthStart, 'LiveSyncVM' BackupType, ISNULL(SourceClientName, '') AS Data FROM Lic_CCL_LiveSyncForVM_vw WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID)
			) AS SourceTable
			PIVOT
			(COUNT(Data) FOR BackupType IN ([MSimUsers], [LiveSyncVM])) AS PivotTable)T
				RIGHT JOIN @monthTable M
					ON M.MonthStart = T.MonthStart) T2
			ON MONTH(T1.Month) = MONTH(T2.Month) AND  YEAR(T1.Month) = YEAR(T2.Month)
		LEFT JOIN
		(SELECT  M.MonthStart AS Month, ISNULL([ProtectedVMs], 0) AS 'ProtectedVMs'
		, ISNULL([AcvVMs], 0) AS 'AcvVMs', ISNULL([ArchivedVMs], 0) AS 'ArchivedVMs'
		, ISNULL([VMonly], 0) AS 'VMonly', ISNULL([AdvancedVM], 0) AS 'AdvancedVM', ISNULL([EpUsers], 0) AS 'EpUsers'
		, ISNULL([EpSharingUsers], 0) AS 'EpSharingUsers', ISNULL([EpEdiscoveryUsers], 0) AS 'EpEdiscoveryUsers'
		, ISNULL([FSOnlyServer], 0) AS 'FSOnlyServer', ISNULL([FSOnlyVM], 0) AS 'FSOnlyVM', ISNULL([DLO], 0) AS 'DLO' , ISNULL([AppServer], 0) AS 'AppServer'
		, ISNULL([VOI], 0) AS 'VOI', ISNULL([DRVM], 0) AS 'DRVM'
		FROM
			(SELECT  *	FROM
				(SELECT DISTINCT MonthStart, 'ProtectedVMs' BackupType, VMId AS Data FROM Lic_CCL_ProtectedVMs_vw WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID)
				UNION ALL
				SELECT DISTINCT MonthStart, 'AcvVMs' BackupType, VMId AS Data FROM Lic_CCL_ACVs_vw WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID)
				UNION ALL
				SELECT DISTINCT MonthStart, 'ArchivedVMs' BackupType, VMId AS Data FROM Lic_CCL_ArchivedVMs_vw WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID)
				UNION ALL
				SELECT DISTINCT MonthStart, 'VMonly' BackupType, VMId AS Data FROM Lic_CCL_VMOnly_vw WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID)
				UNION ALL
				SELECT DISTINCT MonthStart, 'AdvancedVM' BackupType, VMId AS Data FROM Lic_CCL_VMWithApps_vw WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID)
				UNION ALL
				SELECT  DISTINCT MonthStart, 'EpUsers' BackupType, UserId AS Data FROM Lic_CCL_EpUsers_vw WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID)
				UNION ALL
				SELECT  DISTINCT MonthStart, 'EpSharingUsers' BackupType, UserId AS Data FROM Lic_CCL_EpSharingUsers_vw WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID)
				UNION ALL
				SELECT  DISTINCT MonthStart, 'EpEdiscoveryUsers' BackupType, UserId AS Data FROM Lic_CCL_EpEDiscoveryUsers_vw WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID)
				UNION ALL
				SELECT  DISTINCT MonthStart, 'FSOnlyServer' BackupType, ClientId AS Data  FROM Lic_CCL_FSonlyServers_vw WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID) AND LicType=100029
				UNION ALL
				SELECT  DISTINCT MonthStart, 'FSOnlyVM' BackupType, ClientId AS Data  FROM Lic_CCL_FSonlyServers_vw WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID) AND LicType=200017
				UNION ALL
				SELECT DISTINCT MonthStart, 'DLO' BackupType, ClientId AS Data FROM Lic_CCL_DLOs_vw WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID)
				UNION ALL
				SELECT DISTINCT MonthStart, 'AppServer' BackupType, ClientId AS Data FROM Lic_CCL_AppServers_vw WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID)
				UNION ALL
				SELECT DISTINCT MonthStart, 'VOI' BackupType, ClientId AS Data FROM Lic_CCL_VOIs_vw WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID)
				UNION ALL
				SELECT DISTINCT MonthStart, 'DRVM' BackupType, SourceVMId AS Data FROM Lic_CCL_DRVM_vw WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID)
				) AS SourceTable
				PIVOT
				(COUNT(Data) FOR BackupType IN ([ProtectedVMs],[AcvVMs],[ArchivedVMs], [VMonly], [AdvancedVM], [EpUsers],
												[EpSharingUsers], [EpEdiscoveryUsers], [FSOnlyServer], [FSOnlyVM], [DLO], [AppServer], [VOI], [DRVM])) AS PivotTable
			)T	RIGHT JOIN @monthTable M
					ON M.MonthStart = T.MonthStart) T3
			ON MONTH(T2.Month) = MONTH(T3.Month) AND  YEAR(T2.Month) = YEAR(T3.Month)
	END
	/*ELSE IF @option = 3 --current usage details are not displayed in peak graphs anymore. Hence this option is not required */
	ELSE IF @option = 4   -- Get License Peak Usage for Backup in Capacity
	BEGIN
		IF object_id('tempdb.dbo.#VSABackupJobs') IS NOT NULL DROP TABLE #VSABackupJobs
        CREATE TABLE #VSABackupJobs(ParentId INT, ParentName NVARCHAR(255), VMId INT, VMName NVARCHAR(255), ParentJobId INT, ChildJobid INT, JobTypeName VARCHAR(15), SubclientId INT, AppSizeMB BIGINT, Organization NVARCHAR(1024), OrgGUID UNIQUEIDENTIFIER, PlanName NVARCHAR(1024), SubclientName NVARCHAR(255), BackupsetId INT, BackupSetName NVARCHAR(1024), InstanceId INT, InstanceName NVARCHAR(1024), SPId INT, SPName NVARCHAR(1024))
		INSERT #VSABackupJobs
		SELECT DISTINCT ClientId, ClientName, ClientId, ClientName, JobId, JobId, JobType,
		SubclientId, AppSizeMB, Organization, OrgGUID, PlanName, 'N/A', 0, 'N/A', 0, 'N/A', 0, 'N/A'
		FROM Lic_CCL_Backups_InCapacity_vw U1
		WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID) AND MonthStart=@month
		AND U1.AppTypeId=106
		UPDATE U1
		SET U1.ParentJobId=ISNULL(V2.ObjectId,-1), U1.SubclientId=V2.VMFlag
		FROM #VSABackupJobs U1
		LEFT JOIN Lic_PeakUsage V2 WITH (NOLOCK) ON V2.SubclientId=U1.SubclientId AND V2.UsageType=1
		WHERE V2.UsageType=1 AND V2.CapacityFlag=0 AND V2.AppTypeId=106 AND V2.ObjectId>0 AND V2.PeakType=0 AND (@orgGUID IS NULL OR V2.OrgGUID = @orgGUID) AND V2.MonthStart=@month
		UPDATE U1
		SET U1.SubclientName=ISNULL(A.subclientName,'N/A'), U1.BackupsetId=ISNULL(B.id,-1), U1.BackupSetName=ISNULL(B.name,'N/A'), U1.InstanceId=ISNULL(I.id,-1), U1.InstanceName=ISNULL(I.name,'N/A'), U1.SPId=ISNULL(AG.id,-1), U1.SPName=ISNULL(AG.name,'N/A')
		, U1.ParentId=ISNULL(A.clientId,-1), U1.ParentName=ISNULL(C.name,'N/A')
		FROM #VSABackupJobs U1
		LEFT JOIN APP_Application A WITH (NOLOCK) ON A.id=U1.SubclientId
		LEFT JOIN APP_BackupSetName B WITH (NOLOCK) ON B.id=A.backupSet
		LEFT JOIN APP_InstanceName I WITH (NOLOCK) ON I.id=A.instance
		LEFT JOIN archGroup AG WITH (NOLOCK) ON AG.id=A.dataArchGrpID
		LEFT JOIN APP_Client C WITH (NOLOCK) ON A.clientId=C.id
		SELECT 143 AS "License ID", 'Virtual Server' AS License, VMId "Client ID", VMName "Client", 106 AS "Agent ID", 'Virtual Server' AS Agent,
		SubclientId AS "Subclient ID", SubclientName AS Subclient, SPId AS "Storage Policy ID", SPName AS "Storage Policy", BackupSetName AS Backupset,
		InstanceName AS Instance, JobTypeName AS "Job Type", ChildJobId AS "Job ID", AppSizeMB AS Usage, Organization, OrgGUID AS "Organization ID", PlanName As "Plan",
		BackupsetId AS "Backupset ID", InstanceId AS "Instance ID", ParentId AS "Virtualization Client ID", ParentName AS "Virtualization Client", ParentJobId AS "Parent Job ID"
		FROM #VSABackupJobs
		UNION
		SELECT  LicType AS "License ID", CASE WHEN Lictype < 1 THEN 'N/A' ELSE LicName END AS License, ClientId AS "Client ID", ClientName AS Client,
		AppTypeId AS "Agent ID", CASE WHEN AppTypeId < 1 THEN 'N/A' ELSE AppTypeName END AS Agent,
		SubclientId AS "Subclient ID", SubclientName AS Subclient, SPId AS "Storage Policy ID", SPName AS "Storage Policy", BackupSetName AS Backupset,
		InstanceName AS Instance, JobType AS "Job Type", JobId AS "Job ID", AppSizeMB AS Usage, Organization, OrgGUID AS "Organization ID", PlanName As "Plan",
		BackupsetId AS "Backupset ID", InstanceId AS "Instance ID", 0, 'N/A', 0
		FROM Lic_CCL_Backups_InCapacity_vw
		WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID) AND MonthStart=@month
		AND AppTypeId<>106
		IF object_id('tempdb.dbo.#VSABackupJobs') IS NOT NULL DROP TABLE #VSABackupJobs
	END
	ELSE IF  @option = 5  -- Get License Peak Usage for Archive in Capacity
	BEGIN
		IF object_id('tempdb.dbo.#VSAArchiveJobs') IS NOT NULL DROP TABLE #VSAArchiveJobs
        CREATE TABLE #VSAArchiveJobs(ParentId INT, ParentName NVARCHAR(255), VMId INT, VMName NVARCHAR(255), ParentJobId INT, ChildJobid INT, JobTypeName VARCHAR(15), SubclientId INT, AppSizeMB BIGINT, Organization NVARCHAR(1024), OrgGUID UNIQUEIDENTIFIER, PlanName NVARCHAR(1024), SubclientName NVARCHAR(255), BackupsetId INT, BackupSetName NVARCHAR(1024), InstanceId INT, InstanceName NVARCHAR(1024), SPId INT, SPName NVARCHAR(1024))
		INSERT #VSAArchiveJobs
		SELECT DISTINCT ClientId, ClientName, ClientId, ClientName, JobId, JobId, JobType,
		SubclientId, AppSizeMB, Organization, OrgGUID, PlanName, 'N/A', 0, 'N/A', 0, 'N/A', 0, 'N/A'
		FROM Lic_CCL_Archives_InCapacity_vw U1
		WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID)  AND MonthStart=@month
		AND U1.AppTypeId=106
		UPDATE U1
		SET U1.ParentJobId=ISNULL(V2.ObjectId,-1), U1.SubclientId=V2.VMFlag
		FROM #VSAArchiveJobs U1
		LEFT JOIN Lic_PeakUsage V2 WITH (NOLOCK) ON V2.SubclientId=U1.SubclientId AND V2.UsageType=2
		WHERE V2.UsageType=2 AND V2.CapacityFlag=0 AND V2.AppTypeId=106 AND V2.ObjectId>0 AND V2.PeakType=0 AND (@orgGUID IS NULL OR V2.OrgGUID = @orgGUID) AND V2.MonthStart=@month
		UPDATE U1
		SET U1.SubclientName=ISNULL(A.subclientName,'N/A'), U1.BackupsetId=ISNULL(B.id,-1), U1.BackupSetName=ISNULL(B.name,'N/A'), U1.InstanceId=ISNULL(I.id,-1), U1.InstanceName=ISNULL(I.name,'N/A'), U1.SPId=ISNULL(AG.id,-1), U1.SPName=ISNULL(AG.name,'N/A')
		, U1.ParentId=ISNULL(A.clientId,-1), U1.ParentName=ISNULL(C.name,'N/A')
		FROM #VSAArchiveJobs U1
		LEFT JOIN APP_Application A WITH (NOLOCK) ON A.id=U1.SubclientId
		LEFT JOIN APP_BackupSetName B WITH (NOLOCK) ON B.id=A.backupSet
		LEFT JOIN APP_InstanceName I WITH (NOLOCK) ON I.id=A.instance
		LEFT JOIN archGroup AG WITH (NOLOCK) ON AG.id=A.dataArchGrpID
		LEFT JOIN APP_Client C WITH (NOLOCK) ON A.clientId=C.id
		SELECT 143 AS "License ID", 'Virtual Server' AS License, VMId "Client ID", VMName "Client", 106 AS "Agent ID", 'Virtual Server' AS Agent,
		SubclientId AS "Subclient ID", SubclientName AS Subclient, SPId AS "Storage Policy ID", SPName AS "Storage Policy", BackupSetName AS Backupset,
		InstanceName AS Instance, JobTypeName AS "Job Type", ChildJobId AS "Job ID", AppSizeMB AS Usage, Organization, OrgGUID AS "Organization ID", PlanName As "Plan",
		BackupsetId AS "Backupset ID", InstanceId AS "Instance ID", ParentId AS "Virtualization Client ID", ParentName AS "Virtualization Client", ParentJobId AS "Parent Job ID"
		FROM #VSAArchiveJobs
		UNION
		SELECT  LicType AS "License ID", CASE WHEN Lictype < 1 THEN 'N/A' ELSE LicName END AS License, ClientId AS "Client ID", ClientName AS Client,
		AppTypeId AS "Agent ID", CASE WHEN AppTypeId < 1 THEN 'N/A' ELSE AppTypeName END AS Agent,
		SubclientId AS "Subclient ID", SubclientName AS Subclient, SPId AS "Storage Policy ID", SPName AS "Storage Policy", BackupSetName AS Backupset,
		InstanceName AS Instance, JobType AS "Job Type", JobId AS "Job ID", AppSizeMB AS Usage, Organization, OrgGUID AS "Organization ID", PlanName As "Plan",
		BackupsetId AS "Backupset ID", InstanceId AS "Instance ID", 0, 'N/A', 0
		FROM Lic_CCL_Archives_InCapacity_vw
		WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID) AND MonthStart=@month
		AND AppTypeId<>106
		IF object_id('tempdb.dbo.#VSAArchiveJobs') IS NOT NULL DROP TABLE #VSAArchiveJobs
	END
	ELSE IF @option = 6  -- Get License Peak Usage for Snapshot in Capacity
	BEGIN
		IF object_id('tempdb.dbo.#VSASnapJobs') IS NOT NULL DROP TABLE #VSASnapJobs
        CREATE TABLE #VSASnapJobs(ParentId INT, ParentName NVARCHAR(255), VMId INT, VMName NVARCHAR(255), ParentJobId INT, ChildJobid INT, JobTypeName VARCHAR(15), SubclientId INT, AppSizeMB BIGINT, Organization NVARCHAR(1024), OrgGUID UNIQUEIDENTIFIER, PlanName NVARCHAR(1024), SubclientName NVARCHAR(255), BackupsetId INT, BackupSetName NVARCHAR(1024), InstanceId INT, InstanceName NVARCHAR(1024), SPId INT, SPName NVARCHAR(1024))
		INSERT #VSASnapJobs
		SELECT DISTINCT ClientId, ClientName, ClientId, ClientName, JobId, JobId, JobType,
		SubclientId, AppSizeMB, Organization, OrgGUID, PlanName, 'N/A', 0, 'N/A', 0, 'N/A', 0, 'N/A'
		FROM Lic_CCL_Snapshots_InCapacity_vw U1
		WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID)  AND MonthStart=@month
		AND U1.AppTypeId=106
		UPDATE U1
		SET U1.ParentJobId=ISNULL(V2.ObjectId,-1), U1.SubclientId=V2.VMFlag
		FROM #VSASnapJobs U1
		LEFT JOIN Lic_PeakUsage V2 WITH (NOLOCK) ON V2.SubclientId=U1.SubclientId AND V2.UsageType=3
		WHERE V2.UsageType=3 AND V2.CapacityFlag=0 AND V2.AppTypeId=106 AND V2.ObjectId>0 AND V2.PeakType=0 AND (@orgGUID IS NULL OR V2.OrgGUID = @orgGUID) AND V2.MonthStart=@month
		UPDATE U1
		SET U1.SubclientName=ISNULL(A.subclientName,'N/A'), U1.BackupsetId=ISNULL(B.id,-1), U1.BackupSetName=ISNULL(B.name,'N/A'), U1.InstanceId=ISNULL(I.id,-1), U1.InstanceName=ISNULL(I.name,'N/A'), U1.SPId=ISNULL(AG.id,-1), U1.SPName=ISNULL(AG.name,'N/A')
		, U1.ParentId=ISNULL(A.clientId,-1), U1.ParentName=ISNULL(C.name,'N/A')
		FROM #VSASnapJobs U1
		LEFT JOIN APP_Application A WITH (NOLOCK) ON A.id=U1.SubclientId
		LEFT JOIN APP_BackupSetName B WITH (NOLOCK) ON B.id=A.backupSet
		LEFT JOIN APP_InstanceName I WITH (NOLOCK) ON I.id=A.instance
		LEFT JOIN archGroup AG WITH (NOLOCK) ON AG.id=A.dataArchGrpID
		LEFT JOIN APP_Client C WITH (NOLOCK) ON A.clientId=C.id
		SELECT 143 AS "License ID", 'Virtual Server' AS License, VMId "Client ID", VMName "Client", 106 AS "Agent ID", 'Virtual Server' AS Agent,
		SubclientId AS "Subclient ID", SubclientName AS Subclient, SPId AS "Storage Policy ID", SPName AS "Storage Policy", BackupSetName AS Backupset,
		InstanceName AS Instance, JobTypeName AS "Job Type", ChildJobId AS "Job ID", AppSizeMB AS Usage, Organization, OrgGUID AS "Organization ID", PlanName As "Plan",
		BackupsetId AS "Backupset ID", InstanceId AS "Instance ID", ParentId AS "Virtualization Client ID", ParentName AS "Virtualization Client", ParentJobId AS "Parent Job ID"
		FROM #VSASnapJobs
		UNION
		SELECT  LicType AS "License ID", CASE WHEN Lictype < 1 THEN 'N/A' ELSE LicName END AS License, ClientId AS "Client ID", ClientName AS Client,
		AppTypeId AS "Agent ID", CASE WHEN AppTypeId < 1 THEN 'N/A' ELSE AppTypeName END AS Agent,
		SubclientId AS "Subclient ID", SubclientName AS Subclient, SPId AS "Storage Policy ID", SPName AS "Storage Policy", BackupSetName AS Backupset,
		InstanceName AS Instance, JobType AS "Job Type", JobId AS "Job ID", AppSizeMB AS Usage, Organization, OrgGUID AS "Organization ID", PlanName As "Plan",
		BackupsetId AS "Backupset ID", InstanceId AS "Instance ID", 0, 'N/A', 0
		FROM Lic_CCL_Snapshots_InCapacity_vw
		WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID) AND MonthStart=@month
		AND AppTypeId<>106
		IF object_id('tempdb.dbo.#VSASnapJobs') IS NOT NULL DROP TABLE #VSASnapJobs
	END
	ELSE IF @option = 7  -- Get License Peak Usage for Replication in Capacity
	BEGIN
		IF object_id('tempdb.dbo.#VSAReplicationJobs') IS NOT NULL DROP TABLE #VSAReplicationJobs
        CREATE TABLE #VSAReplicationJobs(ParentId INT, ParentName NVARCHAR(255), VMId INT, VMName NVARCHAR(255), ParentJobId INT, ChildJobid INT, JobTypeName VARCHAR(15), SubclientId INT, AppSizeMB BIGINT, Organization NVARCHAR(1024), OrgGUID UNIQUEIDENTIFIER, PlanName NVARCHAR(1024), SubclientName NVARCHAR(255), BackupsetId INT, BackupSetName NVARCHAR(1024), InstanceId INT, InstanceName NVARCHAR(1024), SPId INT, SPName NVARCHAR(1024))
		INSERT #VSAReplicationJobs
		SELECT DISTINCT ClientId, ClientName, ClientId, ClientName, JobId, JobId, JobType,
		SubclientId, AppSizeMB, Organization, OrgGUID, PlanName, 'N/A', 0, 'N/A', 0, 'N/A', 0, 'N/A'
		FROM Lic_CCL_Replications_InCapacity_vw U1
		WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID)  AND MonthStart=@month
		AND U1.AppTypeId=106
		UPDATE U1
		SET U1.ParentJobId=ISNULL(V2.ObjectId,-1), U1.SubclientId=V2.VMFlag
		FROM #VSAReplicationJobs U1
		LEFT JOIN Lic_PeakUsage V2 WITH (NOLOCK) ON V2.SubclientId=U1.SubclientId AND V2.UsageType=4
		WHERE V2.UsageType=4 AND V2.CapacityFlag=0 AND V2.AppTypeId=106 AND V2.ObjectId>0 AND V2.PeakType=0 AND (@orgGUID IS NULL OR V2.OrgGUID = @orgGUID) AND V2.MonthStart=@month
		UPDATE U1
		SET U1.SubclientName=ISNULL(A.subclientName,'N/A'), U1.BackupsetId=ISNULL(B.id,-1), U1.BackupSetName=ISNULL(B.name,'N/A'), U1.InstanceId=ISNULL(I.id,-1), U1.InstanceName=ISNULL(I.name,'N/A'), U1.SPId=ISNULL(AG.id,-1), U1.SPName=ISNULL(AG.name,'N/A')
		, U1.ParentId=ISNULL(A.clientId,-1), U1.ParentName=ISNULL(C.name,'N/A')
		FROM #VSAReplicationJobs U1
		LEFT JOIN APP_Application A WITH (NOLOCK) ON A.id=U1.SubclientId
		LEFT JOIN APP_BackupSetName B WITH (NOLOCK) ON B.id=A.backupSet
		LEFT JOIN APP_InstanceName I WITH (NOLOCK) ON I.id=A.instance
		LEFT JOIN archGroup AG WITH (NOLOCK) ON AG.id=A.dataArchGrpID
		LEFT JOIN APP_Client C WITH (NOLOCK) ON A.clientId=C.id
		SELECT 143 AS "License ID", 'Virtual Server' AS License, VMId "Client ID", VMName "Client", 106 AS "Agent ID", 'Virtual Server' AS Agent,
		SubclientId AS "Subclient ID", SubclientName AS Subclient, SPId AS "Storage Policy ID", SPName AS "Storage Policy", BackupSetName AS Backupset,
		InstanceName AS Instance, JobTypeName AS "Job Type", ChildJobId AS "Job ID", AppSizeMB AS Usage, Organization, OrgGUID AS "Organization ID", PlanName As "Plan",
		BackupsetId AS "Backupset ID", InstanceId AS "Instance ID", ParentId AS "Virtualization Client ID", ParentName AS "Virtualization Client", ParentJobId AS "Parent Job ID"
		FROM #VSAReplicationJobs
		UNION
		SELECT  LicType AS "License ID", CASE WHEN Lictype < 1 THEN 'N/A' ELSE LicName END AS License, ClientId AS "Client ID", ClientName AS Client,
		AppTypeId AS "Agent ID", CASE WHEN AppTypeId < 1 THEN 'N/A' ELSE AppTypeName END AS Agent,
		SubclientId AS "Subclient ID", SubclientName AS Subclient, SPId AS "Storage Policy ID", SPName AS "Storage Policy", BackupSetName AS Backupset,
		InstanceName AS Instance, JobType AS "Job Type", JobId AS "Job ID", AppSizeMB AS Usage, Organization, OrgGUID AS "Organization ID", PlanName As "Plan",
		BackupsetId AS "Backupset ID", InstanceId AS "Instance ID", 0, 'N/A', 0
		FROM Lic_CCL_Replications_InCapacity_vw
		WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID) AND MonthStart=@month
		AND AppTypeId<>106
		IF object_id('tempdb.dbo.#VSAReplicationJobs') IS NOT NULL DROP TABLE #VSAReplicationJobs
	END
	ELSE IF @option = 8   -- Get Last Collection Time
	BEGIN
		SELECT CONVERT(DATETIME, SWITCHOFFSET(CONVERT(DATETIMEOFFSET, commserv.dbo.GetDateTimeBig(value)), @timezone)) 'Last Collection Time'
		FROM commserv.dbo.GXGlobalParam WITH(NOLOCK) WHERE name='LicCurrentUsageCollectionTime'
	END
	ELSE IF @option= 9 --Get list of past N months for peak usages
	BEGIN
		DECLARE @dateTable TABLE (monthValue VARCHAR(20), monthLabel VARCHAR(20))
		DECLARE @date DATETIME = GETDATE()
		DECLARE @counter INT = @noOfMonths
		--default month to be diplayed in list
		INSERT INTO @dateTable VALUES('9999-01-01','Current Month')
		WHILE @counter > 0
		BEGIN
			INSERT @dateTable
			SELECT CAST(DATEADD(DAY,-DAY(@date)+1, CAST(@date AS DATE)) AS DATE), CONVERT(VARCHAR(10),DATENAME(month, @date))+', '+CONVERT(VARCHAR(4),YEAR(@date))
			SET @date=DATEADD(month, -1, @date)
			SET @counter=@counter-1
		END
		SELECT monthValue, monthLabel FROM @dateTable
	END
	ELSE IF @option = 10  -- Get License Peak Usage for VM Sockets
	BEGIN
		SELECT HypervisorHost AS "Hypervisor Host", Sockets, OrgGUID "Organization ID", Organization, PlanName "Plan"
		FROM Lic_CCL_VMSockets_vw
		WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID) AND MonthStart = @month
	END
	ELSE IF @option = 11 -- Get License Usage for VM Sockets, Protected VMs Excluded from Capacity
	BEGIN
		IF object_id('tempdb.dbo.#VSAJobsExcluded') IS NOT NULL DROP TABLE #VSAJobsExcluded
        CREATE TABLE #VSAJobsExcluded(ParentId INT, ParentName NVARCHAR(255), VMId INT, VMName NVARCHAR(255), ParentJobId INT, ChildJobid INT, JobTypeName VARCHAR(15), SubclientId INT, AppSizeMB BIGINT, Organization NVARCHAR(1024), OrgGUID UNIQUEIDENTIFIER, PlanName NVARCHAR(1024), SubclientName NVARCHAR(255), BackupsetId INT, BackupSetName NVARCHAR(1024), InstanceId INT, InstanceName NVARCHAR(1024), SPId INT, SPName NVARCHAR(1024))
		INSERT #VSAJobsExcluded
		SELECT DISTINCT ClientId, ClientName, ClientId, ClientName, JobId, JobId, JobType,
		SubclientId, AppSizeMB, Organization, OrgGUID, PlanName, 'N/A', 0, 'N/A', 0, 'N/A', 0, ''
		FROM Lic_CCL_VSAJobs_NotInCapacity_vw U1
		WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID) AND MonthStart = @month
		UPDATE U1
		SET U1.ParentJobId=ISNULL(V2.ObjectId,-1), U1.SubclientId=V2.VMFlag
		FROM #VSAJobsExcluded U1
		LEFT JOIN Lic_PeakUsage V2 WITH (NOLOCK) ON V2.SubclientId=U1.SubclientId AND V2.UsageType=CASE WHEN U1.JobTypeName='Backup' THEN 1 WHEN U1.JobTypeName='Archive' THEN 2 WHEN U1.JobTypeName='Snapshot' THEN 3 ELSE 4 END
		WHERE V2.UsageType IN (1,2,3,4) AND V2.CapacityFlag=1 AND V2.AppTypeId=106 AND V2.ObjectId>0 AND V2.PeakType=0 AND (@orgGUID IS NULL OR V2.OrgGUID = @orgGUID) AND V2.MonthStart=@month
		UPDATE U1
		SET U1.SubclientName=ISNULL(A.subclientName,'N/A'), U1.BackupsetId=ISNULL(B.id,-1), U1.BackupSetName=ISNULL(B.name,'N/A'), U1.InstanceId=ISNULL(I.id,-1), U1.InstanceName=ISNULL(I.name,'N/A'), U1.SPId=ISNULL(AG.id,-1), U1.SPName=ISNULL(AG.name,'N/A')
		, U1.ParentId=ISNULL(A.clientId,-1), U1.ParentName=ISNULL(C.name,'N/A')
		FROM #VSAJobsExcluded U1
		LEFT JOIN APP_Application A WITH (NOLOCK) ON A.id=U1.SubclientId
		LEFT JOIN APP_BackupSetName B WITH (NOLOCK) ON B.id=A.backupSet
		LEFT JOIN APP_InstanceName I WITH (NOLOCK) ON I.id=A.instance
		LEFT JOIN archGroup AG WITH (NOLOCK) ON AG.id=A.dataArchGrpID
		LEFT JOIN APP_Client C WITH (NOLOCK) ON A.clientId=C.id
		SELECT 143 AS "License ID", 'Virtual Server' AS License, VMId "Client ID", VMName "Client", 106 AS "Agent ID", 'Virtual Server' AS Agent,
			SubclientId AS "Subclient ID", SubclientName AS Subclient, SPId AS "Storage Policy ID", SPName AS "Storage Policy", BackupSetName AS Backupset,
			InstanceName AS Instance, JobTypeName AS "Job Type", ChildJobId AS "Job ID", AppSizeMB AS Usage, Organization, OrgGUID AS "Organization ID", PlanName As "Plan",
			BackupsetId AS "Backupset ID", InstanceId AS "Instance ID", ParentId AS "Virtualization Client ID", ParentName AS "Virtualization Client", ParentJobId AS "Parent Job ID"
		FROM #VSAJobsExcluded
		IF object_id('tempdb.dbo.#VSAJobsExcluded') IS NOT NULL DROP TABLE #VSAJobsExcluded
	END
	ELSE IF @option = 12 -- Get License Usage for Protected VMs
	BEGIN
		SELECT VMId	"VM ID", VMName "Virtual Machine", VMProtectionJob "VM Protection Job",	ProtectedVMSize "Protected VM Size",
				OrgGUID "Organization ID", Organization, PlanName "Plan"
		FROM Lic_CCL_ProtectedVMs_vw
		WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID) AND MonthStart = @month
	END
	ELSE IF @option = 13 -- Get License Usage for ACV Licenses
	BEGIN
		SELECT VMId	"VM ID", VMName "Virtual Machine", Package, isVMProtected "Is VM Protected", VMProtectionJob "VM Protection Job",
			ProtectedVMSize "Protected VM Size",OrgGUID "Organization ID", Organization, PlanName "Plan"
		FROM Lic_CCL_ACVs_vw
		WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID) AND MonthStart = @month
	END
	ELSE IF @option = 14 -- Get License Usage for ACVs excluded from Capacity
	BEGIN
		SELECT LicType "License ID", CASE WHEN Lictype < 1 THEN 'N/A' ELSE LicName END License, ClientId "Client ID",	ClientName Client, AppTypeId "Agent ID", AppTypeName Agent, SubclientId "Subclient ID", SubclientName Subclient,
				SPId "Storage Policy ID", SPName "Storage Policy", BackupSetName "Backupset", InstanceName "Instance", JobType "Job Type", JobId "Job ID",
				AppSizeMB "Usage", OrgGUID "Organization ID", Organization, PlanName "Plan", BackupSetId "Backupset ID", InstanceId "Instance ID"
		FROM Lic_CCL_ACVJobs_NotInCapacity_vw
		WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID) AND MonthStart = @month
	END
	ELSE IF @option = 15 -- Get License Usage for Archived VMs
	BEGIN
		SELECT  VMId	"VM ID", VMName "Virtual Machine", VMArchiveJob "VM Archived Job",
			ArchivedVMSize "Archived VM Size",OrgGUID "Organization ID", Organization, PlanName "Plan"
		FROM Lic_CCL_ArchivedVMs_vw
		WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID) AND MonthStart = @month
	END
	ELSE IF @option = 16 -- Get License Usage for Archived VMs excluded from Capacity
	BEGIN
		IF object_id('tempdb.dbo.#ArchVMJobsExcluded') IS NOT NULL DROP TABLE #ArchVMJobsExcluded
        CREATE TABLE #ArchVMJobsExcluded(ParentId INT, ParentName NVARCHAR(255), VMId INT, VMName NVARCHAR(255), ParentJobId INT, ChildJobid INT, JobTypeName VARCHAR(15), SubclientId INT, AppSizeMB BIGINT, Organization NVARCHAR(1024), OrgGUID UNIQUEIDENTIFIER, PlanName NVARCHAR(1024), SubclientName NVARCHAR(255), BackupsetId INT, BackupSetName NVARCHAR(1024), InstanceId INT, InstanceName NVARCHAR(1024), SPId INT, SPName NVARCHAR(1024))
		INSERT #ArchVMJobsExcluded
		SELECT DISTINCT ClientId, ClientName, ClientId, ClientName, JobId, JobId, JobType,
		SubclientId, AppSizeMB, Organization, OrgGUID, PlanName, 'N/A', 0, 'N/A', 0, 'N/A', 0, ''
		FROM Lic_CCL_ArchviedVMJobs_NotInCapacity_vw U1
		WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID) AND MonthStart = @month
		UPDATE U1
		SET U1.ParentJobId=ISNULL(V2.ObjectId,-1), U1.SubclientId=V2.VMFlag
		FROM #ArchVMJobsExcluded U1
		LEFT JOIN Lic_PeakUsage V2 WITH (NOLOCK) ON V2.SubclientId=U1.SubclientId AND V2.UsageType=CASE WHEN U1.JobTypeName='Backup' THEN 1 WHEN U1.JobTypeName='Archive' THEN 2 WHEN U1.JobTypeName='Snapshot' THEN 3 ELSE 4 END
		WHERE V2.UsageType IN (1,2,3,4) AND V2.CapacityFlag=32 AND V2.AppTypeId=106 AND V2.ObjectId>0 AND V2.PeakType=0 AND (@orgGUID IS NULL OR V2.OrgGUID = @orgGUID) AND V2.MonthStart=@month
		UPDATE U1
		SET U1.SubclientName=ISNULL(A.subclientName,'N/A'), U1.BackupsetId=ISNULL(B.id,-1), U1.BackupSetName=ISNULL(B.name,'N/A'), U1.InstanceId=ISNULL(I.id,-1), U1.InstanceName=ISNULL(I.name,'N/A'), U1.SPId=ISNULL(AG.id,-1), U1.SPName=ISNULL(AG.name,'N/A')
		, U1.ParentId=ISNULL(A.clientId,-1), U1.ParentName=ISNULL(C.name,'N/A')
		FROM #ArchVMJobsExcluded U1
		LEFT JOIN APP_Application A WITH (NOLOCK) ON A.id=U1.SubclientId
		LEFT JOIN APP_BackupSetName B WITH (NOLOCK) ON B.id=A.backupSet
		LEFT JOIN APP_InstanceName I WITH (NOLOCK) ON I.id=A.instance
		LEFT JOIN archGroup AG WITH (NOLOCK) ON AG.id=A.dataArchGrpID
		LEFT JOIN APP_Client C WITH (NOLOCK) ON A.clientId=C.id
		SELECT 143 AS "License ID", 'Virtual Server' AS License, VMId "Client ID", VMName "Client", 106 AS "Agent ID", 'Virtual Server' AS Agent,
			SubclientId AS "Subclient ID", SubclientName AS Subclient, SPId AS "Storage Policy ID", SPName AS "Storage Policy", BackupSetName AS Backupset,
			InstanceName AS Instance, JobTypeName AS "Job Type", ChildJobId AS "Job ID", AppSizeMB AS Usage, Organization, OrgGUID AS "Organization ID", PlanName As "Plan",
			BackupsetId AS "Backupset ID", InstanceId AS "Instance ID", ParentId AS "Virtualization Client ID", ParentName AS "Virtualization Client", ParentJobId AS "Parent Job ID"
		FROM #ArchVMJobsExcluded
		IF object_id('tempdb.dbo.#ArchVMJobsExcluded') IS NOT NULL DROP TABLE #ArchVMJobsExcluded
	END
	ELSE IF @option = 17 -- Get License Usage for End point Users
	BEGIN
		SELECT UserId "User ID", UserName "User Name", UserLogin "User Login", UserEmail "E Mail", Associations, OrgGUID "Organization ID", Organization, PlanName "Plan"
		FROM Lic_CCL_EpUsers_vw
		WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID) AND MonthStart = @month
	END
	ELSE IF @option = 18 -- Get License Usage for DLP excluded from Capacity
	BEGIN
		SELECT LicType "License ID", CASE WHEN Lictype < 1 THEN 'N/A' ELSE LicName END License, ClientId "Client ID",	ClientName Client, AppTypeId "Agent ID", AppTypeName Agent, SubclientId "Subclient ID", SubclientName Subclient,
				SPId "Storage Policy ID", SPName "Storage Policy", BackupSetName "Backupset", InstanceName "Instance", JobType "Job Type", JobId "Job ID",
				AppSizeMB "Usage", OrgGUID "Organization ID", Organization, PlanName "Plan", BackupSetId "Backupset ID", InstanceId "Instance ID"
		FROM Lic_CCL_DLPJobs_NotInCapacity_vw
		WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID) AND MonthStart = @month
	END
	ELSE IF @option = 19 -- Get License Usage for Endpoint Sharing users
	BEGIN
		SELECT UserId "User ID", UserName "User Name", UserLogin "User Login", UserEmail "E Mail", Associations, OrgGUID "Organization ID", Organization, PlanName "Plan"
		FROM Lic_CCL_EpSharingUsers_vw
		WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID) AND MonthStart = @month
	END
	ELSE IF @option = 20 -- Get License Usage for EDiscovery USers
	BEGIN
		SELECT UserId "User ID", UserName "User Name", UserLogin "User Login", UserEmail "E Mail", Associations, OrgGUID "Organization ID", Organization, PlanName "Plan"
		FROM Lic_CCL_EpEDiscoveryUsers_vw
		WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID) AND MonthStart = @month
	END
	ELSE IF @option = 21 -- Get License Usage for File Systems Only Server without Usage
	BEGIN
		SELECT ClientId "Client ID", ClientName Client, OrgGUID "Organization ID", Organization, PlanName "Plan", LicType "License ID", CASE WHEN Lictype < 1 THEN 'N/A' ELSE LicName END License
		FROM Lic_CCL_FSonlyServersWithoutUsage_vw
		WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID) AND MonthStart = @month
	END
	ELSE IF @option = 22  -- Get License Usage for File System Only servers with Usage
	BEGIN
		SELECT  LicType "License ID", CASE WHEN Lictype < 1 THEN 'N/A' ELSE LicName END License, ActualLicType "Actual License ID", CASE WHEN ActualLicType < 1 THEN 'N/A' ELSE ActualLicName END "Actual License",
				ClientId "Client ID",	ClientName Client, AppTypeId "Agent ID", AppTypeName Agent, SubclientId "Subclient ID", SubclientName Subclient,
				SPId "Storage Policy ID", SPName "Storage Policy", BackupSetName "Backupset", InstanceName "Instance", JobType "Job Type", JobId "Job ID",
				AppSizeMB "Usage", OrgGUID "Organization ID", Organization, PlanName "Plan", BackupSetId "Backupset ID", InstanceId "Instance ID"
		FROM Lic_CCL_FSonlyServersWithUsage_vw
		WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID) AND MonthStart = @month
	END
	ELSE IF @option = 23  -- Get License Usage for DL Only with Usage
	BEGIN
		SELECT ClientId "Client ID", ClientName Client, OrgGUID "Organization ID", Organization, PlanName "Plan"
		FROM Lic_CCL_DLOsWithoutUsage_vw
		WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID) AND MonthStart = @month
	END
	ELSE IF @option = 24   -- Get License Usage for DL Only without Usage
	BEGIN
		SELECT  LicType "License ID", CASE WHEN Lictype < 1 THEN 'N/A' ELSE LicName END License, ClientId "Client ID",	ClientName Client, AppTypeId "Agent ID", AppTypeName Agent, SubclientId "Subclient ID", SubclientName Subclient,
				SPId "Storage Policy ID", SPName "Storage Policy", BackupSetName "Backupset", InstanceName "Instance", JobType "Job Type", JobId "Job ID",
				AppSizeMB "Usage", OrgGUID "Organization ID", Organization, PlanName "Plan", BackupSetId "Backupset ID", InstanceId "Instance ID"
		FROM Lic_CCL_DLOsWithUsage_vw
		WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID) AND MonthStart = @month
	END
	ELSE IF @option = 25  -- Get License Usage for Application Servers without Usage
	BEGIN
		SELECT ClientId "Client ID", ClientName Client, OrgGUID "Organization ID", Organization, PlanName "Plan"
		FROM Lic_CCL_AppServersWithoutUsage_vw
		WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID) AND MonthStart = @month
	END
	ELSE IF @option = 26 -- Get License Usage for Application Servers with Usage
	BEGIN
		SELECT  LicType "License ID", CASE WHEN Lictype < 1 THEN 'N/A' ELSE LicName END License, ClientId "Client ID",	ClientName Client, AppTypeId "Agent ID", AppTypeName Agent, SubclientId "Subclient ID", SubclientName Subclient,
				SPId "Storage Policy ID", SPName "Storage Policy", BackupSetName "Backupset", InstanceName "Instance", JobType "Job Type", JobId "Job ID",
				AppSizeMB "Usage", OrgGUID "Organization ID", Organization, PlanName "Plan", BackupSetId "Backupset ID", InstanceId "Instance ID"
		FROM Lic_CCL_AppServersWithUsage_vw
		WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID) AND MonthStart = @month
	END
	ELSE IF @option = 27  -- Get License Usage for VM Only
	BEGIN
		SELECT   VMId "VM ID", VMName "Virtual Machine", VMProtectionJob "VM Protection Job",	ProtectedVMSize "Protected VM Size",
				OrgGUID "Organization ID", Organization, PlanName "Plan"
		FROM Lic_CCL_VMOnly_vw
		WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID) AND MonthStart = @month
	END
	ELSE IF @option = 28  -- Get License Usage for Advanced VMs
	BEGIN
		SELECT   VMId "VM ID", VMName "Virtual Machine", Package, VMProtectionJob "VM Protection Job",	ProtectedVMSize "Protected VM Size",
				OrgGUID "Organization ID", Organization, PlanName "Plan"
		FROM Lic_CCL_VMWithApps_vw
		WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID) AND MonthStart = @month
	END
	ELSE IF @option = 29 -- Get License Usage for Application Users
	BEGIN
		--get sharepoint online users
		IF object_id('tempdb.dbo.#AppUsers') IS NOT NULL DROP TABLE #AppUsers
        CREATE TABLE #AppUsers(Smtp NVARCHAR(1024), OrgGUID UNIQUEIDENTIFIER, Organization NVARCHAR(1024), PlanName NVARCHAR(1024), LicName VARCHAR(128), VMFlag INT)
		INSERT #AppUsers
		SELECT DISTINCT Smtp, OrgGUID, Organization, PlanName, LicName, VMFlag
		FROM Lic_CCL_ApplicationUsers_vw
		WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID) AND MonthStart = @month
		AND LicType=200012
		--remove rows with default plan if any row with non-default plan is present for the same user
		DELETE A1 FROM #AppUsers A1
		INNER JOIN #AppUsers A2 ON A1.Smtp=A2.Smtp AND (A1.OrgGUID=A2.OrgGUID OR (A1.OrgGUID IS NULL AND A2.OrgGUID IS NULL))
		WHERE A1.planname IS NULL AND A2.PlanName IS NOT NULL
		--get the rest of the application users
		INSERT #AppUsers
		SELECT DISTINCT Smtp, OrgGUID, Organization, PlanName, LicName, VMFlag
		FROM Lic_CCL_ApplicationUsers_vw
		WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID) AND MonthStart = @month
		AND LicType<>200012
		--find whether compliance search, content indexing and case manager is enabled for each user
		DECLARE @enablerTable TABLE (SMTP NVARCHAR(1024), OrgGUID UNIQUEIDENTIFIER, enabler INT)
		INSERT INTO @enablerTable
		SELECT DISTINCT Smtp, OrgGUID, ISNULL(SUM(DISTINCT p),0)
		FROM #AppUsers Usage
		OUTER APPLY
		(SELECT p FROM
			(SELECT POWER(2,n) FROM
				(VALUES (0),(1),(2)) Nos(n)
			)Powers(p)
			WHERE p&Usage.VMFlag = p
		)Bitmask
		WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID)
		GROUP BY Smtp,OrgGUID
		--summarize all appuser details
		SELECT Smtp AS SMTP, OrgGUID "Organization ID", Organization, "Plan", CASE WHEN [Exchange Mailbox] > 0 THEN 1 ELSE 0 END "Exchange Mailbox",
		CASE WHEN [Exchange OnePass] > 0 THEN 1 ELSE 0 END "Exchange OnePass", CASE WHEN [SharePoint Online] > 0 THEN 1 ELSE 0 END "SharePoint Online",
		CASE WHEN [Gmail] > 0 THEN 1 ELSE 0 END "Gmail", CASE WHEN [GDrive] > 0 THEN 1 ELSE 0 END "GDrive", CASE WHEN [OneDrive] > 0 THEN 1 ELSE 0 END "OneDrive",
		CASE WHEN [Salesforce] > 0 THEN 1 ELSE 0 END "Salesforce", CASE WHEN [Notes] > 0 THEN 1 ELSE 0 END "Notes",
		CASE WHEN Checker&1>0 THEN 1 ELSE 0 END AS 'CI Enabled', CASE WHEN Checker&2>0 THEN 1 ELSE 0 END AS 'CM Enabled', CASE WHEN Checker&4>0 THEN 1 ELSE 0 END AS 'CS Enabled'
		FROM (
			SELECT Usage.Smtp, Usage.OrgGUID, Organization, PlanName AS "Plan", LicName, E.enabler AS Checker
			FROM #AppUsers Usage
			LEFT JOIN
			@enablerTable E ON Usage.Smtp = E.SMTP AND (Usage.OrgGUID = E.OrgGUID OR (Usage.OrgGUID IS NULL and E.OrgGUID IS NULL))
			WHERE (@orgGUID IS NULL OR Usage.OrgGUID = @orgGUID)
		) AS SourceTable
		PIVOT
		(
			COUNT(LicName)
			FOR LicName IN ([Exchange Mailbox],[Exchange OnePass],[SharePoint Online],[Gmail],[GDrive],[OneDrive],[Salesforce],[Notes])
		) AS PivotTable
		IF object_id('tempdb.dbo.#AppUsers') IS NOT NULL DROP TABLE #AppUsers
	END
	ELSE IF @option = 30 -- Get License Usage for Application Users not in Capacity
	BEGIN
		SELECT LicType "License ID", CASE WHEN Lictype < 1 THEN 'N/A' ELSE LicName END License, ClientId "Client ID",	ClientName Client, AppTypeId "Agent ID", AppTypeName Agent, SubclientId "Subclient ID", SubclientName Subclient,
				SPId "Storage Policy ID", SPName "Storage Policy", BackupSetName "Backupset", InstanceName "Instance", JobType "Job Type", JobId "Job ID",
				AppSizeMB "Usage", OrgGUID "Organization ID", Organization, PlanName "Plan", BackupSetId "Backupset ID", InstanceId "Instance ID"
		FROM Lic_CCL_AppUserJobs_NotInCapacity_vw
		WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID) AND MonthStart = @month
	END
	ELSE IF @option = 31 -- Get License Usage for Edge drive excluded from Capacity
	BEGIN
		SELECT LicType "License ID", CASE WHEN Lictype < 1 THEN 'N/A' ELSE LicName END License, ClientId "Client ID",	ClientName Client, AppTypeId "Agent ID", AppTypeName Agent, SubclientId "Subclient ID", SubclientName Subclient,
				SPId "Storage Policy ID", SPName "Storage Policy", BackupSetName "Backupset", InstanceName "Instance", JobType "Job Type", JobId "Job ID",
				AppSizeMB "Usage", OrgGUID "Organization ID", Organization, PlanName "Plan", BackupSetId "Backupset ID", InstanceId "Instance ID"
		FROM Lic_CCL_EdgeDriveJobs_NotInCapacity_vw
		WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID) AND MonthStart = @month
	END
	ELSE IF @option = 32  -- Get License Peak Usage for Commvault Complete
	BEGIN
		IF object_id('tempdb.dbo.#VSACompleteJobs') IS NOT NULL DROP TABLE #VSACompleteJobs
        CREATE TABLE #VSACompleteJobs(ParentId INT, ParentName NVARCHAR(255), VMId INT, VMName NVARCHAR(255), ParentJobId INT, ChildJobid INT, JobTypeName VARCHAR(15), SubclientId INT, AppSizeMB BIGINT, Organization NVARCHAR(1024), OrgGUID UNIQUEIDENTIFIER, PlanName NVARCHAR(1024), SubclientName NVARCHAR(255), BackupsetId INT, BackupSetName NVARCHAR(1024), InstanceId INT, InstanceName NVARCHAR(1024), SPId INT, SPName NVARCHAR(1024))
		INSERT #VSACompleteJobs
		SELECT DISTINCT ClientId, ClientName, ClientId, ClientName, JobId, JobId, CASE WHEN U1.UsageType=1 THEN 'Backup' WHEN U1.UsageType=2 THEN 'Archive' WHEN U1.UsageType=3 THEN 'Snapshot' WHEN U1.UsageType=4 THEN 'Replication' END,
		SubclientId, AppSizeMB, Organization, OrgGUID, PlanName, 'N/A', 0, 'N/A', 0, 'N/A', 0, 'N/A'
		FROM Lic_PeakUsage U1
		WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID) AND MonthStart=@month AND PeakType=0 AND UsageType IN (1,2) AND U1.CapacityFlag=0
		AND U1.AppTypeId=106
		UPDATE U1
		SET U1.ParentJobId=ISNULL(V2.ObjectId,-1), U1.SubclientId=V2.VMFlag
		FROM #VSACompleteJobs U1
		LEFT JOIN Lic_PeakUsage V2 WITH (NOLOCK) ON V2.SubclientId=U1.SubclientId AND V2.UsageType=CASE WHEN U1.JobTypeName='Backup' THEN 1 WHEN U1.JobTypeName='Archive' THEN 2 WHEN U1.JobTypeName='Snapshot' THEN 3 ELSE 4 END
		WHERE V2.UsageType IN (1,2) AND V2.CapacityFlag=0 AND V2.AppTypeId=106 AND V2.ObjectId>0 AND V2.PeakType=0 AND (@orgGUID IS NULL OR V2.OrgGUID = @orgGUID) AND V2.MonthStart=@month
		UPDATE U1
		SET U1.SubclientName=ISNULL(A.subclientName,'N/A'), U1.BackupsetId=ISNULL(B.id,-1), U1.BackupSetName=ISNULL(B.name,'N/A'), U1.InstanceId=ISNULL(I.id,-1), U1.InstanceName=ISNULL(I.name,'N/A'), U1.SPId=ISNULL(AG.id,-1), U1.SPName=ISNULL(AG.name,'N/A')
		, U1.ParentId=ISNULL(A.clientId,-1), U1.ParentName=ISNULL(C.name,'N/A')
		FROM #VSACompleteJobs U1
		LEFT JOIN APP_Application A WITH (NOLOCK) ON A.id=U1.SubclientId
		LEFT JOIN APP_BackupSetName B WITH (NOLOCK) ON B.id=A.backupSet
		LEFT JOIN APP_InstanceName I WITH (NOLOCK) ON I.id=A.instance
		LEFT JOIN archGroup AG WITH (NOLOCK) ON AG.id=A.dataArchGrpID
		LEFT JOIN APP_Client C WITH (NOLOCK) ON A.clientId=C.id
		SELECT 143 AS "License ID", 'Virtual Server' AS License, VMId "Client ID", VMName "Client", 106 AS "Agent ID", 'Virtual Server' AS Agent,
		SubclientId AS "Subclient ID", SubclientName AS Subclient, SPId AS "Storage Policy ID", SPName AS "Storage Policy", BackupSetName AS Backupset,
		InstanceName AS Instance, JobTypeName AS "Job Type", ChildJobId AS "Job ID", AppSizeMB AS Usage, Organization, OrgGUID AS "Organization ID", PlanName As "Plan",
		BackupsetId AS "Backupset ID", InstanceId AS "Instance ID", ParentId AS "Virtualization Client ID", ParentName AS "Virtualization Client", ParentJobId AS "Parent Job ID"
		FROM #VSACompleteJobs
		UNION
		SELECT  LicType AS "License ID", CASE WHEN Lictype < 1 THEN 'N/A' ELSE LicName END AS License, ClientId AS "Client ID", ClientName AS Client,
		AppTypeId AS "Agent ID", CASE WHEN AppTypeId < 1 THEN 'N/A' ELSE AppTypeName END AS Agent,
		SubclientId AS "Subclient ID", SubclientName AS Subclient, SPId AS "Storage Policy ID", SPName AS "Storage Policy", BackupSetName AS Backupset,
		InstanceName AS Instance, JobType AS "Job Type", JobId AS "Job ID", AppSizeMB AS Usage, Organization, OrgGUID AS "Organization ID", PlanName As "Plan",
		BackupsetId AS "Backupset ID", InstanceId AS "Instance ID", 0, 'N/A', 0
		FROM Lic_CCL_Backups_InCapacity_vw
		WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID) AND MonthStart=@month
		AND AppTypeId<>106
		UNION
		SELECT  LicType AS "License ID", CASE WHEN Lictype < 1 THEN 'N/A' ELSE LicName END AS License, ClientId AS "Client ID", ClientName AS Client,
		AppTypeId AS "Agent ID", CASE WHEN AppTypeId < 1 THEN 'N/A' ELSE AppTypeName END AS Agent,
		SubclientId AS "Subclient ID", SubclientName AS Subclient, SPId AS "Storage Policy ID", SPName AS "Storage Policy", BackupSetName AS Backupset,
		InstanceName AS Instance, JobType AS "Job Type", JobId AS "Job ID", AppSizeMB AS Usage, Organization, OrgGUID AS "Organization ID", PlanName As "Plan",
		BackupsetId AS "Backupset ID", InstanceId AS "Instance ID", 0, 'N/A', 0
		FROM Lic_CCL_Archives_InCapacity_vw
		WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID) AND MonthStart=@month
		AND AppTypeId<>106
		IF object_id('tempdb.dbo.#VSACompleteJobs') IS NOT NULL DROP TABLE #VSACompleteJobs
	END
	ELSE IF @option = 33 -- Get License Peak summary for File Systems Only Servers & VMs
	BEGIN
		DECLARE @fsonlyTbl TABLE(LicType INT, LicName VARCHAR(32), Used INT)
		INSERT INTO @fsonlyTbl VALUES (100029, 'File System only Server',0), (200017, 'File System only VM',0)
		UPDATE T SET T.Used=F.Used
		FROM @fsonlyTbl T
		INNER JOIN
		(
			SELECT LicType, COUNT(DISTINCT ClientId) Used
			FROM Lic_CCL_FSonlyServers_vw
			WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID) AND MonthStart = @month
			GROUP BY LicType
		)F ON F.LicType=T.LicType
		SELECT LicType "License ID", LicName "License", Used FROM @fsonlyTbl
	END
	ELSE IF @option = 34 -- Get Peak Usage of Live Sync pairs for VMs
	BEGIN
		SELECT SourceClientId "Source ID", SourceClientName "Source Name", SourceGUID "Source GUID", DestinationName "Destination Name",
		OrgGUID "Organization ID", Organization, PlanName "Plan"
		FROM Lic_CCL_LiveSyncForVM_vw
		WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID) AND MonthStart=@month
	END
	ELSE IF @option = 35 -- Get Peak License Usage for OI
	BEGIN
		SELECT ClientId "Client ID", ClientName Client, OICount "Number of Operating Instances", OrgGUID "Organization ID", Organization, PlanName "Plan"
		FROM Lic_CCL_OIs_vw
		WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID) AND MonthStart = @month
	END
	ELSE IF @option = 36 -- Get Peak License Usage for VOI
	BEGIN
		SELECT ClientId "Client ID", ClientName Client, OrgGUID "Organization ID", Organization, PlanName "Plan"
		FROM Lic_CCL_VOIs_vw
		WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID) AND MonthStart = @month
	END
	ELSE IF @option = 37 -- Get Peak License Usage for OI excluded from Capacity
	BEGIN
		SELECT LicType "License ID", CASE WHEN Lictype < 1 THEN 'N/A' ELSE LicName END License, ClientId "Client ID",	ClientName Client, AppTypeId "Agent ID", AppTypeName Agent, SubclientId "Subclient ID", SubclientName Subclient,
				SPId "Storage Policy ID", SPName "Storage Policy", BackupSetName "Backupset", InstanceName "Instance", JobType "Job Type", JobId "Job ID",
				AppSizeMB "Usage", OrgGUID "Organization ID", Organization, PlanName "Plan", BackupSetId "Backupset ID", InstanceId "Instance ID"
		FROM Lic_CCL_OIJobs_NotInCapacity_vw
		WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID) AND MonthStart = @month
	END
	ELSE IF @option = 38 -- Get Peak License Usage for VOI excluded from Capacity
	BEGIN
		SELECT LicType "License ID", CASE WHEN Lictype < 1 THEN 'N/A' ELSE LicName END License, ClientId "Client ID",	ClientName Client, AppTypeId "Agent ID", AppTypeName Agent, SubclientId "Subclient ID", SubclientName Subclient,
				SPId "Storage Policy ID", SPName "Storage Policy", BackupSetName "Backupset", InstanceName "Instance", JobType "Job Type", JobId "Job ID",
				AppSizeMB "Usage", OrgGUID "Organization ID", Organization, PlanName "Plan", BackupSetId "Backupset ID", InstanceId "Instance ID"
		FROM Lic_CCL_VOIJobs_NotInCapacity_vw
		WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID) AND MonthStart = @month
	END
	ELSE IF @option = 39 -- Get Peak Usage of HyperScale
	BEGIN
		SELECT StoragePoolId "Storage Pool ID", StoragePoolName "Storage Pool Name", TotalCapacityMB "Total Capacity", UsedCapacityMB "Used Capacity", ApplianceType "Appliance Type",
		OrgGUID "Organization ID", Organization, PlanName "Plan"
		FROM Lic_CCL_HyperScale_vw
		WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID) AND MonthStart=@month
	END
	ELSE IF @option = 40 -- Get Peak Usage of DR VM
	BEGIN
		SELECT SourceVMId "Source VM ID", SourceVMName "Source VM Name",
		OrgGUID "Organization ID", Organization, PlanName "Plan"
		FROM Lic_CCL_DRVM_vw
		WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID) AND MonthStart=@month
	END
	ELSE IF @option = 41 -- Get Peak License Usage for DRVM excluded from Capacity
	BEGIN
		SELECT LicType "License ID", CASE WHEN Lictype < 1 THEN 'N/A' ELSE LicName END License, ClientId "Client ID",	ClientName Client, AppTypeId "Agent ID", AppTypeName Agent, SubclientId "Subclient ID", SubclientName Subclient,
				SPId "Storage Policy ID", SPName "Storage Policy", BackupSetName "Backupset", InstanceName "Instance", JobType "Job Type", JobId "Job ID",
				AppSizeMB "Usage", OrgGUID "Organization ID", Organization, PlanName "Plan", BackupSetId "Backupset ID", InstanceId "Instance ID"
		FROM Lic_CCL_DRVMJobs_NotInCapacity_vw
		WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID) AND MonthStart = @month
	END
	ELSE IF @option = 42 -- Get Activate usage details
	BEGIN
		SET @capacityType=CONVERT(INT,@timezone)--timezone variable is reused to input capacity type here
		SET @sqlQuery = N'SELECT'
		IF @capacityType IN (0,1,3)
			SET @sqlQuery += N' ClientId "Client ID", ClientName "Client", AppSizeMB "Usage"'
		ELSE IF @capacityType IN (2,4)
			SET @sqlQuery += N' UserCount "User Count"'
		SET @sqlQuery += N', OrgGUID "Company ID", Organization "Company", PlanName "Plan" FROM'
		IF @capacityType=0
			SET @sqlQuery += N' Lic_CCL_Activate_File_Optimization_vw'
		ELSE IF @capacityType=1
			SET @sqlQuery += N' Lic_CCL_Activate_Ediscovery_Files_vw'
		ELSE IF @capacityType=2
			SET @sqlQuery += N' Lic_CCL_Activate_Ediscovery_Emails_vw'
		ELSE IF @capacityType=3
			SET @sqlQuery += N' Lic_CCL_Activate_Sensitive_Files_vw'
		ELSE IF @capacityType=4
			SET @sqlQuery += N' Lic_CCL_Activate_Sensitive_Emails_vw'
		SET @sqlQuery += N' WHERE MonthStart = '''+CONVERT(VARCHAR(20),@month)+''''
		IF @orgGUID IS NOT NULL
			SET @sqlQuery += N' AND OrgGUID = '''+CONVERT(VARCHAR(40),@orgGUID)+''''
		EXEC sp_executesql @sqlQuery
	END
	ELSE IF @option = 44 -- Get Metallic Storage usage details
	BEGIN
		SET @capacityType=CONVERT(INT,@timezone)--timezone variable is reused to input capacity type here
		SET @sqlQuery = N'SELECT StoragePoolId "Storage Pool ID", StoragePool "Storage Pool", ContainerId "Container ID", Container, AppSizeMB "Usage", OrgGUID "Company ID", Organization "Company", PlanName "Plan" FROM'
		IF @capacityType=1
			SET @sqlQuery += N' Lic_CCL_Metallic_Storage_vw'
		ELSE IF @capacityType=2
			SET @sqlQuery += N' Lic_CCL_Metallic_Storage_T2_vw'
		ELSE IF @capacityType=3
			SET @sqlQuery += N' Lic_CCL_Metallic_Storage_T3_vw'
		ELSE IF @capacityType=4
			SET @sqlQuery += N' Lic_CCL_Metallic_Storage_T4_vw'
		ELSE IF @capacityType=5
			SET @sqlQuery += N' Lic_CCL_Metallic_Storage_T5_vw'
		ELSE IF @capacityType=6
			SET @sqlQuery += N' Lic_CCL_Metallic_Storage_T6_vw'
		ELSE IF @capacityType=7
			SET @sqlQuery += N' Lic_CCL_Metallic_Storage_T7_vw'
		ELSE IF @capacityType=8
			SET @sqlQuery += N' Lic_CCL_Metallic_Storage_T8_vw'
		ELSE IF @capacityType=9
			SET @sqlQuery += N' Lic_CCL_Metallic_Storage_T9_vw'
		ELSE IF @capacityType=10
			SET @sqlQuery += N' Lic_CCL_Metallic_Storage_T10_vw'
		SET @sqlQuery += N' WHERE MonthStart = '''+CONVERT(VARCHAR(20),@month)+''''
		IF @orgGUID IS NOT NULL
			SET @sqlQuery += N' AND OrgGUID = '''+CONVERT(VARCHAR(40),@orgGUID)+''''
		EXEC sp_executesql @sqlQuery
	END
	ELSE IF @option = 45 -- Get Peak OI instances in use
	BEGIN
		SELECT DISTINCT ClientId "Client ID", ClientName "Client", ISNULL(SubclientName, ClientName) "Operating Instance Name",
		CASE CapacityFlag WHEN 4 THEN 'Amazon RDS' WHEN 22 THEN 'Amazon DynamoDB' WHEN 23 THEN 'Azure Cosmos DB SQL API' WHEN 26 THEN 'Amazon Redshift' WHEN 27 THEN 'Amazon DocumentDB' WHEN 32 THEN 'Azure Table Storage' ELSE 'N/A' END "Operating Instance Type",
		OrgGUID "Organization ID", Organization, PlanName "Plan"
		FROM Lic_PeakUsage WITH (NOLOCK)
		WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID) AND MonthStart = @month AND PeakType = 0 AND UsageType = 30
	END
END
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'Lic_CCL_GetLicenseUsage')
	delete from GxQscripts where name = 'Lic_CCL_GetLicenseUsage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='Lic_CCL_GetLicenseUsage')
	delete from GXDBVersions where aliasname = 'Lic_CCL_GetLicenseUsage'
GO

insert into GXDBVersions values(2, 'Lic_CCL_GetLicenseUsage',  'v1.1.2.12.8.1', 'Lic_CCL_GetLicenseUsage', 'v1.1.2.12.8.1')
GO

