

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/LicVOIToOI.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Zach Wang
--	Date:   4/3/2019
-- ----------------------------------------------------------------------*/
-- Following Line Indicates new Class.  It should be identical to filename+revision!
-- @i_clientId can be client ID or Library ID
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='LicVOIToOI')
BEGIN
	print '>>> Drop Stored Procedure: LicVOIToOI <<<'
	drop procedure LicVOIToOI
END
IF EXISTS (select * from GxQscripts where name='LicVOIToOI')
	delete from GxQscripts where name = 'LicVOIToOI'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LicVOIToOI')
	delete from GXDBVersions where aliasname = 'LicVOIToOI'
GO
print '... Creating Procedure: LicVOIToOI'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure LicVOIToOI
  @in_VOIUsed INTEGER = 0,	
  @in_OIUsed INTEGER = 0,	
  @nVOIToOI INTEGER = 0 OUTPUT
AS
SET NOCOUNT ON
DECLARE @evalFld    varchar(1024)
DECLARE @permFld    varchar(1024)
DECLARE @licTypeId  integer
DECLARE @evalTotal  integer
DECLARE @evalUsed   integer
DECLARE @bEval      integer
DECLARE @evalExpiry integer
DECLARE @permTotal  integer
DECLARE @permUsed   integer
DECLARE @bPerm      integer = 0
DECLARE @permExpiry integer = 0
DECLARE @currentTime int = dbo.GetUNIXTime(GETUTCDATE())
DECLARE @TotalVOILicensesIssued INT = 0
DECLARE @TotalOILicensesIssued  INT = 0
DECLARE @TotalLicensesIssued	INT = 0
DECLARE @nAvailOI		integer = 0
DECLARE @nReqVOI		integer = 0
DECLARE licList CURSOR FOR
    SELECT simLicAppTypeId, RTRIM(eval_fld1), RTRIM(perm_fld1) FROM licAAL A WITH (NOLOCK) WHERE  commcellId = 2 AND simLicAppTypeId in (100032,100033)
OPEN licList
FETCH NEXT FROM licList INTO @licTypeId, @evalFld, @permFld
WHILE @@FETCH_STATUS = 0
BEGIN
    SET @evalTotal  = 0
    SET @evalUsed   = 0
    SET @bEval      = 0
    SET @evalExpiry = 0
    SET @permTotal  = 0
    SET @permUsed   = 0
    IF len(@evalFld) > 0
       EXEC dbo.xp_getAALInfo2 @evalFld, @evalTotal OUTPUT, @evalUsed OUTPUT, @bEval OUTPUT, @evalExpiry OUTPUT
    IF len(@permFld) > 0
        EXEC dbo.xp_getAALInfo2 @permFld, @permTotal OUTPUT, @permUsed OUTPUT, @bPerm OUTPUT, @permExpiry OUTPUT
    IF @evalExpiry = 0 OR @evalExpiry > @currentTime
			SET @TotalLicensesIssued = @evalTotal
	IF @permExpiry = 0 OR @permExpiry > @currentTime
	BEGIN
		IF @TotalLicensesIssued < 0 OR @permTotal < 0
			SET @TotalLicensesIssued = -1
		ELSE
			SET @TotalLicensesIssued = @TotalLicensesIssued + @permTotal
	END
	IF @licTypeId  = 100032
	SET @TotalOILicensesIssued = @TotalLicensesIssued
	ELSE IF @licTypeId  = 100033
	SET @TotalVOILicensesIssued = @TotalLicensesIssued
    FETCH NEXT FROM licList INTO @licTypeId, @evalFld, @permFld
END
CLOSE licList
DEALLOCATE licList
IF @TotalOILicensesIssued >= 0
SET @nAvailOI = @TotalOILicensesIssued * 1.1 - @in_OIUsed
IF @TotalVOILicensesIssued > 0 AND @in_VOIUsed > 0
SET @nReqVOI = @in_VOIUsed - @TotalVOILicensesIssued * 1.1 + 1
ELSE IF @TotalVOILicensesIssued = 0 AND @in_VOIUsed > 0
SET @nReqVOI = @in_VOIUsed
IF @TotalVOILicensesIssued < 0 OR @nReqVOI < = 0 OR @nAvailOI < = 0
SET @nVOIToOI = 0
ELSE IF @TotalOILicensesIssued < 0 AND @nReqVOI > 0
SET @nVOIToOI = @nReqVOI
ELSE IF @nAvailOI > 0 AND @nReqVOI > 0
BEGIN
	IF @nAvailOI >= @nReqVOI
	SET @nVOIToOI = @nReqVOI
	ELSE
	SET @nVOIToOI = @nAvailOI
END
SET NOCOUNT OFF
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'LicVOIToOI')
	delete from GxQscripts where name = 'LicVOIToOI'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LicVOIToOI')
	delete from GXDBVersions where aliasname = 'LicVOIToOI'
GO

insert into GXDBVersions values(2, 'LicVOIToOI',  '00000000000000000000', 'LicVOIToOI', '00000000000000000000')
GO

