

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/LicUpdateOEMProps.sp] ---------- 

-- ----------------------------------------------------------------------
--
--  Copyright (c) CommVault Systems
--  All Rights Reserved
--
--  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF CommVault Systems
--  The copyright notice above does not evidence any
--  actual or intended publication of such source code.
--
--  File name   : LicUpdateOEMProps.sp
--
--  Description : Usede to update OEM info. Used by licenseActivation & QS_UpdateOEM
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/LicUpdateOEMProps.sp,v $ $Id: LicUpdateOEMProps.sp,v 1.2.62.3 2018/03/27 08:54:18 jiechen Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
-- @i_clientId can be client ID or Library ID
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: LicUpdateOEMProps <<<'

IF EXISTS (select * from sysobjects where name='LicUpdateOEMProps')
	drop procedure LicUpdateOEMProps
IF EXISTS (select * from GxQscripts where name='LicUpdateOEMProps')
	delete from GxQscripts where name = 'LicUpdateOEMProps'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LicUpdateOEMProps')
	delete from GXDBVersions where aliasname = 'LicUpdateOEMProps'
GO
print '... Creating Procedure: LicUpdateOEMProps'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure LicUpdateOEMProps
  @i_newOEMId INT,
  @i_CSId INT,
  @i_CSIdEncStr VARCHAR(64),
  @i_CSHostName VARCHAR(255),
  @i_licUpdateTime INT,
  @i_updateFlag INT
AS
SET NOCOUNT ON
	-------------------------------------
	-- Add eval value for new CS
	IF @i_updateFlag > 1
	BEGIN
		DECLARE	@UserNameVal	NVARCHAR(MAX)
		DECLARE	@passwordVal	NVARCHAR(MAX)
		IF @i_CSId > 0
		BEGIN
			IF @i_CSIdEncStr IS NULL OR LEN(@i_CSIdEncStr) = 0
			BEGIN
				DECLARE @csIdStr VARCHAR(64) = CAST(@i_CSId AS VARCHAR(64))
				EXEC pswEncryptionManaged @csIdStr, @i_CSIdEncStr OUTPUT
				SET @i_CSIdEncStr = REPLACE(@i_CSIdEncStr, CHAR(0), '')
			END
			SET @UserNameVal = master.dbo.fn_varbintohexstr(@i_CSId)
			SET @passwordVal = @i_CSIdEncStr
		END
		ELSE
		BEGIN
			SET @UserNameVal = 'pilot'
			SET @passwordVal = '2edyCCCPsCCp1CCpCCCydCC'
		END
		IF EXISTS (SELECT * FROM GxGlobalParam WHERE name = 'MaintAdvantageUsername')
			UPDATE GxGlobalParam SET value = @UserNameVal, created = @i_licUpdateTime WHERE name = 'MaintAdvantageUsername'
		ELSE
			INSERT INTO GxGlobalParam VALUES ('MaintAdvantageUsername', @UserNameVal, @i_licUpdateTime, 0)
		IF EXISTS (SELECT * FROM GxGlobalParam WHERE name = 'MaintAdvantagePassword')
			UPDATE GxGlobalParam SET value = @passwordVal, created = @i_licUpdateTime WHERE name = 'MaintAdvantagePassword'
		ELSE
			INSERT INTO GxGlobalParam VALUES ('MaintAdvantagePassword', @passwordVal, @i_licUpdateTime, 0)
	END
	-- Update OEM props
	IF @i_updateFlag > 0
	BEGIN
		DECLARE	@newOEMPropName VARCHAR(64) = 'LinkToDocumentationWebSite'
		DECLARE	@newOEMPropValue NVARCHAR(MAX) = (	SELECT TOP 1 value
								FROM	SimOEMProp
								WHERE	name = @newOEMPropName AND (OEMID = @i_newOEMId OR OEMID = (select M.OEMId from simMINIBrand M where M.MiniBrandId = @i_newOEMId))
								ORDER BY OEMID DESC)
		IF EXISTS (SELECT * FROM GxGlobalParam WHERE name = @newOEMPropName)
			UPDATE	GxGlobalParam
			SET	value = @newOEMPropValue, created = @i_licUpdateTime
			WHERE	name = 'LinkToDocumentationWebSite'
		ELSE
			INSERT INTO GxGlobalParam VALUES (@newOEMPropName, @newOEMPropValue, @i_licUpdateTime, 0)
		-- UPDATE the sender's email address. skip if already set
		DECLARE @SMTPSenderName VARCHAR(64)	= 'EVSMTPSender'
		DECLARE @SMTPSenderValue NVARCHAR(MAX) = ISNULL((SELECT value FROM GxGlobalParam WHERE name = @SMTPSenderName), '')
		SET @newOEMPropName = 'e-mail'
		SET @newOEMPropValue = (SELECT TOP 1 value
					FROM	SimOEMProp
					WHERE	name = @newOEMPropName AND (OEMID = @i_newOEMId OR OEMID = (select M.OEMId from simMINIBrand M where M.MiniBrandId = @i_newOEMId))
					ORDER BY OEMID DESC)
		SET @newOEMPropValue = CAST(@newOEMPropValue as NVARCHAR(1024)) + '@' + @i_CSHostName
		IF LEN(@SMTPSenderValue) = 0
			INSERT INTO GxGlobalParam SELECT @SMTPSenderName, @newOEMPropValue, @i_licUpdateTime, 0
		ELSE
			UPDATE GxGlobalParam SET value = @newOEMPropValue, created = @i_licUpdateTime WHERE name = @SMTPSenderName
		SET @newOEMPropName = 'MiniBrandId'
		IF EXISTS (SELECT * FROM GxGlobalParam WHERE name = @newOEMPropName)
			UPDATE	GxGlobalParam
			SET	value = CAST(@i_newOEMId AS NVARCHAR(32)), created = @i_licUpdateTime
			WHERE	name = @newOEMPropName
		ELSE
			INSERT INTO GxGlobalParam VALUES (@newOEMPropName, CAST(@i_newOEMId AS NVARCHAR(32)), @i_licUpdateTime, 0)
	END
	RETURN
SET NOCOUNT OFF
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'LicUpdateOEMProps')
	delete from GxQscripts where name = 'LicUpdateOEMProps'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LicUpdateOEMProps')
	delete from GXDBVersions where aliasname = 'LicUpdateOEMProps'
GO

insert into GXDBVersions values(2, 'LicUpdateOEMProps',  '00010002006200030000', 'LicUpdateOEMProps', '00010002006200030000')
GO

