

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/LicUpdateIpStatus.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/LicUpdateIpStatus.sp,v $ $Id: LicUpdateIpStatus.sp,v 1.1.2.7 2018/03/20 00:16:34 jiechen Exp $";
--
--  +========================================================================+
--  | Stored Procedure: LicUpdateIpStatus
--  |
--  |   Revisions  Author           Description
--  |   ---------  -------          ---------------------------------------------
--  |   1.0        Satya Bhukar      Updates IP Status in Licusagebasedconfig table.
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: LicUpdateIpStatus <<<'

IF EXISTS (select * from sysobjects where name='LicUpdateIpStatus')
	drop procedure LicUpdateIpStatus
IF EXISTS (select * from GxQscripts where name='LicUpdateIpStatus')
	delete from GxQscripts where name = 'LicUpdateIpStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LicUpdateIpStatus')
	delete from GXDBVersions where aliasname = 'LicUpdateIpStatus'
GO
print '... Creating Procedure: LicUpdateIpStatus'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure LicUpdateIpStatus
  @in_callfromJM INTEGER=0
AS
  DECLARE @o_error integer = 0
SET NOCOUNT ON
DECLARE @newEncFld    VARCHAR(2048)=''
DECLARE @CLAIssuedName	VARCHAR(128) = 'IpValidStatus'
DECLARE @CLAIssuedData  VARCHAR(512) = ''
DECLARE @MachIDInCslTbl     INT = 0
DECLARE @DRMachIDInCslTbl     INT = 0
DECLARE @CSLocalIPs     TABLE (t_csID INT)
DECLARE @CSLocalIPString VARCHAR(1024) = ''
DECLARE @CSIpProp varchar(32) = 'CSIpAddress'
DECLARE @licUpdateTime INT = dbo.GetUnixTime(GETDATE())
DECLARE @licStatus varchar(8) = '1:-'
SELECT TOP 1 @MachIDInCslTbl = machineId, @DRMachIDInCslTbl = DRMachineId FROM LicCSL ORDER BY id DESC
INSERT INTO @CSLocalIPs EXEC LicGetCSIPs
IF @MachIDInCslTbl <> 0xFFFFFFFF AND NOT EXISTS (SELECT * FROM @CSLocalIPs WHERE t_csID = @MachIDInCslTbl)
AND (@DRMachIDInCslTbl = 0xFFFFFFFF OR NOT EXISTS (SELECT * FROM @CSLocalIPs WHERE t_csID = @DRMachIDInCslTbl))
BEGIN
	SET @licStatus = '0:-'
END
DELETE FROM @CSLocalIPs WHERE t_csID NOT IN (SELECT TOP 5 t_csID FROM @CSLocalIPs)
SELECT @CSLocalIPString = coalesce(@CSLocalIPString + ',', '') + dbo.GetIPAddressString(t_csID) FROM @CSLocalIPs
IF LEN(@CSLocalIPString) >0
    SELECT @CSLocalIPString = substring(@CSLocalIPString,2,LEN(@CSLocalIPString))
-- Store the value in GXGlobalParam for reports to show it on cloud
IF EXISTS (SELECT * FROM GxGlobalParam WITH (NOLOCK) WHERE name = @CSIpProp)
	UPDATE GXGlobalParam SET value = @CSLocalIPString, created = @licUpdateTime WHERE name = @CSIpProp
ELSE
	INSERT INTO GXGlobalParam
	values (@CSIpProp,@CSLocalIPString,@licUpdateTime,0)
SET @CLAIssuedData = @licStatus + (CASE @MachIDInCslTbl WHEN 0xFFFFFFFF THEN '' ELSE dbo.GetIPAddressString(@MachIDInCslTbl) END) +
(CASE @DRMachIDInCslTbl WHEN 0xFFFFFFFF THEN '' ELSE ', ' + dbo.GetIPAddressString(@DRMachIDInCslTbl) END) + ':-' + @CSLocalIPString
EXEC pswEncryptionManaged @CLAIssuedData, @newEncFld OUTPUT
IF @newEncFld <> ''
BEGIN
	SET @newEncFld = REPLACE(@newEncFld, CHAR(0), '')
	IF EXISTS (SELECT * FROM LicUsageBasedConfig WHERE attrname = @CLAIssuedName)
		UPDATE LicUsageBasedConfig
		SET attrVal = @newEncFld
		WHERE attrname = @CLAIssuedName
	ELSE
		INSERT INTO LicUsageBasedConfig
		SELECT @CLAIssuedName, 1, @newEncFld
END
ELSE
BEGIN
	SET @o_error = -1
END
SET NOCOUNT OFF
if @in_callfromJM >0
	SELECT @o_error
else
	RETURN @o_error
GO

IF EXISTS (select * from GxQscripts where name = 'LicUpdateIpStatus')
	delete from GxQscripts where name = 'LicUpdateIpStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LicUpdateIpStatus')
	delete from GXDBVersions where aliasname = 'LicUpdateIpStatus'
GO

insert into GXDBVersions values(2, 'LicUpdateIpStatus',  '00010001000200070000', 'LicUpdateIpStatus', '00010001000200070000')
GO

