

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/LicUpdateCapacityIssuedQty.sp] ---------- 

SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='LicUpdateCapacityIssuedQty')
BEGIN
	print '>>> Drop Stored Procedure: LicUpdateCapacityIssuedQty <<<'
	drop procedure LicUpdateCapacityIssuedQty
END
IF EXISTS (select * from GxQscripts where name='LicUpdateCapacityIssuedQty')
	delete from GxQscripts where name = 'LicUpdateCapacityIssuedQty'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LicUpdateCapacityIssuedQty')
	delete from GXDBVersions where aliasname = 'LicUpdateCapacityIssuedQty'
GO
print '... Creating Procedure: LicUpdateCapacityIssuedQty'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure LicUpdateCapacityIssuedQty
  @i_getPermAalQty INT,
  @i_licType INT=0,
  @i_issuedQty INT=0,
  @i_expTime BIGINT=0
AS
  DECLARE @errCode integer = 0
  DECLARE @totalQty integer = 0
  DECLARE @expTime BIGINT = 0
  DECLARE @errString VARCHAR(2048) = ''
DECLARE @newEncFld    VARCHAR(2048)=''
DECLARE @permFld VARCHAR(2048)=''
DECLARE @evalFld VARCHAR(2048)=''
DECLARE @CommcellID INT = 2
DECLARE @licPerIssued   INT = 0
DECLARE @licUsed    	INT = 0
DECLARE @aalIsEval      INT = 0
DECLARE @aalEvalDays    INT = 0
DECLARE @CLAIssuedName	VARCHAR(2048) = ''
DECLARE @CLAIssuedData  VARCHAR(128)
DECLARE @STR_DASH varchar(10) =':-'
SET @CLAIssuedName = CAST(@i_licType AS VARCHAR(64)) + ' issued'
SET @totalQty = @i_issuedQty
SET @expTime = @i_expTime
IF @i_getPermAalQty = 1
BEGIN
	SELECT @permFld = RTRIM(perm_fld1), @evalFld = RTRIM(eval_fld1) FROM LicAAL WHERE simLicAppTypeId = @i_licType AND commcellId = @CommcellID
	IF (@permFld <> '')
	BEGIN
		EXEC dbo.xp_getAALInfo2 @permFld, @licPerIssued OUTPUT, @licUsed OUTPUT, @aalIsEval OUTPUT, @aalEvalDays OUTPUT
		IF @@error <> 0
		BEGIN
			SET @errCode = 1
			SET @errString = 'Decryption failed for license type: ' + CAST(@i_licType AS VARCHAR(64))
			GOTO EXIT_ERROR
		END
		SET @expTime = @aalEvalDays
		SET @totalQty = @licPerIssued
	END
END
SET @CLAIssuedData = CAST(@expTime AS VARCHAR(64)) + @STR_DASH + CAST(@totalQty AS VARCHAR(64))
EXEC pswEncryptionManaged @CLAIssuedData, @newEncFld OUTPUT
IF @newEncFld <> ''
BEGIN
	SET @newEncFld = REPLACE(@newEncFld, CHAR(0), '')
	IF EXISTS (SELECT * FROM LicUsageBasedConfig where attrname = @CLAIssuedName)
		UPDATE LicUsageBasedConfig
		SET attrVal = @newEncFld
		WHERE attrname = @CLAIssuedName
	ELSE
		INSERT INTO LicUsageBasedConfig
		SELECT @CLAIssuedName, 1, @newEncFld
END
ELSE
BEGIN
	SET @errCode = 2
	SET @errString = 'Encryption failed for license type: ' + CAST(@i_licType AS VARCHAR(64))
	GOTO EXIT_ERROR
END
EXIT_ERROR:
SELECT @errCode,@totalQty,@expTime,@errString
GO

IF EXISTS (select * from GxQscripts where name = 'LicUpdateCapacityIssuedQty')
	delete from GxQscripts where name = 'LicUpdateCapacityIssuedQty'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LicUpdateCapacityIssuedQty')
	delete from GXDBVersions where aliasname = 'LicUpdateCapacityIssuedQty'
GO

insert into GXDBVersions values(2, 'LicUpdateCapacityIssuedQty',  '00000000000000000000', 'LicUpdateCapacityIssuedQty', '00000000000000000000')
GO

