

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/LicUpdateCCLevelLicense.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Sergio Bonilla
--	Date:   12/28/2006
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/LicUpdateCCLevelLicense.sp,v $ $Id: LicUpdateCCLevelLicense.sp,v 1.2.208.2 2018/03/27 09:03:06 jiechen Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
-- @i_clientId can be client ID or Library ID
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: LicUpdateCCLevelLicense <<<'

IF EXISTS (select * from sysobjects where name='LicUpdateCCLevelLicense')
	drop procedure LicUpdateCCLevelLicense
IF EXISTS (select * from GxQscripts where name='LicUpdateCCLevelLicense')
	delete from GxQscripts where name = 'LicUpdateCCLevelLicense'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LicUpdateCCLevelLicense')
	delete from GXDBVersions where aliasname = 'LicUpdateCCLevelLicense'
GO
print '... Creating Procedure: LicUpdateCCLevelLicense'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure LicUpdateCCLevelLicense
  @nLicType INT,
  @bConfigure INT,
  @flags INT,
  @sError VARCHAR(MAX) OUT
AS
DECLARE @appMgrUpdateRetTbl	TABLE (errCode INT, hasChanged INT, propId INT, errString VARCHAR(2048))
DECLARE @resultTbl		TABLE (errCode INT, errStr VARCHAR(255))
DECLARE @CSClientID		INT
DECLARE	@appTypeId		INT
DECLARE	@clId			INT
SET @sError = ''
-- GET CS CLIENT ID
SET @CSClientID = ISNULL((SELECT clientID FROM APP_Platform WHERE platformType = 1), 0)
IF @CSClientID = 0
BEGIN
	SET @sError = 'Failed to get CS client ID'
	RETURN
END
-- GET LICENSE APPTYPE
SET @appTypeId = ISNULL((SELECT appTypeId FROM simAppTypeLicTypeMap WHERE simLicAppType = @nLicType AND isCellLevel > 0), 0)
IF @appTypeId = 0
BEGIN
	SET @sError = 'Failed to get appType ID for cell level license [' + cast(@nLicType as varchar(64)) + ']'
	RETURN
END
-- UPDATE AppMgr TABLE
INSERT INTO @appMgrUpdateRetTbl
EXEC AppSetLicense @CSClientID, @appTypeId, @bConfigure
SELECT @sError = errString FROM @appMgrUpdateRetTbl WHERE errCode <> 0
IF LEN(@sError) > 0
	RETURN
-- CONSUME/RELEASE LICENSE
EXEC LicenseIncrement @CSClientID, @nLicType, @appTypeId, @bConfigure, @flags, 0, @sError OUTPUT
IF LEN(@sError) > 0
	RETURN
IF @nLicType = 85 AND @bConfigure = 0
BEGIN
	INSERT INTO @resultTbl
	EXEC LicDisableCellLevelLicenseProps 1
	SELECT @sError = errStr FROM @resultTbl WHERE errCode <> 0
END
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'LicUpdateCCLevelLicense')
	delete from GxQscripts where name = 'LicUpdateCCLevelLicense'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LicUpdateCCLevelLicense')
	delete from GXDBVersions where aliasname = 'LicUpdateCCLevelLicense'
GO

insert into GXDBVersions values(2, 'LicUpdateCCLevelLicense',  '00010002020800020000', 'LicUpdateCCLevelLicense', '00010002020800020000')
GO

