

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/LicIsUsageBasedValid.sp] ---------- 

-- ----------------------------------------------------------------------
--
--  Copyright (c) CommVault Systems
--  All Rights Reserved
--
--  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF CommVault Systems
--  The copyright notice above does not evidence any
--  actual or intended publication of such source code.
--
--  File name   : LicIsUsageBasedValid.sp
--
--  Description : This Stored Procedure used to check ths usage status
--				  for the Usage based licenses
--
--  Author      : Ravi Kumarasamy
--
-- ----------------------------------------------------------------------*/
--
--  +========================================================================+
--  |      Cursor:  LicIsUsageBasedValid()
--  +========================================================================+
--
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='LicIsUsageBasedValid')
BEGIN
	print '>>> Drop Stored Procedure: LicIsUsageBasedValid <<<'
	drop procedure LicIsUsageBasedValid
END
IF EXISTS (select * from GxQscripts where name='LicIsUsageBasedValid')
	delete from GxQscripts where name = 'LicIsUsageBasedValid'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LicIsUsageBasedValid')
	delete from GXDBVersions where aliasname = 'LicIsUsageBasedValid'
GO
print '... Creating Procedure: LicIsUsageBasedValid'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure LicIsUsageBasedValid
  @in_appType INTEGER,
  @in_jobId INTEGER=0,
  @in_licType INTEGER = 0,
  @in_skipOutput INTEGER = 1
AS
  DECLARE @o_error INTEGER
SET NOCOUNT ON
--local vars
DECLARE @nLicenceTypeToCheck INT
DECLARE @nUsageStatus BIGINT
DECLARE @nDetailedStatus BIGINT
DECLARE @isValid INT = 0
DECLARE @i_ClientId INT =2
DECLARE @bUnderLimit BIGINT
DECLARE @bNotApplied BIGINT
DECLARE @bExpired BIGINT
DECLARE @msgNotApplied BIGINT
DECLARE @msgExpired BIGINT
DECLARE @msgExceeded BIGINT
DECLARE @subclientId INT
DECLARE @nLicenceTypeToCheckJob  VARCHAR(128)
DECLARE @isLicInherited INT = 0
DECLARE @licAppliedStatus INT = 0
--Get appType from license type
IF @in_appType = 0 AND @in_licType > 0
BEGIN
	SELECT  @in_appType = appTypeId
	FROM	simAppTypeLicTypeMap WITH(READUNCOMMITTED)
	WHERE	simLicAppType = @in_licType
END
DECLARE @licTbl TABLE (t_licType INT, t_bUnderLimit BIGINT, t_bNotApplied BIGINT, t_bExpired BIGINT, t_msgNotApplied INT, t_msgExpired INT, t_msgExceeded INT)
INSERT INTO @licTbl
SELECT 203, 0, 0, 0, 20099, 20102, 20105
INSERT INTO @licTbl
SELECT 100013, 0x40, 0x8, 0x4, 20100, 20103,20106
INSERT INTO @licTbl
SELECT 100018, 0x200, 0x200, 0x100, 20153, 20154, 20155
INSERT INTO @licTbl
SELECT 100019, 0x20, 0x2, 0x1, 20150, 20151, 20152
INSERT INTO @licTbl
SELECT 100027, 0x400, 0x800, 0x400, 20156, 20157, 20158
INSERT INTO @licTbl
SELECT 100028, 0x800, 0x2000, 0x1000, 20159, 20160, 20161
INSERT INTO @licTbl
SELECT 100031, 0x1000, 0x8000, 0x4000, 20164,
20165, 20166
INSERT INTO @licTbl
SELECT 100032, 0x2000, 0x20000, 0x10000, 20179, 20180, 20181
INSERT INTO @licTbl
SELECT 100033, 0x4000, 0x80000, 0x40000, 20182, 20183, 20184
INSERT INTO @licTbl
SELECT 100040, 0x200000, 0x200000000, 0x100000000, 20204, 20205, 20206
INSERT INTO @licTbl
SELECT 100041, 0x400000, 0x800000000, 0x400000000, 20207, 20208, 20209
UNION ALL
SELECT 100042, 0x800000, 0x2000000000, 0x1000000000, 20211, 20212, 20213
UNION ALL
SELECT 100043, 0x1000000, 0x8000000000, 0x4000000000, 20214, 20215, 20216
UNION ALL
SELECT 100044, 0x2000000, 0x20000000000, 0x10000000000, 20217, 20218, 20219
UNION ALL
SELECT 100045, 0x4000000, 0x80000000000, 0x40000000000, 20220, 20221, 20222
UNION ALL
SELECT 100046, 0x8000000, 0x200000000000, 0x100000000000, 20223, 20224, 20225
UNION ALL
SELECT 100047, 0x10000000, 0x800000000000, 0x400000000000, 20226, 20227, 20228
UNION ALL
SELECT 100048, 0x20000000, 0x2000000000000, 0x1000000000000, 20229, 20230, 20231
UNION ALL
SELECT 100049, 0x40000000, 0x8000000000000, 0x4000000000000, 20232, 20233, 20234
UNION ALL
SELECT 100050, 0x80000000, 0x20000000000000, 0x10000000000000, 20235, 20236, 20237
--get the capacity usage status
SET @nUsageStatus = ISNULL( (SELECT attrVal FROM LicUsageBasedConfig with (readuncommitted) WHERE attrName = 'LicUsageBasedStatus'), 1)
SET @nDetailedStatus = ISNULL( (SELECT attrVal FROM LicUsageBasedConfig with (readuncommitted) WHERE attrName = 'LicUsageBasedDetailedStatus'), 1)
EXEC LicAppliedStatus @licAppliedStatus OUTPUT, @isLicInherited OUTPUT  --check for license server model
IF @in_licType >= 100041 AND @in_licType <= 100050
BEGIN
	DECLARE @metallicEula nvarchar(MAX) = N''
	DECLARE @ismetalicvalid int = 0
	----------Metallic job ------------
	SET @nLicenceTypeToCheck = @in_licType --100041 to 100050
	--check license server
	IF @isLicInherited > 0
    BEGIN
SELECT @ismetalicvalid = @licAppliedStatus&0x40000
    END
	SELECT @bUnderLimit = t_bUnderLimit, @bNotApplied = t_bNotApplied, @bExpired = t_bExpired, @msgNotApplied = t_msgNotApplied, @msgExpired = t_msgExpired, @msgExceeded =t_msgExceeded
		FROM	@licTbl
		WHERE	t_licType = @nLicenceTypeToCheck
	----Check if license is exceeded,expired
	IF EXISTS(SELECT simLicAppTypeId FROM LicAal WITH (NOLOCK) WHERE simLicAppTypeId = @nLicenceTypeToCheck) or @ismetalicvalid > 0
	BEGIN
		SELECT @metallicEula = value from GXGlobalParam where name='MetallicEulaAccepted' and modified = 0
		if @@ROWCOUNT = 0 OR @metallicEula <> N'1'
			BEGIN
				-----eula not accepted, return notapplied error
SET @o_error = 90000
				SET @isValid = 0
				GOTO SP_EXIT
			END
		IF(@nUsageStatus & @bUnderLimit) = 0
		BEGIN
			SET @isValid = 0
			IF @nDetailedStatus > 0
			BEGIN
				SET @o_error = (CASE
						WHEN (@nDetailedStatus & @bNotApplied) > 0	THEN @msgNotApplied
						WHEN (@nDetailedStatus & @bExpired) > 0		THEN @msgExpired
						ELSE 0 END)
			END
			IF @o_error = 0
				SET @o_error = @msgExceeded
			GOTO SP_EXIT
		END
		else
		begin
		 set @isValid = 1
		 set @o_error = 0
		 GOTO SP_EXIT
		end
	END
	else
	begin
		 set @isValid = 0
		 set @o_error = @msgNotApplied
		 GOTO SP_EXIT
	end
END
 ----End Metallic job
BEGIN
-- If license SIM_CSL_AT_V2_APP_STORE_USAGE exists in the CS it should be within the limits, else no check is required
	  -- According to Sanjay: Appliance Store usage should not be sold together with disk library space as appliance store usage is enforced and backup will stop if the usage exceeds
	  --Selling both together will create contradiction if customer bought both license and comes back and points to disk library space purchased quantity
SET @nLicenceTypeToCheck = 100031 --100031
	DECLARE @bIsAppStoreUsageLicValid INT = 0
EXEC LicIsLicenseValid 100031, @bIsAppStoreUsageLicValid OUTPUT
	IF @bIsAppStoreUsageLicValid > 0
	BEGIN
		SELECT @bUnderLimit = t_bUnderLimit, @bNotApplied = t_bNotApplied, @bExpired = t_bExpired, @msgNotApplied = t_msgNotApplied, @msgExpired = t_msgExpired, @msgExceeded =t_msgExceeded
		FROM	@licTbl
		WHERE	t_licType = @nLicenceTypeToCheck
		IF(@nUsageStatus & @bUnderLimit) = 0
		BEGIN
			SET @isValid = 0
			IF @nDetailedStatus > 0
			BEGIN
			---license not applied
				SET @o_error = (CASE
						WHEN (@nDetailedStatus & @bNotApplied) > 0	THEN @msgNotApplied
						WHEN (@nDetailedStatus & @bExpired) > 0		THEN @msgExpired
						ELSE 0 END)
			END
			IF @o_error = 0
				SET @o_error = @msgExceeded
			GOTO SP_EXIT
		END
	END
END
SET @nLicenceTypeToCheck = 0
SET @o_error = 0 --success
SET @isValid = 0
SET @subclientId = ISNULL((SELECT applicationId FROM JmBkpJobINfo WITH (NOLOCK) WHERE jobId = @in_jobId), 0)
--************************************************************************************************************
--Exclude the Job Check for the RefCopy Client
--************************************************************************************************************
IF EXISTS (	SELECT * FROM APP_APPLICATION WITH (NOLOCK) WHERE ID=@subclientId AND subclientStatus&0x10000 = 0x10000 )
BEGIN
	SET @isValid = 1
	SET @o_error =  0
	GOTO SP_EXIT
END
--************************************************************************************************************
--1. Step1: Check the Apptype..
--************************************************************************************************************
DECLARE @bIsSocketLicValid INT = 0
DECLARE @bIsVMProtectedLicValid INT = 0
IF @isLicInherited > 0
BEGIN
SELECT @bIsSocketLicValid = @licAppliedStatus&0x1
SELECT @bIsVMProtectedLicValid = @licAppliedStatus&0x2
END
ELSE
BEGIN
EXEC LicIsLicenseValid 100018, @bIsSocketLicValid OUTPUT
EXEC LicIsLicenseValid 100019, @bIsVMProtectedLicValid OUTPUT
END
DECLARE @isOIValid					INT = 0
DECLARE @isVOIValid					INT = 0
DECLARE @bIsOIAppTypeValid			INT = 0
DECLARE @ClientId					INT = 0
DECLARE @isVM						INT = 0
DECLARE @isACVValidForOI			INT = 0
SET @ClientId = ISNULL((SELECT clientId FROM APP_Application WITH (NOLOCK) WHERE id = @subclientId), 0)
SELECT @isVM = 1 FROM APP_ClientProp WITH (NOLOCK) WHERE componentNameId = @ClientId AND attrName = 'Virtual Machine GUID' and modified = 0
IF object_id('tempdb.dbo.#tmpValidLictypes') IS NOT null DROP TABLE #tmpValidLictypes
CREATE TABLE #tmpValidLictypes (LicType INT)
EXEC LicCheckOIStatus '#tmpValidLictypes', @in_appType, @ClientId, @isOIValid OUTPUT, @isVOIValid OUTPUT, @bIsOIAppTypeValid OUTPUT
SELECT @isACVValidForOI = 1 FROM #tmpValidLictypes WHERE LicType = 100027
DROP TABLE #tmpValidLictypes
IF @in_appType = 106
BEGIN
	DECLARE @bIsDRVMLicValid INT = 0
	IF EXISTS(
				SELECT 1 FROM JmBkpJobINfo J WITH (NOLOCK)
				INNER JOIN APP_VSAReplication R WITH(NOLOCK) ON J.jobId = R.lastSyncedBkpJob AND ISNULL(R.status,0) <> 6
				INNER JOIN TM_Task T WITH (NOLOCK) ON R.taskId = T.taskId AND ISNULL(T.disabled,0) <> 1
				INNER JOIN APP_ClientProp CP WITH(NOLOCK) ON CP.attrname ='Virtual Machine Instance UUID' AND R.sourceGuid = CP.attrVal AND CP.modified = 0
				WHERE J.jobid =  @in_jobId
				UNION
				SELECT 1 FROM JmBkpJobINfo J WITH (NOLOCK)
                LEFT JOIN JMJobDataLink DL WITH (NOLOCK) ON J.jobid = DL.childJobid AND J.applicationId = DL.childAppid AND DL.linkType = 7
				INNER JOIN app_application A WITH(NOLOCK) ON J.applicationId = A.id OR DL.parentAppid = A.id
                INNER JOIN APP_SubClientProp scprop with(nolock) on
				scprop.componentNameId = A.id
				and scprop.attrName ='Associated Plan'
				and scprop.cs_attrName = CHECKSUM(N'Associated Plan')
				and scprop.modified =0
				inner join app_plan P with (nolock) on
				P.id = scprop.attrval
and P.subtype = 83918853
				WHERE J.jobid = @in_jobId
			  )
	BEGIN
SET @nLicenceTypeToCheck  = 100040
		SELECT @bUnderLimit = t_bUnderLimit, @bNotApplied = t_bNotApplied, @bExpired = t_bExpired, @msgNotApplied = t_msgNotApplied, @msgExpired = t_msgExpired, @msgExceeded =t_msgExceeded
		FROM	@licTbl
		WHERE	t_licType = @nLicenceTypeToCheck
		IF @isLicInherited > 0
SELECT @bIsDRVMLicValid = @licAppliedStatus&0x20000
		ELSE
EXEC LicIsLicenseValid 100040, @bIsDRVMLicValid OUTPUT
		IF @bIsDRVMLicValid = 0 AND (@bIsSocketLicValid > 0 OR @bIsVMProtectedLicValid > 0 OR @isOIValid > 0 OR @isVOIValid > 0)
		BEGIN
			DECLARE @DRVMStartingTime INT = 0
			DECLARE @LicDRVMGracePeriod  INT = 0
			DECLARE @currentTime INT = dbo.GetUNIXTime(GETUTCDATE())
			SELECT @DRVMStartingTime = attrVal FROM LicUsageBasedConfig WITH (NOLOCK) WHERE attrName = 'LicDRVMGracePeriodStartingTime'
			SELECT @LicDRVMGracePeriod  = value FROM GXGlobalParam WITH(NOLOCK) WHERE name = 'LicDRVMGracePeriod'
			IF @DRVMStartingTime > 0 AND (@currentTime - @DRVMStartingTime)/24/60/60 >= @LicDRVMGracePeriod
			BEGIN
				SET @isValid = 0
				SET @o_error = @msgNotApplied
				GOTO SP_EXIT
			END
		END
		ELSE IF @bIsDRVMLicValid > 0
		BEGIN
			IF(@nUsageStatus & @bUnderLimit) = 0
			BEGIN
				SET @isValid = 0
				IF @nDetailedStatus > 0
				BEGIN
				---license not applied
					SET @o_error = (CASE
							WHEN (@nDetailedStatus & @bNotApplied) > 0	THEN @msgNotApplied
							WHEN (@nDetailedStatus & @bExpired) > 0		THEN @msgExpired
							ELSE 0 END)
				END
				IF @o_error = 0
					SET @o_error = @msgExceeded
				GOTO SP_EXIT
			END
			ELSE
			BEGIN
				IF EXISTS(
					SELECT 1 FROM JmBkpJobINfo J WITH (NOLOCK)
					INNER JOIN archGroupCopy AG WITH(NOLOCK) ON J.currentPolicy = AG.archGroupId
					INNER JOIN archAgingRule AGR WITH(NOLOCK) ON AG.id = AGR.copyId
					WHERE J.jobid =  @in_jobId
HAVING max(AGR.retentionDays)<=14
				  )
				  BEGIN
					  SET @isValid = 1
					  SET @o_error =  0
					  GOTO SP_EXIT
				  END
			END
		END
	END
END
SET @nLicenceTypeToCheck = 0
SET @o_error = 0 --success
SET @isValid = 0
IF object_id('tempdb.dbo.#tempVMToPMList') IS NOT null DROP TABLE #tempVMToPMList
CREATE TABLE #tempVMToPMList(appTypeId INT,pseudoClientId INT,physClientId INT)
IF @ClientId > 0 AND @bIsOIAppTypeValid > 0
	EXEC LicGetVMToPMList @ClientId
IF EXISTS (SELECT 1 FROM #tempVMToPMList)
BEGIN
	IF object_id('tempdb.dbo.#tempCluster') IS NOT null DROP TABLE #tempCluster
	CREATE TABLE #tempCluster(t_VMClientId int, t_PMClientId int, isVM INT DEFAULT 0)
	INSERT INTO #tempCluster (t_VMClientId,t_PMClientId)
	SELECT DISTINCT pseudoClientId, physClientId
	FROM #tempVMToPMList V
	INNER JOIN LicUsage U WITH (NOLOCK) ON U.cid = V.physClientId AND LicType in (1,2,3,16,17,25,127) AND AppType = @in_appType
	UNION --add physical nodes which do not consume app class agent licenses due to ACV
	SELECT DISTINCT pseudoClientId, physClientId
	FROM #tempVMToPMList V
	INNER JOIN APP_IDAName Ida WITH (NOLOCK) ON Ida.clientId = V.physClientId AND Ida.appTypeId = @in_appType
	INNER JOIN simAppTypeLicTypeMap Map WITH (NOLOCK) ON Map.appTypeId = Ida.appTypeId AND Map.simLicAppType in (3,16,17)
	UPDATE T
	SET isVM = 1
	FROM #tempCluster T
	INNER JOIN APP_ClientProp WITH (NOLOCK) ON componentNameId = t_PMClientId AND attrName = 'Virtual Machine GUID' and modified = 0
	IF NOT EXISTS (SELECT 1 FROM #tempCluster WHERE isVM = 0)
		SET @isVM = 1
	DROP TABLE #tempCluster
END
DROP TABLE #tempVMToPMList
IF @isVOIValid > 0 AND @bIsOIAppTypeValid > 0 AND (@ClientId = 0 OR @ClientId > 0 AND @isVM > 0)
BEGIN
SET @nLicenceTypeToCheck  = 100033
END
IF @isOIValid > 0 AND @bIsOIAppTypeValid > 0 AND @nLicenceTypeToCheck = 0
BEGIN
SET @nLicenceTypeToCheck  = 100032
END
DECLARE @bIsArchiveMailboxLicValid INT = 0
EXEC LicIsLicenseValid 100013, @bIsArchiveMailboxLicValid OUTPUT
IF EXISTS (select type from APP_iDAType where ((name like '%mail%box%' and  name like '%Archiv%' ) OR (name like '%Compliance Archiver%' ))  AND TYPE=@in_appType and type < 1000 ) AND @bIsArchiveMailboxLicValid > 0
BEGIN
SET @nLicenceTypeToCheck  = 100013 	--100013 -- Archived Mailbox...
END
IF EXISTS ( select type from APP_iDAType where  (name like '%mail%box%'  AND name NOT like '%Archiv%'  OR   name like '%Notes%') AND type < 1000  AND TYPE=@in_appType  AND name not like '%Database' AND name NOT LIKE 'SRM%' )
BEGIN
	-- it means that protected mailbox appType is entered
SET @nLicenceTypeToCheck = 203	 --203 -- Protected MailBox...
	-- check for the Turbo. When the Subclient is Turbo allow backup to run only on Archive mailbox...
	IF EXISTS (	SELECT * FROM APP_SubClientProp SCP WITH (NOLOCK), JmBkpJobINfo J WITH (NOLOCK)
WHERE SCP.componentNameId=J.applicationId AND J.jobId = @in_jobId AND SCP.attrName = 'Is Turbo Subclient' AND SCP.cs_attrName = CHECKSUM('Is Turbo Subclient') AND SCP.modified=0 AND SCP.attrval='1'  )	AND @bIsArchiveMailboxLicValid > 0
	BEGIN
SET @nLicenceTypeToCheck  = 100013 --100013
	END
END
IF @in_appType = 106
BEGIN
	IF @bIsSocketLicValid > 0
SET @nLicenceTypeToCheck  = 100018 --100018
	ELSE IF @bIsVMProtectedLicValid > 0
SET @nLicenceTypeToCheck  = 100019 --100019
END
DECLARE @isAppTypeValid INT
SELECT @isAppTypeValid = dbo.IsAcvAppTypeValid(@in_appType)
DECLARE @isACVCheckValid INT = 0
DECLARE @licInheritedType INT = 0
DECLARe @bIsLicInherited INT = 0
SELECT @licInheritedType = CAST(attrVal AS INT) FROM LicUsageBasedConfig WITH (NOLOCK) WHERE attrName = 'InheritedLicType'--SZ_INHERITED_LI_TYPE
IF @licInheritedType = 1 OR @licInheritedType = (2|1)
	SET @bIsLicInherited = 1
IF @bIsLicInherited = 1
BEGIN
		IF EXISTS(select * FROM RptClientGroupQuotaUsage WITH (NOLOCK) WHERE clientGroupId = 0 AND globalLimitGB > 0 AND quotaType in (100027,100032,100033)) AND
		EXISTS(select * from RptClientGroupQuotaUsage WITH (NOLOCK) WHERE clientGroupId = 0 AND globalLimitGB > 0 AND quotaType IN (100002, 100004, 100005, 100006, 100018, 100019))
			SELECT @isACVCheckValid = 1
END
ELSE
BEGIN
	IF EXISTS(select simLicAppTypeId from licAAL WITH (NOLOCK) WHERE simLicAppTypeId in (100027,100032,100033)) AND
	EXISTS(select simLicAppTypeId from licAAL WITH (NOLOCK) WHERE simLicAppTypeId IN (100002, 100004, 100005, 100006, 100018, 100019))
		SELECT @isACVCheckValid = 1
END
-- check whether it's VMs with application class 1 package
IF @isAppTypeValid = 1 AND @isACVCheckValid = 1
BEGIN
	DECLARE @retCount INT = 0
	EXEC LicGetVMAppcalss1 '', @subclientId, 0, 0, 0, 0, @retCount OUTPUT
	IF @retCount > 0 AND @isACVValidForOI = 0
SET @nLicenceTypeToCheck  = 100027 --100027
	ELSE IF @retCount > 0 AND @isACVValidForOI = 1
	BEGIN
		IF @isVOIValid > 0
SET @nLicenceTypeToCheck  =  100033
		ELSE IF @isOIValid > 0
SET @nLicenceTypeToCheck  =  100032
	END
END
DECLARE @o_isMSimValid INT = 0
DECLARE @o_appTypeList NVARCHAR(1024) = ''
EXEC LicGetMSimAppType @in_appType, @in_jobId, @o_isMSimValid OUTPUT, @o_appTypeList OUTPUT
IF @o_isMSimValid = 1
SET @nLicenceTypeToCheck  = 100028 	--100028
--get the license type against which we should check for license validity
--All the variables are defined in the header files
-- This should never happen
IF (@nLicenceTypeToCheck is null OR @nLicenceTypeToCheck = 0)
BEGIN
	SET @isValid = 1
	SET @o_error =  0
	GOTO SP_EXIT
END
SELECT @bUnderLimit = t_bUnderLimit, @bNotApplied = t_bNotApplied, @bExpired = t_bExpired, @msgNotApplied = t_msgNotApplied, @msgExpired = t_msgExpired, @msgExceeded =t_msgExceeded
FROM	@licTbl
WHERE	t_licType = @nLicenceTypeToCheck
--************************************************************************************************************
--2. Step2: If the AppType is Protected Mailbox then Check the CELL Level License Presence.
--************************************************************************************************************
IF (@nLicenceTypeToCheck = 203 )
BEGIN
	declare @PMApptype int = 1130
	declare @licenseCheckResults table ( isValid integer, expTime integer, errorStr varchar(MAX))
	insert into @licenseCheckResults exec simValidLicenseCheck @i_ClientId, @PMApptype, @nLicenceTypeToCheck
	IF exists (select * from @licenseCheckResults where isValid = 1)
	BEGIN
		SET @isValid = 1
		SET @o_error = 0
	END
	ELSE
	BEGIN
		SET @isValid = 0
		IF exists (select * from @licenseCheckResults where isValid = 0 AND expTime > 0)
			SET @o_error = @msgExpired
		ELSE
			SET @o_error = @msgNotApplied
	END
	GOTO SP_EXIT
END
--************************************************************************************************************
--if we are not using usage based licensing, or if the status is valid, simply return
--************************************************************************************************************
IF (@nUsageStatus = 1 AND @nDetailedStatus = 1)
BEGIN
	SET @o_error = 0 --success
	SET @isValid = 0
	GOTO SP_EXIT
END
--************************************************************************************************************
--3. Step2: If the AppType is Archived Mailbox then Check license is NO Applied or Expired or Over Capacity.
--************************************************************************************************************
SET @isValid = (@nUsageStatus & @bUnderLimit)
IF @isValid = 0
BEGIN
	IF @nDetailedStatus > 0
	BEGIN
	---license not applied
		SET @o_error = (CASE
				WHEN (@nDetailedStatus & @bNotApplied) > 0	THEN @msgNotApplied
				WHEN (@nDetailedStatus & @bExpired) > 0		THEN @msgExpired
				ELSE 0 END)
	END
	IF @o_error = 0
		SET @o_error = @msgExceeded
END
SP_EXIT:
IF @in_skipOutput = 1
	RETURN @o_error
ELSE
	SELECT @o_error
SET NOCOUNT OFF
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'LicIsUsageBasedValid')
	delete from GxQscripts where name = 'LicIsUsageBasedValid'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LicIsUsageBasedValid')
	delete from GXDBVersions where aliasname = 'LicIsUsageBasedValid'
GO

insert into GXDBVersions values(2, 'LicIsUsageBasedValid',  '00000000000000000000', 'LicIsUsageBasedValid', '00000000000000000000')
GO

