

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/LicIsCapactiyBasedValid.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/LicIsCapactiyBasedValid.sp,v $ $Id: LicIsCapactiyBasedValid.sp,v 1.27.2.26 2020/12/08 20:57:07 leiwang Exp $";
--
--  +========================================================================+
--  |      Cursor:  LicIsCapactiyBasedValid()
--  +========================================================================+
--
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='LicIsCapactiyBasedValid')
BEGIN
	print '>>> Drop Stored Procedure: LicIsCapactiyBasedValid <<<'
	drop procedure LicIsCapactiyBasedValid
END
IF EXISTS (select * from GxQscripts where name='LicIsCapactiyBasedValid')
	delete from GxQscripts where name = 'LicIsCapactiyBasedValid'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LicIsCapactiyBasedValid')
	delete from GXDBVersions where aliasname = 'LicIsCapactiyBasedValid'
GO
print '... Creating Procedure: LicIsCapactiyBasedValid'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure LicIsCapactiyBasedValid
  @in_appType INTEGER,
  @in_storagePolicyId INTEGER,
  @in_appId INTEGER,
  @in_jobId INTEGER=0,
  @in_callfromJM INTEGER=0
AS
  DECLARE @o_error INTEGER
SET NOCOUNT ON
--local vars
DECLARE @nLicenceTypeToCheck INT
DECLARE @nCapacityStatus INT
DECLARE @nDetailedStatus INT
DECLARE @tmpLicTbl TABLE (lic INT)
DECLARE @isValid INT = 0
DECLARE @inClientId INT = 0
DECLARE @clientStatus INT = 0
DECLARE @subclientId INT = 0
SET @o_error = 0 --success
SET @isValid = 0
-- get the capacity usage status
SET @nCapacityStatus = ISNULL( (SELECT attrVal FROM LicUsageBasedConfig with (readuncommitted) WHERE attrName = 'Status'), 1)
SET @nDetailedStatus = ISNULL( (SELECT attrVal FROM LicUsageBasedConfig with (readuncommitted) WHERE attrName = 'DetailedStatus'), 1)
-- get client status
SELECT @subclientId = applicationId FROM JmBkpJobINfo WITH (NOLOCK) WHERE jobId = @in_jobId
SELECT @inClientId = A.clientId, @clientStatus = status FROM APP_Client C WITH (NOLOCK) JOIN APP_Application A WITH(NOLOCK) ON C.id = A.clientId AND A.id = @subclientId
-- Exclude VSA jobs from CLA if SIM_CSL_AT_V2_VM_SOCKET license is applied
DECLARE @bIsSocketLicValid INT = 0
DECLARE @bIsVMProtectedLicValid INT = 0
DECLARE @bIsDRVMLicValid INT = 0
DECLARE @licAppliedStatus INT = 0
DECLARE @isLicInherited INT = 0
EXEC LicAppliedStatus @licAppliedStatus OUTPUT, @isLicInherited OUTPUT
IF @isLicInherited > 0
BEGIN
SELECT @bIsSocketLicValid = @licAppliedStatus&0x1
SELECT @bIsVMProtectedLicValid = @licAppliedStatus&0x2
SELECT @bIsDRVMLicValid = @licAppliedStatus&0x20000
END
ELSE
BEGIN
	EXEC LicIsLicenseValid 100018, @bIsSocketLicValid OUTPUT
	EXEC LicIsLicenseValid 100019, @bIsVMProtectedLicValid OUTPUT
	EXEC LicIsLicenseValid 100040, @bIsDRVMLicValid OUTPUT
END
DECLARE @isOIValid					INT = 0
DECLARE @isVOIValid					INT = 0
DECLARE @bIsOIAppTypeValid			INT = 0
EXEC LicCheckOIStatus '', @in_appType, @inClientId, @isOIValid OUTPUT, @isVOIValid OUTPUT, @bIsOIAppTypeValid OUTPUT
IF @in_appType = 106
BEGIN
	IF EXISTS(
				SELECT 1 FROM JmBkpJobINfo J WITH (NOLOCK)
				INNER JOIN APP_VSAReplication R WITH(NOLOCK) ON J.jobId = R.lastSyncedBkpJob AND ISNULL(R.status,0) <> 6
				INNER JOIN TM_Task T WITH (NOLOCK) ON R.taskId = T.taskId AND ISNULL(T.disabled,0) <> 1
				INNER JOIN APP_ClientProp CP WITH(NOLOCK) ON CP.attrname ='Virtual Machine Instance UUID' AND R.sourceGuid = CP.attrVal AND CP.modified = 0
				WHERE J.jobid =  @in_jobId
				UNION
				SELECT 1 FROM JmBkpJobINfo J WITH (NOLOCK)
                LEFT JOIN JMJobDataLink DL WITH (NOLOCK) ON J.jobid = DL.childJobid AND J.applicationId = DL.childAppid AND DL.linkType = 7
				INNER JOIN app_application A WITH(NOLOCK) ON J.applicationId = A.id OR DL.parentAppid = A.id
                INNER JOIN APP_SubClientProp scprop with(nolock) on
				scprop.componentNameId = A.id
				and scprop.attrName ='Associated Plan'
				and scprop.modified =0
				inner join app_plan P with (nolock) on
				P.id = scprop.attrval
and P.subtype = 83918853
				WHERE J.jobid = @in_jobId
			  )
	BEGIN
		IF @bIsDRVMLicValid = 0 AND (@bIsSocketLicValid > 0 OR @bIsVMProtectedLicValid > 0 OR @isOIValid > 0 OR @isVOIValid > 0)
		BEGIN
			DECLARE @DRVMStartingTime INT = 0
			DECLARE @LicDRVMGracePeriod  INT = 0
			DECLARE @currentTime INT = dbo.GetUNIXTime(GETUTCDATE())
			SELECT @DRVMStartingTime = attrVal FROM LicUsageBasedConfig WITH (NOLOCK) WHERE attrName = 'LicDRVMGracePeriodStartingTime'
			SELECT @LicDRVMGracePeriod  = value FROM GXGlobalParam WITH(NOLOCK) WHERE name = 'LicDRVMGracePeriod'
			IF @DRVMStartingTime > 0 AND (@currentTime - @DRVMStartingTime)/24/60/60 >= @LicDRVMGracePeriod
			BEGIN
				SET @isValid = 0
SET @o_error = 20204
				GOTO SP_EXIT
			END
		END
		ELSE IF @bIsDRVMLicValid > 0
		BEGIN
			IF EXISTS(
					SELECT 1 FROM JmBkpJobINfo J WITH (NOLOCK)
					INNER JOIN archGroupCopy AG WITH(NOLOCK) ON J.currentPolicy = AG.archGroupId
					INNER JOIN archAgingRule AGR WITH(NOLOCK) ON AG.id = AGR.copyId
					WHERE J.jobid =  @in_jobId
HAVING max(AGR.retentionDays)<=14
					)
			BEGIN
			  SET @isValid = 1
			  SET @o_error =  0
			  GOTO SP_EXIT
			END
		END
	END
END
IF (@bIsSocketLicValid > 0 OR @bIsVMProtectedLicValid > 0) AND @in_appType = 106
BEGIN
	SET @isValid = 1
	GOTO SP_EXIT
END
DECLARE @isAppTypeValid INT
SELECT @isAppTypeValid = dbo.IsAcvAppTypeValid(@in_appType)
DECLARE @isACVCheckValid INT = 0
DECLARE @licInheritedType INT = 0
DECLARe @bIsLicInherited INT = 0
SELECT @licInheritedType = CAST(attrVal AS INT) FROM LicUsageBasedConfig WITH (NOLOCK) WHERE attrName = 'InheritedLicType'--SZ_INHERITED_LI_TYPE
IF @licInheritedType = 1 OR @licInheritedType = (2|1)
	SET @bIsLicInherited = 1
IF @bIsLicInherited = 1
BEGIN
		IF EXISTS(select * FROM RptClientGroupQuotaUsage WITH (NOLOCK) WHERE clientGroupId = 0 AND globalLimitGB > 0 AND quotaType in (100027,100032,100033)) AND
		EXISTS(select * from RptClientGroupQuotaUsage WITH (NOLOCK) WHERE clientGroupId = 0 AND globalLimitGB > 0 AND quotaType IN (100002, 100004, 100005, 100006, 100018, 100019))
			SELECT @isACVCheckValid = 1
END
ELSE
BEGIN
	IF EXISTS(select simLicAppTypeId from licAAL WITH (NOLOCK) WHERE simLicAppTypeId in (100027,100032,100033)) AND
	EXISTS(select simLicAppTypeId from licAAL WITH (NOLOCK) WHERE simLicAppTypeId IN (100002, 100004, 100005, 100006, 100018, 100019))
		SELECT @isACVCheckValid = 1
END
-- check whether it's VMs with application class 1 package
IF @isAppTypeValid = 1 AND @isACVCheckValid = 1
BEGIN
	EXEC LicGetVMAppcalss1 '', @subclientId, 0, 0, 0, 0, @isValid OUTPUT
	IF @isValid > 0
	BEGIN
		SET @isValid = 1
		GOTO SP_EXIT
	END
END
--If MSim is applied don't count backup under capacity.
DECLARE @o_isMSimValid INT = 0
DECLARE @o_appTypeList NVARCHAR(1024) = ''
EXEC LicGetMSimAppType @in_appType, @in_jobId, @o_isMSimValid OUTPUT, @o_appTypeList OUTPUT
IF @o_isMSimValid = 1
BEGIN
	SET @isValid = 1
	GOTO SP_EXIT
END
IF (@clientStatus & 0x10000000) > 0 OR (@clientStatus & 0x1000) > 0
BEGIN
	DECLARE @LicType    INT
DECLARE @evalFld    varchar(2048)
DECLARE @permFld    varchar(2048)
DECLARE @errorStr   varchar(2048)
	DECLARE @usageLicTbl	TABLE (t_licType INT, t_licStatus INT)
IF (@clientStatus & 0x10000000) > 0 OR (@clientStatus & 0x1000) > 0
	BEGIN
		INSERT INTO @usageLicTbl VALUES (100025, 0)
		INSERT INTO @usageLicTbl VALUES (100026, 0)
	END
IF (@clientStatus & 0x1000) > 0
		INSERT INTO @usageLicTbl VALUES (100024, 0)
	DECLARE GetUsageLicStatus CURSOR FOR SELECT t_licType FROM @usageLicTbl
	OPEN GetUsageLicStatus
	FETCH NEXT FROM GetUsageLicStatus INTO @LicType
	WHILE @@FETCH_STATUS = 0
	BEGIN
		SET @isValid = 0
		SELECT @evalFld = eval_fld1, @permFld = perm_fld1 FROM licAAL WITH (NOLOCK) WHERE simLicAppTypeId = @LicType
		IF LEN(@permFld) > 0
			SET @isValid = 1
		ELSE IF LEN(@evalFld) > 0
		BEGIN
			--check licUsage table
			DECLARE @expTime BIGINT = 0
			SET @evalFld = ''
			SELECT @evalFld = EncryptedField FROM LicUsage WITH (NOLOCK) WHERE CId = 2 AND LicType = @LicType
			IF LEN(@evalFld) > 0
				EXEC isLicenseValidManaged @evalFld, @expTime OUTPUT, @isValid OUTPUT, @errorStr OUTPUT
			ELSE
				-- license is not enforced
				SET @isValid = 1
		END
		IF @isValid > 0
		BEGIN
			UPDATE @usageLicTbl SET t_licStatus = @isValid WHERE t_licType = @LicType
			BREAK
		END
		FETCH NEXT FROM GetUsageLicStatus INTO @LicType
	END
	CLOSE GetUsageLicStatus
	DEALLOCATE GetUsageLicStatus
	DECLARE @bIsEPUserLicValid INT = 0
	DECLARE @bIsEPSharingLicValid INT = 0
	DECLARE @bIsEPDiscoveryLicValid INT = 0
	IF @isLicInherited > 0
	BEGIN
SELECT @bIsEPSharingLicValid = @licAppliedStatus&0x10
SELECT @bIsEPDiscoveryLicValid = @licAppliedStatus&0x20
IF (@clientStatus & 0x1000) > 0
SELECT @bIsEPUserLicValid = @licAppliedStatus&0x8
	END
	IF EXISTS (SELECT * FROM @usageLicTbl WHERE t_licStatus > 0) OR @bIsEPSharingLicValid > 0 OR @bIsEPDiscoveryLicValid > 0 OR @bIsEPUserLicValid > 0
		GOTO SP_EXIT
END
-- Exclude Operating Instances/Virtual Operating Instances jobs from CLA if SIM_CSL_AT_V2_OPERATING_INSTANCES/SIM_CSL_AT_V2_VIRTUAL_OPERATING_INSTANCES license is applied
IF @isVOIValid > 0 AND @bIsOIAppTypeValid > 0 AND EXISTS (SELECT 1 FROM APP_ClientProp WITH (NOLOCK) WHERE componentNameId = @inClientId AND attrName = 'Virtual Machine GUID' and modified = 0)
BEGIN
	SET @isValid = 1
	GOTO SP_EXIT
END
IF @isOIValid > 0 AND @bIsOIAppTypeValid > 0
BEGIN
	SET @isValid = 1
	GOTO SP_EXIT
END
--if we are not using capacity based licensing, or if the status is valid, simply return
IF (@nCapacityStatus = 1 AND @nDetailedStatus = 1)
BEGIN
	GOTO SP_EXIT
END
-- skip snap jobs: SNAPBACKUP = 59, SNAPBACKUP3RD = 65,
IF EXISTS (SELECT * FROM JMJObInfo WITH(NOLOCK) WHERE jobId = @in_jobId AND opType IN (59, 65))
BEGIN
	GOTO SP_EXIT
END
-- Skip for Transaction Log backups even when no capacity is available.
DECLARE @Logbackup TABLE (appType INT, PHASE INT)
INSERT INTO @Logbackup VALUES (81,2)	-- SQL:81/PHASE:2
INSERT INTO @Logbackup VALUES (22,5)	-- ORACLE:22 / PHASE:5
INSERT INTO @Logbackup VALUES (80,5)	-- ORACLE_RAC:80 / PHASE:5
INSERT INTO @Logbackup VALUES (37,4)	-- DB2:37 / PHASE:4
INSERT INTO @Logbackup VALUES (62,4)    -- UNIXDB2:62 / PHASE:4
INSERT INTO @Logbackup VALUES (5,2)		-- SYSBASE:5 / PHASE:2
INSERT INTO @Logbackup VALUES (128,6)	-- DOCUMENTUM:128 / PHASE:6
INSERT INTO @Logbackup VALUES (53,3)	-- Exchnage DB:53 / PHASE:3
IF EXISTS (SELECT * FROM JMJObInfo A WITH(NOLOCK), @Logbackup B WHERE jobId = @in_jobId AND
			B.appType = @in_appType AND A.currentPhase= B.Phase and opType=4)
BEGIN
 GOTO SP_EXIT
END
--Skip DDB subclients
DECLARE @current_appId INT = 0
IF @in_appId > 0
BEGIN
	SET @current_appId = @in_appId
END
ELSE
BEGIN
	SELECT @current_appId = applicationId FROM JMBkpJobInfo WITH(NOLOCK) WHERE jobId = @in_jobId
END
IF EXISTS (	SELECT * FROM APP_subclientProp WITH(NOLOCK) WHERE cs_attrName IN (CheckSum(N'DDB Backup'), CheckSum(N'Index SubClient')) AND
				attrName IN (N'DDB Backup', N'Index SubClient') AND attrVal <> '0' AND modified = 0 AND componentNameId = @current_appId)
BEGIN
	GOTO SP_EXIT
END
--one of the licenses are over the limit, we need to check if we are allowed to run jobs
--get the license type against which we should check for license validity
INSERT INTO @tmpLicTbl
	EXEC LicGetUsageBasedCategory @in_appType, @in_storagePolicyId, @in_appId, @in_jobId
SET @nLicenceTypeToCheck = (SELECT lic from @tmpLicTbl)
-- This should never happen
IF (@nLicenceTypeToCheck is null OR @nLicenceTypeToCheck = 0)
BEGIN
	SET @isValid = 0
	SET @o_error =  103
	GOTO SP_EXIT
END
	SET @isValid =
		CASE @nLicenceTypeToCheck
WHEN 100004		THEN (@nCapacityStatus & 0x100)
WHEN 100002		THEN (@nCapacityStatus & 0x40)
		END
IF @isValid = 0
BEGIN
	IF @nDetailedStatus > 1
	BEGIN
				---license not applied or expired
	SET @o_error =
			CASE @nLicenceTypeToCheck
WHEN 100004 THEN
						(CASE
WHEN ((@nDetailedStatus & 0x2000) = 0x2000) THEN  20094  --20094
WHEN ((@nDetailedStatus & 0x800)     = 0x800) THEN 20085  --20085
						 END)
WHEN 100002	THEN
						(CASE
WHEN ((@nDetailedStatus & 0x8000) = 0x8000) THEN 20096 --20096
WHEN ((@nDetailedStatus & 0x400)     = 0x400) THEN 20084	--20084
						 END)
				ELSE 0
			END
	END
	IF @o_error IS NULL OR @o_error = 0
	BEGIN
		declare @attrVal varchar(500)
		declare @lic1 varchar(5000) =''
		declare @issuedQuantity int
		declare @familyQuantity int = 0
		declare @nLicenceTypeFamily varchar(50) =''
		DECLARE @nLicenceFamily INT = (CASE @nLicenceTypeToCheck WHEN 100001 THEN 100002 WHEN 100003 THEN 100004 ELSE 0 END)
		DECLARE @nLicenceTypeToCheckJob  VARCHAR(128) = CAST(@nLicenceTypeToCheck AS VARCHAR(64)) + ' issued'
		SELECT @attrVal = attrVal FROM LicUsageBasedConfig WITH (NOLOCK) WHERE attrName =@nLicenceTypeToCheckJob
		EXEC miscProc2 @attrVal, @lic1 OUTPUT
SELECT @issuedQuantity = SUBSTRING(@lic1,CHARINDEX(':-',@lic1)+2, LEN(@lic1))
		SET @attrVal = ''
		SELECT @attrVal = attrVal FROM LicUsageBasedConfig WITH (NOLOCK) WHERE attrName ='InheritedLicType' --SZ_INHERITED_LI_TYPE
IF (@issuedQuantity = 0 AND (@attrVal <> 1 OR @attrVal <> (2|1)))
		BEGIN
					IF (@nLicenceFamily > 0)
					BEGIN
						  SET @nLicenceTypeFamily  = CAST(@nLicenceFamily AS VARCHAR(64)) + ' issued'
						  SET @attrVal = ''
						  SELECT @attrVal = attrVal FROM LicUsageBasedConfig WITH (NOLOCK) WHERE attrName =@nLicenceTypeFamily
						  EXEC miscProc2 @attrVal, @lic1 OUTPUT
SELECT @familyQuantity = SUBSTRING(@lic1,CHARINDEX(':-',@lic1)+2, LEN(@lic1))
					END
					IF (@issuedQuantity =0 AND @familyQuantity = 0 )
					BEGIN
						SET @o_error =
							CASE @nLicenceTypeToCheck
WHEN 100004    THEN 20094 --20094
WHEN 100002     THEN 20096   --20096
							ELSE 0
							END
					END
		END
	END
	IF @o_error IS NULL OR @o_error = 0
	BEGIN
		SET @o_error =
			CASE @nLicenceTypeToCheck
WHEN 100004		THEN 20076 --20076
WHEN 100002		THEN 20078	--20078
				ELSE 0
			END
	END
END
IF @inClientId < 2 AND @in_appId > 0
	SET @inClientId = (SELECT clientId FROM APP_Application WITH(NOLOCK) WHERE id = @in_appId)
-- Check if client group quota is avaialble
IF (@o_error IS NULL OR @o_error = 0) AND @inClientId >= 2
	AND EXISTS (SELECT * FROM GXGlobalParam WITH(NOLOCK) WHERE name = 'Enable Quota Limits at Client Group' AND value = '1' AND modified = 0)
BEGIN
	DECLARE @QuotaTbl TABLE (clientGroupId INT, quotaLimit BIGINT, updateTime INT)
	INSERT	INTO @QuotaTbl
	SELECT	CGA.clientGroupId, CP.longlongVal, CP.created
	FROM	APP_ClientGroupAssoc CGA WITH(NOLOCK)
			INNER JOIN APP_ComponentProp CP WITH(NOLOCK) ON CGA.clientGroupId = CP.componentId
				AND CP.componentType = 8 AND CP.propertyTypeId = 3400 AND CP.longlongVal > 0 AND CP.modified = 0
	WHERE	CGA.clientId = @inClientId
	IF EXISTS (SELECT * FROM @QuotaTbl)
	AND NOT EXISTS (
		SELECT	QU.clientGroupId
		FROM	RptClientGroupQuotaUsage QU WITH(NOLOCK)
				INNER JOIN @QuotaTbl T ON QU.clientGroupId = T.clientGroupId AND QU.quotaType =  @nLicenceTypeToCheck
		WHERE	(QU.updateTime = 0 AND QU.quotaUsedGB < T.quotaLimit
			  OR QU.updateTime > 0
					AND (QU.updateTime >= T.updateTime AND QU.globalUsedGB < QU.globalLimitGB
					  OR QU.updateTime <  T.updateTime AND QU.globalUsedGB < T.quotaLimit)
				)
		)
SET @o_error = 20133 -- 20133
END
SP_EXIT:
	if @in_callfromJM >0
		SELECT @o_error
	else
		RETURN @o_error
SET NOCOUNT OFF
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'LicIsCapactiyBasedValid')
	delete from GxQscripts where name = 'LicIsCapactiyBasedValid'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LicIsCapactiyBasedValid')
	delete from GXDBVersions where aliasname = 'LicIsCapactiyBasedValid'
GO

insert into GXDBVersions values(2, 'LicIsCapactiyBasedValid',  '00010027000200260000', 'LicIsCapactiyBasedValid', '00010027000200260000')
GO

