

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/LicGetVirtualizationDetailsV3.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/LicGetVirtualizationDetailsV3.sp,v $ $Id: LicGetVirtualizationDetailsV3.sp,v 1.1.2.11 2020/07/05 02:39:41 leiwang Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='LicGetVirtualizationDetailsV3')
BEGIN
	print '>>> Drop Stored Procedure: LicGetVirtualizationDetailsV3 <<<'
	drop procedure LicGetVirtualizationDetailsV3
END
IF EXISTS (select * from GxQscripts where name='LicGetVirtualizationDetailsV3')
	delete from GxQscripts where name = 'LicGetVirtualizationDetailsV3'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LicGetVirtualizationDetailsV3')
	delete from GXDBVersions where aliasname = 'LicGetVirtualizationDetailsV3'
GO
print '... Creating Procedure: LicGetVirtualizationDetailsV3'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure LicGetVirtualizationDetailsV3
  @nUserId integer = 0,
  @nOrganizationDetails integer = 0
AS
--Calculate 3 licenses, including Advanced VM (VMonly, VM with app, Unprotected VM with app), VM Socket, Archived VM
SET ANSI_PADDING ON
SET NOCOUNT ON
DECLARE @currentTime_Unix  INT = dbo.GetUnixTime(GETUTCDATE())
DECLARE @currentTime DATETIME = dbo.getdatetime(@currentTime_Unix)
DECLARE @monthStart DATETIME = DATEADD(MM, DATEDIFF(MM, 0, GETUTCDATE()), 0)
DECLARE @monthStart_Uix int  = dbo.GetUnixTime(@monthStart)
DECLARE @CCLPeakType INT = 0
DECLARE @SCLPeakType INT = 1
DECLARE @attrName varchar (256) ='LicGetVirtualizationDetailsV3Status'
DECLARE @attrType int = 1
DECLARE @attrVal varchar(1) = '0'    --0 successful  --1 failed
DECLARE @AdvancedVMType int = 19
DECLARE @VMSocketType int = 20
DECLARE @ArchivedVMType int = 21
DECLARE @DRVMType int = 40
DECLARE @ACVLicType  int = 100027
DECLARE @VMSocketLicType  int = 100018
DECLARE @VMOnlyLicType  int = 200001
DECLARE @VMWithAppLicType  int = 200003
DECLARE @ArchivedVMLicType  int = 100021
DECLARE @vmLicType int = 100019
DECLARE @DRVMLicType int = 100040
DECLARE @current_VMOnly				   int = 0
DECLARE @current_VMWithApp			   int = 0
DECLARE @current_UPVMWithApp		   int = 0
DECLARE @current_VMSocket              int = 0
DECLARE @current_ArchivedVM            int = 0
DECLARE @current_DRVM		            int = 0
DECLARE @last_VMOnly				   int = 0
DECLARE @last_VMWithApp			   int = 0
DECLARE @last_UPVMWithApp		   int = 0
DECLARE @last_VMSocket              int = 0
DECLARE @last_ArchivedVM            int = 0
DECLARE @last_DRVM	            int = 0
DECLARE @bIsArchiveLicValid INT = 0
DECLARE @bIsMsimValid INT = 0
DECLARE @bIsDRVMValid INT = 0
DECLARE @bIsVMProtectedLicValid INT = 0
DECLARE @bIsSocketLicValid INT = 0
DECLARE @bIsOILicValid INT = 0
DECLARE @bIsVOILicValid INT = 0
DECLARE @licAppliedStatus INT = 0
DECLARE @isLicInherited INT = 0
EXEC LicAppliedStatus @licAppliedStatus OUTPUT, @isLicInherited OUTPUT
IF @isLicInherited > 0
BEGIN
SELECT @bIsArchiveLicValid = @licAppliedStatus&0x4
SELECT @bIsMsimValid = @licAppliedStatus&0x80
SELECT @bIsDRVMValid = @licAppliedStatus&0x20000
SELECT @bIsVMProtectedLicValid = @licAppliedStatus&0x2
SELECT @bIsSocketLicValid = @licAppliedStatus&0x1
SELECT @bIsOILicValid =  @licAppliedStatus&0x200
SELECT @bIsVOILicValid =  @licAppliedStatus&0x400
END
ELSE
BEGIN
	EXEC LicIsLicenseValid 100021, @bIsArchiveLicValid OUTPUT
	EXEC LicIsLicenseValid 100028, @bIsMsimValid OUTPUT
	EXEC LicIsLicenseValid 100040, @bIsDRVMValid OUTPUT
	EXEC LicIsLicenseValid 100019, @bIsVMProtectedLicValid OUTPUT
	EXEC LicIsLicenseValid 100018, @bIsSocketLicValid OUTPUT
	EXEC LicIsLicenseValid 100032, @bIsOILicValid OUTPUT
	EXEC LicIsLicenseValid 100033, @bIsVOILicValid OUTPUT
END
DECLARE @tblVM TABLE (VMName VARCHAR(1024),VMSizeGB bigint, LastBackupTime datetime, IsVMArchived INT)
IF object_id('tempdb.dbo.#tempVMDPJobs') IS NOT null DROP TABLE #tempVMDPJobs
CREATE TABLE #tempVMDPJobs( VMName              nvarchar(1024),
                    BackupStatus                    VARCHAR(256), -- 0 - Backed Up, 1 -  Did Not Backup, 2 - manually exlcuded,
                    InstanceName                    nvarchar(1024),
                    BackupSetName                   nvarchar(1024),
                    SubClientName                   nvarchar(1024),
                    VMSizeMB                        BIGINT,
                    VMBackedupSizeGB                BIGINT,
                    EstimatedVMDataWrittenSizeGB    BIGINT,
                    LastSuccessfulBackupJobId       BIGINT,
                    LastBackupTime                  datetime,
                    LastBackupType                  VARCHAR(256),
                    TotalTimeForLastBackup          BIGINT,
                    clientId                        INT,
                    CommCellId                      INT,
                    CommCellName                    varchar(256),
                    IsVMArchived                    INT)
IF object_id('tempdb.dbo.#tempClientList2') IS NOT null DROP TABLE #tempClientList2
CREATE TABLE #tempClientList2(t_type int, t_clientId INT, t_subclientid int, t_appTypeId INT, t_lictype INT, t_jobid INT, t_vmstatus INT,t_objectName NVARCHAR(MAX),t_objectId int, t_appsizeMB bigint)
--t_vmstatus  1: VM 2: VM ONLY 3: VM WITH APPS 4: Unprotected VM with apps
CREATE CLUSTERED INDEX tempClientList2_type_vmstatus_objectId on #tempClientList2 (t_type,t_vmstatus,t_objectId)
CREATE INDEX tempClientList2_vmstatus on #tempClientList2 (t_vmstatus)
IF EXISTS(SELECT 1 FROM tempdb.dbo.sysobjects WHERE ID = OBJECT_ID(N'tempdb..#tmpSocketDetails'))
DROP TABLE #tmpSocketDetails
CREATE TABLE #tmpSocketDetails(t_host VARCHAR(256), t_sockets INT, t_clientId INT)
INSERT INTO #tempVMDPJobs EXEC VMProtectionCoverageProc -2, 0, 0
IF object_id('tempdb.dbo.#VSAVMList')  IS NOT null DROP TABLE #VSAVMList
CREATE TABLE #VSAVMList (t2_ccId INT, t2_jobId INT, t2_VMId INT, t2_vmSize BIGINT, t2_vmUsedSpace BIGINT, t2_vmStatus INT)
INSERT INTO #VSAVMList
SELECT  commCellId, jobId, VMClientId, ISNULL([vmGuestSize], 0), ISNULL([vmUsedSpace], 0), CAST(ISNULL([vmStatus],-1) AS INT)
FROM    ( SELECT  ClientJobId AS jobId, commcellId, VmClientId, attrName, attrVal
      FROM    APP_VMProp P WITH (NOLOCK)
      WHERE   EXISTS (select 1 from #tempVMDPJobs J INNER JOIN JMBkpStats JMB WITH (NOLOCK) ON J.LastSuccessfulBackupJobId = JMB.jobid where J.LastSuccessfulBackupJobId = P.ClientJobId AND P.commCellId = JMB.commCellId AND J.clientId = P.VMClientId AND J.BackupStatus = 'Currently protected' ) ) AS VMs
PIVOT   ( MAX(attrVal) FOR attrName IN (  [vmUsedSpace], [vmGuestSize], [vmStatus]) ) AS P
DELETE #VSAVMList WHERE t2_vmStatus NOT IN (0,3)
UPDATE #VSAVMList
SET t2_vmSize   = (CASE WHEN t2_vmSize = 0 THEN t2_vmUsedSpace ELSE t2_vmSize END)
UPDATE J
SET VMSizeMB = CAST(ISNULL(t2_vmSize,0)/1024.0/1024.0 as decimal(10,2))
FROM #tempVMDPJobs J
LEFT JOIN #VSAVMList L ON t2_jobId = J.LastSuccessfulBackupJobId AND t2_VMId = J.clientId
IF object_id('tempdb.dbo.#tempDRVM') IS NOT null DROP TABLE #tempDRVM
CREATE TABLE #tempDRVM (clientId INT, Jobid BIGINT)
INSERT INTO #tempDRVM
SELECT DISTINCT J.clientId, J.LastSuccessfulBackupJobId
FROM #tempVMDPJobs J
INNER JOIN APP_ClientProp CP WITH(NOLOCK) ON CP.componentNameId = J.clientId AND attrname ='Virtual Machine Instance UUID' AND modified = 0
INNER JOIN APP_VSAReplication R WITH(NOLOCK) ON R.sourceGuid = CP.attrVal AND ISNULL(R.status,0) <> 6
INNER JOIN TM_Task T WITH (NOLOCK) ON R.taskId = T.taskId AND ISNULL(T.disabled,0) <> 1
WHERE BackupStatus = 'Currently protected'
DECLARE @t_id INT
DECLARE @t_name VARCHAR(MAX)
IF object_id('tempdb.dbo.#VMsWithAppClassPkg') IS NOT null DROP TABLE #VMsWithAppClassPkg
CREATE TABLE #VMsWithAppClassPkg(t_Id INT, t_Name NVARCHAR(255), t_bRDM INT, t_pkgId INT, t_appType INT, t_licType INT, t_agentStatus INT, t_pkgName VARCHAR(255))
INSERT INTO #VMsWithAppClassPkg
EXEC LicGetVMAppcalss1
IF @bIsMsimValid > 0
BEGIN
	IF object_id('tempdb.dbo.#tmpO365SharePointClients') IS NOT null DROP TABLE #tmpO365SharePointClients
	CREATE TABLE #tmpO365SharePointClients (clientid INT)
	EXEC LicGetO365Sharepoint '#tmpO365SharePointClients'
	DELETE #VMsWithAppClassPkg FROM #tmpO365SharePointClients WHERE t_Id = clientid
	DROP TABLE #tmpO365SharePointClients
END
IF @nUserId > 1 --SECURITY
BEGIN
	IF object_id('tempdb.dbo.#LicCalUserObj') IS NOT NULL DROP TABLE #LicCalUserObj
create table  #LicCalUserObj ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
END
IF @nOrganizationDetails > 0
BEGIN
	IF object_id('tempdb.dbo.#CompanyClientMap') IS NOT NULL DROP TABLE #CompanyClientMap
	CREATE TABLE #CompanyClientMap(t_companyId INT, t_clientId INT)
	CREATE UNIQUE CLUSTERED INDEX CompanyClientMap_Idx ON #CompanyClientMap (t_companyId, t_clientId)
END
IF @nUserId > 1 OR @nOrganizationDetails > 0
EXEC LicGetSecurityObjV3 @nUserId OUTPUT, @nOrganizationDetails
IF @nUserId > 1 --SECURITY
BEGIN
   delete #VMsWithAppClassPkg
   where t_Id not in (select clientId from #LicCalUserObj where clientId > 0)
END
INSERT INTO #tempClientList2 (t_type, t_clientId, t_subclientid, t_appTypeId, t_lictype, t_jobid, t_vmstatus,t_objectName,t_objectId, t_appsizeMB)
SELECT distinct @AdvancedVMType,t_Id,0,t_appType,@ACVLicType,0,4,NULL,t_Id,0
From #VMsWithAppClassPkg
UPDATE #tempClientList2
SET t_objectName = c.name
From App_Client c WITH(NOLOCK)
WHERE t_type = @AdvancedVMType and c.id=t_objectId
IF @nOrganizationDetails > 0
BEGIN
	 --VM calculation
	DELETE FROM #tempVMDPJobs WHERE BackupStatus <> 'Currently protected'
	UPDATE T SET T.vmcount = B.vmcount
	FROM #Companies T JOIN
	(SELECT t_companyId,COUNT(DISTINCT VMName) vmcount FROM #tempVMDPJobs A JOIN #CompanyClientMap B ON A.clientId = B.t_clientId AND IsVMArchived = 0 GROUP BY t_companyId ) B
	ON T.id = B.t_companyId
	--Socket calculation
	UPDATE T SET T.socketcount = C.sockets
	FROM #Companies T JOIN
	(SELECT B.t_companyId,SUM(socket) AS sockets FROM
	(SELECT t_companyId,t_host,MAX(t_sockets) socket FROM #tmpSocketDetails A JOIN #CompanyClientMap B ON A.t_clientId = B.t_clientId GROUP BY t_companyId, t_host ) B
	GROUP BY t_companyId) C ON T.id = C.t_companyId
	DROP TABLE #CompanyClientMap
END
ELSE
BEGIN
--VM Socket
	INSERT INTO #tempClientList2 (t_type, t_clientId, t_subclientid, t_appTypeId, t_lictype, t_jobid, t_vmstatus,t_objectName,t_objectId, t_appsizeMB)
	SELECT distinct @VMSocketType,0,0,0,@VMSocketLicType,0,1,t_host,0,MAX(t_sockets)
	From #tmpSocketDetails
	GROUP BY t_host
----VM only & Archived VM
	 IF @bIsArchiveLicValid > 0
     BEGIN
		INSERT INTO #tempClientList2 (t_type, t_clientId, t_subclientid, t_appTypeId, t_lictype, t_jobid, t_vmstatus,t_objectName,t_objectId, t_appsizeMB)
		SELECT distinct
		(case IsVMArchived when 0 then @AdvancedVMType
					  when 1 then @ArchivedVMType
					  end),
		0, 0,
		106,
		(case IsVMArchived when 0 then @VMOnlyLicType
					  when 1 then @ArchivedVMLicType
					  end),
		LastSuccessfulBackupJobId,2,vmname,clientId,VMSizeMB
		From #tempVMDPJobs
		Where BackupStatus = 'Currently protected'
	 END
     ELSE
	 BEGIN
		INSERT INTO #tempClientList2 (t_type, t_clientId, t_subclientid, t_appTypeId, t_lictype, t_jobid, t_vmstatus,t_objectName,t_objectId, t_appsizeMB)
		SELECT distinct @AdvancedVMType,0, 0,106, @VMOnlyLicType,LastSuccessfulBackupJobId,2,vmname,clientId,VMSizeMB
		From #tempVMDPJobs
		Where BackupStatus = 'Currently protected'
	 END
	 INSERT INTO #tempClientList2 (t_type, t_clientId, t_subclientid, t_appTypeId, t_lictype, t_jobid, t_vmstatus,t_objectName,t_objectId, t_appsizeMB)
	 SELECT distinct @DRVMType,T.t_clientId, T.t_subclientid,T.t_appTypeId, @DRVMLicType,T.t_jobid, T.t_vmstatus,T.t_objectName,T.t_objectId, T.t_appsizeMB
	 FROM #tempClientList2 T
	 INNER JOIN #tempDRVM D ON T.t_objectId = D.clientId AND T.t_jobid = D.JobId
	 IF @bIsDRVMValid > 0 OR @bIsVMProtectedLicValid = 0 AND @bIsSocketLicValid = 0 AND @bIsOILicValid = 0 AND @bIsVOILicValid = 0
	 BEGIN
		DELETE T
		FROM #tempClientList2 T
		INNER JOIN (
					SELECT T.clientId, T.JobId FROM #tempDRVM T
					INNER JOIN JMBkpStats JMB WITH(NOLOCK) ON JMB.jobId = T.JobId
					INNER JOIN archGroupCopy AG WITH(NOLOCK) ON AG.archGroupId = JMB.dataArchGrpId
					INNER JOIN archAgingRule AGR WITH(NOLOCK) ON AG.id = AGR.copyId
					GROUP BY T.clientId, T.JobId
HAVING max(AGR.retentionDays)<=14
				   ) D ON T.t_objectId = D.clientId AND T.t_jobid = D.JobId
		WHERE T.t_type <> @DRVMType
	 END
	 UPDATE A
	 SET A.t_clientId = V.t_Id,A.t_appTypeId = V.t_appType,A.t_lictype = @VMWithAppLicType,t_vmstatus = 3
	 FROM #tempClientList2 A INNER JOIN #VMsWithAppClassPkg V ON A.t_objectId = V.t_Id
	 WHERE A.t_type = @AdvancedVMType AND t_vmstatus = 2
	 DELETE A
	 From #tempClientList2 A INNER JOIN #tempClientList2 B
	 On A.t_type = @AdvancedVMType AND A.t_type = B.t_type AND A.t_vmstatus = 4 AND B.t_vmstatus = 3 AND A.t_objectId = B.t_objectId
	 UPDATE A
	 SET A.t_clientId = C.clientId, A.t_subclientid = C.id
	 FROM #tempClientList2 A join JMBkpStats B WITH(NOLOCK) ON A.t_jobid = B.jobId
	 JOIN APP_Application C WITH(NOLOCK) ON B.appId = C.id
	 WHERE t_vmstatus = 2
	 UPDATE A
	 SET A.t_clientId = C.clientId, A.t_subclientid = C.id
	 FROM #tempClientList2 A join JMJobDataLink L WITH(NOLOCK) ON A.t_jobid = L.childjobId AND A.t_subclientid = L.childAppid AND L.linkType = 7
	 JOIN APP_Application C WITH(NOLOCK) ON L.parentappId = C.id
	 WHERE t_vmstatus = 2
	 UPDATE A
	 SET A.t_jobId = B.jobId
	 FROM #tempClientList2 A JOIN (SELECT DISTINCT clientId, AppTypeId, jobId FROM Lic_PeakUsage WITH(NOLOCK) WHERE MonthStart = @monthStart AND PeakType = 1 AND UsageType <= 4 AND LicType = @vmLicType) B ON A.t_clientId = B.clientId AND A.t_AppTypeId = B.AppTypeId
	 WHERE t_vmstatus in (2,3)
END
IF object_id('tempdb.dbo.#tempUsage') IS NOT null DROP TABLE #tempUsage
CREATE TABLE #tempUsage (t_usageType INT,t_currentUsage INT, t_lastUsage INT, t_VMFlag int DEFAULT 0, t_updateStatus INT DEFAULT 0)
BEGIN TRY
BEGIN TRAN
IF EXISTS (SELECT 1 FROM Lic_CurrentUsage WITH (NOLOCK) WHERE UsageType in (@AdvancedVMType,@VMSocketType,@ArchivedVMType,@DRVMType))
DELETE FROM Lic_CurrentUsage WHERE UsageType in (@AdvancedVMType,@VMSocketType,@ArchivedVMType,@DRVMType)
INSERT INTO Lic_CurrentUsage (UsageType,ClientId,SubclientId,AppTypeId,LicType,JobId,AppSizeMB,CapacityFlag, VMFlag, ObjectName,ObjectId)
SELECT  DISTINCT t_type, t_clientId, t_subclientid, t_appTypeId, t_lictype, t_jobid, t_appsizeMB, -1,t_vmstatus,t_objectName,t_objectId
FROM  #tempClientList2
UPDATE U
SET CapacityFlag = (CASE WHEN J.parentJobid IS NULL THEN JobId ELSE J.parentJobid END)
FROM Lic_CurrentUsage U
LEFT JOIN JMJobDataLink J WITH(NOLOCK) ON U.JobId = J.childJobId AND J.linkType = 7
WHERE (UsageType = @AdvancedVMType AND VMFLAG IN (2,3)) OR UsageType = @ArchivedVMType OR UsageType = @DRVMType
SELECT @current_VMOnly = [2],@current_VMWithApp = [3],@current_UPVMWithApp  = [4]
FROM (SELECT distinct ObjectId, VMFlag FROM Lic_CurrentUsage WITH (NOLOCK) WHERE UsageType = @AdvancedVMType) AS S
PIVOT
(COUNT(ObjectId) FOR VMFlag in ([2],[3],[4])) AS P
SELECT @current_VMSocket = ISNULL(SUM(AppSizeMB),0) FROM Lic_CurrentUsage WITH (NOLOCK) WHERE UsageType = @VMSocketType
SELECT @current_ArchivedVM = COUNT(DISTINCT ObjectId) FROM Lic_CurrentUsage WITH (NOLOCK) WHERE UsageType = @ArchivedVMType
SELECT @current_DRVM = COUNT(DISTINCT ObjectId) FROM Lic_CurrentUsage WITH (NOLOCK) WHERE UsageType = @DRVMType
SELECT @last_VMOnly = [2],@last_VMWithApp = [3],@last_UPVMWithApp  = [4]
FROM (SELECT distinct ObjectId, VMFlag FROM Lic_PeakUsage WITH (NOLOCK) WHERE MonthStart = @monthStart AND PeakType = @CCLPeakType AND UsageType = @AdvancedVMType) AS S
PIVOT
(COUNT(ObjectId) FOR VMFlag in ([2],[3],[4])) AS P
SELECT @last_VMSocket = ISNULL(SUM(AppSizeMB),0) FROM Lic_PeakUsage WITH (NOLOCK) WHERE MonthStart = @monthStart AND UsageType = @VMSocketType AND PeakType = @CCLPeakType
SELECT @last_ArchivedVM  = COUNT(DISTINCT ObjectId) FROM Lic_PeakUsage WITH (NOLOCK) WHERE MonthStart = @monthStart AND UsageType = @ArchivedVMType AND PeakType = @CCLPeakType
SELECT @last_DRVM  = COUNT(DISTINCT ObjectId) FROM Lic_PeakUsage WITH (NOLOCK) WHERE MonthStart = @monthStart AND UsageType = @DRVMType AND PeakType = @CCLPeakType
INSERT INTO #tempUsage (t_usageType,t_currentUsage,t_lastUsage,t_VMFlag)
VALUES (@AdvancedVMType,@current_VMOnly,@last_VMOnly,2),
(@AdvancedVMType,@current_VMWithApp,@last_VMWithApp,3),
(@AdvancedVMType,@current_UPVMWithApp,@last_UPVMWithApp,4),
(@VMSocketType,@current_VMSocket,@last_VMSocket,0),
(@ArchivedVMType,@current_ArchivedVM,@last_ArchivedVM,0),
(@DRVMType,@current_DRVM,@last_DRVM,0)
UPDATE #tempUsage
SET t_updateStatus = 1
WHERE t_currentUsage >= t_lastUsage AND t_currentUsage > 0
DELETE T
FROM Lic_PeakUsage T
INNER JOIN #tempUsage ON T.UsageType = t_usageType AND t_updateStatus = 1 AND t_VMFlag = (CASE t_usageType WHEN @AdvancedVMType THEN T.VMFlag ELSE 0 END)
WHERE T.MonthStart = @monthStart AND T.PeakType = @CCLPeakType
INSERT INTO Lic_PeakUsage (MonthStart,CreationDate,UsageType,PeakType,ClientId,SubclientId,AppTypeId,LicType,JobId,AppSizeMB,CapacityFlag,VMFlag, ObjectName,ObjectId)
SELECT @monthStart,@currentTime,UsageType,@CCLPeakType,ClientId,SubclientId,AppTypeId,LicType,JobId,AppSizeMB,CapacityFlag, VMFlag, ObjectName,ObjectId
FROM Lic_CurrentUsage WITH (NOLOCK)
INNER JOIN #tempUsage ON UsageType = t_usageType AND t_updateStatus = 1 AND t_VMFlag = (CASE t_usageType WHEN @AdvancedVMType THEN VMFlag ELSE 0 END)
MERGE Lic_PeakUsage AS T
USING  (SELECT UsageType,ClientId,SubclientId,AppTypeId,LicType,JobId,AppSizeMB,CapacityFlag,VMFlag,ObjectName,ObjectId FROM Lic_CurrentUsage WITH (NOLOCK) WHERE UsageType in (@AdvancedVMType,@ArchivedVMType,@DRVMType)) AS S
ON T.MonthStart = @monthStart AND T.UsageType = S.UsageType AND T.PeakType = @SCLPeakType AND T.ObjectId = S.ObjectId AND T.AppTypeId = S.AppTypeId AND T.VMFlag = S.VMFlag
WHEN MATCHED AND T.AppSizeMB <= S.AppSizeMB
	THEN Update
		SET T.CreationDate = @currentTime, T.ClientId = S.ClientId,T.Subclientid = S.Subclientid,T.ObjectName = S.ObjectName, T.JobId = S.JobId, T.AppSizeMB = S.AppSizeMB, T.CapacityFlag = S.CapacityFlag
WHEN NOT MATCHED BY TARGET
	THEN INSERT (MonthStart, CreationDate, UsageType, PeakType,ClientId,SubclientId,AppTypeId,LicType,JobId,AppSizeMB,CapacityFlag,VMFlag, ObjectName,ObjectId)
		VALUES(@monthStart, @currentTime, S.UsageType,@SCLPeakType,S.ClientId,S.SubclientId,S.AppTypeId,S.LicType,S.JobId,S.AppSizeMB,S.CapacityFlag,S.VMFlag, S.ObjectName,S.ObjectId)
;
MERGE Lic_PeakUsage AS T
USING  (SELECT UsageType,LicType,AppSizeMB,CapacityFlag, VMFlag, ObjectName FROM Lic_CurrentUsage WITH (NOLOCK) WHERE UsageType = @VMSocketType) AS S
ON T.MonthStart = @monthStart AND T.UsageType = S.UsageType AND T.PeakType = @SCLPeakType AND T.ObjectName = S.ObjectName
WHEN MATCHED AND T.AppSizeMB < S.AppSizeMB
	THEN Update
		SET T.CreationDate = @currentTime, T.AppSizeMB = S.AppSizeMB
WHEN NOT MATCHED BY TARGET
	THEN INSERT (MonthStart, CreationDate, UsageType, PeakType,LicType,AppSizeMB,CapacityFlag, VMFlag, ObjectName)
		VALUES(@monthStart, @currentTime, S.UsageType,@SCLPeakType,S.LicType,S.AppSizeMB,S.CapacityFlag,S.VMFlag,S.ObjectName)
;
COMMIT TRAN
END TRY
BEGIN CATCH
ROLLBACK TRAN
SET @attrVal = '1'
GOTO  CAL_ERROR
END CATCH
CAL_ERROR:
IF EXISTS(select 1 from LicUsageBasedConfig WITH (nolock) where attrname = @attrname)
	Update LicUsageBasedConfig
	SET attrVal = @attrVal
	WHERE attrname = @attrname AND attrVal <> @attrVal
ELSE
	INSERT INTO LicUsageBasedConfig (attrname,attrType,attrVal)
	VALUES (@attrname, @attrType, @attrVal)
IF @nUserId > 0 --SECURITY
DROP TABLE #LicCalUserObj
DROP TABLE #tmpSocketDetails
DROP TABLE #VMsWithAppClassPkg
DROP TABLE #tempVMDPJobs
DROP TABLE #VSAVMList
DROP TABLE #tempClientList2
DROP TABLE #tempUsage
SET NOCOUNT OFF
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'LicGetVirtualizationDetailsV3')
	delete from GxQscripts where name = 'LicGetVirtualizationDetailsV3'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LicGetVirtualizationDetailsV3')
	delete from GXDBVersions where aliasname = 'LicGetVirtualizationDetailsV3'
GO

insert into GXDBVersions values(2, 'LicGetVirtualizationDetailsV3',  '00010001000200110000', 'LicGetVirtualizationDetailsV3', '00010001000200110000')
GO

