

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/LicGetVMToPMList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Zach Wang
--	Date:   4/3/2019
-- ----------------------------------------------------------------------*/
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='LicGetVMToPMList')
BEGIN
	print '>>> Drop Stored Procedure: LicGetVMToPMList <<<'
	drop procedure LicGetVMToPMList
END
IF EXISTS (select * from GxQscripts where name='LicGetVMToPMList')
	delete from GxQscripts where name = 'LicGetVMToPMList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LicGetVMToPMList')
	delete from GXDBVersions where aliasname = 'LicGetVMToPMList'
GO
print '... Creating Procedure: LicGetVMToPMList'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure LicGetVMToPMList
  @i_clientid INT = 0
AS
SET ANSI_PADDING ON
SET NOCOUNT ON
IF object_id('tempdb.dbo.#tempVMToPMList') IS NOT NULL
BEGIN
	IF object_id('tempdb.dbo.#tmpClientList') IS NOT NULL DROP TABLE #tmpClientList
	CREATE TABLE #tmpClientList
    (   ClientId        integer,
        subclientId     integer,
        INSTANCE        integer,
        appTypeId       integer
    )
	DECLARE @currentDateUTC DATETIME = GETUTCDATE()
	INSERT INTO #tmpClientList
	SELECT DISTINCT cid,0,0,0
	FROM LicUsage WITH (NOLOCK)
	WHERE OpType = 'Install' AND LicType in (1,2,3,16,17,25,127) AND (Eval = 0 OR ExpiryDateUTC > @currentDateUTC)	AND (@i_clientid = 0 OR @i_clientid = cid)
	UNION --include Openstack pseudo client
	SELECT DISTINCT C.id,0,0,0
	FROM APP_Client C WITH (NOLOCK)
	INNER JOIN APP_Application APP WITH (NOLOCK) ON APP.clientId = C.id AND (APP.subclientStatus & 6) = 0
	INNER JOIN APP_iDAName IDA WITH (NOLOCK) ON IDA.clientId = APP.clientId AND (iDA.Status & 6) = 0
	INNER JOIN APP_InstanceProp Prop WITH (NOLOCK) ON APP.instance = Prop.componentNameId AND attrName = 'Cloud Apps Instance Type' AND LEN(attrVal) > 0 AND attrVal ='15'
	WHERE (@i_clientid = 0 OR @i_clientid = C.id)
	IF OBJECT_ID('tempdb.dbo.#tmpProxyClientList') IS NOT NULL
    DROP TABLE #tmpProxyClientList
	CREATE TABLE #tmpProxyClientList(
    ClientId        INTEGER,
    instanceId      INTEGER,
    proxyClientId   INTEGER,
    ClientAppType   INTEGER,
    isIndexServer       INTEGER DEFAULT 0,  --0 meaning proxyclient, 1 meaning INDEX server
    iscloudindexServer  INTEGER DEFAULT 0,    -- 1 meaning cloud INDEX server
    cloudindexServer    INTEGER DEFAULT 0,
    isproxyclientGroup  INTEGER DEFAULT 0 , -- 1 meaning client Group
    clientGroup         INTEGER DEFAULT 0,
    subclientId         INTEGER DEFAULT 0
	)
	CREATE CLUSTERED INDEX #tmpProxyClientList_proxyClientId_ClientId_idx ON #tmpProxyClientList(proxyClientId,ClientId)
	EXEC AppGetPRoxyClientInfo '#tmpClientList', '#tmpProxyClientList', 1
	INSERT INTO #tempVMToPMList (appTypeId, pseudoClientId, physClientId)
	SELECT DISTINCT ClientAppType,ClientId,proxyClientId
	FROM #tmpProxyClientList
	WHERE ClientAppType <> 106 AND isIndexServer = 0 AND  iscloudindexServer = 0 AND ClientId > 0 AND proxyClientId > 0 AND (@i_clientid = 0 OR @i_clientid = ClientId)
	IF OBJECT_ID('tempdb.dbo.#tmpProxyMySql') IS NOT NULL
    DROP TABLE #tmpProxyMySql
	CREATE TABLE #tmpProxyMySql(appTypeId INT,pseudoClientId INT,physClientId INT)
	INSERT INTO #tmpProxyMySql
	SELECT DISTINCT t.appTypeId, t.clientId pseudoClientId, a.value('@clientId', 'int') physClientId
    FROM (
            SELECT a.clientId, a.appTypeId, CAST(ip.attrVal AS XML) data
            FROM APP_Application A WITH (NOLOCK)
            INNER JOIN APP_InstanceProp ip WITH (NOLOCK) ON A.appTypeId = 81 AND ip.componentNameId = A.instance AND ip.attrName = 'Availability Group' AND (A.subclientStatus & 6) = 0
            WHERE dbo.IsPseudoClient(a.clientId) = 1
         ) t
    CROSS APPLY t.data.nodes('App_SQLAvailabilityGroup/primaryReplicaClient') rc(a)
    WHERE a.value('@clientId', 'int') IS NOT NULL AND (@i_clientid = 0 OR @i_clientid = t.clientId)
	DELETE T
	FROM #tempVMToPMList T
	INNER JOIN #tmpProxyMySql S ON S.appTypeId = T.appTypeId AND T.pseudoClientId  = S.pseudoClientId
	INSERT INTO #tempVMToPMList
	SELECT appTypeId,pseudoClientId,physClientId
	FROM #tmpProxyMySql
	DELETE T
	FROM #tempVMToPMList T
	INNER JOIN APP_VMToPMMap M ON T.pseudoClientId = M.VMClientId AND T.physClientId = M.PMClientId AND (@i_clientid = 0 OR @i_clientid = M.VMClientId)
	INSERT INTO  #tempVMToPMList
	SELECT DISTINCT 134, VMClientId, PMClientId
	FROM APP_VMToPMMap V WITH (NOLOCK)
	WHERE @i_clientid = 0 OR @i_clientid = VMClientId
	DELETE #tempVMToPMList
	WHERE physClientId IS NULL OR physClientId <= 0
	IF object_id('tempdb.dbo.#tmpClientList') IS NOT NULL
	DROP TABLE #tmpClientList
	IF OBJECT_ID('tempdb.dbo.#tmpProxyMySql') IS NOT NULL
    DROP TABLE #tmpProxyMySql
	IF OBJECT_ID('tempdb.dbo.#tmpProxyClientList') IS NOT NULL
    DROP TABLE #tmpProxyClientList
END
SET NOCOUNT OFF
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'LicGetVMToPMList')
	delete from GxQscripts where name = 'LicGetVMToPMList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LicGetVMToPMList')
	delete from GXDBVersions where aliasname = 'LicGetVMToPMList'
GO

insert into GXDBVersions values(2, 'LicGetVMToPMList',  '00000000000000000000', 'LicGetVMToPMList', '00000000000000000000')
GO

