

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/LicGetVMAppcalss1.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/LicGetVMAppcalss1.sp,v $ $Id: LicGetVMAppcalss1.sp,v 1.3.2.18 2020/10/26 06:33:40 leiwang Exp $";
--
--  +========================================================================+
--  | Stored Precedure: LicGetVMAppcalss1
--  |
--  |   Revisions  Author           Description
--  |   ---------  -------          ---------------------------------------------
--  |   1.0        Xuemei Sui       Get a lis of VMs with appclass 1 packages installed
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='LicGetVMAppcalss1')
BEGIN
	print '>>> Drop Stored Procedure: LicGetVMAppcalss1 <<<'
	drop procedure LicGetVMAppcalss1
END
IF EXISTS (select * from GxQscripts where name='LicGetVMAppcalss1')
	delete from GxQscripts where name = 'LicGetVMAppcalss1'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LicGetVMAppcalss1')
	delete from GXDBVersions where aliasname = 'LicGetVMAppcalss1'
GO
print '... Creating Procedure: LicGetVMAppcalss1'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure LicGetVMAppcalss1
  @in_tmpTbl VARCHAR(MAX)=NULL,
  @in_subclientId INTEGER = 0,
  @in_clientId INTEGER = 0,
  @in_appTypeId INTEGER = 0,
  @in_bIncludeRDM INTEGER = 0,
  @in_bCheckLicense INTEGER = 0,
  @in_returnVal INTEGER = NULL OUTPUT
AS
SET NOCOUNT ON
DECLARE @appClassPkgInfo TABLE(t_pkgId INT, t_appTypeId INT, t_licTypeId INT)
INSERT INTO @appClassPkgInfo SELECT id, 0, 0 FROM SimPackage WITH (NOLOCK) WHERE DisplayName IN ('Exchange', 'SQL Server', 'Active Directory', 'SharePoint', 'MySQL', 'PostgreSQL','Oracle')
UPDATE @appClassPkgInfo
SET	t_appTypeId = appType, t_licTypeId = LicType
FROM	simPackageMap M WITH (NOLOCK)
WHERE	t_pkgId = simPackageId
IF object_id('tempdb.dbo.#VMsWithAppClass1Pkg') IS NOT null DROP TABLE #VMsWithAppClass1Pkg
CREATE TABLE #VMsWithAppClass1Pkg(t_Id INT, t_Name NVARCHAR(255), t_bRDM INT, t_pkgId INT, t_appType INT, t_licType INT, t_agentStatus INT, t_pkgName VARCHAR(255))
INSERT INTO #VMsWithAppClass1Pkg
SELECT	C.id, C.name, 0, t_pkgId, t_appTypeId, t_licTypeId, A.status, (select displayname from simPackage P WITH (NOLOCK) where id = t_pkgId)
FROM	APP_Client C WITH (NOLOCK), APP_iDAName A WITH (NOLOCK), @appClassPkgInfo T
WHERE	(@in_clientId = 0 OR C.id = @in_clientId) AND (@in_appTypeId = 0 OR t_appTypeId = @in_appTypeId) AND
	C.id IN (SELECT clientId FROM simInstalledPackages WHERE simPackageId = t_pkgId) AND
	C.id IN (select componentNameId from APP_ClientProp WITH (NOLOCK) where attrName = 'Virtual Server Discovered Clients' and attrval = '1' and modified = 0) AND
	A.clientId = C.id AND A.appTypeId = t_appTypeId
--exclude VM that has been deleted
DELETE VM
From #VMsWithAppClass1Pkg VM INNER JOIN APP_ClientProp WITH (NOLOCK) ON t_Id = componentNameId AND attrName = 'Virtual Machine Deletion Time' AND ISNULL(attrVal, '0') <> '0' AND modified = 0
WHERE t_agentStatus&(2+4) > 0
IF @in_subclientId > 0
	DELETE #VMsWithAppClass1Pkg
	FROM	(select clientID, appTypeId from APP_Application WITH (NOLOCK) where id = @in_subclientId) T
	WHERE	t_Id <> clientID OR appTypeId <> t_appType
UPDATE #VMsWithAppClass1Pkg
SET	t_bRDM = 1
WHERE	EXISTS (
		SELECT 1 FROM APP_Application A WITH (NOLOCK)
		JOIN APP_SubclientProp P WITH (NOLOCK) ON A.id = P.componentNameID and P.attrName = 'Snap Engine' and P.cs_attrName = CHECKSUM(N'Snap Engine') and LEN(P.attrVal) > 0 and P.attrVal <> '48' and P.modified = 0
		JOIN APP_SubclientProp P1 WITH (NOLOCK) ON A.id = P1.componentNameID and P1.attrName = 'Enable Snap Backups' and P1.cs_attrName = CHECKSUM(N'Enable Snap Backups') and LEN(P1.attrVal) > 0 and P1.attrVal = '1' and P1.modified = 0
		WHERE	clientId = t_Id AND t_appType = appTypeId AND (subClientStatus & 2) = 0)
IF @in_bIncludeRDM = 0
	DELETE #VMsWithAppClass1Pkg WHERE t_id IN (select T.t_id from #VMsWithAppClass1Pkg T where T.t_bRDM = 1)
ELSE -- If even 1 agent is not qualified for ACV, All the agents under that client should consume Agent license. MR 148055
	UPDATE #VMsWithAppClass1Pkg SET t_bRDM = 1 WHERE t_id IN (select T.t_id from #VMsWithAppClass1Pkg T where T.t_bRDM = 1)
IF @in_bCheckLicense > 0
BEGIN
	DECLARE @VMLicInfo TABLE (cid INT, licType INT, appType INT)
	INSERT INTO @VMLicInfo
	SELECT cid, licType, appType
	FROM	LicUsage WITH (NOLOCK), #VMsWithAppClass1Pkg
	WHERE	cid = t_Id AND licType = t_licType AND appType = t_appType AND optype = 'Install' AND
		(eval = 0 AND dbo.getUNIXTime(expiryDateUTC) = 0 OR getUTCDate() < expiryDateUTC)
	DELETE #VMsWithAppClass1Pkg
	WHERE	(t_bRDM > 0 OR t_bRDM = 0 AND @in_bCheckLicense = 2) AND
		((t_agentStatus & 6) > 0 AND NOT EXISTS (select * from @VMLicInfo where cid = t_Id AND licType = t_licType AND appType = t_appType)
			OR
		 (t_agentStatus & 6) = 0 AND EXISTS (select * from @VMLicInfo where cid = t_Id AND licType = t_licType AND appType = t_appType))
			OR
		t_bRDM = 0 AND @in_bCheckLicense = 1 AND NOT EXISTS (select * from @VMLicInfo where cid = t_Id AND licType = t_licType AND appType = t_appType)
END
ELSE
	DELETE FROM #VMsWithAppClass1Pkg WHERE t_agentStatus&(2+4) > 0
IF @in_tmpTbl IS NOT NULL AND LEN(@in_tmpTbl) > 0
BEGIN
	DECLARE @outputstatement VARCHAR(MAX) = 'INSERT INTO '+ @in_tmpTbl
	IF @in_tmpTbl = '#tempVMsWithIdNamePkgName'
		SET @outputstatement = @outputstatement + ' SELECT t_Id, t_Name, t_pkgName '
	IF @in_tmpTbl = '#tempVMsWithIdAppType' OR @in_tmpTbl = '#tempACVList'
		SET @outputstatement = @outputstatement + ' SELECT DISTINCT t_Id, t_appType '
	SET @outputstatement = @outputstatement + 'FROM #VMsWithAppClass1Pkg'
	EXEC (@outputstatement)
END
ELSE IF @in_returnVal IS NULL
	SELECT * FROM #VMsWithAppClass1Pkg ORDER BY t_bRDM, t_Id, t_pkgId
ELSE
	SET @in_returnVal = (select COUNT(*) FROM #VMsWithAppClass1Pkg)
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'LicGetVMAppcalss1')
	delete from GxQscripts where name = 'LicGetVMAppcalss1'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LicGetVMAppcalss1')
	delete from GXDBVersions where aliasname = 'LicGetVMAppcalss1'
GO

insert into GXDBVersions values(2, 'LicGetVMAppcalss1',  '00010003000200180000', 'LicGetVMAppcalss1', '00010003000200180000')
GO

