

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/LicGetUserDetailsV3.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/LicGetUserDetailsV3.sp,v $ $Id: LicGetUserDetailsV3.sp,v 1.1.2.3 2019/04/17 17:16:20 leiwang Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='LicGetUserDetailsV3')
BEGIN
	print '>>> Drop Stored Procedure: LicGetUserDetailsV3 <<<'
	drop procedure LicGetUserDetailsV3
END
IF EXISTS (select * from GxQscripts where name='LicGetUserDetailsV3')
	delete from GxQscripts where name = 'LicGetUserDetailsV3'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LicGetUserDetailsV3')
	delete from GXDBVersions where aliasname = 'LicGetUserDetailsV3'
GO
print '... Creating Procedure: LicGetUserDetailsV3'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure LicGetUserDetailsV3
  @nUserId integer = 0,
  @nOrganizationDetails integer = 0
AS
--Calculate 3 licenses, including Ep Users, Ep Sharing Users, Ep Ediscovery Users
SET ANSI_PADDING ON
SET NOCOUNT ON
DECLARE @currentTime_Unix  INT = dbo.GetUnixTime(GETUTCDATE())
DECLARE @currentTime DATETIME = dbo.getdatetime(@currentTime_Unix)
DECLARE @monthStart DATETIME = DATEADD(MM, DATEDIFF(MM, 0, GETUTCDATE()), 0)
DECLARE @monthStart_Uix int  = dbo.GetUnixTime(@monthStart)
DECLARE @CCLPeakType INT = 0
DECLARE @SCLPeakType INT = 1
DECLARE @attrName varchar (256) ='LicGetUserDetailsV3Status'
DECLARE @attrType int = 1
DECLARE @attrVal varchar(1) = '0'  --0 successful  --1 failed
DECLARE @EpUsersType int  = 22
DECLARE @EpSharingUsersType int = 23
DECLARE @EpEdiscoveryUsersType int  = 24
DECLARE @EpUsersLicType  int = 100024
DECLARE @EpSharingUsersLicType  int = 100025
DECLARE @EpEdiscoveryUsersLicType  int = 100026
DECLARE @current_EpUsers               int = 0
DECLARE @current_EpSharingUsers        int = 0
DECLARE @current_EpEdiscoveryUsers     int = 0
DECLARE @last_EpUsers               int = 0
DECLARE @last_EpSharingUsers        int = 0
DECLARE @last_EpEdiscoveryUsers     int = 0
IF @nUserId > 1 --SECURITY
BEGIN
	IF object_id('tempdb.dbo.#LicCalUserObj') IS NOT NULL DROP TABLE #LicCalUserObj
create table  #LicCalUserObj ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
END
IF @nOrganizationDetails > 0
BEGIN
	IF object_id('tempdb.dbo.#CompanyClientMap') IS NOT NULL DROP TABLE #CompanyClientMap
	CREATE TABLE #CompanyClientMap(t_companyId INT, t_clientId INT)
	CREATE UNIQUE CLUSTERED INDEX CompanyClientMap_Idx ON #CompanyClientMap (t_companyId, t_clientId)
END
IF @nUserId > 1 OR @nOrganizationDetails > 0
EXEC LicGetSecurityObjV3 @nUserId OUTPUT, @nOrganizationDetails
IF object_id('tempdb.dbo.#tempUsers') IS NOT null DROP TABLE #tempUsers
CREATE TABLE #tempUsers(userId INT,userName NVARCHAR(1024),userLogin NVARCHAR(1024),userEmail NVARCHAR(1024),userType INT,reportName NVARCHAR(1024),associationType NVARCHAR(MAX),clientId INT)
CREATE CLUSTERED INDEX tempUsers_userType ON #tempUsers (userType)
INSERT INTO #tempUsers
EXEC RptEndPointUserDetails 4,@nUserId,@nOrganizationDetails
IF object_id('tempdb.dbo.#tempUsage') IS NOT null DROP TABLE #tempUsage
	CREATE TABLE #tempUsage (t_usageType INT,t_currentUsage INT, t_lastUsage INT, t_updateStatus INT DEFAULT 0)
IF @nOrganizationDetails > 0
BEGIN
	UPDATE T SET T.epUsers = S.epUsers, T.epSharingUsers = S.epSharingUsers, T.epDiscoveryUsers = S.epDiscoveryUsers
	FROM #Companies T JOIN
		(SELECT t_companyId, ISNULL([1],0) AS epSharingUsers, ISNULL([2],0) AS epUsers, ISNULL([3],0) AS epDiscoveryUsers
		 FROM (SELECT t_companyId,COUNT(distinct userId) AS users,userType FROM #tempUsers A JOIN #CompanyClientMap B ON A.clientId = B.t_clientId GROUP BY userType,t_companyId) AS B
		 PIVOT (max(users) FOR userType IN ([1],[2],[3])) AS P) AS S
	ON T.id = S.t_companyId
	DROP TABLE #CompanyClientMap
END
BEGIN TRY
BEGIN TRAN
IF EXISTS (SELECT 1 FROM Lic_CurrentUsage WITH (NOLOCK) WHERE UsageType in (@EpUsersType,@EpSharingUsersType,@EpEdiscoveryUsersType))
DELETE FROM Lic_CurrentUsage WHERE UsageType in (@EpUsersType,@EpSharingUsersType,@EpEdiscoveryUsersType)
INSERT INTO Lic_CurrentUsage (UsageType,LicType,BackupSetName,InstanceName,SPName,CapacityFlag, VMFlag, ObjectName,ObjectId)
SELECT DISTINCT @EpUsersType,@EpUsersLicType,userLogin,userEmail,associationType,-1,0,userName,userId
From #tempUsers WHERE userType = 2
UNION ALL
SELECT DISTINCT @EpSharingUsersType,@EpSharingUsersLicType,userLogin,userEmail,associationType,-1,0,userName,userId
From #tempUsers WHERE userType = 1
UNION ALL
SELECT DISTINCT @EpEdiscoveryUsersType,@EpEdiscoveryUsersLicType,userLogin,userEmail,associationType,-1,0,userName,userId
From #tempUsers WHERE userType = 3
SELECT @current_EpUsers = [22], @current_EpSharingUsers = [23], @current_EpEdiscoveryUsers = [24]
FROM (SELECT distinct ObjectId, UsageType FROM Lic_CurrentUsage WITH (NOLOCK) ) AS S
PIVOT
(COUNT(ObjectId) FOR UsageType in ([22],[23],[24])) AS P
SELECT @last_EpUsers = [22], @last_EpSharingUsers = [23], @last_EpEdiscoveryUsers = [24]
FROM (SELECT distinct ObjectId, UsageType FROM Lic_PeakUsage WITH (NOLOCK) WHERE MonthStart = @monthStart AND PeakType = @CCLPeakType) AS S
PIVOT
(COUNT(ObjectId) FOR UsageType in ([22],[23],[24])) AS P
INSERT INTO #tempUsage (t_usageType,t_currentUsage,t_lastUsage)
VALUES (@EpUsersType,@current_EpUsers,@last_EpUsers),
(@EpSharingUsersType,@current_EpSharingUsers,@last_EpSharingUsers),
(@EpEdiscoveryUsersType,@current_EpEdiscoveryUsers,@last_EpEdiscoveryUsers)
UPDATE #tempUsage
SET t_updateStatus = 1
WHERE t_currentUsage >= t_lastUsage AND t_currentUsage > 0
DELETE T
FROM Lic_PeakUsage T
INNER JOIN #tempUsage ON T.UsageType = t_usageType AND t_updateStatus = 1
WHERE T.MonthStart = @monthStart AND T.PeakType = @CCLPeakType
INSERT INTO Lic_PeakUsage (MonthStart,CreationDate,UsageType,PeakType,LicType,BackupSetName,InstanceName,SPName,CapacityFlag, VMFlag, ObjectName,ObjectId)
SELECT @monthStart,@currentTime,UsageType,@CCLPeakType,LicType,BackupSetName,InstanceName,SPName,CapacityFlag, VMFlag, ObjectName,ObjectId
FROM Lic_CurrentUsage WITH (NOLOCK)
INNER JOIN #tempUsage ON UsageType = t_usageType AND t_updateStatus = 1
MERGE Lic_PeakUsage AS T
USING (SELECT UsageType,LicType,BackupSetName,InstanceName,SPName,CapacityFlag, VMFlag, ObjectName,ObjectId FROM Lic_CurrentUsage WITH (NOLOCK) WHERE UsageType in (@EpUsersType,@EpSharingUsersType,@EpEdiscoveryUsersType)) AS S
ON T.MonthStart = @monthStart AND T.UsageType = S.UsageType AND T.PeakType = @SCLPeakType AND T.Objectid = S.Objectid AND T.ObjectName = S.ObjectName
WHEN MATCHED
THEN Update
	SET T.CreationDate = @currentTime, T.BackupSetName = S.BackupSetName,T.InstanceName = S.InstanceName,T.SPName = S.SPName
WHEN NOT MATCHED BY TARGET
THEN INSERT (MonthStart, CreationDate, UsageType, PeakType,LicType,BackupSetName,InstanceName,SPName,CapacityFlag, VMFlag, ObjectName,ObjectId)
	VALUES(@monthStart, @currentTime, S.UsageType,@SCLPeakType,S.LicType,S.BackupSetName,S.InstanceName,S.SPName,S.CapacityFlag,S.VMFlag,S.ObjectName,S.ObjectId)
;
COMMIT TRAN
END TRY
BEGIN CATCH
ROLLBACK TRAN
SET @attrVal = '1'
GOTO  CAL_ERROR
END CATCH
CAL_ERROR:
IF EXISTS(select 1 from LicUsageBasedConfig WITH (nolock) where attrname = @attrname)
	Update LicUsageBasedConfig
	SET attrVal = @attrVal
	WHERE attrname = @attrname AND attrVal <> @attrVal
ELSE
	INSERT INTO LicUsageBasedConfig (attrname,attrType,attrVal)
	VALUES (@attrname, @attrType, @attrVal)
IF @nUserId > 0 --SECURITY
DROP TABLE #LicCalUserObj
DROP TABLE #tempUsers
DROP TABLE #tempUsage
SET NOCOUNT OFF
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'LicGetUserDetailsV3')
	delete from GxQscripts where name = 'LicGetUserDetailsV3'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LicGetUserDetailsV3')
	delete from GXDBVersions where aliasname = 'LicGetUserDetailsV3'
GO

insert into GXDBVersions values(2, 'LicGetUserDetailsV3',  '00010001000200030000', 'LicGetUserDetailsV3', '00010001000200030000')
GO

