

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/LicGetUsageDetails.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/LicGetUsageDetails.sp,v $ $Id: LicGetUsageDetails.sp,v 1.21.86.16 2020/05/16 00:47:17 alakra Exp $";
--
--  +========================================================================+
--  |      Cursor:  LicGetUsageDetails()
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='LicGetUsageDetails')
BEGIN
	print '>>> Drop Stored Procedure: LicGetUsageDetails <<<'
	drop procedure LicGetUsageDetails
END
IF EXISTS (select * from GxQscripts where name='LicGetUsageDetails')
	delete from GxQscripts where name = 'LicGetUsageDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LicGetUsageDetails')
	delete from GXDBVersions where aliasname = 'LicGetUsageDetails'
GO
print '... Creating Procedure: LicGetUsageDetails'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure LicGetUsageDetails
AS
  DECLARE @out_BadkupEnterPriseUsed BIGINT = 0;
  DECLARE @out_BackupCoreUsed BIGINT = 0;
  DECLARE @out_ArchiverEnterPriseUsed BIGINT = 0;
  DECLARE @out_ArchiverCoreUsed BIGINT = 0;
  DECLARE @out_SnapUsed BIGINT = 0;
  DECLARE @out_ReplicationUsed BIGINT = 0;
SET NOCOUNT ON
IF EXISTS(SELECT * FROM tempdb.dbo.sysobjects WHERE ID = OBJECT_ID(N'tempdb..#tmpCommcellUsageReport'))
	DROP TABLE #tmpCommcellUsageReport
create table #tmpCommcellUsageReport ( [EnterpriseBackupSize]	bigint , [CoreBackupSize]		bigint , [EnterpriseArchiveSize] bigint , [CoreArchiveSize]		bigint , [SnapshotSize]			bigint , [ReplicationSize]		bigint , [nJobType]				int , [appId]					int , [jobID]					int , [ClientName]			nvarchar(255) , [ClientId]				int , [AppTypeId]				int , [AppTypeName]			nvarchar(255) , [BackupSetName]			nvarchar(128) , [InstanceName]			nvarchar(512) , [SubclientName]			nvarchar(128) , [SPId]					int , [SPName]				nvarchar(144) , [UncompBytes]			bigint , [DedupEnabled]          int , [SecondaryEncryption]   int , [flag]					int	, [Snapshot]				int default 0, [ClientGroup]			nvarchar(1024) default '')
EXEC QS_CommCellUsageReport '', 0, 4
SELECT TOP 1 @out_BadkupEnterPriseUsed = ISNULL(EnterpriseBackupSize,0),@out_BackupCoreUsed = 0,
@out_ArchiverEnterPriseUsed = ISNULL(EnterpriseArchiveSize,0),@out_ArchiverCoreUsed = 0,
@out_SnapUsed= ISNULL(SnapshotSize,0),@out_ReplicationUsed = ISNULL(ReplicationSize,0) FROM #tmpCommcellUsageReport
DECLARE @currentTime DATETIME = GETDATE()
DECLARE @monthStart DATETIME = DATEADD(MM, DATEDIFF(MM, 0, GETDATE()), 0)
--Keep data only for last 3 months and current month
DELETE FROM LicPeakUsageDetails WHERE DATEDiff(MM, MonthStart,@currentTime) > 3
DELETE FROM LicPeakCLALicClientCount WHERE DATEDiff(MM, MonthStart,@currentTime) > 3
IF object_id('tempdb.dbo.#tempVMsWithIdAppType') IS NOT null DROP TABLE #tempVMsWithIdAppType
CREATE TABLE #tempVMsWithIdAppType(t_Id INT, t_appTypeId INT)
EXEC LicGetVMAppcalss1 '#tempVMsWithIdAppType'
IF object_id('tempdb.dbo.#tempVMDPJobs') IS NOT null DROP TABLE #tempVMDPJobs
	CREATE TABLE #tempVMDPJobs( VMName              nvarchar(1024),
					BackupStatus                    VARCHAR(256), -- 0 - Backed Up, 1 -  Did Not Backup, 2 - manually exlcuded,
					InstanceName                    nvarchar(1024),
					BackupSetName                   nvarchar(1024),
					SubClientName                   nvarchar(1024),
					VMSizeGB                        BIGINT,
					VMBackedupSizeGB                BIGINT,
					EstimatedVMDataWrittenSizeGB    BIGINT,
					LastSuccessfulBackupJobId       BIGINT,
					LastBackupTime                  datetime,
					LastBackupType                  VARCHAR(256),
					TotalTimeForLastBackup          BIGINT,
					clientId                        INT,
					CommCellId                      INT,
					CommCellName                    varchar(256),
					IsVMArchived                    INT)
INSERT INTO #tempVMDPJobs EXEC VMProtectionCoverageProc -3, 0
BEGIN TRANSACTION
MERGE LicPeakUsageDetails AS T
USING #tmpCommcellUsageReport AS S
ON T.AppId = S.AppId AND T.nJobtype = S.nJobtype AND T.MonthStart = @monthStart
WHEN MATCHED AND S.UncompBytes > (T.AppSizeMB*1024*1024)
	THEN UPDATE SET T.AppSizeMB = (1.0*S.UncompBytes)/1024/1024, T.PeakDate = @currentTime, T.jobID = S.jobID, T.SPId = S.SPId
WHEN NOT MATCHED BY TARGET
	THEN INSERT (MonthStart, PeakDate, nJobType, jobID, SPId, ClientId, AppTypeId , appId, AppSizeMB, LicType, IsVM, CapacityFlag, Organization, OrgGUID)
	VALUES(@monthStart, @currentTime, S.nJobType, S.jobID, S.SPId, S.ClientId, S.AppTypeId ,S.appId,(1.0*S.UncompBytes)/1024/1024, -1, -1, S.flag, NULL, NULL)
;
UPDATE LicPeakUsageDetails SET LicType = ISNULL(A.LicType,0)
FROM LicPeakUsageDetails B LEFT JOIN LicUsage A WITH(NOLOCK) ON Cid = ClientId AND A.AppType = B.AppTypeId
WHERE B.LicType < 0
UPDATE LicPeakUsageDetails SET IsVM = ISNULL(CAST(attrVal AS INT),0)
FROM LicPeakUsageDetails B LEFT JOIN APP_ClientProp A WITH(NOLOCK)
ON componentNameId = ClientId AND attrName ='Virtual Server Discovered Clients' AND attrVal = '1' AND modified = 0
WHERE B.IsVM < 0
--Calculation for usage based license
DECLARE @AcvLicType INT = 100027
INSERT INTO LicPeakCLALicClientCount
SELECT @monthStart, @currentTime, t_Id, t_Id, t_appTypeId, @AcvLicType, 0, NULL, NULL FROM #tempVMsWithIdAppType A LEFT JOIN LicPeakCLALicClientCount B ON A.t_Id = B.ClientId AND B.LicType = @AcvLicType AND A.t_appTypeId = B.AppTypeId AND B.MonthStart = @monthStart
WHERE B.ClientId IS NULL
DECLARE @vmLicType INT = 100019
INSERT INTO LicPeakCLALicClientCount
SELECT @monthStart, @currentTime, 0, A.clientId, 106, @vmLicType, A.LastSuccessfulBackupJobId, NULL, NULL FROM #tempVMDPJobs A
LEFT JOIN LicPeakCLALicClientCount B ON A.clientId = B.VMClientId AND B.LicType = @vmLicType AND B.MonthStart = @monthStart
WHERE B.ClientId IS NULL AND BackupStatus = 'Currently protected'
UPDATE LicPeakCLALicClientCount
SET ClientId = C.clientId
FROM #tempVMDPJobs A join JMBkpStats B WITH(NOLOCK) ON A.LastSuccessfulBackupJobId = B.jobId
JOIN APP_Application C WITH(NOLOCK) ON B.appId = C.id
WHERE A.clientId = VMClientId AND BackupStatus = 'Currently protected' AND LicType = @vmLicType
UPDATE A
SET A.jobId = B.jobId
FROM LicPeakCLALicClientCount A JOIN LicPeakUsageDetails B WITH(NOLOCK) ON A.clientId = B.clientId AND A.AppTypeId = B.AppTypeId
WHERE B.LicType = @vmLicType
IF object_id('tempdb.dbo.#tempClientId') IS NOT null DROP TABLE #tempClientId
CREATE TABLE #tempClientId(t_cid INT)
IF object_id('tempdb.dbo.#tempClientIdOrgMap') IS NOT null DROP TABLE #tempClientIdOrgMap
CREATE TABLE #tempClientIdOrgMap(t_cid INT, t_org NVARCHAR(1024), t_orgGUID VARCHAR(40))
INSERT INTO #tempClientId
SELECT clientid FROM LicPeakUsageDetails WITH(NOLOCK) WHERE Organization IS NULL OR OrgGUID IS NULL
UNION
SELECT VMClientId FROM LicPeakCLALicClientCount WITH(NOLOCK) WHERE Organization IS NULL OR OrgGUID IS NULL
INSERT INTO #tempClientIdOrgMap
SELECT t_cid,domainName, D.GUID FROM #tempClientId details JOIN APP_ClientGroupAssoc A WITH(NOLOCK) ON details.t_cid = A.ClientId
JOIN APP_ClientGroup B WITH(NOLOCK) ON A.clientGroupId = B.id
JOIN App_CompanyProp C WITH(NOLOCK) ON C.attrName = 'Associated Smart Client Group' AND A.clientGroupId=C.attrValInt AND C.modified = 0
JOIN UMDSProviders D WITH(NOLOCK) ON C.componentNameId = D.id
WHERE B.flag&0x1000 > 0
UPDATE LicPeakUsageDetails SET Organization = t_org, OrgGUID = t_orgGUID
FROM #tempClientIdOrgMap
WHERE ClientId = t_cid
UPDATE LicPeakCLALicClientCount SET Organization = t_org, OrgGUID = t_orgGUID
FROM #tempClientIdOrgMap
WHERE VMClientId = t_cid
COMMIT TRANSACTION
declare @retcode TABLE(retcode int)
insert into @retcode
EXEC UpdateLicUsageDetailsHistory @out_BadkupEnterPriseUsed, @out_BackupCoreUsed,
@out_ArchiverEnterPriseUsed,@out_ArchiverCoreUsed,0,0,0,@out_SnapUsed,@out_ReplicationUsed,0
IF EXISTS(SELECT * FROM tempdb.dbo.sysobjects WHERE ID = OBJECT_ID(N'tempdb..#tmpCommcellUsageReport'))
	DROP TABLE #tmpCommcellUsageReport
IF EXISTS(SELECT * FROM tempdb.dbo.sysobjects WHERE ID = OBJECT_ID(N'tempdb..#tempVMsWithIdAppType'))
    DROP TABLE #tempVMsWithIdAppType
IF EXISTS(SELECT * FROM tempdb.dbo.sysobjects WHERE ID = OBJECT_ID(N'tempdb..#tempVMDPJobs'))
    DROP TABLE #tempVMDPJobs
IF EXISTS(SELECT * FROM tempdb.dbo.sysobjects WHERE ID = OBJECT_ID(N'tempdb..#tempClientId'))
    DROP TABLE #tempClientId
IF EXISTS(SELECT * FROM tempdb.dbo.sysobjects WHERE ID = OBJECT_ID(N'tempdb..#tempClientIdOrgMap'))
    DROP TABLE #tempClientIdOrgMap
SELECT @out_BadkupEnterPriseUsed, @out_BackupCoreUsed,
@out_ArchiverEnterPriseUsed,@out_ArchiverCoreUsed,
@out_SnapUsed,@out_ReplicationUsed
SET NOCOUNT OFF
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'LicGetUsageDetails')
	delete from GxQscripts where name = 'LicGetUsageDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LicGetUsageDetails')
	delete from GXDBVersions where aliasname = 'LicGetUsageDetails'
GO

insert into GXDBVersions values(2, 'LicGetUsageDetails',  '00010021008600160000', 'LicGetUsageDetails', '00010021008600160000')
GO

