

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/LicGetUsageBasedCategory.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/LicGetUsageBasedCategory.sp,v $ $Id: LicGetUsageBasedCategory.sp,v 1.12.2.3 2018/03/27 09:08:51 jiechen Exp $";
--
--  +========================================================================+
--  |      Cursor:  LicGetUsageBasedCategory()
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: LicGetUsageBasedCategory <<<'

IF EXISTS (select * from sysobjects where name='LicGetUsageBasedCategory')
	drop procedure LicGetUsageBasedCategory
IF EXISTS (select * from GxQscripts where name='LicGetUsageBasedCategory')
	delete from GxQscripts where name = 'LicGetUsageBasedCategory'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LicGetUsageBasedCategory')
	delete from GXDBVersions where aliasname = 'LicGetUsageBasedCategory'
GO
print '... Creating Procedure: LicGetUsageBasedCategory'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure LicGetUsageBasedCategory
  @in_appType INTEGER,
  @in_storagePolicyId INTEGER,
  @in_appId INTEGER,
  @in_jobId INTEGER=0
AS
  DECLARE @outLicType INTEGER;
SET NOCOUNT ON
DECLARE @isArchiverAppType INT
DECLARE @xmlJobInfo XML
DECLARE @phaseDetails INT
SET @isArchiverAppType = 0
SET @outLicType = 0
SET @phaseDetails = 0
SET @isArchiverAppType = ISNULL((SELECT isDMAppType from APP_IDATypeHandlingInfo with (readuncommitted) where appTypeId = @in_appType), 0)
SELECT @xmlJobInfo = SUBSTRING(xmlJobInfo, CHARINDEX('>', xmlJobInfo)+1, LEN(xmlJobInfo))
FROM JMJobInfo WITH(NOLOCK) WHERE opType = 64 and jobId = @in_jobId
and commCellId = 2
IF @xmlJobInfo IS NOT NULL
	SELECT  @phaseDetails = R.ref.value('@phaseDetails', 'int')
	FROM @xmlJobInfo.nodes('JobManager_AdminJobDetailsXml/compPolicyJobInfo/compliancePolicyInfo') R ( ref )
IF (@phaseDetails & 0x10) > 0
	SET @isArchiverAppType = 1
IF EXISTS (SELECT * FROM APP_APPLICATION APP WITH (NOLOCK) WHERE ID=@in_appId AND (subclientStatus&0x10000) > 0)
	SET @isArchiverAppType = 1
--- Turbo check added at Subclients and removed from Agent Level.
--- File system with Turbo Subclients should count agains Archive bucket.
IF @isArchiverAppType = 0
BEGIN
	;WITH temp_CTE (attrName,attrval)
	AS
	(
		SELECT attrName,1 FROM APP_subclientProp PROP WITH(NOLOCK) WHERE prop.componentNameId = @in_appId
		AND  attrName IN ('Is Turbo Subclient','Is Archive Retention Mode Enabled','Is Backup Retention Mode Enabled') and prop.attrval='1' and prop.modified = 0
		AND @in_appType IN
		(
			SELECT type from APP_iDAType WHERE
			type < 600 and type not in (28,86)
			and (name like '%file%system%' or type in (select appTypeId from simAppTypeLicTypeMap where display_name = 'File System')
			OR type in (13,54))
		)
	)
	SELECT @isArchiverAppType = 1 FROM(
	SELECT  ISNULL([Is Turbo Subclient],0) as IsTurbo, ISNULL([Is Archive Retention Mode Enabled],0) as IsArchive, ISNULL([Is Backup Retention Mode Enabled],0) AS IsBackup from temp_CTE
	pivot ( MAX(attrval) FOR attrName IN ([Is Turbo Subclient],[Is Archive Retention Mode Enabled],[Is Backup Retention Mode Enabled])) AS P
	) T
	where  IsTurbo = 1 AND (IsArchive = 1 OR IsBackup = 0)
END
IF (@isArchiverAppType > 0)
	SET @outLicType = 100004
ELSE
	SET @outLicType = 100002
SP_EXIT:
	SELECT @outLicType
SET NOCOUNT OFF
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'LicGetUsageBasedCategory')
	delete from GxQscripts where name = 'LicGetUsageBasedCategory'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LicGetUsageBasedCategory')
	delete from GXDBVersions where aliasname = 'LicGetUsageBasedCategory'
GO

insert into GXDBVersions values(2, 'LicGetUsageBasedCategory',  '00010012000200030000', 'LicGetUsageBasedCategory', '00010012000200030000')
GO

