

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/LicGetSharedLicenseToUpdate.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/LicGetSharedLicenseToUpdate.sp,v $ $Id: LicGetSharedLicenseToUpdate.sp,v 1.7.210.2 2018/03/27 09:01:05 jiechen Exp $";
--
--  +========================================================================+
--  |   Procedure:  LicGetSharedLicenseToUpdate
--  |
--  | Description:  For licenses shared by packages & GUI options, it returns
--  |		    licUsage rows to update
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  |   1.1        xsui     Initial Edit
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: LicGetSharedLicenseToUpdate <<<'

IF EXISTS (select * from sysobjects where name='LicGetSharedLicenseToUpdate')
	drop procedure LicGetSharedLicenseToUpdate
IF EXISTS (select * from GxQscripts where name='LicGetSharedLicenseToUpdate')
	delete from GxQscripts where name = 'LicGetSharedLicenseToUpdate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LicGetSharedLicenseToUpdate')
	delete from GXDBVersions where aliasname = 'LicGetSharedLicenseToUpdate'
GO
print '... Creating Procedure: LicGetSharedLicenseToUpdate'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure LicGetSharedLicenseToUpdate
  @i_type integer,
  @i_ClientId integer,
  @i_appTypeId integer,
  @i_bConsume integer
AS
  DECLARE @o_clientId integer
  DECLARE @o_bIsPackage integer
  DECLARE @o_appTypeId integer
  DECLARE @o_licTypeId integer
SET NOCOUNT ON
SET transaction isolation level read uncommitted
DECLARE @appMapTbl	 	TABLE (t_type INT, t_pkgAppType INT, t_licAppType INT)
DECLARE @resultTbl	 	TABLE (t_appType INT, t_lictype INT)
DECLARE @licUsageAppTypeId 	INTEGER
DECLARE @licTypeId 		INTEGER
DECLARE @bIsPackage 		INTEGER
DECLARE @bNeedToUpdateLic	INTEGER
SET	@bIsPackage 		= 0
SET	@bNeedToUpdateLic	= 1
INSERT @appMapTbl VALUES (1, 17, 66)
INSERT @appMapTbl VALUES (1, 18, 66)
INSERT @appMapTbl VALUES (1, 19, 66)
INSERT @appMapTbl VALUES (1, 20, 66)
INSERT @appMapTbl VALUES (1, 21, 66)
INSERT @appMapTbl VALUES (1, 29, 66)
INSERT @appMapTbl VALUES (1, 38, 66)
INSERT @appMapTbl VALUES (1, 36, 66)
INSERT @appMapTbl VALUES (1, 63, 66)
INSERT @appMapTbl VALUES (1, 64, 66)
INSERT @appMapTbl VALUES (1, 74, 66)
-- Get dummy appTypeID which is used to consume SRM license
IF @i_appTypeId = 66
BEGIN
	SET @licUsageAppTypeId	= @i_appTypeId
	SET @bIsPackage		= 1
END
ELSE
	SET @licUsageAppTypeId = ISNULL((select t_licAppType from @appMapTbl where t_type = @i_type AND t_pkgAppType = @i_appTypeId), 0)
IF @licUsageAppTypeId > 0
BEGIN
	-- get license type
	SET @licTypeId	= ISNULL((	SELECT	simLicAppType
					FROM	simAppTypeLicTypeMap
					WHERE	appTypeId = @licUsageAppTypeId), 0)
	IF @i_bConsume > 0
	BEGIN
		IF NOT EXISTS (	SELECT	*
				FROM	licUsage
				WHERE	cid = @i_ClientId AND licType = @licTypeId AND optype = 'Install' AND
					(eval = 0 OR ExpiryDateUTC > GetUTCDate()))
			INSERT INTO @resultTbl
			SELECT	@licUsageAppTypeId, @licTypeId
	END
	ELSE IF EXISTS (SELECT	*
			FROM	licUsage
			WHERE	cid = @i_ClientId AND licType = @licTypeId AND optype = 'Install' AND
				(eval = 0 OR ExpiryDateUTC > GetUTCDate()))
	BEGIN
		DECLARE	@isGUIOptionEnabled	INT
		DECLARE	@isPackageInstalled	INT
		SET @isGUIOptionEnabled	= 0
		SET @isPackageInstalled	= 0
		IF EXISTS (	SELECT	*
				FROM	APP_iDAName N JOIN APP_iDAProp P ON N.id = P.componentNameId
				WHERE	N.clientId = @i_ClientId AND
					N.apptypeId in (SELECT t_pkgAppType from @appMapTbl where t_licAppType = @licUsageAppTypeId) aND
					(@i_type = 1 AND P.attrName = 'Enable Archive') AND P.attrVal ='1' AND P.modified = 0)
			SET @isGUIOptionEnabled	= 1
		IF EXISTS (	SELECT	*
				FROM	APP_iDAName
				WHERE	clientId = @i_ClientId AND (status & 6) = 0 AND appTypeId = @licUsageAppTypeId)
			SET @isPackageInstalled	= 1
		IF @isGUIOptionEnabled = 0 OR @isPackageInstalled = 0
			INSERT INTO @resultTbl
			SELECT	@licUsageAppTypeId, @licTypeId
	END
	ELSE
		SET @bNeedToUpdateLic = 0
	IF @bIsPackage = 0 AND @bNeedToUpdateLic > 0 AND NOT EXISTS (SELECT * FROM @resultTbl)
	BEGIN
		IF NOT EXISTS (	SELECT *
				FROM	APP_ClientProp JOIN APP_iDAType ON attrName = name and type = @licUsageAppTypeId
				WHERE	componentNameId = @i_ClientId AND
					attrVal = CAST(@i_bConsume AS VARCHAR(56)) AND modified = 0)
			INSERT INTO @resultTbl
			SELECT	@licUsageAppTypeId, 0
	END
	-- incase FS is uninstalled before FSDM, we shouldn't return FSDM package
	IF @bIsPackage = 0 AND @isGUIOptionEnabled = 0
		delete @resultTbl
END
SELECT @i_ClientId, @bIsPackage, *
FROM @resultTbl
SET NOCOUNT OFF
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'LicGetSharedLicenseToUpdate')
	delete from GxQscripts where name = 'LicGetSharedLicenseToUpdate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LicGetSharedLicenseToUpdate')
	delete from GXDBVersions where aliasname = 'LicGetSharedLicenseToUpdate'
GO

insert into GXDBVersions values(2, 'LicGetSharedLicenseToUpdate',  '00010007021000020000', 'LicGetSharedLicenseToUpdate', '00010007021000020000')
GO

