

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/LicGetSRMDCLicenseToUpdate.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/LicGetSRMDCLicenseToUpdate.sp,v $ $Id: LicGetSRMDCLicenseToUpdate.sp,v 1.14.208.2 2018/03/27 09:05:03 jiechen Exp $";
--
--  +========================================================================+
--  |   Procedure:  LicGetSRMDCLicenseToUpdate
--  |
--  | Description:  xx
--  |
--  |       Input:  xx
--	|
--  |      Output:  Returns licUsage rows to update
--  |      Return:  xxx
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  |   1.1        xsui     Initial Edit
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: LicGetSRMDCLicenseToUpdate <<<'

IF EXISTS (select * from sysobjects where name='LicGetSRMDCLicenseToUpdate')
	drop procedure LicGetSRMDCLicenseToUpdate
IF EXISTS (select * from GxQscripts where name='LicGetSRMDCLicenseToUpdate')
	delete from GxQscripts where name = 'LicGetSRMDCLicenseToUpdate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LicGetSRMDCLicenseToUpdate')
	delete from GXDBVersions where aliasname = 'LicGetSRMDCLicenseToUpdate'
GO
print '... Creating Procedure: LicGetSRMDCLicenseToUpdate'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure LicGetSRMDCLicenseToUpdate
  @i_ClientId integer,
  @i_appTypeId integer,
  @i_bConsume integer
AS
  DECLARE @o_clientId integer
  DECLARE @o_bIsPackage integer
  DECLARE @o_appTypeId integer
  DECLARE @o_licTypeId integer
  DECLARE @o_GUIAppTypeId integer
SET NOCOUNT ON
SET transaction isolation level read uncommitted
DECLARE @SRMMapTbl	 	TABLE (t_pkgAppType INT, t_licAppType INT)
DECLARE @resultTbl	 	TABLE (t_appType INT, t_lictype INT)
DECLARE @licUsageAppTypeId 	INTEGER
DECLARE @licTypeId 		INTEGER
DECLARE @bIsPackage 		INTEGER
DECLARE @bNeedToUpdateLic	INTEGER
DECLARE @GUIAppTypeId		INTEGER = 0
SET	@bIsPackage 		= 0
SET	@bNeedToUpdateLic	= 1
INSERT @SRMMapTbl VALUES (17, 605)
INSERT @SRMMapTbl VALUES (18, 605)
INSERT @SRMMapTbl VALUES (19, 605)
INSERT @SRMMapTbl VALUES (20, 605)
INSERT @SRMMapTbl VALUES (21, 605)
INSERT @SRMMapTbl VALUES (29, 605)
INSERT @SRMMapTbl VALUES (11, 600)
INSERT @SRMMapTbl VALUES (33, 600)
INSERT @SRMMapTbl VALUES (34, 600)
INSERT @SRMMapTbl VALUES (42, 600)
INSERT @SRMMapTbl VALUES (43, 600)
INSERT @SRMMapTbl VALUES (58, 1115)
INSERT @SRMMapTbl VALUES (106, 1117)
INSERT @SRMMapTbl VALUES (54, 606)
INSERT @SRMMapTbl VALUES (53, 606)
INSERT @SRMMapTbl VALUES (13, 603)
-- Get dummy appTypeID which is used to consume SRM license
IF @i_appTypeId >= 600 AND @i_appTypeId <= 654
BEGIN
	SET @licUsageAppTypeId	= @i_appTypeId
	SET @bIsPackage		= 1
END
ELSE
	SET @licUsageAppTypeId = ISNULL((select t_licAppType from @SRMMapTbl where t_pkgAppType = @i_appTypeId), 0)
IF @licUsageAppTypeId > 0
BEGIN
	-- get license type
	SET @licTypeId	= ISNULL((	SELECT	simLicAppType
					FROM	simAppTypeLicTypeMap
					WHERE	appTypeId = @licUsageAppTypeId), 0)
	IF @i_bConsume > 0
	BEGIN
		IF NOT EXISTS (	SELECT	*
				FROM	licUsage
				WHERE	cid = @i_ClientId AND licType = @licTypeId AND optype = 'Install' AND
					(eval = 0 OR ExpiryDateUTC > GetUTCDate()))
			INSERT INTO @resultTbl
			SELECT	@licUsageAppTypeId, @licTypeId
	END
	ELSE IF EXISTS (SELECT	*
			FROM	licUsage
			WHERE	cid = @i_ClientId AND licType = @licTypeId AND optype = 'Install' AND
				(eval = 0 OR ExpiryDateUTC > GetUTCDate()))
	BEGIN
		DECLARE	@isGUIOptionEnabled	INT
		DECLARE	@isPackageInstalled	INT
		SET @isGUIOptionEnabled	= 0
		SET @isPackageInstalled	= 0
		SET @GUIAppTypeId = ISNULL((	SELECT	N.appTypeId FROM APP_iDAName N JOIN APP_iDAProp P ON N.id = P.componentNameId
						WHERE	N.clientId = @i_ClientId AND
							N.apptypeId in (SELECT t_pkgAppType from @SRMMapTbl where t_licAppType = @licUsageAppTypeId) aND
							P.attrName = 'SRM Data Collection Enabled' AND P.attrVal ='1' AND P.modified = 0), 0)
		IF @GUIAppTypeId > 0
			SET @isGUIOptionEnabled	= 1
		IF EXISTS (	SELECT	*
				FROM	APP_iDAName
				WHERE	clientId = @i_ClientId AND (status & 6) = 0 AND appTypeId = @licUsageAppTypeId)
			SET @isPackageInstalled	= 1
IF @isPackageInstalled = 0 AND @licUsageAppTypeId = 606
		BEGIN
			IF EXISTS (	SELECT	*
					FROM	APP_iDAName
					WHERE	clientId = @i_ClientId AND (status & 6) = 0 AND appTypeId <> @i_appTypeId AND
						appTypeId in (SELECT t_pkgAppType from @SRMMapTbl where t_licAppType = @licUsageAppTypeId))
				SET @isPackageInstalled	= 1
		END
		IF @isGUIOptionEnabled = 0 OR @isPackageInstalled = 0
			INSERT INTO @resultTbl
			SELECT	@licUsageAppTypeId, @licTypeId
	END
	ELSE
		SET @bNeedToUpdateLic = 0
	IF @bIsPackage = 0 AND @bNeedToUpdateLic > 0 AND NOT EXISTS (SELECT * FROM @resultTbl)
	BEGIN
		IF NOT EXISTS (	SELECT *
				FROM	APP_ClientProp JOIN APP_iDAType ON attrName = name and type = @licUsageAppTypeId
				WHERE	componentNameId = @i_ClientId AND
					attrVal = CAST(@i_bConsume AS VARCHAR(56)) AND modified = 0)
			INSERT INTO @resultTbl
			SELECT	@licUsageAppTypeId, 0
	END
	-- incase FS is uninstalled before SRM FS, we shouldn't return SRM FS package
	IF @bIsPackage = 0 AND @isGUIOptionEnabled = 0
		delete @resultTbl
END
SELECT @i_ClientId, @bIsPackage, *, @GUIAppTypeId
FROM @resultTbl
SET NOCOUNT OFF
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'LicGetSRMDCLicenseToUpdate')
	delete from GxQscripts where name = 'LicGetSRMDCLicenseToUpdate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LicGetSRMDCLicenseToUpdate')
	delete from GXDBVersions where aliasname = 'LicGetSRMDCLicenseToUpdate'
GO

insert into GXDBVersions values(2, 'LicGetSRMDCLicenseToUpdate',  '00010014020800020000', 'LicGetSRMDCLicenseToUpdate', '00010014020800020000')
GO

