

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/LicGetQuotaUsage.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Satya Bhukar
--	Date:   05/2/2016
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/LicGetQuotaUsage.sp,v $ $Id: LicGetQuotaUsage.sp,v 1.1.2.11 2018/03/20 00:06:15 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: LicGetQuotaUsage <<<'

IF EXISTS (select * from sysobjects where name='LicGetQuotaUsage')
	drop procedure LicGetQuotaUsage
IF EXISTS (select * from GxQscripts where name='LicGetQuotaUsage')
	delete from GxQscripts where name = 'LicGetQuotaUsage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LicGetQuotaUsage')
	delete from GXDBVersions where aliasname = 'LicGetQuotaUsage'
GO
print '... Creating Procedure: LicGetQuotaUsage'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure LicGetQuotaUsage
  @i_issuedQty INT=0,
  @i_licenseId INT=0,
  @i_alertFlag INT=0 
--i_alertFlag = 1 means checking connection and sending alert if connection is broken
AS
  DECLARE @errCode integer = 0
  DECLARE @issuedQty integer = 0
  DECLARE @usedQty integer = 0
  DECLARE @isLicInherited integer = 0
  DECLARE @isLicExpired integer = 0
  DECLARE @errString VARCHAR(2048) = ''
  DECLARE @lastUpdateTime integer = dbo.GetUNIXTime(GETUTCDATE())
  DECLARE @metricsURL VARCHAR(2048) = ''
DECLARE @commcellFlags	INT = -1
DECLARE @globalLimitGB	INT = 0
DECLARE @globalUsedGB	INT = 0
DECLARE @secInDay 		INT = 24 * 60 * 60
DECLARE	@currentTime	INT
DECLARE	@licExpTime	INT = 0
DECLARE	@nDays    INT = 0
SET @currentTime = dbo.GetUNIXTime(GETUTCDATE())
SET @issuedQty = @i_issuedQty
SELECT @commcellFlags = attrVal FROM LicUsageBasedConfig WITH (NOLOCK) WHERE attrName = 'InheritedLicType'--SZ_INHERITED_LI_TYPE
IF @commcellFlags = -1
BEGIN
SET @errCode = 1
	SET @errString = 'InheritedLicType Not set'
	GOTO EXIT_ERROR
END
SELECT @lastUpdateTime = CAST(value as INT) FROM GXGlobalParam WITH (NOLOCK) where name = 'Global Client Group Quota Update Time'
IF @commcellFlags = 1
	SELECT @metricsURL = value FROM GXGlobalParam WITH (NOLOCK) where name = 'CommservSurveyUploadsite'
ELSE IF @commcellFlags = (2|1) OR @commcellFlags = (4|2|1)
	SELECT @metricsURL = value FROM GXGlobalParam WITH (NOLOCK) where name = 'CommservSurveyPrivateUploadsite'
IF @i_alertFlag = 1 and @commcellFlags <> 0
BEGIN
	IF(@lastUpdateTime + @secInDay < @currentTime)
	BEGIN
SET @errCode = 3
		SET @nDays = (@currentTime-@lastUpdateTime)/@secInDay
		SET @errString = 'Latest Data Not available for ' +  cast(@nDays as varchar(4)) +' Day(s)'
		GOTO EXIT_ERROR
	END
END
IF ((@commcellFlags = 1 OR @commcellFlags = (2|1)) AND
@i_issuedQty = 0) OR (@commcellFlags = (4|2|1) AND @i_issuedQty <> 0)
BEGIN
	SET @isLicInherited = 1
	SELECT @globalLimitGB = ISNULL(globalLimitGB,0),@globalUsedGB = ISNULL(globalUsedGB,0) , @licExpTime = ISNULL(expiryTime,0)
	FROM RptClientGroupQuotaUsage WITH (NOLOCK) WHERE clientGroupId = 0 AND quotaType = @i_licenseId
IF @commcellFlags <> (4|2|1)
	BEGIN
		SET @issuedQty = @globalLimitGB
	END
	SET @usedQty = @globalUsedGB
	IF @licExpTime > 0 AND @licExpTime < @currentTime
		SET @isLicExpired = 1
	IF(@lastUpdateTime + 5 * @secInDay < @currentTime)
	BEGIN
SET @errCode = 2
		SET @errString = 'Latest Data Not available'
		GOTO EXIT_ERROR
	END
END
EXIT_ERROR:
SELECT @errCode,@issuedQty,@usedQty,@isLicInherited, @isLicExpired, @errString, @lastUpdateTime, @metricsURL
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'LicGetQuotaUsage')
	delete from GxQscripts where name = 'LicGetQuotaUsage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LicGetQuotaUsage')
	delete from GXDBVersions where aliasname = 'LicGetQuotaUsage'
GO

insert into GXDBVersions values(2, 'LicGetQuotaUsage',  '00010001000200110000', 'LicGetQuotaUsage', '00010001000200110000')
GO

