

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/LicGetPhysicalClientsWithLic.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--
--  +========================================================================+
--  |   Procedure:  LicGetPhysicalClientsWithLic
--  |
--  | Description:  xx
--  |
--  |       Input:  xx
--  |
--  |      Output: Return list of physical client where license needs to be released
--  |      Return:  xxx
--  |
--  |   Revisions  Author						Description
--  |   ---------  -------				--------------------------------
--  |   1.1        Satya Bhukar  Initial Edit
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: LicGetPhysicalClientsWithLic <<<'

IF EXISTS (select * from sysobjects where name='LicGetPhysicalClientsWithLic')
	drop procedure LicGetPhysicalClientsWithLic
IF EXISTS (select * from GxQscripts where name='LicGetPhysicalClientsWithLic')
	delete from GxQscripts where name = 'LicGetPhysicalClientsWithLic'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LicGetPhysicalClientsWithLic')
	delete from GXDBVersions where aliasname = 'LicGetPhysicalClientsWithLic'
GO
print '... Creating Procedure: LicGetPhysicalClientsWithLic'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure LicGetPhysicalClientsWithLic
AS
  DECLARE @outputList xml = ''
SET NOCOUNT ON
DECLARE @prevReleaseID INT = 0
select @prevReleaseID = CAST(attrVal as INT) from APP_ClientProp WITH (NOLOCK) where componentNameID = 2 AND attrName = 'Previous Release'
IF @prevReleaseID = 0
	select top 1 @prevReleaseID = id from simAllGalaxyRel WITH (NOLOCK) order by id desc
IF @prevReleaseID < 16 OR (@prevReleaseID = 16 AND (select TOP 1 HighestSP from PatchInstallHistory WITH (NOLOCK) where ClientId = 2 order by id desc) < 7)
BEGIN
	DECLARE @apptypeTable TABLE (t_apptype INT, t_AgentName VARCHAR(256))
	INSERT INTO @apptypeTable
	VALUES(22, 'Oracle Database'),
	(53,'Exchange Database'),
	(62,'DB2 on Unix'),
	(78,'SharePoint Server'),
	(81,'SQL Server'),
	(106,'Virtual Server'),
	(136, 'SAP HANA')
	IF object_id('tempdb.dbo.#PhysicalClientsList') IS NOT null DROP TABLE #PhysicalClientsList
	CREATE TABLE #PhysicalClientsList (t_cid INT, t_apptype INT, t_packageID INT, t_clientName VARCHAR(MAX), t_packageName VARCHAR(MAX))
	INSERT INTO #PhysicalClientsList
	--RAC
	SELECT distinct I.clientId, t_apptype, 0,'',''
	FROM @apptypeTable tmp,APP_OracleRacInstance I WITH (NOLOCK)
	WHERE t_AgentName = 'Oracle Database'
	UNION ALL
	--Exchange DAG
	SELECT distinct AC.id, t_apptype, 0,'',''
	FROM @apptypeTable tmp,APP_ClientProp AP WITH (NOLOCK)
	JOIN APP_Client AC WITH (NOLOCK)  ON AP.attrName = AC.net_hostname
	WHERE AP.attrType = 125 AND AP.modified = 0 AND t_AgentName = 'Exchange Database'
	UNION ALL
	-- DB2_DPF
	SELECT distinct t_pClientId, t_apptype, 0,'',''
	FROM @apptypeTable tmp,
	(SELECT t_pClientId = substring(T1.Data, CHARINDEX(',', T1.Data)+1, LEN(T1.Data))
		FROM    APP_InstanceProp IP WITH (NOLOCK) CROSS APPLY dbo.SplitString(IP.attrVal, ' ') T1
		WHERE   IP.attrName = 'DB2 Partition Clients' and IP.modified = 0 AND LEN(IP.attrVal) > 0 ) T2
	WHERE t_AgentName = 'DB2 on Unix'
	UNION ALL
	--SharePoint
	SELECT distinct Cid, t_apptype, 0,'',''
	FROM @apptypeTable tmp,
	(SELECT CAST(AP.attrVal AS INT) AS cid FROM APP_ClientProp AP WITH (NOLOCK) WHERE AP.attrName = 'SharePoint Primary Member Server' AND LEN(AP.attrVal) > 0 AND AP.modified = 0) T
	WHERE t_AgentName = 'SharePoint Server'
	UNION
	SELECT distinct
		Cid,
		t_apptype,
		0,
		'',''
	FROM @apptypeTable tmp,
		(
			-- Relocated 'SharePoint Member Servers' XML Document from APP_ClientProp to APP_ComponentProp Table since attrVal limited to max data size of NVARCHAR(1024)
			SELECT DISTINCT
				P.value('@clientId', 'int') AS cid
			FROM APP_ComponentProp CP WITH (NOLOCK)
				CROSS APPLY (SELECT CAST(CP.stringVal as xml)) AS X(X)
				CROSS APPLY X.nodes('App_MemberServers/memberServers/client') AS P(P)
			WHERE
				CP.componentType = 3			-- CV_COMPONENT_TYPE_CLIENT
				AND CP.propertyTypeId = 1046	-- CV_COMPONENT_SHAREPOINT_SECONDARY_MEMBER_SERVERS		-- Old APP_ClientProp 'SharePoint Member Servers'
				AND LEN(CP.stringVal) > 0
				AND CP.modified = 0
			) T
	WHERE t_AgentName = 'SharePoint Server'
	UNION ALL
	--MSSqlAG
	SELECT distinct Cid, t_apptype, 0,'',''
	FROM @apptypeTable tmp,
	(SELECT p.value('@clientId', 'int') AS cid FROM APP_InstanceProp AP WITH (NOLOCK) CROSS APPLY (select cast(attrVal as xml))
	as X(X) CROSS APPLY X.nodes('App_SQLAvailabilityReplicas/SQLAvailabilityReplicasList/replicaClient') as P(P)
	WHERE AP.attrName = 'Availability Replicas' AND LEN(AP.attrVal) > 0 AND AP.modified = 0) T
	WHERE t_AgentName = 'SQL Server'
	UNION ALL
	--VSA
	SELECT distinct Cid, t_apptype, 0,'',''
	FROM @apptypeTable tmp,LicUsage WITH (NOLOCK) WHERE AppType = t_apptype AND t_AgentName = 'Virtual Server'
	UNION ALL
	-- SAP_HANA
	SELECT distinct t_pClientId, t_apptype, 0,'',''
	FROM @apptypeTable tmp,(SELECT t_pClientId = T1.Data
			FROM    APP_InstanceProp IP WITH (NOLOCK) CROSS APPLY dbo.SplitString(IP.attrVal, '+') T1
			WHERE   IP.attrName = 'Database Clients' and IP.modified = 0 AND LEN(IP.attrVal) > 0 ) T2
	WHERE t_AgentName = 'SAP HANA'
	--Remove pseudo clients from the list fetched which leave us with only proxy clients.
	DELETE #PhysicalClientsList FROM
	APP_Application app WITH (NOLOCK)
	JOIN app_instanceprop Iprop WITH (NOLOCK) ON app.instance = Iprop.componentNameId AND Iprop.attrName = 'Virtual Server Instance Type' AND LEN(Iprop.attrVal) > 0 AND Iprop.modified = 0
	WHERE t_cid = clientId AND app.appTypeId = t_apptype AND t_apptype = 106
	--Remove clients where backup jobs are present in DB
	DELETE #PhysicalClientsList FROM
	APP_Application app WITH (NOLOCK)
	JOIN archFile afile WITH (NOLOCK) ON app.id = afile.appId
	WHERE t_cid = app.clientId AND app.appTypeId = t_apptype
	--Delete the client where license is not consumed
	DELETE tmp
	FROM #PhysicalClientsList tmp LEFT JOIN LIcUsage LU ON LU.cid = tmp.t_cid AND LU.appType = tmp.t_apptype AND opType = 'install'
	WHERE  LU.cid IS NULL
	UPDATE #PhysicalClientsList SET t_clientName = name , t_packageID = (SELECT dbo.GetPackageID(t_apptype,simOperatingSystemId)) FROM APP_Client WHERE id = t_cid
	UPDATE #PhysicalClientsList SET t_packageName = Name FROM simPackage WHERE t_packageID = id
	SELECT @outputList = (
	select
	(select
		(select
			( SELECT t_clientName as  '@clientName'
			FOR XML PATH('clientEntity'),TYPE)
		FOR XML PATH('client'),TYPE)
	FOR XML PATH('clientInfo'),TYPE),
	(SELECT
		(SELECT T2.t_packageID AS '@ComponentId', T2.t_packageName AS '@ComponentName', 0 as '@consumeLicense'
		FROM #PhysicalClientsList T2 WHERE T1.t_cid = T2.t_cid FOR XML PATH('componentInfo'),TYPE)
	FOR XML PATH('components'),TYPE)
	FROM #PhysicalClientsList T1 group by T1.t_cid,T1.t_clientName
	FOR XML PATH('clientComposition'),TYPE, Root ('CVInstallManager_ClientSetup'))
	IF object_id('tempdb.dbo.#PhysicalClientsList') IS NOT null DROP TABLE #PhysicalClientsList
END
SELECT @outputList
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'LicGetPhysicalClientsWithLic')
	delete from GxQscripts where name = 'LicGetPhysicalClientsWithLic'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LicGetPhysicalClientsWithLic')
	delete from GXDBVersions where aliasname = 'LicGetPhysicalClientsWithLic'
GO

insert into GXDBVersions values(2, 'LicGetPhysicalClientsWithLic',  '00000000000000000000', 'LicGetPhysicalClientsWithLic', '00000000000000000000')
GO

