

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/LicGetO365SharepointDetailsV3.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/LicGetO365SharepointDetailsV3.sp,v $ $Id: LicGetO365SharepointDetailsV3.sp,v 1.1.2.1 2018/09/29 17:34:02 leiwang Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: LicGetO365SharepointDetailsV3 <<<'

IF EXISTS (select * from sysobjects where name='LicGetO365SharepointDetailsV3')
	drop procedure LicGetO365SharepointDetailsV3
IF EXISTS (select * from GxQscripts where name='LicGetO365SharepointDetailsV3')
	delete from GxQscripts where name = 'LicGetO365SharepointDetailsV3'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LicGetO365SharepointDetailsV3')
	delete from GXDBVersions where aliasname = 'LicGetO365SharepointDetailsV3'
GO
print '... Creating Procedure: LicGetO365SharepointDetailsV3'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure LicGetO365SharepointDetailsV3
AS
--Calculate O365 Sharepoint license
SET ANSI_PADDING ON
SET NOCOUNT ON
DECLARE @currentTime_Unix  INT = dbo.GetUnixTime(GETUTCDATE())
DECLARE @currentTime DATETIME = dbo.getdatetime(@currentTime_Unix)
DECLARE @monthStart DATETIME = DATEADD(MM, DATEDIFF(MM, 0, GETUTCDATE()), 0)
DECLARE @monthStart_Uix int  = dbo.GetUnixTime(@monthStart)
DECLARE @CCLPeakType INT = 0
DECLARE @SCLPeakType INT = 1
DECLARE @attrName varchar (256) ='LicGetO365SharepointDetailsV3Status'
DECLARE @attrType int = 1
DECLARE @attrVal varchar(1) = '0'  --0 successful  --1 failed
DECLARE @O365SharepointType int = 26
DECLARE @O365SharepointLicType int = 100032
DECLARE @current_O365Sharepoint int = 0
DECLARE @last_O365Sharepoint    int = 0
IF object_id('tempdb.dbo.#O365UserAccount') IS NOT null DROP TABLE #O365UserAccount
CREATE TABLE #O365UserAccount (t_Clientid INT, t_backupsetName NVARCHAR(256), t_UserAccount NVARCHAR(1024),t_UserName NVARCHAR(1024))
INSERT INTO #O365UserAccount
SELECT DISTINCT SC.clientId, N.name, P.attrName, P.attrVal
FROM APP_BackupSetProp P WITH (NOLOCK)
INNER JOIN APP_Application SC WITH (NOLOCK) ON SC.backupSet = P.componentNameId
INNER JOIN APP_BackupSetName N WITH (NOLOCK) ON N.id = P.componentNameId
WHERE P.attrType = 137
BEGIN TRY
BEGIN TRAN
IF EXISTS (SELECT 1 FROM historyDB.dbo.Lic_CurrentUsage WITH (NOLOCK) WHERE UsageType = @O365SharepointType)
DELETE FROM historyDB.dbo.Lic_CurrentUsage WHERE UsageType = @O365SharepointType
INSERT INTO historyDB.dbo.Lic_CurrentUsage (UsageType,ClientId,LicType,BackupSetName,InstanceName,CapacityFlag, VMFlag, ObjectName)
SELECT DISTINCT @O365SharepointType,t_Clientid,@O365SharepointLicType,t_backupsetName,t_UserName,-1,0,t_UserAccount
FROM  #O365UserAccount
SELECT @current_O365Sharepoint = COUNT(DISTINCT ObjectName) FROM historyDB.dbo.Lic_CurrentUsage WITH (NOLOCK) WHERE UsageType = @O365SharepointType
SELECT @last_O365Sharepoint  = COUNT(DISTINCT ObjectName) FROM historyDB.dbo.Lic_PeakUsage WITH (NOLOCK) WHERE MonthStart = @monthStart AND UsageType = @O365SharepointType AND PeakType = @CCLPeakType
IF @current_O365Sharepoint >= @last_O365Sharepoint AND @current_O365Sharepoint > 0
BEGIN
DELETE historyDB.dbo.Lic_PeakUsage WHERE MonthStart = @monthStart AND UsageType = @O365SharepointType AND PeakType = @CCLPeakType
INSERT INTO historyDB.dbo.Lic_PeakUsage (MonthStart,CreationDate,UsageType,PeakType,ClientId,LicType,BackupSetName,InstanceName,CapacityFlag,VMFlag, ObjectName)
SELECT @monthStart,@currentTime,UsageType,@CCLPeakType,ClientId,LicType,BackupSetName,InstanceName,CapacityFlag,VMFlag, ObjectName
FROM historyDB.dbo.Lic_CurrentUsage WITH (NOLOCK)
WHERE UsageType = @O365SharepointType
END
MERGE historyDB.dbo.Lic_PeakUsage AS T
USING  (SELECT UsageType,ClientId,LicType,BackupSetName,InstanceName,CapacityFlag, VMFlag, ObjectName FROM historyDB.dbo.Lic_CurrentUsage WITH (NOLOCK) WHERE UsageType  = @O365SharepointType) AS S
ON  T.MonthStart = @monthStart AND T.UsageType = S.UsageType AND T.PeakType = @SCLPeakType AND T.ObjectName = S.ObjectName
WHEN NOT MATCHED BY TARGET
	THEN INSERT (MonthStart, CreationDate,UsageType,PeakType,ClientId,LicType,BackupSetName,InstanceName,CapacityFlag, VMFlag, ObjectName)
	VALUES(@monthStart,@currentTime,S.UsageType,@SCLPeakType,S.ClientId,S.LicType,S.BackupSetName,S.InstanceName,S.CapacityFlag,S.VMFlag,S.ObjectName)
;
COMMIT TRAN
END TRY
BEGIN CATCH
ROLLBACK TRAN
SET @attrVal = '1'
GOTO  CAL_ERROR
END CATCH
CAL_ERROR:
IF EXISTS(select 1 from LicUsageBasedConfig WITH (nolock) where attrname = @attrname)
	Update LicUsageBasedConfig
	SET attrVal = @attrVal
	WHERE attrname = @attrname AND attrVal <> @attrVal
ELSE
	INSERT INTO LicUsageBasedConfig (attrname,attrType,attrVal)
	VALUES (@attrname, @attrType, @attrVal)
DROP TABLE #O365UserAccount
SET NOCOUNT OFF
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'LicGetO365SharepointDetailsV3')
	delete from GxQscripts where name = 'LicGetO365SharepointDetailsV3'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LicGetO365SharepointDetailsV3')
	delete from GXDBVersions where aliasname = 'LicGetO365SharepointDetailsV3'
GO

insert into GXDBVersions values(2, 'LicGetO365SharepointDetailsV3',  '00010001000200010000', 'LicGetO365SharepointDetailsV3', '00010001000200010000')
GO

