

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/LicGetO365Sharepoint.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/LicGetO365Sharepoint.sp,v $ $Id: LicGetO365Sharepoint.sp,v 1.1.4.7 2020/09/02 22:27:17 leiwang Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='LicGetO365Sharepoint')
BEGIN
	print '>>> Drop Stored Procedure: LicGetO365Sharepoint <<<'
	drop procedure LicGetO365Sharepoint
END
IF EXISTS (select * from GxQscripts where name='LicGetO365Sharepoint')
	delete from GxQscripts where name = 'LicGetO365Sharepoint'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LicGetO365Sharepoint')
	delete from GXDBVersions where aliasname = 'LicGetO365Sharepoint'
GO
print '... Creating Procedure: LicGetO365Sharepoint'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure LicGetO365Sharepoint
  @in_tmpTbl VARCHAR(MAX)=NULL,
  @in_jobId INTEGER = 0,
  @in_returnVal INTEGER = 0 OUTPUT
AS
SET @in_returnVal = 0
DECLARE @clientid INT = 0
DECLARE @bIsACVValid INT = 0
DECLARE @licAppliedStatus INT = 0
DECLARE @isLicInherited INT = 0
DECLARE @bIsOIValid INT = 0
DECLARE @bIsVOIValid INT = 0
EXEC LicAppliedStatus @licAppliedStatus OUTPUT, @isLicInherited OUTPUT
--check if ACV license present
IF @isLicInherited > 0
BEGIN
SELECT @bIsACVValid = @licAppliedStatus&0x40
SELECT @bIsOIValid = @licAppliedStatus&0x200
SELECT @bIsVOIValid = @licAppliedStatus&0x400
END
ELSE
BEGIN
	EXEC LicIsLicenseValid 100027, @bIsACVValid OUTPUT
	EXEC LicIsLicenseValid 100032, @bIsOIValid OUTPUT
	EXEC LicIsLicenseValid 100033, @bIsVOIValid OUTPUT
END
IF object_id('tempdb.dbo.#tempACVList') IS NOT NULL DROP TABLE #tempACVList
	CREATE TABLE #tempACVList (t_Id INT, t_appType INT)
IF @bIsACVValid > 0   -- IF ACV License is present
	EXEC LicGetVMAppcalss1 '#tempACVList'
IF @in_jobId > 0
BEGIN
	SELECT @clientid = APP.clientId	FROM JMBkpJobInfo JM WITH (NOLOCK)
	INNER JOIN APP_Application APP WITH (NOLOCK) ON APP.id = JM.applicationId
	INNER JOIN APP_BackupSetName B WITH (NOLOCK) ON APP.backupSet = B.id
WHERE jobId = @in_jobId AND appTypeId = 78 AND B.status & 0x80000 = 0x80000
	IF @clientid > 0 -- Office 365 SharePoint job
	BEGIN
IF @bIsACVValid > 0 AND EXISTS (SELECT 1 FROM #tempACVList WHERE t_Id = @clientid AND t_appType = 78) -- IF this client is in the ACV List and Only SharePoint package is installed on this client and Only Office 365 SharePoint backupset is present under this client
		BEGIN
IF NOT EXISTS (SELECT 1 FROM #tempACVList WHERE t_Id = @clientid AND t_appType <> 78)
AND NOT EXISTS (SELECT 1 FROM APP_Application APP WITH (NOLOCK) INNER JOIN APP_BackupSetName B WITH (NOLOCK) ON APP.backupSet = B.id WHERE APP.clientId = @clientid AND appTypeId = 78 AND B.status & 0x80000 <> 0x80000 AND B.name <> 'Indexing BackupSet')
			SET @in_returnVal = 1
		END
		ELSE   -- IF ACV License is not present or this client is not in the ACV list
			SET @in_returnVal = 1
	END
END
ELSE IF @in_jobId = 0
BEGIN
	IF object_id('tempdb.dbo.#O365SharePointClients') IS NOT NULL DROP TABLE #O365SharePointClients
	CREATE TABLE #O365SharePointClients (clientid INT)
	INSERT INTO #O365SharePointClients
	SELECT DISTINCT C.id
    FROM APP_BackupSetName B WITH (NOLOCK)
    INNER JOIN APP_Application APP WITH (NOLOCK) ON APP.backupSet = B.id
    INNER JOIN APP_Client C WITH (NOLOCK) ON C.id = APP.clientId
WHERE APP.appTypeId = 78 AND B.status & 0x80000 = 0x80000
	IF @bIsACVValid > 0
	BEGIN
		DELETE C   -- Delete clients that has ACV package other than SharePoint installed
		FROM #O365SharePointClients C
		INNER JOIN #tempACVList ACV ON C.clientid = ACV.t_Id
WHERE ACV.t_appType <> 78
		DELETE C  -- Delete clients that has SP backupset other than O365 SharePoint backupset
		FROM #O365SharePointClients C
		INNER JOIN #tempACVList ACV ON C.clientid = ACV.t_Id
		INNER JOIN APP_Application APP WITH (NOLOCK) ON C.clientid = APP.clientId
		INNER JOIN APP_BackupSetName B WITH (NOLOCK) ON APP.backupSet = B.id
WHERE APP.appTypeId = 78 AND B.status & 0x80000 <> 0x80000 AND B.name <> 'Indexing BackupSet'
	END
	ELSE IF @bIsOIValid > 0
	BEGIN
		DELETE C  -- Delete clients that has SP backupset other than O365 SharePoint backupset
		FROM #O365SharePointClients C
		INNER JOIN APP_Application APP WITH (NOLOCK) ON C.clientid = APP.clientId
		INNER JOIN APP_BackupSetName B WITH (NOLOCK) ON APP.backupSet = B.id
WHERE APP.appTypeId = 78 AND B.status & 0x80000 <> 0x80000 AND B.name <> 'Indexing BackupSet'
	END
	ELSE IF @bIsVOIValid > 0 AND @bIsOIValid = 0
		DELETE C  -- Delete clients that has SP backupset other than O365 SharePoint backupset
		FROM #O365SharePointClients C
		INNER JOIN APP_Application APP WITH (NOLOCK) ON C.clientid = APP.clientId
		INNER JOIN APP_BackupSetName B WITH (NOLOCK) ON APP.backupSet = B.id
		INNER JOIN APP_ClientProp CP WITH (NOLOCK) ON C.clientid = CP.componentNameId AND CP.attrName = 'Virtual Machine GUID' AND CP.modified = 0
WHERE APP.appTypeId = 78 AND B.status & 0x80000 <> 0x80000 AND B.name <> 'Indexing BackupSet'
	IF EXISTS (SELECT 1 FROM #O365SharePointClients)
	SET @in_returnVal = 1
	IF @in_tmpTbl = '#tmpO365SharePointClients'
	BEGIN
		INSERT INTO #tmpO365SharePointClients
		SELECT DISTINCT clientid FROM #O365SharePointClients
	END
	DROP TABLE #O365SharePointClients
END
DROP TABLE #tempACVList
SET NOCOUNT OFF
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'LicGetO365Sharepoint')
	delete from GxQscripts where name = 'LicGetO365Sharepoint'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LicGetO365Sharepoint')
	delete from GXDBVersions where aliasname = 'LicGetO365Sharepoint'
GO

insert into GXDBVersions values(2, 'LicGetO365Sharepoint',  '00010001000400070000', 'LicGetO365Sharepoint', '00010001000400070000')
GO

