

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/LicGetMetallicStorageDetailsV3.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='LicGetMetallicStorageDetailsV3')
BEGIN
	print '>>> Drop Stored Procedure: LicGetMetallicStorageDetailsV3 <<<'
	drop procedure LicGetMetallicStorageDetailsV3
END
IF EXISTS (select * from GxQscripts where name='LicGetMetallicStorageDetailsV3')
	delete from GxQscripts where name = 'LicGetMetallicStorageDetailsV3'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LicGetMetallicStorageDetailsV3')
	delete from GXDBVersions where aliasname = 'LicGetMetallicStorageDetailsV3'
GO
print '... Creating Procedure: LicGetMetallicStorageDetailsV3'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure LicGetMetallicStorageDetailsV3
AS
--Calculate 10 licenses for metallic
SET ANSI_PADDING ON
SET NOCOUNT ON
  DECLARE @o_storagePoolId INTEGER
  DECLARE @o_storagePoolName NVARCHAR(144)
  DECLARE @o_container VARCHAR(64)
  DECLARE @o_usedSpace BIGINT
  DECLARE @i_licType int = 0
  DECLARE @Metallic_1UsageType int = 41
  DECLARE @Metallic1_LicType  int = 100041
  DECLARE @Metallic10_LicType  int = 100050
  DECLARE @last_metallicUsed BIGINT = 0
  DECLARE @last_metallicUsed2 BIGINT = 0
  DECLARE @last_metallicUsed3 BIGINT = 0
  DECLARE @last_metallicUsed4 BIGINT = 0
  DECLARE @last_metallicUsed5 BIGINT = 0
  DECLARE @last_metallicUsed6 BIGINT = 0
  DECLARE @last_metallicUsed7 BIGINT = 0
  DECLARE @last_metallicUsed8 BIGINT = 0
  DECLARE @last_metallicUsed9 BIGINT = 0
  DECLARE @last_metallicUsed10 BIGINT = 0
  DECLARE @current_metallicUsed BIGINT = 0
  DECLARE @current_metallicUsed2 BIGINT = 0
  DECLARE @current_metallicUsed3 BIGINT = 0
  DECLARE @current_metallicUsed4 BIGINT = 0
  DECLARE @current_metallicUsed5 BIGINT = 0
  DECLARE @current_metallicUsed6 BIGINT = 0
  DECLARE @current_metallicUsed7 BIGINT = 0
  DECLARE @current_metallicUsed8 BIGINT = 0
  DECLARE @current_metallicUsed9 BIGINT = 0
  DECLARE @current_metallicUsed10 BIGINT = 0
  DECLARE @CCLPeakType INT = 0
  DECLARE @SCLPeakType INT = 1
  DECLARE @attrName varchar (256) ='LicGetMetallicStorageDetailsV3'
  DECLARE @attrType int = 1
  DECLARE @attrVal varchar(1) = '0' --0 successful  --1 failed
  DECLARE @currentTime_Unix  INT = dbo.GetUnixTime(GETUTCDATE())
  DECLARE @currentTime DATETIME = dbo.getdatetime(@currentTime_Unix)
  DECLARE @monthStart DATETIME = DATEADD(MM, DATEDIFF(MM, 0, GETUTCDATE()), 0)
  DECLARE @monthStart_Uix int  = dbo.GetUnixTime(@monthStart)
SET NOCOUNT ON
IF OBJECT_ID('tempdb.dbo.#tempMetallicStorageUsageByContainer') IS NOT NULL DROP TABLE #tempMetallicStorageUsageByContainer
CREATE TABLE #tempMetallicStorageUsageByContainer
(
   licenseType		  INT,
   usageType		  INT,
   deviceId           INT,
   storagepoolId      INT,
   storagePoolName    NVARCHAR(144),
   container	      VARCHAR(64),
   usedSpace	      BIGINT
 )
exec Lic_GetMetallicStorageUsageByContainer 0
UPDATE #tempMetallicStorageUsageByContainer
SET usageType =  @Metallic_1UsageType
BEGIN TRY
BEGIN TRAN
IF EXISTS (SELECT 1 FROM Lic_CurrentUsage WITH (NOLOCK) WHERE UsageType = @Metallic_1UsageType )
DELETE FROM Lic_CurrentUsage WHERE UsageType = @Metallic_1UsageType
INSERT INTO Lic_CurrentUsage (UsageType,LicType,AppSizeMB,SPId,SPName, ObjectName, ObjectId, CapacityFlag,VMFlag)
SELECT distinct usageType, licenseType, usedSpace, storagepoolId,storagePoolName, container, deviceId, 0, 0 FROM #tempMetallicStorageUsageByContainer
IF object_id('tempdb.dbo.#tempUsage') IS NOT null DROP TABLE #tempUsage
CREATE TABLE #tempUsage (t_licType INT,t_currentUsage BIGINT, t_lastUsage BIGINT, t_updateStatus INT DEFAULT 0)
SELECT @current_metallicUsed = ISNULL([100041],0),@current_metallicUsed2 = ISNULL([100042],0),@current_metallicUsed3 = ISNULL([100043],0), @current_metallicUsed4 = ISNULL([100044],0), @current_metallicUsed5 = ISNULL([100045],0),
@current_metallicUsed6 = ISNULL([100046],0), @current_metallicUsed7 = ISNULL([100047],0), @current_metallicUsed8 = ISNULL([100048],0), @current_metallicUsed9 = ISNULL([100049],0), @current_metallicUsed10 = ISNULL([100050],0)
FROM (select AppSizeMB, LicType from Lic_CurrentUsage WITH (NOLOCK) WHERE UsageType = 41) AS S
PIVOT
(sum(AppSizeMB) FOR LicType in ([100041], [100042], [100043], [100044],[100045],[100046],[100047],[100048],[100049],[100050])) AS P
SELECT @last_metallicUsed = ISNULL([100041],0), @last_metallicUsed2 = ISNULL([100042],0), @last_metallicUsed3 = ISNULL([100043],0), @last_metallicUsed4 = ISNULL([100044],0), @last_metallicUsed5 = ISNULL([100045],0),
@last_metallicUsed6 = ISNULL([100046],0), @last_metallicUsed7 = ISNULL([100047],0), @last_metallicUsed8 = ISNULL([100048],0), @last_metallicUsed9 = ISNULL([100049],0), @last_metallicUsed10 = ISNULL([100050],0)
FROM (select AppSizeMB, LicType from Lic_PeakUsage WITH (NOLOCK) WHERE MonthStart = @monthStart AND PeakType = @CCLPeakType AND UsageType = 41) AS S
PIVOT
(sum(AppSizeMB) FOR LicType in ([100041], [100042], [100043], [100044],[100045],[100046],[100047],[100048],[100049],[100050])) AS P
INSERT INTO #tempUsage (t_licType,t_currentUsage,t_lastUsage)
VALUES (100041,@current_metallicUsed,@last_metallicUsed),
(100042,@current_metallicUsed2,@last_metallicUsed2),
(100043,@current_metallicUsed3,@last_metallicUsed3),
(100044,@current_metallicUsed4,@last_metallicUsed4),
(100045,@current_metallicUsed5,@last_metallicUsed5),
(100046,@current_metallicUsed6,@last_metallicUsed6),
(100047,@current_metallicUsed7,@last_metallicUsed7),
(100048,@current_metallicUsed8,@last_metallicUsed8),
(100049,@current_metallicUsed9,@last_metallicUsed9),
(100050,@current_metallicUsed10,@last_metallicUsed10)
UPDATE #tempUsage SET t_updateStatus = 1 WHERE t_currentUsage >= t_lastUsage AND t_currentUsage > 0
DELETE T
FROM Lic_PeakUsage T
INNER JOIN #tempUsage ON T.LicType = t_licType AND t_updateStatus = 1
WHERE T.MonthStart = @monthStart AND T.PeakType = @CCLPeakType AND T.UsageType=41
INSERT INTO Lic_PeakUsage (MonthStart,CreationDate,UsageType,PeakType,LicType,AppSizeMB,CapacityFlag, VMFlag,SPId,SPName, ObjectName, ObjectId)
SELECT @monthStart,@currentTime,UsageType,@CCLPeakType,LicType,AppSizeMB,CapacityFlag,VMFlag,SPId,SPName, ObjectName, ObjectId
FROM Lic_CurrentUsage WITH (NOLOCK)
INNER JOIN #tempUsage ON UsageType=41 AND LicType = t_licType AND t_updateStatus = 1
MERGE Lic_PeakUsage AS T
USING  (SELECT UsageType,ClientId,LicType,AppSizeMB,CapacityFlag, VMFlag ,SPId,SPName, ObjectName, ObjectId FROM Lic_CurrentUsage WITH (NOLOCK) WHERE UsageType = @Metallic_1UsageType) AS S
ON  T.MonthStart = @monthStart AND T.UsageType = S.UsageType AND T.PeakType = @SCLPeakType  AND S.LicType = T.LicType and S.SPId = T.SPId AND S.ObjectId = T.ObjectId
WHEN MATCHED AND T.AppSizeMB <= S.AppSizeMB
    THEN UPDATE SET T.CreationDate = @currentTime, T.AppSizeMB = S.AppSizeMB
WHEN NOT MATCHED BY TARGET
    THEN INSERT (MonthStart,CreationDate,UsageType,PeakType,ClientId,LicType,AppSizeMB,CapacityFlag, VMFlag, SPId,SPName, ObjectName, ObjectId)
    VALUES(@monthStart,@currentTime,S.UsageType,@SCLPeakType,S.ClientId,S.LicType,S.AppSizeMB,S.CapacityFlag, S.VMFlag ,S.SPId,S.SPName, S.ObjectName, S.ObjectId)
;
COMMIT TRAN
END TRY
BEGIN CATCH
ROLLBACK TRAN
SET @attrVal = '1'
GOTO  CAL_ERROR
END CATCH
CAL_ERROR:
IF EXISTS(select 1 from LicUsageBasedConfig WITH (nolock) where attrname = @attrname)
    Update LicUsageBasedConfig
    SET attrVal = @attrVal
    WHERE attrname = @attrname AND attrVal <> @attrVal
ELSE
    INSERT INTO LicUsageBasedConfig (attrname,attrType,attrVal)
    VALUES (@attrname, @attrType, @attrVal)
DROP TABLE #tempMetallicStorageUsageByContainer
DROP TABLE #tempUsage
SET NOCOUNT OFF
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'LicGetMetallicStorageDetailsV3')
	delete from GxQscripts where name = 'LicGetMetallicStorageDetailsV3'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LicGetMetallicStorageDetailsV3')
	delete from GXDBVersions where aliasname = 'LicGetMetallicStorageDetailsV3'
GO

insert into GXDBVersions values(2, 'LicGetMetallicStorageDetailsV3',  '00000000000000000000', 'LicGetMetallicStorageDetailsV3', '00000000000000000000')
GO

