

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/LicGetMetallicLicenseKey.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2020  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--	+===================================================================+
--	|  			 	 LicGetMetallicLicenseKey							|
--	|		Return Metallic Credential blob from license key			|
--	+===================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='LicGetMetallicLicenseKey')
BEGIN
	print '>>> Drop Stored Procedure: LicGetMetallicLicenseKey <<<'
	drop procedure LicGetMetallicLicenseKey
END
IF EXISTS (select * from GxQscripts where name='LicGetMetallicLicenseKey')
	delete from GxQscripts where name = 'LicGetMetallicLicenseKey'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LicGetMetallicLicenseKey')
	delete from GXDBVersions where aliasname = 'LicGetMetallicLicenseKey'
GO
print '... Creating Procedure: LicGetMetallicLicenseKey'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure LicGetMetallicLicenseKey
AS
  DECLARE @o_licenseKey varchar(MAX) = ''
	SET NOCOUNT ON
	--
	-- Return license key only when EULA is accepted
	--
IF EXISTS(SELECT 1 FROM GXGlobalParam WHERE name = 'MetallicEulaAccepted' and value = N'1' and modified = 0)
	BEGIN
		DECLARE @licXml xml
		SELECT TOP 1 @licXml = CAST(licXML as xml) FROM SimLicenses WITH(READUNCOMMITTED) ORDER BY id DESC
		SELECT	@o_licenseKey = ISNULL(C.value('.', 'varchar(max)'), '')
		FROM	@licXml.nodes('/CommVaultOEMOrder/LAServerInfo/MetallicLicenseKey')  R(C)
		IF @o_licenseKey <> ''
		BEGIN
			-- Remove the special delimiters
SET @o_licenseKey = LTRIM(RTRIM(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(@o_licenseKey, 'CommVault Metallic License:', ''), 'KEY: ', ''), 'CommVault Metallic License End:', ''), CHAR(10), ''), CHAR(32), '')))
		END
	END
	SELECT @o_licenseKey
GO

IF EXISTS (select * from GxQscripts where name = 'LicGetMetallicLicenseKey')
	delete from GxQscripts where name = 'LicGetMetallicLicenseKey'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LicGetMetallicLicenseKey')
	delete from GXDBVersions where aliasname = 'LicGetMetallicLicenseKey'
GO

insert into GXDBVersions values(2, 'LicGetMetallicLicenseKey',  '00000000000000000000', 'LicGetMetallicLicenseKey', '00000000000000000000')
GO

