

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/LicGetMSimUserCount.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Satya Prakash Bhukar
--	Date:   1/26/2016
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/LicGetMSimUserCount.sp,v $ $Id: LicGetMSimUserCount.sp,v 1.1.2.23 2019/06/29 15:43:56 leiwang Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
-- @i_clientId can be client ID or Library ID
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='LicGetMSimUserCount')
BEGIN
	print '>>> Drop Stored Procedure: LicGetMSimUserCount <<<'
	drop procedure LicGetMSimUserCount
END
IF EXISTS (select * from GxQscripts where name='LicGetMSimUserCount')
	delete from GxQscripts where name = 'LicGetMSimUserCount'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LicGetMSimUserCount')
	delete from GXDBVersions where aliasname = 'LicGetMSimUserCount'
GO
print '... Creating Procedure: LicGetMSimUserCount'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure LicGetMSimUserCount
  @bDetails INTEGER = 0,
  @nUserId INTEGER = 0,
  @nUserCount INTEGER = 0 OUTPUT,
  @mSIMXML NVARCHAR(MAX) = '' OUTPUT
AS
DECLARE @o_isValidApptype INT
DECLARE @o_appTypeList NVARCHAR(1024) = ''
EXEC LicGetMSimAppType -2,0,@o_isValidApptype OUTPUT, @o_appTypeList OUTPUT
DECLARE @filterSubclientStatus INT = (CAST(0x00002 AS INT)+CAST(0x00004 AS INT)+CAST(0x00020 AS INT))
IF object_id('tempdb.dbo.#tmpO365SharePointClients') IS NOT null DROP TABLE #tmpO365SharePointClients
CREATE TABLE #tmpO365SharePointClients (clientid INT)
IF @bDetails = 0
BEGIN
	IF object_id('tempdb.dbo.#mailBoxCountTable') is not null
		DROP TABLE #mailBoxCountTable
	CREATE TABLE #mailBoxCountTable (clientId INT, appTypeId INT, instanceId INT, SubClientId INT, mailbox NVARCHAR(1024), mailboxGUID VARCHAR(512))
	CREATE INDEX #mailBoxCountTable_SubClientId_mailbox_Index1 ON #mailBoxCountTable (SubClientId) include (mailbox)
	SELECT @mSIMXML = ''
	INSERT INTO #mailBoxCountTable
	(clientId, appTypeId, instanceId, SubClientId, mailbox, mailboxGUID)
	SELECT DISTINCT APP.clientId, APP.appTypeId, APP.instance, APP.id, MB.stringVal, GD.stringVal AS mailboxGUID
	FROM APP_Application APP (READUNCOMMITTED)
	JOIN APP_SubClientProp SP (READUNCOMMITTED) ON APP.subclientStatus&@filterSubclientStatus = 0
			AND SP.componentNameId = APP.id AND SP.modified=0 AND SP.attrType in (101,111) --PROPERTY_EXCHANGE_MBOX , PROPERTY_LNOTES_DOC
JOIN APP_ComponentProp GD (READUNCOMMITTED) ON GD.componentId = SP.id AND GD.modified = 0 AND GD.propertyTypeId in (1103,1400) --_CV_COMPONENT_EXMB_GUID
JOIN APP_ComponentProp MB (READUNCOMMITTED) ON MB.componentId = SP.id AND MB.modified = 0 AND MB.propertyTypeId in (1100,1400) --_CV_COMPONENT_EXMB_MAILBOX
	WHERE LEN(GD.stringVal) > 0 AND APP.appTypeId IN (SELECT _ID FROM dbo.SplitIDs(@o_appTypeList))
	UNION
	SELECT clientId, appTypeId, instance, id, rc.value('@smtpAdrress', 'NVARCHAR(1024)') mailbox, um.value('@userGUID', 'VARCHAR(512)') mailboxGUID
	FROM
	(
		SELECT APP.clientId, APP.appTypeId, APP.instance, APP.id, CAST(MB.stringVal AS XML) userEmails
		FROM APP_Application APP (READUNCOMMITTED)
JOIN APP_ComponentProp JM (READUNCOMMITTED) ON JM.componentId = APP.id AND JM.modified = 0 AND JM.propertyTypeId = 1150 --_CV_COMPONENT_EXONEPASS_JOURNAL_MAILBOX
JOIN APP_ComponentProp MB (READUNCOMMITTED) ON MB.componentId = JM.id AND MB.modified = 0 AND MB.propertyTypeId = 1151 --_CV_COMPONENT_EXONEPASS_USER_MAILBOX
		WHERE APP.subclientStatus&@filterSubclientStatus = 0
	) T
	CROSS APPLY userEmails.nodes('./recipients') R(rc)
	CROSS APPLY rc.nodes('./user') M(um)
	WHERE LEN(um.value('@userGUID', 'VARCHAR(512)')) > 0
	UNION
	SELECT CP.clientId, APP.appTypeId, APP.instance, APP.id, CP.smtpAdrress, CASE WHEN CP.mailBoxType = 1 THEN '{'+userGuid+'}' ELSE CP.smtpAdrress END
	FROM APP_EmailConfigPolicyAssoc CP (READUNCOMMITTED)
	JOIN APP_Application APP (READUNCOMMITTED) ON APP.id = CP.subClientId AND CP.modified = 0 AND CP.deleted = 0
	WHERE discoverByType = 13 OR (CP.mailBoxType = 1 AND CP.msExchRecipientTypeDetails = 1 AND LEN(CP.userGuid) > 0 AND CP.status = 0 /*Don't count disabled mailboxes*/)
	DELETE M
	FROM #mailBoxCountTable M
	INNER JOIN App_InstanceProp Ins (READUNCOMMITTED) on M.instanceId = Ins.componentNameId AND Ins.attrName = 'Exchange Online Enabled' AND Ins.attrVal = '1' AND Ins.modified = 0
	WHERE M.appTypeId = 54
	-- Count Gmail, Gdrive, OneDrive and Salesforce
	;WITH Gmail_CTE (clientId,appTypeId,instance,subClientId,instanceVal,backupSet)
	AS
	(
		SELECT APP.clientId, APP.appTypeId, APP.instance, APP.id, Prop.attrVal, APP.backupSet
		FROM APP_Application APP (READUNCOMMITTED)
		JOIN APP_InstanceProp Prop (READUNCOMMITTED) ON APP.instance = Prop.componentNameId AND APP.subclientStatus&@filterSubclientStatus = 0
			AND attrName = 'Cloud Apps Instance Type' AND LEN(attrVal) > 0	AND attrVal in ('1','2','3','7')
	)
	INSERT INTO #mailBoxCountTable
	SELECT DISTINCT clientId,appTypeId,case when isnumeric(instanceVal) = 1 then cast(instanceVal AS int) else 0 end,subClientId,SP.attrName, SP.attrName
	FROM Gmail_CTE
	JOIN (SELECT componentNameId, attrVal,
		 CASE WHEN CHARINDEX(';',attrName) = 0 THEN attrName
			  WHEN CHARINDEX(';',attrName) = len(attrName) THEN SUBSTRING(attrName,1,CHARINDEX(';',attrName)-1)
			  WHEN CHARINDEX(';',attrName) < len(attrName) THEN SUBSTRING(attrName,CHARINDEX(';',attrName)+1,len(attrName))
		 END AS attrName
		 FROM APP_SubClientProp (READUNCOMMITTED) WHERE attrType = 134 AND modified=0 AND LEN(attrName) > 0) SP ON SP.componentNameId = subClientId --PROPERTY_CLOUD_APPS
		AND (CASE WHEN instanceVal = '7' and SP.attrVal like '%::oq' THEN 1
				  WHEN instanceVal <> '7' THEN 1
				  ELSE 0 END) = 1
	WHERE instanceVal <> '3'
	UNION
	SELECT DISTINCT clientId,appTypeId,3,subClientId,BKP.attrVal,BKP.attrVal
	FROM Gmail_CTE
	JOIN APP_BackupSetProp BKP (READUNCOMMITTED) ON backupSet = BKP.componentNameId AND BKP.attrName = 'Salesforce username' AND BKP.modified = 0
	WHERE instanceVal = '3'
	-- Count Office 365 SharePoint
	EXEC LicGetO365Sharepoint '#tmpO365SharePointClients'
	INSERT INTO #mailBoxCountTable
    SELECT DISTINCT C.clientid, APP.appTypeId, APP.instance, APP.id, P.attrName, P.attrName
    FROM APP_BackupSetProp P (READUNCOMMITTED)
    INNER JOIN APP_Application APP (READUNCOMMITTED) ON APP.backupSet = P.componentNameId AND APP.subclientStatus&@filterSubclientStatus = 0
    INNER JOIN #tmpO365SharePointClients C ON C.clientid = APP.clientId
    WHERE P.attrType = 137
	-- Remove the mailbox not belonging to user
	IF @nUserId > 1 AND object_id('tempdb.dbo.#LicCalUserObj') IS NOT NULL --SECURITY
		delete #mailBoxCountTable
		where clientId not in (select clientId from #LicCalUserObj where clientId > 0)
		--REMOVE DISABLED ACTIVITY AT SUBCLIENT LEVEL
	DELETE #mailBoxCountTable
	FROM #mailBoxCountTable MC
	JOIN JMJobAction (READUNCOMMITTED) JA ON JA.opType = 4 AND JA.action = 1 AND JA.appId = MC.SubClientId
	--REMOVE DISABLED ACTIVITY AT CLIENT LEVEL
	DELETE #mailBoxCountTable
	FROM #mailBoxCountTable MC
	JOIN JMJobAction (READUNCOMMITTED) JA ON JA.opType = 4 AND JA.action = 1 AND JA.clientId = MC.clientId AND JA.appType = 0
	--REMOVE DISABLED ACTIVITY AT APPTYPE LEVEL
	DELETE #mailBoxCountTable
	FROM #mailBoxCountTable MC
	JOIN JMJobAction (READUNCOMMITTED) JA ON JA.opType = 4 AND JA.action = 1 AND JA.appType = MC.appTypeId AND JA.clientId = MC.clientId
	--REMOVE DISABLED ACTIVITY AT CLIENT GROUP LEVEL
	DELETE #mailBoxCountTable
	FROM #mailBoxCountTable MC
	JOIN JMJobAction (READUNCOMMITTED) JA ON JA.opType = 4 AND JA.action = 1 AND JA.clientGroupId > 0
	JOIN APP_ClientGroupAssoc (READUNCOMMITTED) GA ON GA.clientGroupId = JA.clientGroupId AND GA.clientId = MC.clientId
	SELECT @nUserCount = COUNT(DISTINCT mailbox) FROM #mailBoxCountTable WHERE appTypeId in (54,78,137) OR (appTypeId = 134 AND instanceId = 7)
END
ELSE
BEGIN
	DECLARE @MailBoxXML XML
	IF object_id('tempdb.dbo.#mailBoxTable') is not null
		DROP TABLE #mailBoxTable
	CREATE TABLE #mailBoxTable (clientId INT, appTypeId INT, mailbox NVARCHAR(1024), mailboxGUID VARCHAR(512), apptypename NVARCHAR(1024), subclientname NVARCHAR(1024), clientname NVARCHAR(1024), SubClientId  int, instance int)
	CREATE INDEX #mailBoxTable_SubClientId_mailbox_Index1 ON #mailBoxTable (SubClientId) include (mailbox)
	INSERT INTO	#mailBoxTable
	SELECT DISTINCT C.id, APP.appTypeId, MB.stringVal, GD.stringVal, IDT.name, APP.SubClientName, C.name ClientName, APP.id, 0--COUNT(DISTINCT CP.stringVal)
	FROM APP_Client C (READUNCOMMITTED)
	JOIN APP_Application APP (READUNCOMMITTED) ON APP.clientId = C.id
	JOIN APP_iDAType IDT (READUNCOMMITTED) ON IDT.type = APP.appTypeId
	JOIN APP_SubClientProp SP (READUNCOMMITTED) ON APP.subclientStatus&@filterSubclientStatus = 0
			AND SP.componentNameId = APP.id AND SP.modified=0 AND SP.attrType in (101,111) --PROPERTY_LNOTES_DOC, PROPERTY_EXCHANGE_MBOX
JOIN APP_ComponentProp GD (READUNCOMMITTED) ON GD.componentId = SP.id AND GD.modified = 0 AND GD.propertyTypeId in (1103,1400) --_CV_COMPONENT_EXMB_GUID
JOIN APP_ComponentProp MB (READUNCOMMITTED) ON MB.componentId = SP.id AND MB.modified = 0 AND MB.propertyTypeId in (1100,1400) --_CV_COMPONENT_EXMB_MAILBOX
	WHERE LEN(GD.stringVal) > 0 AND APP.appTypeId IN (SELECT _ID FROM dbo.SplitIDs(@o_appTypeList))
	INSERT INTO	#mailBoxTable
	SELECT T.clientId, T.appTypeId, rc.value('@smtpAdrress', 'NVARCHAR(1024)') mailbox, um.value('@userGUID', 'VARCHAR(512)') mailboxGUID, T.name, T.subclientName, T.ClientName, T.subclientId, 0
	FROM
	(
		SELECT C.id clientId, APP.appTypeId, CAST(MB.stringVal AS XML) userEmails, IDT.name, APP.SubClientName, C.name ClientName, APP.id subclientId--COUNT(DISTINCT CP.stringVal)
		FROM APP_Client C (READUNCOMMITTED)
		JOIN APP_Application APP (READUNCOMMITTED) ON APP.clientId = C.id AND APP.subclientStatus&@filterSubclientStatus = 0
		JOIN APP_iDAType IDT (READUNCOMMITTED) ON IDT.type = APP.appTypeId
JOIN APP_ComponentProp JM (READUNCOMMITTED) ON JM.componentId = APP.id AND JM.modified = 0 AND JM.propertyTypeId = 1150 --_CV_COMPONENT_EXONEPASS_JOURNAL_MAILBOX
JOIN APP_ComponentProp MB (READUNCOMMITTED) ON MB.componentId = JM.id AND MB.modified = 0 AND MB.propertyTypeId = 1151 --_CV_COMPONENT_EXONEPASS_USER_MAILBOX
	) T
	CROSS APPLY userEmails.nodes('./recipients') R(rc)
	CROSS APPLY rc.nodes('./user') M(um)
	WHERE LEN(um.value('@userGUID', 'VARCHAR(512)')) > 0
	UNION
	SELECT CP.clientId, APP.appTypeId, CP.smtpAdrress, CASE WHEN CP.mailBoxType = 1 THEN '{'+CP.userGuid+'}' ELSE CP.smtpAdrress END, IDT.name, APP.subclientName, C.name, APP.id, 0
	FROM APP_EmailConfigPolicyAssoc CP (READUNCOMMITTED)
	JOIN APP_Application APP (READUNCOMMITTED) ON APP.id = CP.subClientId AND APP.subclientStatus&@filterSubclientStatus = 0
	AND CP.modified = 0 AND CP.deleted = 0
	JOIN APP_Client C (READUNCOMMITTED) ON C.id = APP.clientId
	JOIN APP_iDAType IDT (READUNCOMMITTED) ON IDT.type = APP.appTypeId
	WHERE discoverByType = 13 OR (CP.mailBoxType = 1 AND CP.msExchRecipientTypeDetails = 1 AND LEN(CP.userGuid) > 0 AND CP.status = 0 /*Don't count disabled mailboxes*/)
	DELETE M
	FROM #mailBoxTable M
	INNER JOIN APP_Application APP (READUNCOMMITTED) ON APP.id = M.SubClientId AND APP.appTypeId = M.appTypeId
	INNER JOIN App_InstanceProp Ins (READUNCOMMITTED) ON APP.instance = Ins.componentNameId AND Ins.attrName = 'Exchange Online Enabled' AND Ins.attrVal = '1' AND Ins.modified = 0
	WHERE M.appTypeId = 54
	-- Count Gmail, Gdrive, OneDrive and Salesforce
	;WITH Gmail_CTE (clientId,appTypeId,apptypename,subclientname,clientname,subClientId,instance,backupSet)
	AS
	(
		SELECT C.id, APP.appTypeId, IDT.name, APP.SubClientName, C.name, APP.id, Prop.attrVal, APP.backupSet
		FROM APP_Client C (READUNCOMMITTED)
		JOIN APP_Application APP (READUNCOMMITTED) ON APP.clientId = C.id
		JOIN APP_iDAType IDT (READUNCOMMITTED) ON IDT.type = APP.appTypeId
		JOIN APP_InstanceProp Prop (READUNCOMMITTED) ON APP.instance = Prop.componentNameId AND APP.subclientStatus&@filterSubclientStatus = 0
			AND attrName = 'Cloud Apps Instance Type' AND LEN(attrVal) > 0 AND attrVal in ('1','2','3','7')
	)
	INSERT INTO #mailBoxTable
	SELECT DISTINCT clientId,appTypeId,SP.attrName,SP.attrName,apptypename,subclientname,clientname,subClientId,case when isnumeric(instance) = 1 then cast(instance AS int) else 0 end
	FROM Gmail_CTE
	JOIN (SELECT componentNameId, attrVal,
		 CASE WHEN CHARINDEX(';',attrName) = 0 THEN attrName
			  WHEN CHARINDEX(';',attrName) = len(attrName) THEN SUBSTRING(attrName,1,CHARINDEX(';',attrName)-1)
			  WHEN CHARINDEX(';',attrName) < len(attrName) THEN SUBSTRING(attrName,CHARINDEX(';',attrName)+1,len(attrName))
		 END AS attrName
		 FROM APP_SubClientProp (READUNCOMMITTED) WHERE attrType = 134 AND modified=0 AND LEN(attrName) > 0) SP ON SP.componentNameId = subClientId --PROPERTY_CLOUD_APPS
		AND (CASE WHEN instance = '7' and SP.attrVal like '%::oq' THEN 1
				  WHEN instance <> '7' THEN 1 ELSE 0 END) = 1
	WHERE instance <> '3'
	UNION
	SELECT DISTINCT clientId,appTypeId,BKP.attrVal,BKP.attrVal,apptypename,subclientname,clientname,subClientId,3
	FROM Gmail_CTE
	JOIN APP_BackupSetProp BKP (READUNCOMMITTED) ON backupSet = BKP.componentNameId AND BKP.attrName = 'Salesforce username' AND BKP.modified = 0
	WHERE instance = '3'
	-- Count Office 365 SharePoint
	EXEC LicGetO365Sharepoint '#tmpO365SharePointClients'
	INSERT INTO #mailBoxTable
    SELECT DISTINCT C.id, APP.appTypeId, P.attrName, P.attrName, IDT.name, APP.SubClientName, C.name, APP.id, 0
    FROM APP_BackupSetProp P (READUNCOMMITTED)
    INNER JOIN APP_Application APP (READUNCOMMITTED) ON APP.backupSet = P.componentNameId AND APP.subclientStatus&@filterSubclientStatus = 0
	INNER JOIN #tmpO365SharePointClients T ON T.clientid =  APP.clientId
    INNER JOIN APP_Client C (READUNCOMMITTED) ON C.id = APP.clientId
	INNER JOIN APP_iDAType IDT (READUNCOMMITTED) ON IDT.type = APP.appTypeId
    WHERE P.attrType = 137
	-- Remove the mailbox not belonging to user
	IF @nUserId > 1 AND object_id('tempdb.dbo.#LicCalUserObj') IS NOT NULL
		delete #mailBoxTable
		where clientId not in (select clientId from #LicCalUserObj where clientId > 0)
	--REMOVE DISABLED ACTIVITY AT SUBCLIENT LEVEL
	DELETE #mailBoxTable
	FROM #mailBoxTable MC
	JOIN JMJobAction (READUNCOMMITTED) JA ON JA.opType = 4 AND JA.action = 1 AND JA.appId = MC.SubClientId
	--REMOVE DISABLED ACTIVITY AT CLIENT LEVEL
	DELETE #mailBoxTable
	FROM #mailBoxTable MC
	JOIN JMJobAction (READUNCOMMITTED) JA ON JA.opType = 4 AND JA.action = 1 AND JA.clientId = MC.clientId AND JA.appType = 0
	--REMOVE DISABLED ACTIVITY AT APPTYPE LEVEL
	DELETE #mailBoxTable
	FROM #mailBoxTable MC
	JOIN JMJobAction (READUNCOMMITTED) JA ON JA.opType = 4 AND JA.action = 1 AND JA.appType = MC.appTypeId AND JA.clientId = MC.clientId
	--REMOVE DISABLED ACTIVITY AT CLIENT GROUP LEVEL
	DELETE #mailBoxTable
	FROM #mailBoxTable MC
	JOIN JMJobAction (READUNCOMMITTED) JA ON JA.opType = 4 AND JA.action = 1 AND JA.clientGroupId > 0
	JOIN APP_ClientGroupAssoc (READUNCOMMITTED) GA ON GA.clientGroupId = JA.clientGroupId AND GA.clientId = MC.clientId
	SELECT @nUserCount = COUNT(DISTINCT mailbox) FROM #mailBoxTable WHERE appTypeId in (54,78,137) OR (appTypeId = 134 AND instance = 7)
	SELECT @MailBoxXML =
	(
		SELECT distinct
		dbo.NormalizeForXML(mailbox) as '@SMTP', apptypename as '@Apptype', subclientname  as '@SubClientName',
		clientname  as '@ClientName'
		FROM
		(
			SELECT * FROM #mailBoxTable
		) T
		FOR XML PATH('mailBoxList'),
		ROOT('MailBoxes')
	)
 	IF object_id('tempdb.dbo.#mailBoxTable') is not null
		DROP TABLE #mailBoxTable
	--IF object_id('tempdb.dbo.#recipientTable') is not null
		--DROP TABLE #recipientTable
	SET @mSIMXML = CAST(@MailBoxXML AS NVARCHAR(MAX))
END
DROP TABLE #tmpO365SharePointClients
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'LicGetMSimUserCount')
	delete from GxQscripts where name = 'LicGetMSimUserCount'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LicGetMSimUserCount')
	delete from GXDBVersions where aliasname = 'LicGetMSimUserCount'
GO

insert into GXDBVersions values(2, 'LicGetMSimUserCount',  '00010001000200230000', 'LicGetMSimUserCount', '00010001000200230000')
GO

