

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/LicGetMSimAppType.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Satya Prakash Bhukar
--	Date:   1/26/2016
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/LicGetMSimAppType.sp,v $ $Id: LicGetMSimAppType.sp,v 1.1.2.13 2020/08/28 17:13:05 leiwang Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
-- @i_clientId can be client ID or Library ID
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='LicGetMSimAppType')
BEGIN
	print '>>> Drop Stored Procedure: LicGetMSimAppType <<<'
	drop procedure LicGetMSimAppType
END
IF EXISTS (select * from GxQscripts where name='LicGetMSimAppType')
	delete from GxQscripts where name = 'LicGetMSimAppType'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LicGetMSimAppType')
	delete from GXDBVersions where aliasname = 'LicGetMSimAppType'
GO
print '... Creating Procedure: LicGetMSimAppType'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure LicGetMSimAppType
  @in_appType INTEGER,
  @in_jobId INTEGER,
  @in_returnVal INTEGER = 0 OUTPUT,
  @in_appTypeList NVARCHAR(1024) = '' OUTPUT
AS
SET @in_returnVal = 0
DECLARE @bIsMsimValid INT = 0
DECLARE @licAppliedStatus INT = 0
DECLARE @isLicInherited INT = 0
DECLARE @subClientid INT = 0
EXEC LicAppliedStatus @licAppliedStatus OUTPUT, @isLicInherited OUTPUT
IF @isLicInherited > 0
BEGIN
SELECT @bIsMsimValid = @licAppliedStatus&0x80
END
ELSE
	EXEC LicIsLicenseValid 100028, @bIsMsimValid OUTPUT
IF @in_jobId > 0 AND @in_appType = 137
BEGIN
	SELECT @subClientid = applicationId	FROM JMBkpJobInfo WITH (NOLOCK)
	WHERE jobId = @in_jobId
END
IF @bIsMsimValid > 0 OR @in_appType = -2
BEGIN
	DECLARE @appTypeTable TABLE (t_apptype INT)
	INSERT INTO @appTypeTable VALUES
(54), --54
(56),
(67), --67
(90), --90
(137) --137
	IF @in_appType < 0
	BEGIN
		SELECT @in_appTypeList = STUFF((SELECT ','+ CAST(t_apptype as NVARCHAR(32)) FROM @appTypeTable FOR XML PATH('')),1,1,'')
	END
	ELSE IF @in_appType IN (SELECT t_apptype FROM @appTypeTable)
	BEGIN
IF @in_appType = 137 AND @subClientid > 0
			SET @in_returnVal = CASE dbo.IsCaseMgrSubclient(@subClientid) WHEN 1 THEN 0 ELSE 1 END
		ELSE
			SET @in_returnVal = 1
	END
ELSE IF @in_appType = 134 -- Special Handling for Apptype 134
	BEGIN
	-- Under apptype 134 instance 1 represents Gmail, 2 represent Gdrive and 7 represent OneDrive. Refer App.x cloudInstanceType enum for details.
		IF EXISTS(SELECT app.id
		FROM JMBkpJobInfo JM WITH (NOLOCK)
		INNER JOIN APP_Application app WITH (NOLOCK) ON app.id = JM.applicationId
		INNER JOIN APP_InstanceProp Prop WITH (NOLOCK) ON app.instance = Prop.componentNameId
		WHERE @in_jobId = jobId AND appTypeId = @in_appType AND attrName = 'Cloud Apps Instance Type' AND attrVal in ('1','2','3','7'))
			SET @in_returnVal = 1
	END
ELSE IF @in_appType = 78 -- Special Handling for Office 365 SharePoint
	BEGIN
		DECLARE @isO365SPValid INT = 0
		EXEC LicGetO365Sharepoint '', @in_jobId, @isO365SPValid OUTPUT
		IF @isO365SPValid > 0
		SET @in_returnVal = 1
	END
END
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'LicGetMSimAppType')
	delete from GxQscripts where name = 'LicGetMSimAppType'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LicGetMSimAppType')
	delete from GXDBVersions where aliasname = 'LicGetMSimAppType'
GO

insert into GXDBVersions values(2, 'LicGetMSimAppType',  '00010001000200130000', 'LicGetMSimAppType', '00010001000200130000')
GO

